/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.entryPointCreators;

import java.util.HashMap;
import java.util.Map;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.jimple.infoflow.android.entryPointCreators.AndroidEntryPointConstants;

public class AndroidEntryPointUtils {
    private Map<SootClass, ComponentType> componentTypeCache = new HashMap<SootClass, ComponentType>();
    private SootClass osClassApplication = Scene.v().getSootClassUnsafe("android.app.Application");
    private SootClass osClassActivity = Scene.v().getSootClassUnsafe("android.app.Activity");
    private SootClass osClassMapActivity;
    private SootClass osClassService = Scene.v().getSootClassUnsafe("android.app.Service");
    private SootClass osClassFragment = Scene.v().getSootClassUnsafe("android.app.Fragment");
    private SootClass osClassSupportFragment = Scene.v().getSootClassUnsafe("android.support.v4.app.Fragment");
    private SootClass osClassAndroidXFragment = Scene.v().getSootClassUnsafe("androidx.fragment.app.Fragment");
    private SootClass osClassBroadcastReceiver = Scene.v().getSootClassUnsafe("android.content.BroadcastReceiver");
    private SootClass osClassContentProvider = Scene.v().getSootClassUnsafe("android.content.ContentProvider");
    private SootClass osClassGCMBaseIntentService = Scene.v().getSootClassUnsafe("com.google.android.gcm.GCMBaseIntentService");
    private SootClass osClassGCMListenerService = Scene.v().getSootClassUnsafe("com.google.android.gms.gcm.GcmListenerService");
    private SootClass osInterfaceServiceConnection = Scene.v().getSootClassUnsafe("android.content.ServiceConnection");

    public AndroidEntryPointUtils() {
        this.osClassMapActivity = Scene.v().getSootClassUnsafe("com.google.android.maps.MapActivity");
    }

    public ComponentType getComponentType(SootClass currentClass) {
        if (this.componentTypeCache.containsKey(currentClass)) {
            return this.componentTypeCache.get(currentClass);
        }
        ComponentType ctype = ComponentType.Plain;
        if (this.osClassApplication != null && Scene.v().getOrMakeFastHierarchy().canStoreType((Type)currentClass.getType(), (Type)this.osClassApplication.getType())) {
            ctype = ComponentType.Application;
        } else if (this.osClassActivity != null && Scene.v().getOrMakeFastHierarchy().canStoreType((Type)currentClass.getType(), (Type)this.osClassActivity.getType())) {
            ctype = ComponentType.Activity;
        } else if (this.osClassService != null && Scene.v().getOrMakeFastHierarchy().canStoreType((Type)currentClass.getType(), (Type)this.osClassService.getType())) {
            ctype = ComponentType.Service;
        } else if (this.osClassFragment != null && Scene.v().getOrMakeFastHierarchy().canStoreType((Type)currentClass.getType(), (Type)this.osClassFragment.getType())) {
            ctype = ComponentType.Fragment;
        } else if (this.osClassSupportFragment != null && Scene.v().getOrMakeFastHierarchy().canStoreType((Type)currentClass.getType(), (Type)this.osClassSupportFragment.getType())) {
            ctype = ComponentType.Fragment;
        } else if (this.osClassAndroidXFragment != null && Scene.v().getOrMakeFastHierarchy().canStoreType((Type)currentClass.getType(), (Type)this.osClassAndroidXFragment.getType())) {
            ctype = ComponentType.Fragment;
        } else if (this.osClassBroadcastReceiver != null && Scene.v().getOrMakeFastHierarchy().canStoreType((Type)currentClass.getType(), (Type)this.osClassBroadcastReceiver.getType())) {
            ctype = ComponentType.BroadcastReceiver;
        } else if (this.osClassContentProvider != null && Scene.v().getOrMakeFastHierarchy().canStoreType((Type)currentClass.getType(), (Type)this.osClassContentProvider.getType())) {
            ctype = ComponentType.ContentProvider;
        } else if (this.osClassGCMBaseIntentService != null && Scene.v().getOrMakeFastHierarchy().canStoreType((Type)currentClass.getType(), (Type)this.osClassGCMBaseIntentService.getType())) {
            ctype = ComponentType.GCMBaseIntentService;
        } else if (this.osClassGCMListenerService != null && Scene.v().getOrMakeFastHierarchy().canStoreType((Type)currentClass.getType(), (Type)this.osClassGCMListenerService.getType())) {
            ctype = ComponentType.GCMListenerService;
        } else if (this.osInterfaceServiceConnection != null && Scene.v().getOrMakeFastHierarchy().canStoreType((Type)currentClass.getType(), (Type)this.osInterfaceServiceConnection.getType())) {
            ctype = ComponentType.ServiceConnection;
        } else if (this.osClassMapActivity != null && Scene.v().getOrMakeFastHierarchy().canStoreType((Type)currentClass.getType(), (Type)this.osClassMapActivity.getType())) {
            ctype = ComponentType.Activity;
        }
        this.componentTypeCache.put(currentClass, ctype);
        return ctype;
    }

    public boolean isApplicationClass(SootClass clazz) {
        return this.osClassApplication != null && Scene.v().getOrMakeFastHierarchy().canStoreType((Type)clazz.getType(), (Type)this.osClassApplication.getType());
    }

    public boolean isEntryPointMethod(SootMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("Given method is null");
        }
        ComponentType componentType = this.getComponentType(method.getDeclaringClass());
        String subsignature = method.getSubSignature();
        if (componentType == ComponentType.Activity && AndroidEntryPointConstants.getActivityLifecycleMethods().contains(subsignature)) {
            return true;
        }
        if (componentType == ComponentType.Service && AndroidEntryPointConstants.getServiceLifecycleMethods().contains(subsignature)) {
            return true;
        }
        if (componentType == ComponentType.Fragment && AndroidEntryPointConstants.getFragmentLifecycleMethods().contains(subsignature)) {
            return true;
        }
        if (componentType == ComponentType.BroadcastReceiver && AndroidEntryPointConstants.getBroadcastLifecycleMethods().contains(subsignature)) {
            return true;
        }
        if (componentType == ComponentType.ContentProvider && AndroidEntryPointConstants.getContentproviderLifecycleMethods().contains(subsignature)) {
            return true;
        }
        if (componentType == ComponentType.GCMBaseIntentService && AndroidEntryPointConstants.getGCMIntentServiceMethods().contains(subsignature)) {
            return true;
        }
        if (componentType == ComponentType.GCMListenerService && AndroidEntryPointConstants.getGCMListenerServiceMethods().contains(subsignature)) {
            return true;
        }
        return componentType == ComponentType.ServiceConnection && AndroidEntryPointConstants.getServiceConnectionMethods().contains(subsignature);
    }

    public static enum ComponentType {
        Application,
        Activity,
        Service,
        Fragment,
        BroadcastReceiver,
        ContentProvider,
        GCMBaseIntentService,
        GCMListenerService,
        ServiceConnection,
        Plain;

    }
}

