/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.data.parsers;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.infoflow.android.data.AndroidMethod;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinitionProvider;
import soot.jimple.infoflow.sourcesSinks.definitions.MethodSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.SourceSinkType;

public class PermissionMethodParser
implements ISourceSinkDefinitionProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, AndroidMethod> methods = null;
    private Set<ISourceSinkDefinition> sourceList = null;
    private Set<ISourceSinkDefinition> sinkList = null;
    private Set<ISourceSinkDefinition> neitherList = null;
    private static final int INITIAL_SET_SIZE = 10000;
    private List<String> data;
    private final String regex = "^<(.+):\\s*(.+)\\s+(.+)\\s*\\((.*)\\)>\\s*(.*?)(\\s+->\\s+(.*))?$";
    private final String regexNoRet = "^<(.+):\\s*(.+)\\s*\\((.*)\\)>\\s*(.*?)?(\\s+->\\s+(.*))?$";

    public static PermissionMethodParser fromFile(String fileName) throws IOException {
        PermissionMethodParser pmp = new PermissionMethodParser();
        pmp.readFile(fileName);
        return pmp;
    }

    public static PermissionMethodParser fromStream(InputStream input) throws IOException {
        PermissionMethodParser pmp = new PermissionMethodParser();
        pmp.readReader(new InputStreamReader(input));
        return pmp;
    }

    public static PermissionMethodParser fromStringList(List<String> data) throws IOException {
        PermissionMethodParser pmp = new PermissionMethodParser(data);
        return pmp;
    }

    private PermissionMethodParser() {
    }

    private PermissionMethodParser(List<String> data) {
        this.data = data;
    }

    private void readFile(String fileName) throws IOException {
        try (FileReader fr = null;){
            fr = new FileReader(fileName);
            this.readReader(fr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readReader(Reader r) throws IOException {
        this.data = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(r);){
            String line;
            while ((line = br.readLine()) != null) {
                this.data.add(line);
            }
        }
    }

    public Set<ISourceSinkDefinition> getSources() {
        if (this.sourceList == null || this.sinkList == null) {
            this.parse();
        }
        return this.sourceList;
    }

    public Set<ISourceSinkDefinition> getSinks() {
        if (this.sourceList == null || this.sinkList == null) {
            this.parse();
        }
        return this.sinkList;
    }

    private void parse() {
        this.methods = new HashMap<String, AndroidMethod>(10000);
        this.sourceList = new HashSet<ISourceSinkDefinition>(10000);
        this.sinkList = new HashSet<ISourceSinkDefinition>(10000);
        this.neitherList = new HashSet<ISourceSinkDefinition>(10000);
        Pattern p = Pattern.compile("^<(.+):\\s*(.+)\\s+(.+)\\s*\\((.*)\\)>\\s*(.*?)(\\s+->\\s+(.*))?$");
        Pattern pNoRet = Pattern.compile("^<(.+):\\s*(.+)\\s*\\((.*)\\)>\\s*(.*?)?(\\s+->\\s+(.*))?$");
        for (String line : this.data) {
            if (line.isEmpty() || line.startsWith("%")) continue;
            Matcher m = p.matcher(line);
            if (m.find()) {
                this.createMethod(m);
                continue;
            }
            Matcher mNoRet = pNoRet.matcher(line);
            if (mNoRet.find()) {
                this.createMethod(mNoRet);
                continue;
            }
            this.logger.warn(String.format("Line does not match: %s", line));
        }
        for (AndroidMethod am : this.methods.values()) {
            MethodSourceSinkDefinition singleMethod = new MethodSourceSinkDefinition((SootMethodAndClass)am);
            if (am.getSourceSinkType().isSource()) {
                this.sourceList.add((ISourceSinkDefinition)singleMethod);
            }
            if (am.getSourceSinkType().isSink()) {
                this.sinkList.add((ISourceSinkDefinition)singleMethod);
            }
            if (am.getSourceSinkType() != SourceSinkType.Neither) continue;
            this.neitherList.add((ISourceSinkDefinition)singleMethod);
        }
    }

    private AndroidMethod createMethod(Matcher m) {
        AndroidMethod am = this.parseMethod(m, true);
        AndroidMethod oldMethod = this.methods.get(am.getSignature());
        if (oldMethod != null) {
            oldMethod.setSourceSinkType(oldMethod.getSourceSinkType().addType(am.getSourceSinkType()));
            return oldMethod;
        }
        this.methods.put(am.getSignature(), am);
        return am;
    }

    private AndroidMethod parseMethod(Matcher m, boolean hasReturnType) {
        String params;
        assert (m.group(1) != null && m.group(2) != null && m.group(3) != null && m.group(4) != null);
        int groupIdx = 1;
        String className = m.group(groupIdx++).trim();
        String returnType = "";
        if (hasReturnType) {
            returnType = m.group(groupIdx++).trim();
        }
        String methodName = m.group(groupIdx++).trim();
        ArrayList<String> methodParameters = new ArrayList<String>();
        if (!(params = m.group(groupIdx++).trim()).isEmpty()) {
            for (String parameter : params.split(",")) {
                methodParameters.add(parameter.trim());
            }
        }
        String classData = "";
        String permData = "";
        HashSet<String> permissions = null;
        if (groupIdx < m.groupCount() && m.group(groupIdx) != null) {
            permData = m.group(groupIdx);
            if (permData.contains("->")) {
                classData = permData.replace("->", "").trim();
                permData = "";
            }
            ++groupIdx;
        }
        if (!permData.isEmpty()) {
            permissions = new HashSet<String>();
            for (String permission : permData.split(" ")) {
                permissions.add(permission);
            }
        }
        AndroidMethod singleMethod = new AndroidMethod(methodName, methodParameters, returnType, className, permissions);
        if (classData.isEmpty() && m.group(groupIdx) != null) {
            classData = m.group(groupIdx).replace("->", "").trim();
            ++groupIdx;
        }
        if (!classData.isEmpty()) {
            for (String target : classData.split("\\s")) {
                if ((target = target.trim()).contains("|")) {
                    target = target.substring(target.indexOf(124));
                }
                if (target.isEmpty() || target.startsWith("|")) continue;
                if (target.equals("_SOURCE_")) {
                    singleMethod.setSourceSinkType(SourceSinkType.Source);
                    continue;
                }
                if (target.equals("_SINK_")) {
                    singleMethod.setSourceSinkType(SourceSinkType.Sink);
                    continue;
                }
                if (target.equals("_NONE_")) {
                    singleMethod.setSourceSinkType(SourceSinkType.Neither);
                    continue;
                }
                if (target.equals("_BOTH_")) {
                    singleMethod.setSourceSinkType(SourceSinkType.Both);
                    continue;
                }
                throw new RuntimeException("error in target definition: " + target);
            }
        }
        return singleMethod;
    }

    public Set<ISourceSinkDefinition> getAllMethods() {
        if (this.sourceList == null || this.sinkList == null) {
            this.parse();
        }
        HashSet<ISourceSinkDefinition> sourcesSinks = new HashSet<ISourceSinkDefinition>(this.sourceList.size() + this.sinkList.size() + this.neitherList.size());
        sourcesSinks.addAll(this.sourceList);
        sourcesSinks.addAll(this.sinkList);
        sourcesSinks.addAll(this.neitherList);
        return sourcesSinks;
    }
}

