/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.config;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.android.InfoflowAndroidConfiguration;
import soot.jimple.infoflow.android.data.CategoryDefinition;

public class XMLConfigurationWriter {
    private final InfoflowAndroidConfiguration config;

    public XMLConfigurationWriter(InfoflowAndroidConfiguration config) {
        this.config = config;
    }

    public String write() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element rootElement = document.createElement("configuration");
            document.appendChild(rootElement);
            this.writeAnalysisFileConfig(document, rootElement);
            this.writeSourceSinkConfig(document, rootElement);
            this.writeAndroidConfig(document, rootElement);
            this.writeIccConfig(document, rootElement);
            this.writeDataFlowConfig(document, rootElement);
            StringWriter stringWriter = new StringWriter();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(stringWriter);
            transformer.transform(source, result);
            return stringWriter.toString();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        catch (TransformerConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void writeDataFlowConfig(Document document, Element parentElement) {
        Element dataFlowConfigTag = document.createElement("dataFlowConfiguration");
        parentElement.appendChild(dataFlowConfigTag);
        InfoflowConfiguration.PathConfiguration pathConfig = this.config.getPathConfiguration();
        InfoflowConfiguration.SolverConfiguration solverConfig = this.config.getSolverConfiguration();
        this.appendSimpleTag(document, dataFlowConfigTag, "maxJoinPointAbstractions", Integer.toString(solverConfig.getMaxJoinPointAbstractions()));
        this.appendSimpleTag(document, dataFlowConfigTag, "maxCalleesPerCallSite", Integer.toString(solverConfig.getMaxCalleesPerCallSite()));
        this.appendSimpleTag(document, dataFlowConfigTag, "implicitFlowMode", this.config.getImplicitFlowMode().toString());
        this.appendSimpleTag(document, dataFlowConfigTag, "staticFieldTrackingMode", this.config.getStaticFieldTrackingMode().toString());
        this.appendSimpleTag(document, dataFlowConfigTag, "enableExceptions", Boolean.toString(this.config.getEnableExceptionTracking()));
        this.appendSimpleTag(document, dataFlowConfigTag, "enableArrays", Boolean.toString(this.config.getEnableArrayTracking()));
        this.appendSimpleTag(document, dataFlowConfigTag, "enableReflection", Boolean.toString(this.config.getEnableReflection()));
        this.appendSimpleTag(document, dataFlowConfigTag, "flowSensitiveAliasing", Boolean.toString(this.config.getFlowSensitiveAliasing()));
        this.appendSimpleTag(document, dataFlowConfigTag, "logSourcesAndSinks", Boolean.toString(this.config.getLogSourcesAndSinks()));
        this.appendSimpleTag(document, dataFlowConfigTag, "enableArraySizeTainting", Boolean.toString(this.config.getEnableArraySizeTainting()));
        this.appendSimpleTag(document, dataFlowConfigTag, "pathReconstructionMode", pathConfig.getPathReconstructionMode().toString());
        this.appendSimpleTag(document, dataFlowConfigTag, "pathAgnosticResults", Boolean.toString(InfoflowConfiguration.getPathAgnosticResults()));
        this.appendSimpleTag(document, dataFlowConfigTag, "maxCallStackSize", Integer.toString(pathConfig.getMaxCallStackSize()));
        this.appendSimpleTag(document, dataFlowConfigTag, "maxPathLength", Integer.toString(pathConfig.getMaxPathLength()));
        this.appendSimpleTag(document, dataFlowConfigTag, "maxPathsPerAbstraction", Integer.toString(pathConfig.getMaxPathsPerAbstraction()));
        this.appendSimpleTag(document, dataFlowConfigTag, "dataFlowTimeout", Long.toString(this.config.getDataFlowTimeout()));
        this.appendSimpleTag(document, dataFlowConfigTag, "pathReconstructionTimeout", Long.toString(pathConfig.getPathReconstructionTimeout()));
        this.appendSimpleTag(document, dataFlowConfigTag, "pathReconstructionBatchSize", Integer.toString(pathConfig.getPathReconstructionBatchSize()));
        this.appendSimpleTag(document, dataFlowConfigTag, "writeOutputFiles", Boolean.toString(this.config.getWriteOutputFiles()));
    }

    private void writeIccConfig(Document document, Element parentElement) {
        Element iccConfigTag = document.createElement("iccConfiguration");
        parentElement.appendChild(iccConfigTag);
        InfoflowAndroidConfiguration.IccConfiguration iccConfig = this.config.getIccConfig();
        this.appendSimpleTag(document, iccConfigTag, "enableICCTracking", Boolean.toString(iccConfig.isIccEnabled()));
        this.appendSimpleTag(document, iccConfigTag, "modelFile", iccConfig.getIccModel());
        this.appendSimpleTag(document, iccConfigTag, "purifyResults", Boolean.toString(iccConfig.isIccResultsPurifyEnabled()));
    }

    private void writeAndroidConfig(Document document, Element parentElement) {
        Element androidConfigTag = document.createElement("androidConfiguration");
        parentElement.appendChild(androidConfigTag);
        InfoflowAndroidConfiguration.CallbackConfiguration callbackConfig = this.config.getCallbackConfig();
        InfoflowAndroidConfiguration.SourceSinkConfiguration sourceSinkConfig = this.config.getSourceSinkConfig();
        this.appendSimpleTag(document, androidConfigTag, "enableCallbacks", Boolean.toString(callbackConfig.getEnableCallbacks()));
        this.appendSimpleTag(document, androidConfigTag, "filterThreadCallbacks", Boolean.toString(callbackConfig.getFilterThreadCallbacks()));
        this.appendSimpleTag(document, androidConfigTag, "maxCallbacksPerComponent", Integer.toString(callbackConfig.getMaxCallbacksPerComponent()));
        this.appendSimpleTag(document, androidConfigTag, "maxCallbackDepth", Integer.toString(callbackConfig.getMaxAnalysisCallbackDepth()));
        this.appendSimpleTag(document, androidConfigTag, "layoutMatchingMode", sourceSinkConfig.getLayoutMatchingMode().toString());
        this.appendSimpleTag(document, androidConfigTag, "mergeDexFiles", Boolean.toString(this.config.getMergeDexFiles()));
        this.appendSimpleTag(document, androidConfigTag, "callbackSourceMode", sourceSinkConfig.getCallbackSourceMode().toString());
        this.appendSimpleTag(document, androidConfigTag, "callbackAnalysisTimeout", Integer.toString(callbackConfig.getCallbackAnalysisTimeout()));
    }

    private void writeSourceSinkConfig(Document document, Element parentElement) {
        Element sourceSpecTag = document.createElement("sources");
        parentElement.appendChild(sourceSpecTag);
        sourceSpecTag.setAttribute("defaultMode", this.config.getSourceSinkConfig().getSourceFilterMode().toString());
        this.writeCategoryConfig(document, sourceSpecTag, this.config.getSourceSinkConfig().getSourceCategoriesAndModes());
        Element sinkSpecTag = document.createElement("sinks");
        parentElement.appendChild(sinkSpecTag);
        sinkSpecTag.setAttribute("defaultMode", this.config.getSourceSinkConfig().getSinkFilterMode().toString());
        this.writeCategoryConfig(document, sinkSpecTag, this.config.getSourceSinkConfig().getSinkCategoriesAndModes());
    }

    private void writeCategoryConfig(Document document, Element parentElement, Map<CategoryDefinition, InfoflowConfiguration.CategoryMode> categorySpec) {
        for (CategoryDefinition def : categorySpec.keySet()) {
            if (this.config.getSourceSinkConfig().getSourceFilterMode() == InfoflowConfiguration.SourceSinkFilterMode.UseAllButExcluded && categorySpec.get(def) == InfoflowConfiguration.CategoryMode.Include || this.config.getSourceSinkConfig().getSourceFilterMode() == InfoflowConfiguration.SourceSinkFilterMode.UseOnlyIncluded && categorySpec.get(def) == InfoflowConfiguration.CategoryMode.Exclude) continue;
            Element categoryTag = document.createElement("category");
            parentElement.appendChild(categoryTag);
            categoryTag.setAttribute("id", def.getSystemCategory().toString());
            if (def.getCustomCategory() != null && !def.getCustomCategory().isEmpty()) {
                categoryTag.setAttribute("customId", def.getCustomCategory());
            }
            categoryTag.setAttribute("mode", categorySpec.get(def).toString());
        }
    }

    private void writeAnalysisFileConfig(Document document, Element parentElement) {
        Element inputFileTag = document.createElement("inputFiles");
        parentElement.appendChild(inputFileTag);
        this.appendSimpleTag(document, inputFileTag, "targetAPK", this.config.getAnalysisFileConfig().getTargetAPKFile());
        this.appendSimpleTag(document, inputFileTag, "sourceSinkFile", this.config.getAnalysisFileConfig().getSourceSinkFile());
        this.appendSimpleTag(document, inputFileTag, "androidPlatform", this.config.getAnalysisFileConfig().getAndroidPlatformDir());
        this.appendSimpleTag(document, inputFileTag, "outputFile", this.config.getAnalysisFileConfig().getOutputFile());
    }

    private void appendSimpleTag(Document document, Element parentElement, String tagName, String contents) {
        Element newElement = document.createElement(tagName);
        parentElement.appendChild(newElement);
        newElement.setTextContent(contents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String fileName) throws IOException {
        String xmlData = this.write();
        try (PrintWriter pw = null;){
            pw = new PrintWriter(fileName);
            pw.write(xmlData);
        }
    }
}

