/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.callbacks.filters;

import java.util.Set;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.jimple.infoflow.android.callbacks.filters.AbstractCallbackFilter;
import soot.jimple.infoflow.android.entryPointCreators.AndroidEntryPointConstants;

public class ApplicationCallbackFilter
extends AbstractCallbackFilter {
    private final String applicationClass;
    private SootClass activityLifecycleCallbacks;
    private SootClass provideAssistDataListener;
    private SootClass componentCallbacks;

    public ApplicationCallbackFilter(Set<SootClass> entrypoints) {
        this(ApplicationCallbackFilter.getApplicationClass(entrypoints));
    }

    private static String getApplicationClass(Set<SootClass> entrypoints) {
        SootClass scApplication = Scene.v().getSootClassUnsafe("android.app.Application");
        for (SootClass sc : entrypoints) {
            if (sc == null || !Scene.v().getOrMakeFastHierarchy().canStoreType((Type)sc.getType(), (Type)scApplication.getType())) continue;
            return sc.getName();
        }
        return null;
    }

    public ApplicationCallbackFilter(String applicationClass) {
        this.applicationClass = applicationClass;
        this.reset();
    }

    @Override
    public boolean accepts(SootClass component, SootClass callbackHandler) {
        return this.applicationClass == null || !component.getName().equals(this.applicationClass) || callbackHandler.getName().equals(this.applicationClass) || Scene.v().getOrMakeFastHierarchy().canStoreType((Type)callbackHandler.getType(), (Type)this.activityLifecycleCallbacks.getType()) || Scene.v().getOrMakeFastHierarchy().canStoreType((Type)callbackHandler.getType(), (Type)this.provideAssistDataListener.getType()) || Scene.v().getOrMakeFastHierarchy().canStoreType((Type)callbackHandler.getType(), (Type)this.componentCallbacks.getType());
    }

    @Override
    public void reset() {
        this.activityLifecycleCallbacks = Scene.v().getSootClassUnsafe("android.app.Application$ActivityLifecycleCallbacks");
        this.provideAssistDataListener = Scene.v().getSootClassUnsafe("android.app.Application$OnProvideAssistDataListener");
        this.componentCallbacks = Scene.v().getSootClassUnsafe("android.content.ComponentCallbacks");
    }

    @Override
    public boolean accepts(SootClass component, SootMethod callback) {
        if (component.getName().equals(this.applicationClass)) {
            return true;
        }
        String subSig = callback.getSubSignature();
        return !AndroidEntryPointConstants.getActivityLifecycleCallbackMethods().contains(subSig) && !AndroidEntryPointConstants.getComponentCallbackMethods().contains(subSig) && !AndroidEntryPointConstants.getComponentCallback2Methods().contains(subSig);
    }
}

