/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.callbacks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.AnySubType;
import soot.Body;
import soot.FastHierarchy;
import soot.Local;
import soot.PointsToSet;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;
import soot.jimple.infoflow.android.InfoflowAndroidConfiguration;
import soot.jimple.infoflow.android.callbacks.AndroidCallbackDefinition;
import soot.jimple.infoflow.android.callbacks.filters.ICallbackFilter;
import soot.jimple.infoflow.android.source.parsers.xml.ResourceUtils;
import soot.jimple.infoflow.util.SootMethodRepresentationParser;
import soot.jimple.infoflow.util.SystemClassHandler;
import soot.jimple.infoflow.values.IValueProvider;
import soot.jimple.infoflow.values.SimpleConstantValueProvider;
import soot.jimple.toolkits.callgraph.Edge;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public abstract class AbstractCallbackAnalyzer {
    private static final String SIG_CAR_CREATE = "<android.car.Car: android.car.Car createCar(android.content.Context,android.content.ServiceConnection)>";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final SootClass scContext = Scene.v().getSootClassUnsafe("android.content.Context");
    protected final SootClass scBroadcastReceiver = Scene.v().getSootClassUnsafe("android.content.BroadcastReceiver");
    protected final SootClass scServiceConnection = Scene.v().getSootClassUnsafe("android.content.ServiceConnection");
    protected final SootClass scFragmentTransaction = Scene.v().getSootClassUnsafe("android.app.FragmentTransaction");
    protected final SootClass scFragment = Scene.v().getSootClassUnsafe("android.app.Fragment");
    protected final SootClass scSupportFragmentTransaction = Scene.v().getSootClassUnsafe("android.support.v4.app.FragmentTransaction");
    protected final SootClass scAndroidXFragmentTransaction = Scene.v().getSootClassUnsafe("androidx.fragment.app.FragmentTransaction");
    protected final SootClass scSupportFragment = Scene.v().getSootClassUnsafe("android.support.v4.app.Fragment");
    protected final SootClass scAndroidXFragment = Scene.v().getSootClassUnsafe("androidx.fragment.app.Fragment");
    protected final SootClass scSupportViewPager = Scene.v().getSootClassUnsafe("android.support.v4.view.ViewPager");
    protected final SootClass scAndroidXViewPager = Scene.v().getSootClassUnsafe("androidx.viewpager.widget.ViewPager");
    protected final SootClass scFragmentStatePagerAdapter = Scene.v().getSootClassUnsafe("android.support.v4.app.FragmentStatePagerAdapter");
    protected final SootClass scAndroidXFragmentStatePagerAdapter = Scene.v().getSootClassUnsafe("androidx.fragment.app.FragmentStatePagerAdapter");
    protected final InfoflowAndroidConfiguration config;
    protected final Set<SootClass> entryPointClasses;
    protected final Set<String> androidCallbacks;
    protected final MultiMap<SootClass, AndroidCallbackDefinition> callbackMethods = new HashMultiMap();
    protected final MultiMap<SootClass, Integer> layoutClasses = new HashMultiMap();
    protected final Set<SootClass> dynamicManifestComponents = new HashSet<SootClass>();
    protected final MultiMap<SootClass, SootClass> fragmentClasses = new HashMultiMap();
    protected final Map<SootClass, Integer> fragmentIDs = new HashMap<SootClass, Integer>();
    protected final List<ICallbackFilter> callbackFilters = new ArrayList<ICallbackFilter>();
    protected final Set<SootClass> excludedEntryPoints = new HashSet<SootClass>();
    protected IValueProvider valueProvider = new SimpleConstantValueProvider();

    public AbstractCallbackAnalyzer(InfoflowAndroidConfiguration config, Set<SootClass> entryPointClasses) throws IOException {
        this(config, entryPointClasses, "AndroidCallbacks.txt");
    }

    public AbstractCallbackAnalyzer(InfoflowAndroidConfiguration config, Set<SootClass> entryPointClasses, String callbackFile) throws IOException {
        this(config, entryPointClasses, AbstractCallbackAnalyzer.loadAndroidCallbacks(callbackFile));
    }

    public AbstractCallbackAnalyzer(InfoflowAndroidConfiguration config, Set<SootClass> entryPointClasses, InputStream inputStream) throws IOException {
        this(config, entryPointClasses, AbstractCallbackAnalyzer.loadAndroidCallbacks(new InputStreamReader(inputStream)));
    }

    public AbstractCallbackAnalyzer(InfoflowAndroidConfiguration config, Set<SootClass> entryPointClasses, Reader reader) throws IOException {
        this(config, entryPointClasses, AbstractCallbackAnalyzer.loadAndroidCallbacks(reader));
    }

    public AbstractCallbackAnalyzer(InfoflowAndroidConfiguration config, Set<SootClass> entryPointClasses, Set<String> androidCallbacks) throws IOException {
        this.config = config;
        this.entryPointClasses = entryPointClasses;
        this.androidCallbacks = androidCallbacks;
    }

    private static Set<String> loadAndroidCallbacks(String androidCallbackFile) throws IOException {
        String fileName = androidCallbackFile;
        if (!new File(fileName).exists() && !new File(fileName = "../soot-infoflow-android/AndroidCallbacks.txt").exists()) {
            try (InputStream is = ResourceUtils.getResourceStream("/AndroidCallbacks.txt");){
                Set<String> set = AbstractCallbackAnalyzer.loadAndroidCallbacks(new InputStreamReader(is));
                return set;
            }
        }
        try (FileReader fr = new FileReader(fileName);){
            Set<String> set = AbstractCallbackAnalyzer.loadAndroidCallbacks(fr);
            return set;
        }
    }

    public static Set<String> loadAndroidCallbacks(Reader reader) throws IOException {
        HashSet<String> androidCallbacks = new HashSet<String>();
        try (BufferedReader bufReader = new BufferedReader(reader);){
            String line;
            while ((line = bufReader.readLine()) != null) {
                if (line.isEmpty()) continue;
                androidCallbacks.add(line);
            }
        }
        return androidCallbacks;
    }

    public void collectCallbackMethods() {
        for (ICallbackFilter filter : this.callbackFilters) {
            filter.reset();
        }
    }

    protected void analyzeMethodForCallbackRegistrations(SootClass lifecycleElement, SootMethod method) {
        if (SystemClassHandler.v().isClassInSystemPackage(method.getDeclaringClass().getName())) {
            return;
        }
        if (!method.isConcrete()) {
            return;
        }
        HashSet<SootClass> callbackClasses = new HashSet<SootClass>();
        for (Unit u : method.retrieveActiveBody().getUnits()) {
            Stmt stmt = (Stmt)u;
            if (!stmt.containsInvokeExpr() || !(stmt.getInvokeExpr() instanceof InstanceInvokeExpr)) continue;
            InstanceInvokeExpr iinv = (InstanceInvokeExpr)stmt.getInvokeExpr();
            SootMethodRef mref = iinv.getMethodRef();
            for (int i = 0; i < iinv.getArgCount(); ++i) {
                RefType baseType;
                String param;
                Type type = mref.getParameterType(i);
                if (!(type instanceof RefType) || !this.androidCallbacks.contains(param = type.toString())) continue;
                Value arg = iinv.getArg(i);
                if (!SystemClassHandler.v().isClassInSystemPackage(iinv.getMethod().getDeclaringClass().getName()) || !(arg instanceof Local)) continue;
                Set possibleTypes = Scene.v().getPointsToAnalysis().reachingObjects((Local)arg).possibleTypes();
                for (Type possibleType : possibleTypes) {
                    RefType baseType2;
                    if (possibleType instanceof RefType) {
                        baseType2 = (RefType)possibleType;
                    } else if (possibleType instanceof AnySubType) {
                        baseType2 = ((AnySubType)possibleType).getBase();
                    } else {
                        this.logger.warn("Unsupported type detected in callback analysis");
                        continue;
                    }
                    SootClass targetClass = baseType2.getSootClass();
                    if (SystemClassHandler.v().isClassInSystemPackage(targetClass.getName())) continue;
                    callbackClasses.add(targetClass);
                }
                if (!possibleTypes.isEmpty()) continue;
                Type argType = ((Local)arg).getType();
                if (argType instanceof RefType) {
                    baseType = (RefType)argType;
                } else if (argType instanceof AnySubType) {
                    baseType = ((AnySubType)argType).getBase();
                } else {
                    this.logger.warn("Unsupported type detected in callback analysis");
                    continue;
                }
                SootClass targetClass = baseType.getSootClass();
                if (SystemClassHandler.v().isClassInSystemPackage(targetClass.getName())) continue;
                callbackClasses.add(targetClass);
            }
        }
        for (SootClass callbackClass : callbackClasses) {
            this.analyzeClassInterfaceCallbacks(callbackClass, callbackClass, lifecycleElement);
        }
    }

    private boolean filterAccepts(SootClass lifecycleElement, SootClass targetClass) {
        for (ICallbackFilter filter : this.callbackFilters) {
            if (filter.accepts(lifecycleElement, targetClass)) continue;
            return false;
        }
        return true;
    }

    private boolean filterAccepts(SootClass lifecycleElement, SootMethod targetMethod) {
        for (ICallbackFilter filter : this.callbackFilters) {
            if (filter.accepts(lifecycleElement, targetMethod)) continue;
            return false;
        }
        return true;
    }

    protected void analyzeMethodForDynamicBroadcastReceiver(SootMethod method) {
        if (SystemClassHandler.v().isClassInSystemPackage(method.getDeclaringClass().getName())) {
            return;
        }
        if (!method.isConcrete() || !method.hasActiveBody()) {
            return;
        }
        FastHierarchy fastHierarchy = Scene.v().getFastHierarchy();
        RefType contextType = this.scContext.getType();
        for (Unit u : method.getActiveBody().getUnits()) {
            Value br;
            InvokeExpr iexpr;
            SootMethodRef methodRef;
            Stmt stmt = (Stmt)u;
            if (!stmt.containsInvokeExpr() || !(methodRef = (iexpr = stmt.getInvokeExpr()).getMethodRef()).getName().equals("registerReceiver") || iexpr.getArgCount() <= 0 || !fastHierarchy.canStoreType((Type)methodRef.getDeclaringClass().getType(), (Type)contextType) || !((br = iexpr.getArg(0)).getType() instanceof RefType)) continue;
            RefType rt = (RefType)br.getType();
            if (SystemClassHandler.v().isClassInSystemPackage(rt.getSootClass().getName())) continue;
            this.dynamicManifestComponents.add(rt.getSootClass());
        }
    }

    protected void analyzeMethodForServiceConnection(SootMethod method) {
        if (SystemClassHandler.v().isClassInSystemPackage(method.getDeclaringClass().getName())) {
            return;
        }
        if (!method.isConcrete() || !method.hasActiveBody()) {
            return;
        }
        for (Unit u : method.getActiveBody().getUnits()) {
            InvokeExpr iexpr;
            SootMethodRef methodRef;
            Stmt stmt = (Stmt)u;
            if (!stmt.containsInvokeExpr() || !(methodRef = (iexpr = stmt.getInvokeExpr()).getMethodRef()).getSignature().equals(SIG_CAR_CREATE)) continue;
            Value br = iexpr.getArg(1);
            if (br instanceof Local && Scene.v().hasPointsToAnalysis()) {
                PointsToSet pts = Scene.v().getPointsToAnalysis().reachingObjects((Local)br);
                for (Type tp : pts.possibleTypes()) {
                    if (!(tp instanceof RefType)) continue;
                    RefType rt = (RefType)tp;
                    if (SystemClassHandler.v().isClassInSystemPackage(rt.getSootClass().getName())) continue;
                    this.dynamicManifestComponents.add(rt.getSootClass());
                }
            }
            if (!(br.getType() instanceof RefType)) continue;
            RefType rt = (RefType)br.getType();
            if (SystemClassHandler.v().isClassInSystemPackage(rt.getSootClass().getName())) continue;
            this.dynamicManifestComponents.add(rt.getSootClass());
        }
    }

    protected void analyzeMethodForFragmentTransaction(SootClass lifecycleElement, SootMethod method) {
        Stmt stmt;
        if (!(this.scFragment != null && this.scFragmentTransaction != null || this.scSupportFragment != null && this.scSupportFragmentTransaction != null || this.scAndroidXFragment != null && this.scAndroidXFragmentTransaction != null)) {
            return;
        }
        if (!method.isConcrete() || !method.hasActiveBody()) {
            return;
        }
        boolean isFragmentManager = false;
        boolean isFragmentTransaction = false;
        boolean isAddTransaction = false;
        for (Unit u : method.getActiveBody().getUnits()) {
            Value arg;
            Integer fragmentID;
            stmt = (Stmt)u;
            if (!stmt.containsInvokeExpr()) continue;
            String methodName = stmt.getInvokeExpr().getMethod().getName();
            if (methodName.equals("getFragmentManager")) {
                isFragmentManager = true;
                continue;
            }
            if (methodName.equals("beginTransaction")) {
                isFragmentTransaction = true;
                continue;
            }
            if (methodName.equals("add") || methodName.equals("replace")) {
                isAddTransaction = true;
                continue;
            }
            if (!methodName.equals("inflate") || stmt.getInvokeExpr().getArgCount() <= 1 || (fragmentID = (Integer)this.valueProvider.getValue(method, stmt, arg = stmt.getInvokeExpr().getArg(0), Integer.class)) == null) continue;
            this.fragmentIDs.put(lifecycleElement, fragmentID);
        }
        if (isFragmentManager && isFragmentTransaction && isAddTransaction) {
            for (Unit u : method.getActiveBody().getUnits()) {
                InvokeExpr invExpr;
                stmt = (Stmt)u;
                if (!stmt.containsInvokeExpr() || !((invExpr = stmt.getInvokeExpr()) instanceof InstanceInvokeExpr)) continue;
                InstanceInvokeExpr iinvExpr = (InstanceInvokeExpr)invExpr;
                isFragmentTransaction = this.scFragmentTransaction != null && Scene.v().getFastHierarchy().canStoreType(iinvExpr.getBase().getType(), (Type)this.scFragmentTransaction.getType());
                isFragmentTransaction |= this.scSupportFragmentTransaction != null && Scene.v().getFastHierarchy().canStoreType(iinvExpr.getBase().getType(), (Type)this.scSupportFragmentTransaction.getType());
                boolean bl = isAddTransaction = stmt.getInvokeExpr().getMethod().getName().equals("add") || stmt.getInvokeExpr().getMethod().getName().equals("replace");
                if (!(isFragmentTransaction |= this.scAndroidXFragmentTransaction != null && Scene.v().getFastHierarchy().canStoreType(iinvExpr.getBase().getType(), (Type)this.scAndroidXFragmentTransaction.getType())) || !isAddTransaction) continue;
                for (int i = 0; i < stmt.getInvokeExpr().getArgCount(); ++i) {
                    Value br = stmt.getInvokeExpr().getArg(i);
                    if (!(br.getType() instanceof RefType)) continue;
                    RefType rt = (RefType)br.getType();
                    boolean addFragment = this.scFragment != null && Scene.v().getFastHierarchy().canStoreType((Type)rt, (Type)this.scFragment.getType());
                    addFragment |= this.scSupportFragment != null && Scene.v().getFastHierarchy().canStoreType((Type)rt, (Type)this.scSupportFragment.getType());
                    if (!(addFragment |= this.scAndroidXFragment != null && Scene.v().getFastHierarchy().canStoreType((Type)rt, (Type)this.scAndroidXFragment.getType()))) continue;
                    this.checkAndAddFragment(method.getDeclaringClass(), rt.getSootClass());
                }
            }
        }
    }

    protected void analyzeMethodForViewPagers(SootClass clazz, SootMethod method) {
        if (!(this.scSupportViewPager != null && this.scFragmentStatePagerAdapter != null || this.scAndroidXViewPager != null && this.scAndroidXFragmentStatePagerAdapter != null)) {
            return;
        }
        if (!method.isConcrete()) {
            return;
        }
        Body body = method.retrieveActiveBody();
        for (Unit u : body.getUnits()) {
            Body b;
            Value pa;
            InstanceInvokeExpr iinvExpr;
            InvokeExpr invExpr;
            Stmt stmt = (Stmt)u;
            if (!stmt.containsInvokeExpr() || !((invExpr = stmt.getInvokeExpr()) instanceof InstanceInvokeExpr) || !this.safeIsType((iinvExpr = (InstanceInvokeExpr)invExpr).getBase(), this.scSupportViewPager) && !this.safeIsType(iinvExpr.getBase(), this.scAndroidXViewPager) || !stmt.getInvokeExpr().getMethod().getName().equals("setAdapter") || stmt.getInvokeExpr().getArgCount() != 1 || !((pa = stmt.getInvokeExpr().getArg(0)).getType() instanceof RefType)) continue;
            RefType rt = (RefType)pa.getType();
            if (!this.safeIsType(pa, this.scFragmentStatePagerAdapter) && !this.safeIsType(pa, this.scAndroidXFragmentStatePagerAdapter)) continue;
            SootMethod getItem = rt.getSootClass().getMethodUnsafe("android.support.v4.app.Fragment getItem(int)");
            if (getItem == null) {
                getItem = rt.getSootClass().getMethodUnsafe("androidx.fragment.app.Fragment getItem(int)");
            }
            if (getItem == null || !getItem.isConcrete() || (b = getItem.retrieveActiveBody()) == null) continue;
            for (Unit getItemUnit : b.getUnits()) {
                ReturnStmt rs;
                Value rv;
                Type type;
                if (!(getItemUnit instanceof ReturnStmt) || !((type = (rv = (rs = (ReturnStmt)getItemUnit).getOp()).getType()) instanceof RefType)) continue;
                this.checkAndAddFragment(method.getDeclaringClass(), ((RefType)type).getSootClass());
            }
        }
    }

    private boolean safeIsType(Value val, SootClass clazz) {
        return clazz != null && Scene.v().getFastHierarchy().canStoreType(val.getType(), (Type)clazz.getType());
    }

    protected boolean isInheritedMethod(Stmt stmt, String ... classNames) {
        if (!stmt.containsInvokeExpr()) {
            return false;
        }
        SootMethod tgt = stmt.getInvokeExpr().getMethod();
        for (String className : classNames) {
            if (!className.equals(tgt.getDeclaringClass().getName())) continue;
            return true;
        }
        if (Scene.v().hasCallGraph()) {
            Iterator edgeIt = Scene.v().getCallGraph().edgesOutOf((Unit)stmt);
            while (edgeIt.hasNext()) {
                Edge edge = (Edge)edgeIt.next();
                String targetClass = edge.getTgt().method().getDeclaringClass().getName();
                for (String className : classNames) {
                    if (!className.equals(targetClass)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean invokesSetContentView(InvokeExpr inv) {
        String methodName = SootMethodRepresentationParser.v().getMethodNameFromSubSignature(inv.getMethodRef().getSubSignature().getString());
        if (!methodName.equals("setContentView")) {
            return false;
        }
        SootClass curClass = inv.getMethod().getDeclaringClass();
        while (curClass != null) {
            if (curClass.getName().equals("android.app.Activity") || curClass.getName().equals("android.support.v7.app.ActionBarActivity") || curClass.getName().equals("android.support.v7.app.AppCompatActivity") || curClass.getName().equals("androidx.appcompat.app.AppCompatActivity")) {
                return true;
            }
            curClass = curClass.hasSuperclass() ? curClass.getSuperclass() : null;
        }
        return false;
    }

    protected boolean invokesInflate(InvokeExpr inv) {
        String methodName = SootMethodRepresentationParser.v().getMethodNameFromSubSignature(inv.getMethodRef().getSubSignature().getString());
        if (!methodName.equals("inflate")) {
            return false;
        }
        SootClass curClass = inv.getMethod().getDeclaringClass();
        while (curClass != null) {
            if (curClass.getName().equals("android.app.Fragment")) {
                return true;
            }
            if (curClass.declaresMethod("android.view.View inflate(int,android.view.ViewGroup,boolean)")) {
                return false;
            }
            curClass = curClass.hasSuperclass() ? curClass.getSuperclass() : null;
        }
        return false;
    }

    protected void analyzeMethodOverrideCallbacks(SootClass sootClass) {
        if (!sootClass.isConcrete()) {
            return;
        }
        if (sootClass.isInterface()) {
            return;
        }
        if (this.config.getIgnoreFlowsInSystemPackages() && SystemClassHandler.v().isClassInSystemPackage(sootClass.getName())) {
            return;
        }
        HashMap<String, SootMethod> systemMethods = new HashMap<String, SootMethod>(10000);
        for (SootClass parentClass : Scene.v().getActiveHierarchy().getSuperclassesOf(sootClass)) {
            if (!SystemClassHandler.v().isClassInSystemPackage(parentClass.getName())) continue;
            for (SootMethod sm : parentClass.getMethods()) {
                if (sm.isConstructor()) continue;
                systemMethods.put(sm.getSubSignature(), sm);
            }
        }
        for (SootClass parentClass : Scene.v().getActiveHierarchy().getSubclassesOfIncluding(sootClass)) {
            if (SystemClassHandler.v().isClassInSystemPackage(parentClass.getName())) continue;
            for (SootMethod method : parentClass.getMethods()) {
                SootMethod parentMethod;
                if (method.hasTag("SimulatedCodeElementTag") || (parentMethod = (SootMethod)systemMethods.get(method.getSubSignature())) == null) continue;
                this.checkAndAddMethod(method, parentMethod, sootClass, AndroidCallbackDefinition.CallbackType.Default);
            }
        }
    }

    private SootMethod getMethodFromHierarchyEx(SootClass c, String methodSignature) {
        SootMethod m = c.getMethodUnsafe(methodSignature);
        if (m != null) {
            return m;
        }
        SootClass superClass = c.getSuperclassUnsafe();
        if (superClass != null) {
            return this.getMethodFromHierarchyEx(superClass, methodSignature);
        }
        return null;
    }

    protected void analyzeClassInterfaceCallbacks(SootClass baseClass, SootClass sootClass, SootClass lifecycleElement) {
        if (!baseClass.isConcrete()) {
            return;
        }
        if (SystemClassHandler.v().isClassInSystemPackage(baseClass.getName())) {
            return;
        }
        if (SystemClassHandler.v().isClassInSystemPackage(sootClass.getName())) {
            return;
        }
        if (!this.filterAccepts(lifecycleElement, baseClass)) {
            return;
        }
        if (!this.filterAccepts(lifecycleElement, sootClass)) {
            return;
        }
        SootClass superClass = sootClass.getSuperclassUnsafe();
        if (superClass != null) {
            this.analyzeClassInterfaceCallbacks(baseClass, superClass, lifecycleElement);
        }
        for (SootClass i : this.collectAllInterfaces(sootClass)) {
            this.checkAndAddCallback(i, baseClass, lifecycleElement);
        }
        for (SootClass c : this.collectAllSuperClasses(sootClass)) {
            this.checkAndAddCallback(c, baseClass, lifecycleElement);
        }
    }

    private void checkAndAddCallback(SootClass sc, SootClass baseClass, SootClass lifecycleElement) {
        if (this.androidCallbacks.contains(sc.getName())) {
            AndroidCallbackDefinition.CallbackType callbackType = this.isUICallback(sc) ? AndroidCallbackDefinition.CallbackType.Widget : AndroidCallbackDefinition.CallbackType.Default;
            for (SootMethod sm : sc.getMethods()) {
                SootMethod callbackImplementation = this.getMethodFromHierarchyEx(baseClass, sm.getSubSignature());
                if (callbackImplementation == null) continue;
                this.checkAndAddMethod(callbackImplementation, sm, lifecycleElement, callbackType);
            }
        }
    }

    private boolean isUICallback(SootClass i) {
        return i.getName().startsWith("android.widget") || i.getName().startsWith("android.view") || i.getName().startsWith("android.content.DialogInterface$");
    }

    protected boolean checkAndAddMethod(SootMethod method, SootMethod parentMethod, SootClass lifecycleClass, AndroidCallbackDefinition.CallbackType callbackType) {
        if (SystemClassHandler.v().isClassInSystemPackage(method.getDeclaringClass().getName())) {
            return false;
        }
        if (method.isConcrete() && this.isEmpty(method.retrieveActiveBody())) {
            return false;
        }
        if (method.isConstructor() || method.isStaticInitializer()) {
            return false;
        }
        if (!this.filterAccepts(lifecycleClass, method.getDeclaringClass())) {
            return false;
        }
        if (!this.filterAccepts(lifecycleClass, method)) {
            return false;
        }
        return this.callbackMethods.put((Object)lifecycleClass, (Object)new AndroidCallbackDefinition(method, parentMethod, callbackType));
    }

    protected void checkAndAddFragment(SootClass componentClass, SootClass fragmentClass) {
        this.fragmentClasses.put((Object)componentClass, (Object)fragmentClass);
    }

    private boolean isEmpty(Body activeBody) {
        for (Unit u : activeBody.getUnits()) {
            if (u instanceof IdentityStmt || u instanceof ReturnVoidStmt) continue;
            return false;
        }
        return true;
    }

    private Set<SootClass> collectAllInterfaces(SootClass sootClass) {
        HashSet<SootClass> interfaces = new HashSet<SootClass>((Collection<SootClass>)sootClass.getInterfaces());
        for (SootClass i : sootClass.getInterfaces()) {
            interfaces.addAll(this.collectAllInterfaces(i));
        }
        return interfaces;
    }

    private Set<SootClass> collectAllSuperClasses(SootClass sootClass) {
        HashSet<SootClass> classes = new HashSet<SootClass>();
        if (sootClass.hasSuperclass()) {
            classes.add(sootClass.getSuperclass());
            classes.addAll(this.collectAllSuperClasses(sootClass.getSuperclass()));
        }
        return classes;
    }

    public MultiMap<SootClass, AndroidCallbackDefinition> getCallbackMethods() {
        return this.callbackMethods;
    }

    public MultiMap<SootClass, Integer> getLayoutClasses() {
        return this.layoutClasses;
    }

    public MultiMap<SootClass, SootClass> getFragmentClasses() {
        return this.fragmentClasses;
    }

    public Set<SootClass> getDynamicManifestComponents() {
        return this.dynamicManifestComponents;
    }

    public void addCallbackFilter(ICallbackFilter filter) {
        this.callbackFilters.add(filter);
    }

    public void excludeEntryPoint(SootClass entryPoint) {
        this.excludedEntryPoints.add(entryPoint);
    }

    public boolean isExcludedEntryPoint(SootClass entryPoint) {
        return this.excludedEntryPoints.contains(entryPoint);
    }

    public void setValueProvider(IValueProvider valueProvider) {
        this.valueProvider = valueProvider;
    }
}

