/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.axml.parsers;

import android.content.res.AXmlResourceParser;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;
import soot.jimple.infoflow.android.axml.AXmlAttribute;
import soot.jimple.infoflow.android.axml.AXmlNamespace;
import soot.jimple.infoflow.android.axml.AXmlNode;
import soot.jimple.infoflow.android.axml.parsers.AbstractBinaryXMLFileParser;

public class AXMLPrinter2Parser
extends AbstractBinaryXMLFileParser {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void parseFile(byte[] inputBuffer) throws IOException {
        BufferedInputStream buffer = new BufferedInputStream(new ByteArrayInputStream(inputBuffer));
        AXmlNode node = null;
        AXmlNode parent = null;
        AXmlResourceParser parser = new AXmlResourceParser();
        parser.open((InputStream)buffer);
        int type = -1;
        try {
            int i;
            for (i = 0; i < parser.getNamespaceCount(parser.getDepth()); ++i) {
                this.document.addNamespace(new AXmlNamespace(parser.getNamespacePrefix(i), parser.getNamespaceUri(i), parser.getLineNumber()));
            }
            block15: while ((type = parser.next()) != 1) {
                switch (type) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        String tag = parser.getName();
                        parent = node;
                        node = new AXmlNode(tag, parser.getNamespace(), parent, false);
                        this.addPointer(tag, node);
                        for (i = 0; i < parser.getAttributeCount(); ++i) {
                            String name = parser.getAttributeName(i);
                            String ns = parser.getAttributeNamespace(i);
                            int atype = parser.getAttributeValueType(i);
                            AXmlAttribute<Object> attr = null;
                            int resourceId = parser.getAttributeNameResource(i);
                            switch (atype) {
                                case 3: {
                                    attr = new AXmlAttribute<String>(name, resourceId, atype, parser.getAttributeValue(i), ns, false);
                                    break;
                                }
                                case 18: {
                                    attr = new AXmlAttribute<Boolean>(name, resourceId, atype, parser.getAttributeBooleanValue(i, false), ns, false);
                                    break;
                                }
                                case 16: 
                                case 17: {
                                    attr = new AXmlAttribute<Integer>(name, resourceId, atype, parser.getAttributeIntValue(i, 0), ns, false);
                                    break;
                                }
                                case 1: {
                                    attr = new AXmlAttribute<Integer>(name, resourceId, atype, parser.getAttributeResourceValue(i, 0), ns, false);
                                    break;
                                }
                                default: {
                                    this.logger.error("Unsupported attribute type: %d", (Object)atype);
                                }
                            }
                            if (attr == null) continue;
                            node.addAttribute(attr);
                        }
                        continue block15;
                    }
                    case 3: {
                        this.document.setRootNode(node);
                        node = parent;
                        parent = parent == null ? null : parent.getParent();
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
            }
        }
        catch (XmlPullParserException ex) {
            throw new IOException(ex);
        }
    }
}

