/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.axml;

public class AXmlComplexValue {
    private final Unit unit;
    private final int mantissa;
    private final int radix;

    public AXmlComplexValue(Unit unit, int mantissa, int radix) {
        this.unit = unit;
        this.mantissa = mantissa;
        this.radix = radix;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public int getMantissa() {
        return this.mantissa;
    }

    public int getRadix() {
        return this.radix;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toString(this.mantissa));
        sb.append('.');
        sb.append(Integer.toString(this.radix));
        sb.append(this.unit.toString());
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mantissa;
        result = 31 * result + this.radix;
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AXmlComplexValue other = (AXmlComplexValue)obj;
        if (this.mantissa != other.mantissa) {
            return false;
        }
        if (this.radix != other.radix) {
            return false;
        }
        return this.unit == other.unit;
    }

    public static enum Unit {
        DIP,
        Fraction,
        FractionParent,
        IN,
        MM,
        PT,
        PX,
        SP;


        public String toString() {
            switch (this) {
                case DIP: {
                    return "dip";
                }
                case Fraction: 
                case FractionParent: {
                    return "%";
                }
                case IN: {
                    return "in";
                }
                case MM: {
                    return "mm";
                }
                case PT: {
                    return "pt";
                }
                case PX: {
                    return "px";
                }
                case SP: {
                    return "sp";
                }
            }
            return "";
        }
    }
}

