/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.xml;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import soot.jimple.infoflow.methodSummary.data.summary.SummaryMetaData;
import soot.jimple.infoflow.methodSummary.xml.AbstractXMLReader;
import soot.jimple.infoflow.methodSummary.xml.SummaryXMLException;

public class MetaDataReader
extends AbstractXMLReader {
    private static final String XSD_FILE_PATH = "schema/SummaryMetaData.xsd";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SummaryMetaData read(Reader reader) throws XMLStreamException, SummaryXMLException, IOException {
        SummaryMetaData metaData = new SummaryMetaData();
        try (XMLStreamReader xmlreader = null;){
            xmlreader = XMLInputFactory.newInstance().createXMLStreamReader(reader);
            String name = "";
            String type = "";
            String superclass = "";
            State state = State.summaryMetaData;
            while (xmlreader.hasNext()) {
                xmlreader.next();
                if (!xmlreader.hasName()) continue;
                String localName = xmlreader.getLocalName();
                if (localName.equals("exclusiveModels") && xmlreader.isStartElement()) {
                    if (state == State.summaryMetaData) {
                        state = State.exclusiveModels;
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("exclusiveModel") && xmlreader.isStartElement()) {
                    if (state == State.exclusiveModels) {
                        state = State.exclusiveModel;
                        name = this.getAttributeByName(xmlreader, "name");
                        type = this.getAttributeByName(xmlreader, "type");
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("exclusiveModel") && xmlreader.isEndElement()) {
                    if (state == State.exclusiveModel) {
                        state = State.exclusiveModels;
                        if (type == null || name == null || name.isEmpty()) continue;
                        switch (type) {
                            case "class": {
                                metaData.getExclusiveClasses().add(name);
                                break;
                            }
                            case "package": {
                                metaData.getExclusivePackages().add(name);
                            }
                        }
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("exclusiveModels") && xmlreader.isEndElement()) {
                    if (state == State.exclusiveModels) {
                        state = State.summaryMetaData;
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("hierarchy") && xmlreader.isStartElement()) {
                    if (state == State.summaryMetaData) {
                        state = State.hierarchy;
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("class") && xmlreader.isStartElement()) {
                    if (state == State.hierarchy) {
                        state = State.clazz;
                        name = this.getAttributeByName(xmlreader, "name");
                        superclass = this.getAttributeByName(xmlreader, "superClass");
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("class") && xmlreader.isEndElement()) {
                    if (state == State.clazz) {
                        state = State.hierarchy;
                        metaData.setSuperclass(name, superclass);
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (!localName.equals("hierarchy") || !xmlreader.isEndElement()) continue;
                if (state == State.hierarchy) {
                    state = State.summaryMetaData;
                    continue;
                }
                throw new SummaryXMLException();
            }
            SummaryMetaData summaryMetaData = metaData;
            return summaryMetaData;
        }
    }

    public SummaryMetaData read(File fileName) throws XMLStreamException, SummaryXMLException, IOException {
        try (FileReader rdr = null;){
            rdr = new FileReader(fileName);
            if (!MetaDataReader.verifyXML(rdr, XSD_FILE_PATH)) {
                throw new RuntimeException("The XML-File isn't valid");
            }
        }
        return this.read(new FileReader(fileName));
    }

    private static enum State {
        summaryMetaData,
        exclusiveModels,
        exclusiveModel,
        hierarchy,
        clazz;

    }
}

