/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.taintWrappers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.xml.stream.XMLStreamException;
import soot.jimple.infoflow.methodSummary.data.provider.EagerSummaryProvider;
import soot.jimple.infoflow.methodSummary.data.provider.LazySummaryProvider;
import soot.jimple.infoflow.methodSummary.taintWrappers.SummaryTaintWrapper;

public class TaintWrapperFactory {
    public static final String DEFAULT_SUMMARY_DIR = "/summariesManual";

    public static SummaryTaintWrapper createTaintWrapper(Collection<String> files) throws FileNotFoundException, XMLStreamException {
        LinkedList<File> fs = new LinkedList<File>();
        for (String s : files) {
            fs.add(new File(s));
        }
        return new SummaryTaintWrapper(new LazySummaryProvider(fs));
    }

    public static SummaryTaintWrapper createTaintWrapperEager(Collection<String> files) throws FileNotFoundException, XMLStreamException {
        LinkedList<File> fs = new LinkedList<File>();
        for (String s : files) {
            fs.add(new File(s));
        }
        return new SummaryTaintWrapper(new EagerSummaryProvider(fs));
    }

    public static SummaryTaintWrapper createTaintWrapper(String f) throws FileNotFoundException, XMLStreamException {
        return TaintWrapperFactory.createTaintWrapper(Collections.singletonList(f));
    }

    public static SummaryTaintWrapper createTaintWrapper() throws URISyntaxException, IOException {
        return new SummaryTaintWrapper(new LazySummaryProvider(DEFAULT_SUMMARY_DIR));
    }

    public static SummaryTaintWrapper createTaintWrapperEager() throws URISyntaxException, IOException {
        return new SummaryTaintWrapper(new EagerSummaryProvider(DEFAULT_SUMMARY_DIR));
    }

    public static SummaryTaintWrapper createTaintWrapper(File f) {
        return new SummaryTaintWrapper(new LazySummaryProvider(f));
    }
}

