/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.taintWrappers;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import heros.solver.IDESolver;
import heros.solver.Pair;
import heros.solver.PathEdge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import soot.ArrayType;
import soot.FastHierarchy;
import soot.Hierarchy;
import soot.Local;
import soot.PrimType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.VoidType;
import soot.jimple.DefinitionStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.methodSummary.data.provider.IMethodSummaryProvider;
import soot.jimple.infoflow.methodSummary.data.sourceSink.AbstractFlowSinkSource;
import soot.jimple.infoflow.methodSummary.data.sourceSink.FlowSink;
import soot.jimple.infoflow.methodSummary.data.sourceSink.FlowSource;
import soot.jimple.infoflow.methodSummary.data.summary.ClassMethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.ClassSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.GapDefinition;
import soot.jimple.infoflow.methodSummary.data.summary.MethodClear;
import soot.jimple.infoflow.methodSummary.data.summary.MethodFlow;
import soot.jimple.infoflow.methodSummary.data.summary.MethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.SourceSinkType;
import soot.jimple.infoflow.methodSummary.data.summary.SummaryMetaData;
import soot.jimple.infoflow.methodSummary.taintWrappers.AccessPathFragment;
import soot.jimple.infoflow.methodSummary.taintWrappers.AccessPathPropagator;
import soot.jimple.infoflow.methodSummary.taintWrappers.Taint;
import soot.jimple.infoflow.solver.IFollowReturnsPastSeedsHandler;
import soot.jimple.infoflow.taintWrappers.IReversibleTaintWrapper;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.infoflow.util.ByReferenceBoolean;
import soot.jimple.infoflow.util.SootMethodRepresentationParser;
import soot.jimple.infoflow.util.SystemClassHandler;
import soot.jimple.infoflow.util.TypeUtils;
import soot.util.ConcurrentHashMultiMap;
import soot.util.MultiMap;

public class SummaryTaintWrapper
implements IReversibleTaintWrapper {
    private static final int MAX_HIERARCHY_DEPTH = 10;
    private InfoflowManager manager;
    private AtomicInteger wrapperHits = new AtomicInteger();
    private AtomicInteger wrapperMisses = new AtomicInteger();
    private boolean reportMissingSummaries = false;
    private ITaintPropagationWrapper fallbackWrapper = null;
    protected IMethodSummaryProvider flows;
    private Hierarchy hierarchy;
    private FastHierarchy fastHierarchy;
    private MultiMap<Pair<Abstraction, SootMethod>, AccessPathPropagator> userCodeTaints = new ConcurrentHashMultiMap();
    protected final LoadingCache<SummaryQuery, SummaryResponse> methodToImplFlows = IDESolver.DEFAULT_CACHE_BUILDER.build((CacheLoader)new CacheLoader<SummaryQuery, SummaryResponse>(){

        public SummaryResponse load(SummaryQuery query) throws Exception {
            SootClass calleeClass = query.calleeClass;
            SootClass declaredClass = query.declaredClass;
            String methodSig = query.subsignature;
            ClassSummaries classSummaries = new ClassSummaries();
            boolean isClassSupported = false;
            if (calleeClass != null) {
                isClassSupported = this.getSummaries(methodSig, classSummaries, calleeClass);
            }
            if (declaredClass != null && !isClassSupported) {
                isClassSupported = this.getSummaries(methodSig, classSummaries, declaredClass);
            }
            if (!isClassSupported && calleeClass != null) {
                isClassSupported = this.getSummariesHierarchy(methodSig, classSummaries, calleeClass);
            }
            if (declaredClass != null && !isClassSupported) {
                isClassSupported = this.getSummariesHierarchy(methodSig, classSummaries, declaredClass);
            }
            if (!classSummaries.isEmpty()) {
                return new SummaryResponse(classSummaries, isClassSupported);
            }
            return isClassSupported ? SummaryResponse.EMPTY_BUT_SUPPORTED : SummaryResponse.NOT_SUPPORTED;
        }

        private boolean getSummaries(String methodSig, ClassSummaries summaries, SootClass clazz) {
            ClassMethodSummaries classSummaries;
            if (summaries.merge(SummaryTaintWrapper.this.flows.getMethodFlows(clazz, methodSig))) {
                return true;
            }
            if (this.checkInterfaces(methodSig, summaries, clazz)) {
                return true;
            }
            SootMethod targetMethod = clazz.getMethodUnsafe(methodSig);
            if (!clazz.isConcrete() || targetMethod == null || !targetMethod.isConcrete()) {
                for (SootClass parentClass : SummaryTaintWrapper.this.getAllParentClasses(clazz)) {
                    if (summaries.merge(SummaryTaintWrapper.this.flows.getMethodFlows(parentClass, methodSig))) {
                        return true;
                    }
                    if (!this.checkInterfaces(methodSig, summaries, parentClass)) continue;
                    return true;
                }
            }
            String curClass = clazz.getName();
            while (curClass != null && (classSummaries = SummaryTaintWrapper.this.flows.getClassFlows(curClass)) != null) {
                if (summaries.merge(SummaryTaintWrapper.this.flows.getMethodFlows(curClass, methodSig))) {
                    return true;
                }
                if (this.checkInterfacesFromSummary(methodSig, summaries, curClass)) {
                    return true;
                }
                curClass = classSummaries.getSuperClass();
            }
            return false;
        }

        private boolean getSummariesHierarchy(String methodSig, ClassSummaries summaries, SootClass clazz) {
            if (clazz == Scene.v().getSootClassUnsafe("java.lang.Object")) {
                return false;
            }
            SootMethod targetMethod = clazz.getMethodUnsafe(methodSig);
            if (!clazz.isConcrete() || targetMethod == null || !targetMethod.isConcrete()) {
                Set childClasses = SummaryTaintWrapper.this.getAllChildClasses(clazz);
                if (childClasses.size() > 10) {
                    return false;
                }
                boolean found = false;
                for (SootClass childClass : childClasses) {
                    if (summaries.merge(SummaryTaintWrapper.this.flows.getMethodFlows(childClass, methodSig))) {
                        found = true;
                    }
                    if (!this.checkInterfaces(methodSig, summaries, childClass)) continue;
                    found = true;
                }
                return found;
            }
            return false;
        }

        private boolean checkInterfaces(String methodSig, ClassSummaries summaries, SootClass clazz) {
            for (SootClass intf : clazz.getInterfaces()) {
                if (summaries.merge(SummaryTaintWrapper.this.flows.getMethodFlows(intf, methodSig))) {
                    return true;
                }
                for (SootClass parent : SummaryTaintWrapper.this.getAllParentClasses(intf)) {
                    if (!summaries.merge(SummaryTaintWrapper.this.flows.getMethodFlows(parent, methodSig))) continue;
                    return true;
                }
            }
            return this.checkInterfacesFromSummary(methodSig, summaries, clazz.getName());
        }

        protected boolean checkInterfacesFromSummary(String methodSig, ClassSummaries summaries, String className) {
            ArrayList<String> interfaces = new ArrayList<String>();
            interfaces.add(className);
            while (!interfaces.isEmpty()) {
                String intfName = (String)interfaces.remove(0);
                ClassMethodSummaries classSummaries = SummaryTaintWrapper.this.flows.getClassFlows(intfName);
                if (classSummaries == null || !classSummaries.hasInterfaces()) continue;
                for (String intf : classSummaries.getInterfaces()) {
                    if (summaries.merge(SummaryTaintWrapper.this.flows.getMethodFlows(intf, methodSig))) {
                        return true;
                    }
                    interfaces.add(intf);
                }
            }
            return false;
        }
    });

    public SummaryTaintWrapper(IMethodSummaryProvider flows) {
        this.flows = flows;
    }

    public void initialize(InfoflowManager manager) {
        this.manager = manager;
        Set<String> loadableClasses = this.flows.getLoadableClasses();
        if (loadableClasses != null) {
            for (String className : loadableClasses) {
                this.loadClass(className);
            }
        }
        for (String className : this.flows.getSupportedClasses()) {
            this.loadClass(className);
        }
        this.hierarchy = Scene.v().getActiveHierarchy();
        this.fastHierarchy = Scene.v().getOrMakeFastHierarchy();
        manager.getForwardSolver().setFollowReturnsPastSeedsHandler((IFollowReturnsPastSeedsHandler)new SummaryFRPSHandler());
        if (this.fallbackWrapper != null) {
            this.fallbackWrapper.initialize(manager);
        }
    }

    private void loadClass(String className) {
        SootClass sc = Scene.v().getSootClassUnsafe(className);
        if (sc == null) {
            sc = Scene.v().makeSootClass(className);
            sc.setPhantomClass();
            Scene.v().addClass(sc);
        } else if (sc.resolvingLevel() < 1) {
            Scene.v().forceResolve(className, 1);
        }
    }

    private Set<Taint> createTaintFromAccessPathOnCall(AccessPath ap, Stmt stmt, boolean matchReturnedValues) {
        DefinitionStmt defStmt;
        int paramIdx;
        Value base = this.getMethodBase(stmt);
        HashSet<Taint> newTaints = null;
        if ((ap.isLocal() || ap.isInstanceFieldRef()) && base != null && base == ap.getPlainValue()) {
            if (newTaints == null) {
                newTaints = new HashSet<Taint>();
            }
            newTaints.add(new Taint(SourceSinkType.Field, -1, ap.getBaseType().toString(), new AccessPathFragment(ap.getFields(), ap.getFieldTypes()), ap.getTaintSubFields()));
        }
        if ((paramIdx = this.getParameterIndex(stmt, ap)) >= 0) {
            if (newTaints == null) {
                newTaints = new HashSet();
            }
            newTaints.add(new Taint(SourceSinkType.Parameter, paramIdx, ap.getBaseType().toString(), new AccessPathFragment(ap.getFields(), ap.getFieldTypes()), ap.getTaintSubFields()));
        }
        if (matchReturnedValues && stmt instanceof DefinitionStmt && (defStmt = (DefinitionStmt)stmt).getLeftOp() == ap.getPlainValue()) {
            if (newTaints == null) {
                newTaints = new HashSet();
            }
            newTaints.add(new Taint(SourceSinkType.Return, -1, ap.getBaseType().toString(), new AccessPathFragment(ap.getFields(), ap.getFieldTypes()), ap.getTaintSubFields()));
        }
        return newTaints;
    }

    private Set<Taint> createTaintFromAccessPathOnReturn(AccessPath ap, Stmt stmt, GapDefinition gap) {
        ReturnStmt retStmt;
        int paramIdx;
        SootMethod sm = (SootMethod)this.manager.getICFG().getMethodOf((Object)stmt);
        HashSet<Taint> res = null;
        if (!sm.isStatic() && (ap.isLocal() || ap.isInstanceFieldRef()) && ap.getPlainValue() == sm.getActiveBody().getThisLocal()) {
            if (res == null) {
                res = new HashSet();
            }
            res.add(new Taint(SourceSinkType.Field, -1, ap.getBaseType().toString(), new AccessPathFragment(ap.getFields(), ap.getFieldTypes()), ap.getTaintSubFields(), gap));
        }
        if ((paramIdx = this.getParameterIndex(sm, ap)) >= 0) {
            if (res == null) {
                res = new HashSet<Taint>();
            }
            res.add(new Taint(SourceSinkType.Parameter, paramIdx, ap.getBaseType().toString(), new AccessPathFragment(ap.getFields(), ap.getFieldTypes()), ap.getTaintSubFields(), gap));
        }
        if (stmt instanceof ReturnStmt && (retStmt = (ReturnStmt)stmt).getOp() == ap.getPlainValue()) {
            if (res == null) {
                res = new HashSet();
            }
            res.add(new Taint(SourceSinkType.Return, -1, ap.getBaseType().toString(), new AccessPathFragment(ap.getFields(), ap.getFieldTypes()), ap.getTaintSubFields(), gap));
        }
        return res;
    }

    protected AccessPath createAccessPathFromTaint(Taint t, Stmt stmt) {
        SootField[] fields = this.safeGetFields(t.getAccessPath());
        Type[] types = this.safeGetTypes(t.getAccessPath(), fields);
        Type baseType = TypeUtils.getTypeFromString((String)t.getBaseType());
        if (t.isReturn()) {
            if (!(stmt instanceof DefinitionStmt)) {
                return null;
            }
            DefinitionStmt defStmt = (DefinitionStmt)stmt;
            return this.manager.getAccessPathFactory().createAccessPath(defStmt.getLeftOp(), fields, baseType, types, t.taintSubFields(), false, true, AccessPath.ArrayTaintType.ContentsAndLength);
        }
        if (t.isParameter() && stmt.containsInvokeExpr()) {
            InvokeExpr iexpr = stmt.getInvokeExpr();
            Value paramVal = iexpr.getArg(t.getParameterIndex());
            if (!AccessPath.canContainValue((Value)paramVal)) {
                return null;
            }
            return this.manager.getAccessPathFactory().createAccessPath(paramVal, fields, baseType, types, t.taintSubFields(), false, true, AccessPath.ArrayTaintType.ContentsAndLength);
        }
        if (t.isField() && stmt.containsInvokeExpr()) {
            StaticInvokeExpr siexpr;
            InvokeExpr iexpr = stmt.getInvokeExpr();
            if (iexpr instanceof InstanceInvokeExpr) {
                InstanceInvokeExpr iiexpr = (InstanceInvokeExpr)iexpr;
                return this.manager.getAccessPathFactory().createAccessPath(iiexpr.getBase(), fields, baseType, types, t.taintSubFields(), false, true, AccessPath.ArrayTaintType.ContentsAndLength);
            }
            if (iexpr instanceof StaticInvokeExpr && !((siexpr = (StaticInvokeExpr)iexpr).getMethodRef().getReturnType() instanceof VoidType)) {
                if (stmt instanceof DefinitionStmt) {
                    DefinitionStmt defStmt = (DefinitionStmt)stmt;
                    return this.manager.getAccessPathFactory().createAccessPath(defStmt.getLeftOp(), fields, baseType, types, t.taintSubFields(), false, true, AccessPath.ArrayTaintType.ContentsAndLength);
                }
                return null;
            }
        }
        throw new RuntimeException("Could not convert taint to access path: " + t + " at " + stmt);
    }

    private AccessPath createAccessPathInMethod(Taint t, SootMethod sm) {
        SootField[] fields = this.safeGetFields(t.getAccessPath());
        Type[] types = this.safeGetTypes(t.getAccessPath(), fields);
        Type baseType = TypeUtils.getTypeFromString((String)t.getBaseType());
        if (t.isReturn()) {
            throw new RuntimeException("Unsupported taint type");
        }
        if (t.isParameter()) {
            Local l = sm.getActiveBody().getParameterLocal(t.getParameterIndex());
            return this.manager.getAccessPathFactory().createAccessPath((Value)l, fields, baseType, types, true, false, true, AccessPath.ArrayTaintType.ContentsAndLength);
        }
        if (t.isField() || t.isGapBaseObject()) {
            Local l = sm.getActiveBody().getThisLocal();
            return this.manager.getAccessPathFactory().createAccessPath((Value)l, fields, baseType, types, true, false, true, AccessPath.ArrayTaintType.ContentsAndLength);
        }
        throw new RuntimeException("Failed to convert taint " + t);
    }

    public Set<Abstraction> getTaintsForMethod(Stmt stmt, Abstraction d1, Abstraction taintedAbs) {
        if (!stmt.containsInvokeExpr()) {
            return Collections.singleton(taintedAbs);
        }
        HashSet<Abstraction> resAbs = null;
        ByReferenceBoolean killIncomingTaint = new ByReferenceBoolean(false);
        ByReferenceBoolean classSupported = new ByReferenceBoolean(false);
        SootMethod callee = stmt.getInvokeExpr().getMethod();
        Set<AccessPath> res = this.computeTaintsForMethod(stmt, d1, taintedAbs, callee, killIncomingTaint, classSupported);
        if (res != null && !res.isEmpty()) {
            if (resAbs == null) {
                resAbs = new HashSet<Abstraction>();
            }
            for (AccessPath ap : res) {
                resAbs.add(taintedAbs.deriveNewAbstraction(ap, stmt));
            }
        }
        if (!(killIncomingTaint.value || resAbs != null && !resAbs.isEmpty() || this.flows.isMethodExcluded(callee.getDeclaringClass().getName(), callee.getSubSignature()))) {
            this.wrapperMisses.incrementAndGet();
            if (classSupported.value) {
                return Collections.singleton(taintedAbs);
            }
            this.reportMissingSummary(callee, stmt, taintedAbs);
            if (this.fallbackWrapper == null) {
                return null;
            }
            Set fallbackTaints = this.fallbackWrapper.getTaintsForMethod(stmt, d1, taintedAbs);
            return fallbackTaints;
        }
        if (!killIncomingTaint.value) {
            if (resAbs == null) {
                return Collections.singleton(taintedAbs);
            }
            resAbs.add(taintedAbs);
        }
        return resAbs;
    }

    protected void reportMissingSummary(SootMethod method, Stmt stmt, Abstraction incoming) {
        this.reportMissingMethod(method);
    }

    protected void reportMissingMethod(SootMethod method) {
        if (this.reportMissingSummaries && SystemClassHandler.v().isClassInSystemPackage(method.getDeclaringClass().getName())) {
            System.out.println("Missing summary for class " + method.getDeclaringClass());
        }
    }

    private Set<AccessPath> computeTaintsForMethod(Stmt stmt, Abstraction d1, Abstraction taintedAbs, SootMethod method, ByReferenceBoolean killIncomingTaint, ByReferenceBoolean classSupported) {
        this.wrapperHits.incrementAndGet();
        ClassSummaries flowsInCallees = this.getFlowSummariesForMethod(stmt, method, taintedAbs, classSupported);
        if (flowsInCallees == null || flowsInCallees.isEmpty()) {
            return null;
        }
        Set<Taint> taintsFromAP = this.createTaintFromAccessPathOnCall(taintedAbs.getAccessPath(), stmt, false);
        if (taintsFromAP == null || taintsFromAP.isEmpty()) {
            return null;
        }
        HashSet<AccessPath> res = null;
        for (String className : flowsInCallees.getClasses()) {
            MethodSummaries flowsInCallee;
            ClassMethodSummaries classFlows = flowsInCallees.getClassSummaries(className);
            if (classFlows == null || classFlows.isEmpty() || (flowsInCallee = classFlows.getMethodSummaries()) == null || flowsInCallee.isEmpty()) continue;
            ArrayList<AccessPathPropagator> workList = new ArrayList<AccessPathPropagator>();
            for (Taint taint : taintsFromAP) {
                boolean killTaint = false;
                if (killIncomingTaint != null && flowsInCallee.hasClears()) {
                    for (MethodClear clear : flowsInCallee.getAllClears()) {
                        if (!this.flowMatchesTaint(clear.getClearDefinition(), taint)) continue;
                        killTaint = true;
                        break;
                    }
                }
                if (killTaint) {
                    killIncomingTaint.value = true;
                    continue;
                }
                workList.add(new AccessPathPropagator(taint, null, null, stmt, d1, taintedAbs));
            }
            Set<AccessPath> resCallee = this.applyFlowsIterative(flowsInCallee, workList);
            if (resCallee == null || resCallee.isEmpty()) continue;
            if (res == null) {
                res = new HashSet<AccessPath>();
            }
            res.addAll(resCallee);
        }
        return res;
    }

    private Set<AccessPath> applyFlowsIterative(MethodSummaries flowsInCallee, List<AccessPathPropagator> workList) {
        HashSet<AccessPath> res = null;
        HashSet<AccessPathPropagator> doneSet = new HashSet<AccessPathPropagator>(workList);
        while (!workList.isEmpty()) {
            SootMethod callee;
            MethodSummaries flowsInTarget;
            AccessPathPropagator curPropagator = workList.remove(0);
            GapDefinition curGap = curPropagator.getGap();
            if (curGap != null && curPropagator.getParent() == null) {
                throw new RuntimeException("Gap flow without parent detected");
            }
            MethodSummaries methodSummaries = flowsInTarget = curGap == null ? flowsInCallee : this.getFlowSummariesForGap(curGap);
            if ((flowsInTarget == null || flowsInTarget.isEmpty()) && curGap != null && (callee = Scene.v().grabMethod(curGap.getSignature())) != null) {
                for (SootMethod implementor : this.getAllImplementors(callee)) {
                    Set<AccessPathPropagator> implementorPropagators;
                    if (!implementor.getDeclaringClass().isConcrete() || implementor.getDeclaringClass().isPhantom() || !implementor.isConcrete() || (implementorPropagators = this.spawnAnalysisIntoClientCode(implementor, curPropagator)) == null) continue;
                    workList.addAll(implementorPropagators);
                }
            }
            if (flowsInTarget == null || flowsInTarget.isEmpty()) continue;
            for (MethodFlow flow : flowsInTarget) {
                AccessPathPropagator backwardsPropagator;
                AccessPathPropagator newPropagator = this.applyFlow(flow, curPropagator);
                if (newPropagator == null && ((flow = this.getReverseFlowForAlias(flow)) == null || (newPropagator = this.applyFlow(flow, curPropagator)) == null)) continue;
                if (newPropagator.getParent() == null && newPropagator.getTaint().getGap() == null) {
                    AccessPath ap = this.createAccessPathFromTaint(newPropagator.getTaint(), newPropagator.getStmt());
                    if (ap == null) continue;
                    if (res == null) {
                        res = new HashSet<AccessPath>();
                    }
                    res.add(ap);
                }
                if (doneSet.add(newPropagator)) {
                    workList.add(newPropagator);
                }
                if (!newPropagator.getTaint().hasAccessPath() || !doneSet.add(backwardsPropagator = newPropagator.deriveInversePropagator())) continue;
                workList.add(backwardsPropagator);
            }
        }
        return res;
    }

    private MethodFlow getReverseFlowForAlias(MethodFlow flow) {
        if (!flow.isAlias()) {
            return null;
        }
        if (!this.canTypeAlias(flow.source().getLastFieldType())) {
            return null;
        }
        if (!this.canTypeAlias(flow.sink().getLastFieldType())) {
            return null;
        }
        if (flow.source().getGap() != null && flow.source().getType() == SourceSinkType.Return) {
            return null;
        }
        return flow.reverse();
    }

    private boolean canTypeAlias(String type) {
        Type tp = TypeUtils.getTypeFromString((String)type);
        if (tp instanceof PrimType) {
            return false;
        }
        return !(tp instanceof RefType) || !((RefType)tp).getClassName().equals("java.lang.String");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<AccessPathPropagator> spawnAnalysisIntoClientCode(SootMethod implementor, AccessPathPropagator propagator) {
        if (!implementor.hasActiveBody()) {
            SootMethod sootMethod = implementor;
            synchronized (sootMethod) {
                if (!implementor.hasActiveBody()) {
                    implementor.retrieveActiveBody();
                    this.manager.getICFG().notifyMethodChanged(implementor);
                }
            }
        }
        AccessPath ap = this.createAccessPathInMethod(propagator.getTaint(), implementor);
        Abstraction abs = new Abstraction(null, ap, null, null, false, false);
        AccessPathPropagator parent = this.safePopParent(propagator);
        GapDefinition gap = propagator.getParent() == null ? null : propagator.getParent().getGap();
        HashSet<AccessPathPropagator> outgoingTaints = null;
        Set endSummary = this.manager.getForwardSolver().endSummary(implementor, abs);
        if (endSummary != null && !endSummary.isEmpty()) {
            for (Pair pair : endSummary) {
                Set<Taint> newTaints;
                if (outgoingTaints == null) {
                    outgoingTaints = new HashSet<AccessPathPropagator>();
                }
                if ((newTaints = this.createTaintFromAccessPathOnReturn(((Abstraction)pair.getO2()).getAccessPath(), (Stmt)pair.getO1(), propagator.getGap())) == null) continue;
                for (Taint newTaint : newTaints) {
                    AccessPathPropagator newPropagator = new AccessPathPropagator(newTaint, gap, parent, propagator.getParent() == null ? null : propagator.getParent().getStmt(), propagator.getParent() == null ? null : propagator.getParent().getD1(), propagator.getParent() == null ? null : propagator.getParent().getD2());
                    outgoingTaints.add(newPropagator);
                }
            }
            return outgoingTaints;
        }
        for (Unit sP : this.manager.getICFG().getStartPointsOf((Object)implementor)) {
            PathEdge edge = new PathEdge((Object)abs, (Object)sP, (Object)abs);
            this.manager.getForwardSolver().processEdge(edge);
        }
        this.userCodeTaints.put((Object)new Pair((Object)abs, (Object)implementor), (Object)propagator);
        return null;
    }

    private AccessPathPropagator safePopParent(AccessPathPropagator curPropagator) {
        if (curPropagator.getParent() == null) {
            return null;
        }
        return curPropagator.getParent().getParent();
    }

    private MethodSummaries getFlowSummariesForGap(GapDefinition gap) {
        SootMethod gapMethod;
        ClassSummaries flows;
        if (Scene.v().containsMethod(gap.getSignature()) && (flows = this.getFlowSummariesForMethod(null, gapMethod = Scene.v().getMethod(gap.getSignature()), null)) != null && !flows.isEmpty()) {
            MethodSummaries summaries = new MethodSummaries();
            summaries.mergeSummaries(flows.getAllMethodSummaries());
            return summaries;
        }
        SootMethodAndClass smac = SootMethodRepresentationParser.v().parseSootMethodString(gap.getSignature());
        ClassMethodSummaries cms = this.flows.getMethodFlows(smac.getClassName(), smac.getSubSignature());
        return cms == null ? null : cms.getMethodSummaries();
    }

    private ClassSummaries getFlowSummariesForMethod(Stmt stmt, SootMethod method, ByReferenceBoolean classSupported) {
        return this.getFlowSummariesForMethod(stmt, method, null, classSupported);
    }

    protected ClassSummaries getFlowSummariesForMethod(Stmt stmt, SootMethod method, Abstraction taintedAbs, ByReferenceBoolean classSupported) {
        SummaryResponse response;
        InstanceInvokeExpr iinv;
        Type baseType;
        String subsig = method.getSubSignature();
        if (!this.flows.mayHaveSummaryForMethod(subsig)) {
            return ClassSummaries.EMPTY_SUMMARIES;
        }
        ClassSummaries classSummaries = null;
        if (!(method.isConstructor() || method.isStaticInitializer() || method.isStatic() || stmt == null)) {
            for (SootMethod callee : this.manager.getICFG().getCalleesOfCallAt((Object)stmt)) {
                ClassMethodSummaries flows = this.flows.getMethodFlows(callee.getDeclaringClass(), subsig);
                if (flows == null || flows.isEmpty()) continue;
                if (classSupported != null) {
                    classSupported.value = true;
                }
                if (classSummaries == null) {
                    classSummaries = new ClassSummaries();
                }
                classSummaries.merge("<dummy>", flows.getMethodSummaries());
            }
        }
        SootClass declaredClass = null;
        if (stmt != null && stmt.getInvokeExpr() instanceof InstanceInvokeExpr && (baseType = (iinv = (InstanceInvokeExpr)stmt.getInvokeExpr()).getBase().getType()) instanceof RefType) {
            declaredClass = ((RefType)baseType).getSootClass();
        }
        if ((classSummaries == null || classSummaries.isEmpty()) && (response = (SummaryResponse)this.methodToImplFlows.getUnchecked((Object)new SummaryQuery(method.getDeclaringClass(), declaredClass, subsig))) != null) {
            if (classSupported != null) {
                classSupported.value = response.isClassSupported;
            }
            classSummaries = new ClassSummaries();
            classSummaries.merge(response.classSummaries);
        }
        return classSummaries;
    }

    private Collection<SootMethod> getAllImplementors(SootMethod method) {
        String subSig = method.getSubSignature();
        HashSet<SootMethod> implementors = new HashSet<SootMethod>();
        ArrayList<SootClass> workList = new ArrayList<SootClass>();
        workList.add(method.getDeclaringClass());
        HashSet<SootClass> doneSet = new HashSet<SootClass>();
        while (!workList.isEmpty()) {
            SootMethod ifm;
            SootClass curClass = (SootClass)workList.remove(0);
            if (!doneSet.add(curClass)) continue;
            if (curClass.isInterface()) {
                workList.addAll(this.hierarchy.getImplementersOf(curClass));
                workList.addAll(this.hierarchy.getSubinterfacesOf(curClass));
            } else {
                workList.addAll(this.hierarchy.getSubclassesOf(curClass));
            }
            if ((ifm = curClass.getMethodUnsafe(subSig)) == null) continue;
            implementors.add(ifm);
        }
        return implementors;
    }

    private Set<SootClass> getAllChildClasses(SootClass sc) {
        ArrayList<SootClass> workList = new ArrayList<SootClass>();
        workList.add(sc);
        HashSet<SootClass> doneSet = new HashSet<SootClass>();
        HashSet<SootClass> classes = new HashSet<SootClass>();
        while (!workList.isEmpty()) {
            SootClass curClass = (SootClass)workList.remove(0);
            if (!doneSet.add(curClass)) continue;
            if (curClass.isInterface()) {
                workList.addAll(this.hierarchy.getImplementersOf(curClass));
                workList.addAll(this.hierarchy.getSubinterfacesOf(curClass));
                continue;
            }
            workList.addAll(this.hierarchy.getSubclassesOf(curClass));
            classes.add(curClass);
        }
        return classes;
    }

    private Set<SootClass> getAllParentClasses(SootClass sc) {
        ArrayList<SootClass> workList = new ArrayList<SootClass>();
        workList.add(sc);
        HashSet<SootClass> doneSet = new HashSet<SootClass>();
        HashSet<SootClass> classes = new HashSet<SootClass>();
        while (!workList.isEmpty()) {
            SootClass curClass = (SootClass)workList.remove(0);
            if (!doneSet.add(curClass)) continue;
            if (curClass.isInterface()) {
                workList.addAll(this.hierarchy.getSuperinterfacesOf(curClass));
                continue;
            }
            workList.addAll(this.hierarchy.getSuperclassesOf(curClass));
            classes.add(curClass);
        }
        return classes;
    }

    private AccessPathPropagator applyFlow(MethodFlow flow, AccessPathPropagator propagator) {
        GapDefinition taintGap;
        Abstraction d2;
        Abstraction d1;
        Stmt stmt;
        GapDefinition gap;
        AccessPathPropagator parent;
        boolean typesCompatible;
        FlowSource flowSource = flow.source();
        FlowSink flowSink = flow.sink();
        Taint taint = propagator.getTaint();
        boolean bl = typesCompatible = flowSource.getBaseType() == null || this.isCastCompatible(TypeUtils.getTypeFromString((String)taint.getBaseType()), TypeUtils.getTypeFromString((String)flowSource.getBaseType()));
        if (!typesCompatible) {
            return null;
        }
        if (taint.getGap() != flow.source().getGap()) {
            return null;
        }
        if (flowSink.getGap() != null) {
            parent = propagator;
            gap = flowSink.getGap();
            stmt = null;
            d1 = null;
            d2 = null;
            taintGap = null;
        } else {
            parent = this.safePopParent(propagator);
            gap = propagator.getParent() == null ? null : propagator.getParent().getGap();
            stmt = propagator.getParent() == null ? propagator.getStmt() : propagator.getParent().getStmt();
            d1 = propagator.getParent() == null ? propagator.getD1() : propagator.getParent().getD1();
            d2 = propagator.getParent() == null ? propagator.getD2() : propagator.getParent().getD2();
            taintGap = propagator.getGap();
        }
        boolean addTaint = this.flowMatchesTaint(flowSource, taint);
        if (!addTaint) {
            return null;
        }
        Taint newTaint = null;
        newTaint = flow.isCustom() ? this.addCustomSinkTaint(flow, taint, taintGap) : this.addSinkTaint(flow, taint, taintGap);
        if (newTaint == null) {
            return null;
        }
        AccessPathPropagator newPropagator = new AccessPathPropagator(newTaint, gap, parent, stmt, d1, d2);
        return newPropagator;
    }

    private boolean flowMatchesTaint(AbstractFlowSinkSource flowSource, Taint taint) {
        if (flowSource.isParameter() && taint.isParameter()) {
            if (taint.getParameterIndex() == flowSource.getParameterIndex() && this.compareFields(taint, flowSource)) {
                return true;
            }
        } else if (flowSource.isField()) {
            boolean doTaint;
            boolean bl = doTaint = taint.isGapBaseObject() || taint.isField();
            if (doTaint && this.compareFields(taint, flowSource)) {
                return true;
            }
        } else {
            if (flowSource.isThis() && taint.isField()) {
                return true;
            }
            if (flowSource.isReturn() && flowSource.getGap() != null && taint.getGap() != null && this.compareFields(taint, flowSource)) {
                return true;
            }
            if (flowSource.isReturn() && flowSource.getGap() == null && taint.getGap() == null && taint.isReturn() && this.compareFields(taint, flowSource)) {
                return true;
            }
        }
        return false;
    }

    private boolean isCastCompatible(Type baseType, Type checkType) {
        if (baseType == null || checkType == null) {
            return false;
        }
        if (baseType == Scene.v().getObjectType()) {
            return checkType instanceof RefType;
        }
        if (checkType == Scene.v().getObjectType()) {
            return baseType instanceof RefType;
        }
        return baseType == checkType || this.fastHierarchy.canStoreType(baseType, checkType) || this.fastHierarchy.canStoreType(checkType, baseType);
    }

    private int getParameterIndex(Stmt stmt, AccessPath curAP) {
        if (!stmt.containsInvokeExpr()) {
            return -1;
        }
        if (curAP.isStaticFieldRef()) {
            return -1;
        }
        InvokeExpr iexpr = stmt.getInvokeExpr();
        for (int i = 0; i < iexpr.getArgCount(); ++i) {
            if (iexpr.getArg(i) != curAP.getPlainValue()) continue;
            return i;
        }
        return -1;
    }

    private int getParameterIndex(SootMethod sm, AccessPath curAP) {
        if (curAP.isStaticFieldRef()) {
            return -1;
        }
        for (int i = 0; i < sm.getParameterCount(); ++i) {
            if (curAP.getPlainValue() != sm.getActiveBody().getParameterLocal(i)) continue;
            return i;
        }
        return -1;
    }

    private boolean compareFields(Taint taintedPath, AbstractFlowSinkSource flowSource) {
        if (taintedPath.getAccessPathLength() < flowSource.getAccessPathLength() && (!taintedPath.taintSubFields() || flowSource.isMatchStrict())) {
            return false;
        }
        for (int i = 0; i < taintedPath.getAccessPathLength() && i < flowSource.getAccessPathLength(); ++i) {
            String taintField = taintedPath.getAccessPath().getField(i);
            String sourceField = flowSource.getAccessPath().getField(i);
            if (sourceField.equals(taintField)) continue;
            return false;
        }
        return true;
    }

    private SootField safeGetField(String fieldSig) {
        if (fieldSig == null || fieldSig.equals("")) {
            return null;
        }
        SootField sf = Scene.v().grabField(fieldSig);
        if (sf != null) {
            return sf;
        }
        String className = fieldSig.substring(1);
        className = className.substring(0, className.indexOf(":"));
        SootClass sc = Scene.v().getSootClassUnsafe(className, true);
        if (sc.resolvingLevel() < 2 && !sc.isPhantom()) {
            System.err.println("WARNING: Class not loaded: " + sc);
            return null;
        }
        String type = fieldSig.substring(fieldSig.indexOf(": ") + 2);
        type = type.substring(0, type.indexOf(" "));
        String fieldName = fieldSig.substring(fieldSig.lastIndexOf(" ") + 1);
        fieldName = fieldName.substring(0, fieldName.length() - 1);
        return Scene.v().makeFieldRef(sc, fieldName, TypeUtils.getTypeFromString((String)type), false).resolve();
    }

    private SootField[] safeGetFields(AccessPathFragment accessPath) {
        if (accessPath == null || accessPath.isEmpty()) {
            return null;
        }
        return this.safeGetFields(accessPath.getFields());
    }

    private SootField[] safeGetFields(String[] fieldSigs) {
        if (fieldSigs == null || fieldSigs.length == 0) {
            return null;
        }
        SootField[] fields = new SootField[fieldSigs.length];
        for (int i = 0; i < fieldSigs.length; ++i) {
            fields[i] = this.safeGetField(fieldSigs[i]);
            if (fields[i] != null) continue;
            return null;
        }
        return fields;
    }

    private Type[] safeGetTypes(AccessPathFragment accessPath, SootField[] fields) {
        if (accessPath == null || accessPath.isEmpty()) {
            return null;
        }
        return this.safeGetTypes(accessPath.getFieldTypes(), fields);
    }

    private Type[] safeGetTypes(String[] fieldTypes, SootField[] fields) {
        if (fieldTypes == null || fieldTypes.length == 0) {
            if (fields != null && fields.length > 0) {
                Type[] types = new Type[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    types[i] = fields[i].getType();
                }
                return types;
            }
            return null;
        }
        Type[] types = new Type[fieldTypes.length];
        for (int i = 0; i < fieldTypes.length; ++i) {
            types[i] = TypeUtils.getTypeFromString((String)fieldTypes[i]);
        }
        return types;
    }

    protected Taint addCustomSinkTaint(MethodFlow flow, Taint taint, GapDefinition gap) {
        return null;
    }

    private Taint addSinkTaint(MethodFlow flow, Taint taint, GapDefinition gap) {
        String sBaseType;
        Type newBaseType;
        FlowSource flowSource = flow.source();
        FlowSink flowSink = flow.sink();
        boolean taintSubFields = flow.sink().taintSubFields();
        Boolean checkTypes = flow.getTypeChecking();
        AccessPathFragment remainingFields = this.cutSubFields(flow, this.getRemainingFields(flowSource, taint));
        AccessPathFragment appendedFields = AccessPathFragment.append(flowSink.getAccessPath(), remainingFields);
        int lastCommonAPIdx = Math.min(flowSource.getAccessPathLength(), taint.getAccessPathLength());
        Type sinkType = TypeUtils.getTypeFromString((String)this.getAssignmentType(flowSink));
        Type taintType = TypeUtils.getTypeFromString((String)this.getAssignmentType(taint, lastCommonAPIdx - 1));
        if (!(checkTypes != null && !checkTypes.booleanValue() || sinkType == null || taintType == null || sinkType instanceof PrimType || this.isCastCompatible(taintType, sinkType) || flowSink.getType() != SourceSinkType.Field)) {
            boolean found = false;
            while (sinkType instanceof ArrayType) {
                if (!this.isCastCompatible(taintType, sinkType = ((ArrayType)sinkType).getElementType())) continue;
                found = true;
                break;
            }
            while (taintType instanceof ArrayType) {
                if (!this.isCastCompatible(taintType = ((ArrayType)taintType).getElementType(), sinkType)) continue;
                found = true;
                break;
            }
            if (!found) {
                return null;
            }
        }
        SourceSinkType sourceSinkType = flowSink.getType();
        if (flowSink.getType() == SourceSinkType.GapBaseObject && remainingFields != null && !remainingFields.isEmpty()) {
            sourceSinkType = SourceSinkType.Field;
        }
        if ((newBaseType = TypeUtils.getMorePreciseType((Type)taintType, (Type)sinkType)) == null) {
            newBaseType = sinkType;
        }
        String string = sBaseType = sinkType == null ? null : "" + sinkType;
        if (flowSink.hasAccessPath()) {
            if (appendedFields != null) {
                appendedFields = appendedFields.updateFieldType(flowSink.getAccessPathLength() - 1, "" + newBaseType);
            }
            sBaseType = flowSink.getBaseType();
        }
        return new Taint(sourceSinkType, flowSink.getParameterIndex(), sBaseType, appendedFields, taintSubFields || taint.taintSubFields(), gap);
    }

    protected AccessPathFragment cutSubFields(MethodFlow flow, AccessPathFragment accessPath) {
        if (this.isCutSubFields(flow)) {
            return null;
        }
        return accessPath;
    }

    protected boolean isCutSubFields(MethodFlow flow) {
        Boolean cut = flow.getCutSubFields();
        Boolean typeChecking = flow.getTypeChecking();
        if (cut == null) {
            if (typeChecking != null) {
                return typeChecking == false;
            }
            return false;
        }
        return cut;
    }

    private String getAssignmentType(Taint taint, int idx) {
        if (idx < 0) {
            return taint.getBaseType();
        }
        AccessPathFragment accessPath = taint.getAccessPath();
        if (accessPath == null) {
            return null;
        }
        String[] fieldTypes = accessPath.getFieldTypes();
        return fieldTypes == null ? null : fieldTypes[idx];
    }

    private String getAssignmentType(AbstractFlowSinkSource srcSink) {
        if (!srcSink.hasAccessPath()) {
            return srcSink.getBaseType();
        }
        AccessPathFragment accessPath = srcSink.getAccessPath();
        if (accessPath.getFieldTypes() == null && accessPath.getFields() != null) {
            String[] ap = accessPath.getFields();
            String apElement = ap[srcSink.getAccessPathLength() - 1];
            Pattern pattern = Pattern.compile("^\\s*<(.*?):\\s*(.*?)>\\s*$");
            Matcher matcher = pattern.matcher(apElement);
            if (matcher.find()) {
                return matcher.group(1);
            }
        }
        return accessPath.getFieldTypes() == null ? null : accessPath.getFieldTypes()[srcSink.getAccessPathLength() - 1];
    }

    private AccessPathFragment getRemainingFields(AbstractFlowSinkSource flowSource, Taint taintedPath) {
        if (!flowSource.hasAccessPath()) {
            return taintedPath.getAccessPath();
        }
        int fieldCnt = taintedPath.getAccessPathLength() - flowSource.getAccessPathLength();
        if (fieldCnt <= 0) {
            return null;
        }
        AccessPathFragment taintedAP = taintedPath.getAccessPath();
        String[] oldFields = taintedAP.getFields();
        String[] oldFieldTypes = taintedAP.getFieldTypes();
        String[] fields = new String[fieldCnt];
        String[] fieldTypes = new String[fieldCnt];
        System.arraycopy(oldFields, flowSource.getAccessPathLength(), fields, 0, fieldCnt);
        System.arraycopy(oldFieldTypes, flowSource.getAccessPathLength(), fieldTypes, 0, fieldCnt);
        return new AccessPathFragment(fields, fieldTypes);
    }

    private Value getMethodBase(Stmt stmt) {
        if (!stmt.containsInvokeExpr()) {
            throw new RuntimeException("Statement is not a method call: " + stmt);
        }
        InvokeExpr invExpr = stmt.getInvokeExpr();
        if (invExpr instanceof InstanceInvokeExpr) {
            return ((InstanceInvokeExpr)invExpr).getBase();
        }
        return null;
    }

    public boolean isExclusive(Stmt stmt, Abstraction taintedPath) {
        SootClass targetClass;
        if (this.supportsCallee(stmt)) {
            return true;
        }
        if (this.fallbackWrapper != null && this.fallbackWrapper.isExclusive(stmt, taintedPath)) {
            return true;
        }
        if (stmt.containsInvokeExpr() && (targetClass = stmt.getInvokeExpr().getMethod().getDeclaringClass()) != null) {
            String targetClassName = targetClass.getName();
            ClassMethodSummaries cms = this.flows.getClassFlows(targetClassName);
            if (cms != null && cms.isExclusiveForClass()) {
                return true;
            }
            ClassSummaries summaries = this.flows.getSummaries();
            SummaryMetaData metaData = summaries.getMetaData();
            if (metaData != null && metaData.isClassExclusive(targetClassName)) {
                return true;
            }
        }
        return false;
    }

    public boolean supportsCallee(SootMethod method) {
        SootClass declClass = method.getDeclaringClass();
        return declClass != null && this.flows.supportsClass(declClass.getName());
    }

    public boolean supportsCallee(Stmt callSite) {
        if (!callSite.containsInvokeExpr()) {
            return false;
        }
        if (this.manager == null) {
            SootMethod method = callSite.getInvokeExpr().getMethod();
            if (this.supportsCallee(method)) {
                return true;
            }
        } else {
            for (SootMethod callee : this.manager.getICFG().getCalleesOfCallAt((Object)callSite)) {
                if (callee.isStaticInitializer() || !this.supportsCallee(callee)) continue;
                return true;
            }
        }
        return false;
    }

    Set<AccessPathPropagator> getUserCodeTaints(Abstraction abs, SootMethod callee) {
        return this.userCodeTaints.get((Object)new Pair((Object)abs, (Object)callee));
    }

    public int getWrapperHits() {
        return this.wrapperHits.get();
    }

    public int getWrapperMisses() {
        return this.wrapperMisses.get();
    }

    public Set<Abstraction> getAliasesForMethod(Stmt stmt, Abstraction d1, Abstraction taintedAbs) {
        if (!stmt.containsInvokeExpr()) {
            return Collections.singleton(taintedAbs);
        }
        SootMethod method = stmt.getInvokeExpr().getMethod();
        ClassSummaries flowsInCallees = this.getFlowSummariesForMethod(stmt, method, null);
        if (flowsInCallees.isEmpty()) {
            if (this.fallbackWrapper == null) {
                return null;
            }
            return this.fallbackWrapper.getAliasesForMethod(stmt, d1, taintedAbs);
        }
        Set<Taint> taintsFromAP = this.createTaintFromAccessPathOnCall(taintedAbs.getAccessPath(), stmt, true);
        if (taintsFromAP == null || taintsFromAP.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<AccessPath> res = null;
        for (String className : flowsInCallees.getClasses()) {
            Set<AccessPath> resCallee;
            MethodSummaries flowsInCallee;
            ArrayList<AccessPathPropagator> workList = new ArrayList<AccessPathPropagator>();
            for (Taint taint : taintsFromAP) {
                workList.add(new AccessPathPropagator(taint, null, null, stmt, d1, taintedAbs, true));
            }
            ClassMethodSummaries classFlows = flowsInCallees.getClassSummaries(className);
            if (classFlows == null || (flowsInCallee = classFlows.getMethodSummaries()) == null || flowsInCallee.isEmpty() || (resCallee = this.applyFlowsIterative(flowsInCallee, workList)) == null || resCallee.isEmpty()) continue;
            if (res == null) {
                res = new HashSet<AccessPath>();
            }
            res.addAll(resCallee);
        }
        if (res == null || res.isEmpty()) {
            return Collections.singleton(taintedAbs);
        }
        HashSet<Abstraction> resAbs = new HashSet<Abstraction>(res.size() + 1);
        resAbs.add(taintedAbs);
        for (AccessPath ap : res) {
            Abstraction newAbs = taintedAbs.deriveNewAbstraction(ap, stmt);
            newAbs.setCorrespondingCallSite(stmt);
            resAbs.add(newAbs);
        }
        return resAbs;
    }

    public void setReportMissingDummaries(boolean report) {
        this.reportMissingSummaries = report;
    }

    public void setFallbackTaintWrapper(ITaintPropagationWrapper fallbackWrapper) {
        this.fallbackWrapper = fallbackWrapper;
    }

    public IMethodSummaryProvider getProvider() {
        return this.flows;
    }

    public Set<Abstraction> getInverseTaintsForMethod(Stmt stmt, Abstraction d1, Abstraction taintedAbs) {
        if (!stmt.containsInvokeExpr()) {
            return Collections.singleton(taintedAbs);
        }
        SootMethod method = stmt.getInvokeExpr().getMethod();
        ClassSummaries flowsInCallees = this.getFlowSummariesForMethod(stmt, method, null);
        if (flowsInCallees.isEmpty()) {
            if (this.fallbackWrapper != null && this.fallbackWrapper instanceof IReversibleTaintWrapper) {
                return ((IReversibleTaintWrapper)this.fallbackWrapper).getInverseTaintsForMethod(stmt, d1, taintedAbs);
            }
            return null;
        }
        Set<Taint> taintsFromAP = this.createTaintFromAccessPathOnCall(taintedAbs.getAccessPath(), stmt, true);
        if (taintsFromAP == null || taintsFromAP.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<AccessPath> res = null;
        for (String className : flowsInCallees.getClasses()) {
            Set<AccessPath> resCallee;
            MethodSummaries flowsInCallee;
            ArrayList<AccessPathPropagator> workList = new ArrayList<AccessPathPropagator>();
            for (Taint taint : taintsFromAP) {
                workList.add(new AccessPathPropagator(taint, null, null, stmt, d1, taintedAbs, true));
            }
            ClassMethodSummaries classFlows = flowsInCallees.getClassSummaries(className);
            if (classFlows == null || (flowsInCallee = classFlows.getMethodSummaries()) == null || flowsInCallee.isEmpty() || (resCallee = this.applyFlowsIterative(flowsInCallee = flowsInCallee.reverse(), workList)) == null || resCallee.isEmpty()) continue;
            if (res == null) {
                res = new HashSet<AccessPath>();
            }
            res.addAll(resCallee);
        }
        if (res == null || res.isEmpty()) {
            return Collections.singleton(taintedAbs);
        }
        HashSet<Abstraction> resAbs = new HashSet<Abstraction>(res.size() + 1);
        resAbs.add(taintedAbs);
        for (AccessPath ap : res) {
            Abstraction newAbs = taintedAbs.deriveNewAbstraction(ap, stmt);
            newAbs.setCorrespondingCallSite(stmt);
            resAbs.add(newAbs);
        }
        return resAbs;
    }

    private class SummaryFRPSHandler
    implements IFollowReturnsPastSeedsHandler {
        private SummaryFRPSHandler() {
        }

        public void handleFollowReturnsPastSeeds(Abstraction d1, Unit u, Abstraction d2) {
            SootMethod sm = (SootMethod)SummaryTaintWrapper.this.manager.getICFG().getMethodOf((Object)u);
            Set<AccessPathPropagator> propagators = SummaryTaintWrapper.this.getUserCodeTaints(d1, sm);
            if (propagators != null) {
                for (AccessPathPropagator propagator : propagators) {
                    GapDefinition parentGap;
                    AccessPathPropagator parent = SummaryTaintWrapper.this.safePopParent(propagator);
                    GapDefinition gapDefinition = parentGap = propagator.getParent() == null ? null : propagator.getParent().getGap();
                    Set returnTaints = SummaryTaintWrapper.this.createTaintFromAccessPathOnReturn(d2.getAccessPath(), (Stmt)u, propagator.getGap());
                    if (returnTaints == null) continue;
                    MethodSummaries flowsInTarget = parentGap == null ? this.getFlowsInOriginalCallee(propagator) : SummaryTaintWrapper.this.getFlowSummariesForGap(parentGap);
                    HashSet<AccessPathPropagator> workSet = new HashSet<AccessPathPropagator>();
                    for (Taint returnTaint : returnTaints) {
                        AccessPathPropagator newPropagator = new AccessPathPropagator(returnTaint, parentGap, parent, propagator.getParent() == null ? null : propagator.getParent().getStmt(), propagator.getParent() == null ? null : propagator.getParent().getD1(), propagator.getParent() == null ? null : propagator.getParent().getD2());
                        workSet.add(newPropagator);
                    }
                    Set resultAPs = SummaryTaintWrapper.this.applyFlowsIterative(flowsInTarget, new ArrayList(workSet));
                    if (resultAPs == null || resultAPs.isEmpty()) continue;
                    AccessPathPropagator rootPropagator = this.getOriginalCallSite(propagator);
                    for (AccessPath ap : resultAPs) {
                        Abstraction newAbs = rootPropagator.getD2().deriveNewAbstraction(ap, rootPropagator.getStmt());
                        for (Unit succUnit : SummaryTaintWrapper.this.manager.getICFG().getSuccsOf((Object)rootPropagator.getStmt())) {
                            SummaryTaintWrapper.this.manager.getForwardSolver().processEdge(new PathEdge((Object)rootPropagator.getD1(), (Object)succUnit, (Object)newAbs));
                        }
                    }
                }
            }
        }

        private MethodSummaries getFlowsInOriginalCallee(AccessPathPropagator propagator) {
            Stmt originalCallSite = this.getOriginalCallSite(propagator).getStmt();
            ClassSummaries flowsInCallee = SummaryTaintWrapper.this.getFlowSummariesForMethod(originalCallSite, originalCallSite.getInvokeExpr().getMethod(), null);
            String methodSig = originalCallSite.getInvokeExpr().getMethod().getSubSignature();
            return flowsInCallee.getAllSummariesForMethod(methodSig);
        }

        private AccessPathPropagator getOriginalCallSite(AccessPathPropagator propagator) {
            for (AccessPathPropagator curProp = propagator; curProp != null; curProp = curProp.getParent()) {
                if (curProp.getParent() != null) continue;
                return curProp;
            }
            return null;
        }
    }

    private static class SummaryResponse {
        public static final SummaryResponse NOT_SUPPORTED = new SummaryResponse(null, false);
        public static final SummaryResponse EMPTY_BUT_SUPPORTED = new SummaryResponse(null, true);
        private final ClassSummaries classSummaries;
        private final boolean isClassSupported;

        public SummaryResponse(ClassSummaries classSummaries, boolean isClassSupported) {
            this.classSummaries = classSummaries;
            this.isClassSupported = isClassSupported;
        }

        public String toString() {
            if (this.isClassSupported) {
                if (this.classSummaries == null) {
                    return "<Empty summary>";
                }
                return this.classSummaries.toString();
            }
            return "<Class not supported>";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.classSummaries == null ? 0 : this.classSummaries.hashCode());
            result = 31 * result + (this.isClassSupported ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SummaryResponse other = (SummaryResponse)obj;
            if (this.classSummaries == null ? other.classSummaries != null : !this.classSummaries.equals(other.classSummaries)) {
                return false;
            }
            return this.isClassSupported == other.isClassSupported;
        }
    }

    private static class SummaryQuery {
        public final SootClass calleeClass;
        public final SootClass declaredClass;
        public final String subsignature;

        public SummaryQuery(SootClass calleeClass, SootClass declaredClass, String subsignature) {
            this.calleeClass = calleeClass;
            this.declaredClass = declaredClass;
            this.subsignature = subsignature;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.calleeClass.getName());
            sb.append(": ");
            sb.append(this.subsignature);
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.calleeClass == null ? 0 : this.calleeClass.hashCode());
            result = 31 * result + (this.declaredClass == null ? 0 : this.declaredClass.hashCode());
            result = 31 * result + (this.subsignature == null ? 0 : this.subsignature.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SummaryQuery other = (SummaryQuery)obj;
            if (this.calleeClass == null ? other.calleeClass != null : !this.calleeClass.equals(other.calleeClass)) {
                return false;
            }
            if (this.declaredClass == null ? other.declaredClass != null : !this.declaredClass.equals(other.declaredClass)) {
                return false;
            }
            return !(this.subsignature == null ? other.subsignature != null : !this.subsignature.equals(other.subsignature));
        }
    }
}

