/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.taintWrappers;

import java.util.Arrays;
import soot.SootField;
import soot.Type;
import soot.jimple.infoflow.data.AccessPath;

public class AccessPathFragment {
    private final String[] fields;
    private final String[] fieldTypes;

    public AccessPathFragment(String[] fields, String[] fieldTypes) {
        this.fields = fields;
        this.fieldTypes = fieldTypes;
        if (fields != null && fieldTypes != null && fields.length != fieldTypes.length) {
            throw new RuntimeException("Access path array and type array must be of equal length");
        }
    }

    public AccessPathFragment(SootField[] fields, Type[] fieldTypes) {
        this(AccessPathFragment.fieldArrayToStringArray(fields), AccessPathFragment.typeArrayToStringArray(fieldTypes));
    }

    public AccessPathFragment(AccessPath accessPath) {
        this(accessPath.getFields(), accessPath.getFieldTypes());
    }

    private static String[] fieldArrayToStringArray(SootField[] fields) {
        if (fields == null) {
            return null;
        }
        String[] stringFields = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            stringFields[i] = fields[i].toString();
        }
        return stringFields;
    }

    private static String[] typeArrayToStringArray(Type[] types) {
        if (types == null) {
            return null;
        }
        String[] stringTypes = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            stringTypes[i] = types[i].toString();
        }
        return stringTypes;
    }

    public int length() {
        return this.fields == null ? 0 : this.fields.length;
    }

    public String[] getFields() {
        return this.fields;
    }

    public String[] getFieldTypes() {
        return this.fieldTypes;
    }

    public String getLastFieldName() {
        if (this.fields == null || this.fields.length == 0) {
            return null;
        }
        return this.fields[this.fields.length - 1];
    }

    public String getLastFieldType() {
        if (this.fieldTypes == null || this.fieldTypes.length == 0) {
            return null;
        }
        return this.fieldTypes[this.fieldTypes.length - 1];
    }

    public boolean isEmpty() {
        return this.fields == null || this.fields.length == 0;
    }

    public AccessPathFragment append(AccessPathFragment toAppend) {
        if (toAppend == null || toAppend.isEmpty()) {
            if (this.isEmpty()) {
                return null;
            }
            return this;
        }
        if (this.isEmpty()) {
            return toAppend;
        }
        String[] toAppendFields = toAppend.getFields();
        String[] toAppendFieldTypes = toAppend.getFieldTypes();
        String[] appendedFields = new String[this.fields.length + toAppendFields.length];
        System.arraycopy(this.fields, 0, appendedFields, 0, this.fields.length);
        System.arraycopy(toAppendFields, 0, appendedFields, this.fields.length, toAppendFields.length);
        String[] appendedTypes = new String[this.fieldTypes.length + toAppendFieldTypes.length];
        System.arraycopy(this.fieldTypes, 0, appendedTypes, 0, this.fieldTypes.length);
        System.arraycopy(toAppendFieldTypes, 0, appendedTypes, this.fieldTypes.length, toAppendFieldTypes.length);
        return new AccessPathFragment(appendedFields, appendedTypes);
    }

    public AccessPathFragment updateFieldType(int idx, String fieldType) {
        String[] newFieldTypes = Arrays.copyOf(this.fieldTypes, this.fieldTypes.length);
        newFieldTypes[idx] = fieldType;
        return new AccessPathFragment(this.fields, newFieldTypes);
    }

    public String getField(int idx) {
        if (idx < 0 || idx >= this.fields.length) {
            return null;
        }
        return this.fields[idx];
    }

    public AccessPathFragment prefix(int length) {
        if (length < 0) {
            return this;
        }
        if (this.length() <= length) {
            return this;
        }
        String[] newFields = new String[length];
        String[] newFieldTypes = new String[length];
        System.arraycopy(this.fields, 0, newFields, 0, length);
        System.arraycopy(this.fieldTypes, 0, newFieldTypes, 0, length);
        return new AccessPathFragment(newFields, newFieldTypes);
    }

    public String toString() {
        return this.fields == null ? "<null>" : Arrays.toString(this.fields);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.fieldTypes);
        result = 31 * result + Arrays.hashCode(this.fields);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessPathFragment other = (AccessPathFragment)obj;
        if (!Arrays.equals(this.fieldTypes, other.fieldTypes)) {
            return false;
        }
        return Arrays.equals(this.fields, other.fields);
    }

    public static String toString(AccessPathFragment accessPath) {
        return accessPath.fields == null ? "" : Arrays.toString(accessPath.fields);
    }

    public static AccessPathFragment append(AccessPathFragment accessPath, AccessPathFragment suffix) {
        if (accessPath == null) {
            return suffix;
        }
        if (suffix == null) {
            return accessPath;
        }
        return accessPath.append(suffix);
    }
}

