/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.source;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import heros.solver.IDESolver;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Value;
import soot.jimple.DefinitionStmt;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.methodSummary.data.factory.SourceSinkFactory;
import soot.jimple.infoflow.sourcesSinks.manager.ISourceSinkManager;
import soot.jimple.infoflow.sourcesSinks.manager.SinkInfo;
import soot.jimple.infoflow.sourcesSinks.manager.SourceInfo;

public class SummarySourceSinkManager
implements ISourceSinkManager {
    protected final LoadingCache<SootClass, Collection<SootField>> classToFields = IDESolver.DEFAULT_CACHE_BUILDER.build((CacheLoader)new CacheLoader<SootClass, Collection<SootField>>(){

        public Collection<SootField> load(SootClass sc) throws Exception {
            LinkedList<SootField> res = new LinkedList<SootField>();
            List impler = Scene.v().getActiveHierarchy().getSuperclassesOfIncluding(SummarySourceSinkManager.this.method.getDeclaringClass());
            for (SootClass c : impler) {
                res.addAll((Collection<SootField>)c.getFields());
            }
            return res;
        }
    });
    private boolean debug = false;
    private final Logger logger = LoggerFactory.getLogger(SummarySourceSinkManager.class);
    private final String methodSig;
    private final String parentClass;
    private final SourceSinkFactory sourceSinkFactory;
    private SootMethod method = null;

    public SummarySourceSinkManager(String mSig, String parentClass, SourceSinkFactory sourceSinkFactory) {
        this.methodSig = mSig;
        this.parentClass = parentClass;
        this.sourceSinkFactory = sourceSinkFactory;
    }

    public SummarySourceSinkManager(SootMethod method, SourceSinkFactory sourceSinkFactory) {
        this.method = method;
        this.methodSig = null;
        this.parentClass = null;
        this.sourceSinkFactory = sourceSinkFactory;
    }

    public SourceInfo getSourceInfo(Stmt sCallSite, InfoflowManager manager) {
        SootMethod currentMethod = (SootMethod)manager.getICFG().getMethodOf((Object)sCallSite);
        if (!this.isMethodToSummarize(currentMethod)) {
            return null;
        }
        if (sCallSite instanceof DefinitionStmt) {
            DefinitionStmt jstmt = (DefinitionStmt)sCallSite;
            Value leftOp = jstmt.getLeftOp();
            Value rightOp = jstmt.getRightOp();
            if (rightOp instanceof ParameterRef) {
                ParameterRef pref = (ParameterRef)rightOp;
                this.logger.debug("source: " + sCallSite + " " + currentMethod.getSignature());
                if (this.debug) {
                    System.out.println("source: " + sCallSite + " " + currentMethod.getSignature());
                }
                return new SourceInfo(null, manager.getAccessPathFactory().createAccessPath(leftOp, true), Collections.singletonList(this.sourceSinkFactory.createParameterSource(pref.getIndex(), pref.getType().toString())));
            }
            if (rightOp instanceof ThisRef) {
                ThisRef tref = (ThisRef)rightOp;
                if (this.debug) {
                    System.out.println("source: (this)" + sCallSite + " " + currentMethod.getSignature());
                }
                return new SourceInfo(null, manager.getAccessPathFactory().createAccessPath(leftOp, true), Collections.singletonList(this.sourceSinkFactory.createThisSource(tref.getType().toString())));
            }
        }
        return null;
    }

    private boolean isMethodToSummarize(SootMethod currentMethod) {
        if (this.method == null) {
            this.method = Scene.v().getMethod(this.methodSig);
        }
        if (currentMethod == this.method) {
            return true;
        }
        return this.parentClass != null && currentMethod.getDeclaringClass().getName().equals(this.parentClass) && currentMethod.getSubSignature().equals(this.method.getSubSignature());
    }

    public SinkInfo getSinkInfo(Stmt sCallSite, InfoflowManager manager, AccessPath sourceAP) {
        if (sourceAP != null) {
            return null;
        }
        SootMethod currentMethod = (SootMethod)manager.getICFG().getMethodOf((Object)sCallSite);
        if (!this.isMethodToSummarize(currentMethod)) {
            return null;
        }
        return sCallSite instanceof ReturnStmt || sCallSite instanceof ReturnVoidStmt ? new SinkInfo(null) : null;
    }

    public void initialize() {
    }
}

