/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.postProcessor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import soot.SootMethod;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.collect.ConcurrentHashSet;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AbstractionAtSink;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.SourceContextAndPath;
import soot.jimple.infoflow.data.pathBuilders.ContextSensitivePathBuilder;
import soot.jimple.infoflow.methodSummary.postProcessor.SummaryPathBuilderContext;
import soot.jimple.infoflow.methodSummary.postProcessor.SummarySourceContextAndPath;
import soot.jimple.infoflow.methodSummary.util.AliasUtils;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.results.ResultSinkInfo;
import soot.jimple.infoflow.results.ResultSourceInfo;
import soot.jimple.infoflow.solver.executors.InterruptableExecutor;

class SummaryPathBuilder
extends ContextSensitivePathBuilder {
    private Set<SummaryResultInfo> resultInfos = new ConcurrentHashSet();
    private Set<Abstraction> visitedAbstractions = Collections.newSetFromMap(new IdentityHashMap());
    private final SummaryPathBuilderContext context;

    public SummaryPathBuilder(InfoflowManager manager, InterruptableExecutor executor) {
        super(manager, executor);
        this.context = new SummaryPathBuilderContext(manager.getTaintWrapper());
    }

    protected boolean checkForSource(Abstraction abs, SourceContextAndPath scap) {
        this.visitedAbstractions.add(abs);
        if (abs.getPredecessor() != null) {
            return false;
        }
        SummarySourceContextAndPath sscap = (SummarySourceContextAndPath)scap;
        SummarySourceInfo ssi = new SummarySourceInfo(abs.getSourceContext().getAccessPath(), abs.getSourceContext().getStmt(), abs.getSourceContext().getUserData(), sscap.getCurrentAccessPath(), sscap.getIsAlias(), !scap.isCallStackEmpty() || sscap.getDepth() != 0);
        ResultSinkInfo rsi = new ResultSinkInfo(null, scap.getAccessPath(), scap.getStmt());
        this.resultInfos.add(new SummaryResultInfo(ssi, rsi));
        return true;
    }

    public void clear() {
        super.getResults().clear();
        this.resultInfos.clear();
        this.visitedAbstractions.clear();
        this.pathCache.clear();
    }

    public Set<SummaryResultInfo> getResultInfos() {
        return this.resultInfos;
    }

    public InfoflowResults getResults() {
        throw new RuntimeException("Not implemented, use getResultInfos() instead");
    }

    protected Runnable getTaintPathTask(AbstractionAtSink abs) {
        SummarySourceContextAndPath scap = new SummarySourceContextAndPath(this.manager, abs.getAbstraction().getAccessPath(), abs.getSinkStmt(), AliasUtils.canAccessPathHaveAliases(abs.getAbstraction().getAccessPath()), abs.getAbstraction().getAccessPath(), new ArrayList<SootMethod>(), this.context);
        if ((scap = scap.extendPath(abs.getAbstraction())) != null && this.pathCache.put((Object)abs.getAbstraction(), (Object)scap) && !this.checkForSource(abs.getAbstraction(), scap)) {
            return new ContextSensitivePathBuilder.SourceFindingTask((ContextSensitivePathBuilder)this, abs.getAbstraction());
        }
        return null;
    }

    public static class SummaryResultInfo {
        private final SummarySourceInfo sourceInfo;
        private final ResultSinkInfo sinkInfo;

        public SummaryResultInfo(SummarySourceInfo sourceInfo, ResultSinkInfo sinkInfo) {
            this.sourceInfo = sourceInfo;
            this.sinkInfo = sinkInfo;
        }

        public SummarySourceInfo getSourceInfo() {
            return this.sourceInfo;
        }

        public ResultSinkInfo getSinkInfo() {
            return this.sinkInfo;
        }

        public String toString() {
            return "Source: " + (Object)((Object)this.sourceInfo) + " -> Sink: " + this.sinkInfo;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.sinkInfo == null ? 0 : this.sinkInfo.hashCode());
            result = 31 * result + (this.sourceInfo == null ? 0 : this.sourceInfo.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SummaryResultInfo other = (SummaryResultInfo)obj;
            if (this.sinkInfo == null ? other.sinkInfo != null : !this.sinkInfo.equals((Object)other.sinkInfo)) {
                return false;
            }
            return !(this.sourceInfo == null ? other.sourceInfo != null : !this.sourceInfo.equals((Object)other.sourceInfo));
        }
    }

    public static class SummarySourceInfo
    extends ResultSourceInfo {
        private final AccessPath sourceAP;
        private final boolean isAlias;
        private final boolean isInCallee;

        public SummarySourceInfo() {
            this.sourceAP = null;
            this.isAlias = false;
            this.isInCallee = false;
        }

        public SummarySourceInfo(AccessPath source, Stmt context, Object userData, AccessPath sourceAP, boolean isAlias, boolean isInCallee) {
            super(null, source, context, userData, null, null);
            this.sourceAP = sourceAP;
            this.isAlias = isAlias;
            this.isInCallee = isInCallee;
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.isAlias ? 1231 : 1237);
            result = 31 * result + (this.sourceAP == null ? 0 : this.sourceAP.hashCode());
            result = 31 * result + (this.isInCallee ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            SummarySourceInfo other = (SummarySourceInfo)((Object)obj);
            if (this.isAlias != other.isAlias) {
                return false;
            }
            if (this.sourceAP == null ? other.sourceAP != null : !this.sourceAP.equals((Object)other.sourceAP)) {
                return false;
            }
            return this.isInCallee == other.isInCallee;
        }

        public AccessPath getSourceAP() {
            return this.sourceAP;
        }

        public boolean getIsAlias() {
            return this.isAlias;
        }

        public boolean getIsInCallee() {
            return this.isInCallee;
        }
    }
}

