/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.postProcessor;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.Local;
import soot.Scene;
import soot.SootMethod;
import soot.Value;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AbstractionAtSink;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.methodSummary.data.factory.SourceSinkFactory;
import soot.jimple.infoflow.methodSummary.data.sourceSink.FlowSink;
import soot.jimple.infoflow.methodSummary.data.sourceSink.FlowSource;
import soot.jimple.infoflow.methodSummary.data.summary.GapDefinition;
import soot.jimple.infoflow.methodSummary.data.summary.MethodFlow;
import soot.jimple.infoflow.methodSummary.data.summary.MethodSummaries;
import soot.jimple.infoflow.methodSummary.generator.GapManager;
import soot.jimple.infoflow.methodSummary.generator.SummaryGeneratorConfiguration;
import soot.jimple.infoflow.methodSummary.postProcessor.SummaryFlowCompactor;
import soot.jimple.infoflow.methodSummary.postProcessor.SummaryPathBuilder;
import soot.jimple.infoflow.methodSummary.taintWrappers.AccessPathFragment;
import soot.jimple.infoflow.methodSummary.util.AliasUtils;
import soot.jimple.infoflow.solver.executors.InterruptableExecutor;
import soot.jimple.infoflow.util.SootMethodRepresentationParser;
import soot.util.MultiMap;

public class InfoflowResultPostProcessor {
    private final boolean DEBUG = true;
    private static final Logger logger = LoggerFactory.getLogger(InfoflowResultPostProcessor.class);
    protected final InfoflowManager manager;
    private final MultiMap<Abstraction, Stmt> collectedAbstractions;
    private final String method;
    protected final SourceSinkFactory sourceSinkFactory;
    private final GapManager gapManager;
    private final SummaryGeneratorConfiguration config;

    public InfoflowResultPostProcessor(MultiMap<Abstraction, Stmt> collectedAbstractions, InfoflowManager manager, String m, SourceSinkFactory sourceSinkFactory, GapManager gapManager) {
        this.collectedAbstractions = collectedAbstractions;
        this.manager = manager;
        this.method = m;
        this.sourceSinkFactory = sourceSinkFactory;
        this.gapManager = gapManager;
        this.config = (SummaryGeneratorConfiguration)manager.getConfig();
    }

    public InfoflowResultPostProcessor(MultiMap<Abstraction, Stmt> collectedAbstractions, InfoflowConfiguration config, String m, SourceSinkFactory sourceSinkFactory, GapManager gapManager) {
        this.collectedAbstractions = collectedAbstractions;
        this.manager = new FakeInfoflowManager(config);
        this.method = m;
        this.sourceSinkFactory = sourceSinkFactory;
        this.gapManager = gapManager;
        this.config = (SummaryGeneratorConfiguration)config;
    }

    public MethodSummaries postProcess() {
        MethodSummaries summaries = new MethodSummaries();
        this.postProcess(summaries);
        return summaries;
    }

    public MethodSummaries postProcess(MethodSummaries flows) {
        logger.info("start processing {} infoflow abstractions for method {}", (Object)this.collectedAbstractions.size(), (Object)this.method);
        SootMethod m = Scene.v().grabMethod(this.method);
        if (m == null) {
            return MethodSummaries.EMPTY_SUMMARIES;
        }
        int analyzedPaths = 0;
        int abstractionCount = 0;
        if (this.collectedAbstractions != null && !this.collectedAbstractions.isEmpty()) {
            InterruptableExecutor executor = new InterruptableExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 30L, TimeUnit.SECONDS, new LinkedBlockingQueue());
            executor.setThreadFactory(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thr = new Thread(r);
                    thr.setDaemon(true);
                    thr.setName("Post processing");
                    return thr;
                }
            });
            SummaryPathBuilder pathBuilder = new SummaryPathBuilder(this.manager, executor);
            for (Abstraction a : this.collectedAbstractions.keySet()) {
                if (a.getSourceContext() != null) {
                    for (Stmt stmt : this.collectedAbstractions.get((Object)a)) {
                        this.processFlowSource(flows, m, a.getAccessPath(), stmt, new SummaryPathBuilder.SummarySourceInfo(a.getAccessPath(), a.getCurrentStmt(), a.getSourceContext().getUserData(), a.getAccessPath(), this.isAliasedField(a.getAccessPath(), a.getSourceContext().getAccessPath(), a.getSourceContext().getStmt()), false));
                    }
                    continue;
                }
                pathBuilder.clear();
                pathBuilder.reset();
                pathBuilder.computeTaintPaths(Collections.singleton(new AbstractionAtSink(null, a, a.getCurrentStmt())));
                try {
                    executor.awaitCompletion();
                }
                catch (InterruptedException e) {
                    logger.error("Could not wait for executor termination", (Throwable)e);
                }
                logger.info("Obtained {} source-to-sink connections.", (Object)pathBuilder.getResultInfos().size());
                for (Stmt stmt : this.collectedAbstractions.get((Object)a)) {
                    ++abstractionCount;
                    if (a.getSourceContext() != null) continue;
                    for (SummaryPathBuilder.SummaryResultInfo si : pathBuilder.getResultInfos()) {
                        boolean isAliasedField;
                        AccessPath sourceAP = si.getSourceInfo().getAccessPath();
                        AccessPath sinkAP = si.getSinkInfo().getAccessPath();
                        Stmt sourceStmt = si.getSourceInfo().getStmt();
                        if (sourceAP == null || sinkAP == null) {
                            throw new RuntimeException("Invalid access path");
                        }
                        boolean bl = isAliasedField = this.gapManager.getGapForCall(sourceStmt) != null && this.isAliasedField(sinkAP, sourceAP, sourceStmt) && si.getSourceInfo().getIsAlias();
                        if (sinkAP.equals((Object)sourceAP) && !isAliasedField) continue;
                        this.processFlowSource(flows, m, sinkAP, stmt, si.getSourceInfo());
                        ++analyzedPaths;
                    }
                }
                pathBuilder.clear();
            }
        }
        new SummaryFlowCompactor(flows).compact();
        if (this.config.getValidateResults()) {
            flows.validate();
        }
        logger.info("Result processing finished, analyzed {} paths from {} stored abstractions", (Object)analyzedPaths, (Object)abstractionCount);
        return flows;
    }

    private boolean isAliasedField(AccessPath apAtSink, AccessPath apAtSource, Stmt sourceStmt) {
        return AliasUtils.canAccessPathHaveAliases(apAtSink);
    }

    private void processFlowSource(MethodSummaries flows, SootMethod m, AccessPath ap, Stmt stmt, SummaryPathBuilder.SummarySourceInfo sourceInfo) {
        Collection sources = (Collection)sourceInfo.getUserData();
        if (sources == null || sources.size() == 0) {
            throw new RuntimeException("Link to source missing");
        }
        for (FlowSource flowSource : sources) {
            if (flowSource == null) continue;
            AccessPath sourceAP = sourceInfo.getSourceAP();
            boolean isAlias = sourceInfo.getIsAlias();
            boolean isInCallee = sourceInfo.getIsInCallee();
            flowSource = this.sourceSinkFactory.createSource(flowSource.getType(), flowSource.getParameterIndex(), sourceAP, flowSource.getGap());
            if (this.manager.getICFG().isExitStmt((Object)stmt)) {
                this.processAbstractionAtReturn(flows, ap, m, flowSource, stmt, sourceAP, isAlias, isInCallee);
                continue;
            }
            if (this.manager.getICFG().isCallStmt((Object)stmt)) {
                this.processAbstractionAtCall(flows, ap, flowSource, stmt, sourceAP, isAlias);
                continue;
            }
            throw new RuntimeException("Invalid statement for flow termination: " + stmt);
        }
    }

    protected void processAbstractionAtCall(MethodSummaries flows, AccessPath apAtCall, FlowSource source, Stmt stmt, AccessPath sourceAP, boolean isAlias) {
        GapDefinition gd = this.gapManager.getGapForCall(stmt);
        if (gd == null) {
            return;
        }
        FlowSink sink = this.createFlowSinkAtCall(apAtCall, gd, stmt);
        if (sink != null) {
            this.addFlow(source, sink, isAlias, flows);
        }
    }

    protected FlowSink createFlowSinkAtCall(AccessPath apAtCall, GapDefinition gd, Stmt stmt) {
        InstanceInvokeExpr iinv;
        Local baseLocal;
        if (apAtCall.isLocal() && stmt.getInvokeExpr() instanceof InstanceInvokeExpr && (baseLocal = (Local)(iinv = (InstanceInvokeExpr)stmt.getInvokeExpr()).getBase()) == apAtCall.getPlainValue()) {
            return this.sourceSinkFactory.createGapBaseObjectSink(gd, apAtCall.getBaseType());
        }
        for (int i = 0; i < stmt.getInvokeExpr().getArgCount(); ++i) {
            Value p = stmt.getInvokeExpr().getArg(i);
            if (apAtCall.getPlainValue() != p) continue;
            return this.sourceSinkFactory.createParameterSink(i, apAtCall, gd);
        }
        if (apAtCall.getFieldCount() > 0 && stmt.getInvokeExpr() instanceof InstanceInvokeExpr) {
            iinv = (InstanceInvokeExpr)stmt.getInvokeExpr();
            if (apAtCall.getPlainValue() == iinv.getBase()) {
                return this.sourceSinkFactory.createFieldSink(apAtCall);
            }
        }
        return null;
    }

    protected void processAbstractionAtReturn(MethodSummaries flows, AccessPath apAtReturn, SootMethod m, FlowSource source, Stmt stmt, AccessPath sourceAP, boolean isAlias, boolean isInCallee) {
        if (stmt instanceof ReturnStmt) {
            ReturnStmt retStmt = (ReturnStmt)stmt;
            if (apAtReturn.getPlainValue() == retStmt.getOp()) {
                FlowSink sink = this.sourceSinkFactory.createReturnSink(apAtReturn);
                this.addFlow(source, sink, isAlias, flows);
            }
        }
        if (!isInCallee && (!apAtReturn.isLocal() || apAtReturn.getTaintSubFields() || apAtReturn.getBaseType() instanceof ArrayType)) {
            for (int i = 0; i < m.getParameterCount(); ++i) {
                Local p = m.getActiveBody().getParameterLocal(i);
                if (apAtReturn.getPlainValue() != p) continue;
                FlowSink sink = this.sourceSinkFactory.createParameterSink(i, apAtReturn);
                this.addFlow(source, sink, isAlias, flows);
            }
        }
        if (!m.isStatic() && apAtReturn.getPlainValue() == m.getActiveBody().getThisLocal()) {
            FlowSink sink = this.sourceSinkFactory.createFieldSink(apAtReturn);
            this.addFlow(source, sink, isAlias, flows);
        }
        if (apAtReturn.isInstanceFieldRef()) {
            FlowSink sink;
            Set<GapDefinition> referencedGaps = this.gapManager.getGapDefinitionsForLocalUse(apAtReturn.getPlainValue());
            if (referencedGaps != null && !referencedGaps.isEmpty()) {
                for (GapDefinition gap : referencedGaps) {
                    sink = this.sourceSinkFactory.createFieldSink(apAtReturn, gap);
                    this.addFlow(source, sink, isAlias, flows);
                }
            }
            if ((referencedGaps = this.gapManager.getGapDefinitionsForLocalDef(apAtReturn.getPlainValue())) != null && !referencedGaps.isEmpty()) {
                for (GapDefinition gap : referencedGaps) {
                    sink = this.sourceSinkFactory.createReturnSink(apAtReturn, gap);
                    this.addFlow(source, sink, isAlias, flows);
                }
            }
        }
    }

    private boolean isIdentityFlow(FlowSource source, FlowSink sink) {
        if (sink.isReturn()) {
            return false;
        }
        if (sink.isField() && source.isParameter()) {
            return false;
        }
        if (sink.isParameter() && (source.isField() || source.isThis())) {
            return false;
        }
        if (source.getGap() != sink.getGap()) {
            return false;
        }
        if (sink.getParameterIndex() != source.getParameterIndex()) {
            return false;
        }
        if (sink.getAccessPath() == null && source.getAccessPath() != null || sink.getAccessPath() != null && source.getAccessPath() == null) {
            return false;
        }
        AccessPathFragment sinkAccessPath = sink.getAccessPath();
        AccessPathFragment sourceAccessPath = source.getAccessPath();
        if (sinkAccessPath != null && sourceAccessPath != null) {
            if (sinkAccessPath.length() != sourceAccessPath.length()) {
                return false;
            }
            for (int i = 0; i < sink.getAccessPath().length(); ++i) {
                if (sourceAccessPath.getField(i).equals(sinkAccessPath.getField(i))) continue;
                return false;
            }
        }
        return true;
    }

    protected void addFlow(FlowSource source, FlowSink sink, boolean isAlias, MethodSummaries summaries) {
        String methodSubSig = SootMethodRepresentationParser.v().parseSootMethodString(this.method).getSubSignature();
        if (this.isIdentityFlow(source, sink)) {
            return;
        }
        MethodFlow mFlow = new MethodFlow(methodSubSig, source, sink, isAlias, true, false);
        if (summaries.addFlow(mFlow)) {
            this.debugMSG(source, sink, isAlias);
        }
    }

    private void debugMSG(FlowSource source, FlowSink sink, boolean isAlias) {
        System.out.println("\nmethod: " + this.method);
        System.out.println("source: " + source.toString());
        System.out.println("sink  : " + sink.toString());
        System.out.println("alias : " + isAlias);
        GapDefinition gap = sink.getGap();
        if (gap != null) {
            System.out.println("gap : " + gap.getSignature());
        }
        System.out.println("------------------------------------");
    }

    private static class FakeInfoflowManager
    extends InfoflowManager {
        protected FakeInfoflowManager(InfoflowConfiguration config) {
            super(config, null, null, null, null, null, null, null);
        }
    }
}

