/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.handler;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.handlers.TaintPropagationHandler;
import soot.jimple.infoflow.methodSummary.generator.GapManager;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.util.ConcurrentHashMultiMap;
import soot.util.MultiMap;

public class SummaryTaintPropagationHandler
implements TaintPropagationHandler {
    private final String methodSig;
    private final String parentClass;
    private final Set<SootMethod> excludedMethods = new HashSet<SootMethod>();
    private final GapManager gapManager;
    private SootMethod method = null;
    private boolean followReturnsPastSeeds = false;
    private ConcurrentHashMultiMap<Abstraction, Stmt> result = new ConcurrentHashMultiMap();

    public SummaryTaintPropagationHandler(String m, String parentClass, GapManager gapManager) {
        this.methodSig = m;
        this.parentClass = parentClass;
        this.gapManager = gapManager;
    }

    public SummaryTaintPropagationHandler(SootMethod m, GapManager gapManager) {
        this.method = m;
        this.methodSig = null;
        this.parentClass = null;
        this.gapManager = gapManager;
    }

    private boolean isMethodToSummarize(SootMethod currentMethod) {
        if (currentMethod == this.method) {
            return true;
        }
        return this.parentClass != null && currentMethod.getDeclaringClass().getName().equals(this.parentClass) && currentMethod.getSubSignature().equals(this.method.getSubSignature());
    }

    public void notifyFlowIn(Unit stmt, Abstraction result, InfoflowManager manager, TaintPropagationHandler.FlowFunctionType type) {
        if (this.method == null) {
            this.method = Scene.v().getMethod(this.methodSig);
        }
        IInfoflowCFG cfg = manager.getICFG();
        if (type.equals((Object)TaintPropagationHandler.FlowFunctionType.ReturnFlowFunction)) {
            SootMethod m = (SootMethod)cfg.getMethodOf((Object)stmt);
            if (!this.isMethodToSummarize(m)) {
                return;
            }
            this.handleReturnFlow((Stmt)stmt, result, cfg);
        } else if (type.equals((Object)TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction)) {
            this.handleCallToReturnFlow((Stmt)stmt, result, cfg);
        }
    }

    protected void handleReturnFlow(Stmt stmt, Abstraction abs, IInfoflowCFG cfg) {
        if (!abs.isAbstractionActive()) {
            return;
        }
        this.addResult(abs, stmt);
    }

    private void purgeResults() {
        Iterator absIt = this.result.keySet().iterator();
        while (absIt.hasNext()) {
            Abstraction abs = (Abstraction)absIt.next();
            boolean isGapField = this.gapManager.isLocalReferencedInGap(abs.getAccessPath().getPlainValue());
            if (isGapField) continue;
            boolean isReturned = false;
            for (Stmt stmt : this.result.get((Object)abs)) {
                if (!this.isValueReturnedFromCall((Unit)stmt, abs)) continue;
                isReturned = true;
                break;
            }
            if (isReturned) continue;
            absIt.remove();
        }
    }

    private boolean isValueReturnedFromCall(Unit stmt, Abstraction abs) {
        ThrowStmt throwStmt;
        ReturnStmt retStmt;
        if (stmt instanceof ReturnStmt && (retStmt = (ReturnStmt)stmt).getOp() == abs.getAccessPath().getPlainValue()) {
            return true;
        }
        if (stmt instanceof ThrowStmt && (throwStmt = (ThrowStmt)stmt).getOp() == abs.getAccessPath().getPlainValue()) {
            return true;
        }
        for (Value param : this.method.getActiveBody().getParameterLocals()) {
            if (abs.getAccessPath().getPlainValue() != param) continue;
            return true;
        }
        return !this.method.isStatic() && abs.getAccessPath().getPlainValue() == this.method.getActiveBody().getThisLocal();
    }

    protected void handleCallToReturnFlow(Stmt stmt, Abstraction abs, IInfoflowCFG cfg) {
        if (this.gapManager.needsGapConstruction(stmt, abs, cfg)) {
            this.addResult(abs, stmt);
        }
    }

    protected void addResult(Abstraction abs, Stmt stmt) {
        if (!this.result.put((Object)abs, (Object)stmt)) {
            for (Abstraction abs2 : this.result.keySet()) {
                if (!abs.equals((Object)abs2)) continue;
                abs2.addNeighbor(abs);
                break;
            }
        }
    }

    public Set<Abstraction> notifyFlowOut(Unit u, Abstraction d1, Abstraction incoming, Set<Abstraction> outgoing, InfoflowManager manager, TaintPropagationHandler.FlowFunctionType type) {
        SootMethod sm = (SootMethod)manager.getICFG().getMethodOf((Object)u);
        if (this.excludedMethods.contains(sm)) {
            return Collections.emptySet();
        }
        if (type == TaintPropagationHandler.FlowFunctionType.ReturnFlowFunction && !this.followReturnsPastSeeds && sm == this.method) {
            return Collections.emptySet();
        }
        return outgoing;
    }

    public MultiMap<Abstraction, Stmt> getResult() {
        this.purgeResults();
        return this.result;
    }

    public GapManager getGapManager() {
        return this.gapManager;
    }

    public void addExcludedMethod(SootMethod excluded) {
        this.excludedMethods.add(excluded);
    }

    public void setFollowReturnsPastSeeds(boolean follow) {
        this.followReturnsPastSeeds = follow;
    }
}

