/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.generator;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.G;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.config.IInfoflowConfig;
import soot.jimple.infoflow.data.pathBuilders.DefaultPathBuilderFactory;
import soot.jimple.infoflow.data.pathBuilders.IPathBuilderFactory;
import soot.jimple.infoflow.entryPointCreators.BaseEntryPointCreator;
import soot.jimple.infoflow.entryPointCreators.IEntryPointCreator;
import soot.jimple.infoflow.entryPointCreators.SequentialEntryPointCreator;
import soot.jimple.infoflow.handlers.PreAnalysisHandler;
import soot.jimple.infoflow.handlers.ResultsAvailableHandler;
import soot.jimple.infoflow.methodSummary.DefaultSummaryConfig;
import soot.jimple.infoflow.methodSummary.data.factory.SourceSinkFactory;
import soot.jimple.infoflow.methodSummary.data.provider.EagerSummaryProvider;
import soot.jimple.infoflow.methodSummary.data.provider.IMethodSummaryProvider;
import soot.jimple.infoflow.methodSummary.data.provider.LazySummaryProvider;
import soot.jimple.infoflow.methodSummary.data.provider.MemorySummaryProvider;
import soot.jimple.infoflow.methodSummary.data.provider.MergingSummaryProvider;
import soot.jimple.infoflow.methodSummary.data.summary.ClassMethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.ClassSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.MethodFlow;
import soot.jimple.infoflow.methodSummary.data.summary.MethodSummaries;
import soot.jimple.infoflow.methodSummary.generator.GapManager;
import soot.jimple.infoflow.methodSummary.generator.IClassSummaryHandler;
import soot.jimple.infoflow.methodSummary.generator.SummaryGenerationTaintWrapper;
import soot.jimple.infoflow.methodSummary.generator.SummaryGeneratorConfiguration;
import soot.jimple.infoflow.methodSummary.generator.SummaryInfoflow;
import soot.jimple.infoflow.methodSummary.generator.SummaryNativeCallHandler;
import soot.jimple.infoflow.methodSummary.handler.SummaryTaintPropagationHandler;
import soot.jimple.infoflow.methodSummary.postProcessor.InfoflowResultPostProcessor;
import soot.jimple.infoflow.methodSummary.postProcessor.SummaryFlowCompactor;
import soot.jimple.infoflow.methodSummary.source.SummarySourceSinkManager;
import soot.jimple.infoflow.methodSummary.taintWrappers.AccessPathFragment;
import soot.jimple.infoflow.methodSummary.taintWrappers.SummaryTaintWrapper;
import soot.jimple.infoflow.nativeCallHandler.INativeCallHandler;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.infoflow.taintWrappers.TaintWrapperList;
import soot.options.Options;

public class SummaryGenerator {
    private static final Logger logger = LoggerFactory.getLogger(SummaryGenerator.class);
    public static final String DUMMY_MAIN_SIG = "<dummyMainClass: void dummyMainMethod(java.lang.String[])>";
    protected boolean debug = false;
    protected INativeCallHandler nativeCallHandler;
    protected IInfoflowConfig sootConfig;
    protected SummaryGeneratorConfiguration config = new SummaryGeneratorConfiguration();
    protected List<String> substitutedWith = new LinkedList<String>();
    protected SummaryTaintWrapper fallbackWrapper;
    protected boolean fallbackWrapperInitialized = false;
    protected MemorySummaryProvider onFlySummaryProvider = null;

    private void initializeFallbackWrapper() {
        if (this.fallbackWrapperInitialized) {
            return;
        }
        this.fallbackWrapperInitialized = true;
        try {
            Set<String> additionalSummaryDirs;
            ArrayList<IMethodSummaryProvider> innerProviders = new ArrayList<IMethodSummaryProvider>();
            if (this.config.getApplySummariesOnTheFly()) {
                this.onFlySummaryProvider = new MemorySummaryProvider();
                innerProviders.add(this.onFlySummaryProvider);
            }
            if ((additionalSummaryDirs = this.config.getAdditionalSummaryDirectories()) != null && !additionalSummaryDirs.isEmpty()) {
                LazySummaryProvider lazySummaryProvider = new LazySummaryProvider(additionalSummaryDirs.stream().map(d -> new File((String)d)).collect(Collectors.toList()));
                innerProviders.add(lazySummaryProvider);
            }
            if (this.config.isUseDefaultSummaries()) {
                innerProviders.add(new EagerSummaryProvider("/summariesManual"));
            }
            MergingSummaryProvider provider = new MergingSummaryProvider(innerProviders);
            this.fallbackWrapper = new SummaryTaintWrapper(provider);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("An error occurred while loading the fallback taint wrapper, proceeding without fallback", (Throwable)e);
        }
    }

    public void releaseFallbackTaintWrapper() {
        this.fallbackWrapper = null;
        this.fallbackWrapperInitialized = false;
    }

    public ClassSummaries createMethodSummaries(String classpath, Collection<String> classNames) {
        return this.createMethodSummaries(classpath, classNames, null);
    }

    public ClassSummaries createMethodSummaries(String classpath, Collection<String> classNames, IClassSummaryHandler handler) {
        G.reset();
        boolean hasWildcard = false;
        for (String className : classNames) {
            if (!className.endsWith(".*")) continue;
            hasWildcard = true;
            break;
        }
        Options.v().set_output_format(12);
        if (hasWildcard || this.config.getLoadFullJAR()) {
            Options.v().set_process_dir(Arrays.asList(classpath.split(File.pathSeparator)));
        } else {
            Options.v().set_soot_classpath(classpath);
        }
        Options.v().set_whole_program(false);
        Options.v().set_allow_phantom_refs(true);
        for (String className : classNames) {
            if (className.endsWith(".*")) continue;
            Scene.v().addBasicClass(className, 2);
        }
        if (classpath.toLowerCase().endsWith(".apk")) {
            Options.v().set_src_prec(5);
            Options.v().set_process_multiple_dex(true);
            if (this.config.getAndroidPlatformDir() != null) {
                Options.v().set_android_jars(this.config.getAndroidPlatformDir());
            }
        } else {
            Options.v().set_src_prec(1);
        }
        Scene.v().loadNecessaryClasses();
        HashSet<ClassAnalysisTask> realClasses = new HashSet<ClassAnalysisTask>(classNames.size());
        if (this.config.getLoadFullJAR()) {
            Iterator scIt = Scene.v().getApplicationClasses().snapshotIterator();
            while (scIt.hasNext()) {
                SootClass sootClass = (SootClass)scIt.next();
                Scene.v().forceResolve(sootClass.getName(), 2);
                if (!sootClass.isConcrete()) continue;
                this.checkAndAdd(realClasses, sootClass.getName());
            }
        }
        for (String string : classNames) {
            if (string.endsWith(".*")) {
                String prefix = string.substring(0, string.length() - 1);
                Iterator<? extends String> scIt = Scene.v().getClasses().snapshotIterator();
                while (scIt.hasNext()) {
                    SootClass sootClass = (SootClass)scIt.next();
                    if (!sootClass.getName().startsWith(prefix)) continue;
                    Scene.v().forceResolve(sootClass.getName(), 2);
                    if (!sootClass.isConcrete()) continue;
                    this.checkAndAdd(realClasses, sootClass.getName());
                }
                continue;
            }
            SootClass sc3 = Scene.v().getSootClass(string);
            if (!sc3.isConcrete()) {
                for (String string2 : this.getImplementorsOf(sc3)) {
                    this.checkAndAdd(realClasses, string2);
                }
                continue;
            }
            this.checkAndAdd(realClasses, string);
        }
        ArrayList<ClassAnalysisTask> sortedTasks = new ArrayList<ClassAnalysisTask>(realClasses);
        if (this.config.getApplySummariesOnTheFly()) {
            sortedTasks.sort(new AnalysisTasksComparator());
        }
        for (ClassAnalysisTask analysisTask : sortedTasks) {
            HashSet<String> doneMethods = new HashSet<String>();
            SootClass sootClass = Scene.v().getSootClass(analysisTask.className);
            for (Object sm : sootClass.getMethods()) {
                if (!this.checkAndAdd(analysisTask, (SootMethod)sm)) continue;
                doneMethods.add(sm.getSubSignature());
            }
            for (SootClass curClass = sootClass.getSuperclassUnsafe(); curClass != null && curClass.isConcrete() && !curClass.isLibraryClass(); curClass = curClass.getSuperclassUnsafe()) {
                Object sm;
                sm = curClass.getMethods().iterator();
                while (sm.hasNext()) {
                    SootMethod sm2 = (SootMethod)sm.next();
                    if (!this.checkAndAdd(analysisTask, sm2)) continue;
                    doneMethods.add(sm2.getSubSignature());
                }
            }
        }
        G.reset();
        GapManager gapManager = new GapManager();
        ClassSummaries summaries = new ClassSummaries();
        for (ClassAnalysisTask classAnalysisTask : realClasses) {
            String className = classAnalysisTask.className;
            if (handler != null && !handler.onBeforeAnalyzeClass(className)) {
                logger.info(String.format("Skipping over class %s", className));
                continue;
            }
            ClassMethodSummaries curSummaries = null;
            for (int i = 0; i < this.config.getRepeatCount(); ++i) {
                System.gc();
                long nanosBeforeClass = System.nanoTime();
                System.out.println(String.format("Analyzing class %s", className));
                curSummaries = new ClassMethodSummaries(className);
                for (String methodSig : classAnalysisTask.methods) {
                    MethodSummaries newSums = this.createMethodSummary(classpath, methodSig, className, gapManager, new SummaryHierarchyGenerator(curSummaries));
                    if (handler != null) {
                        handler.onMethodFinished(methodSig, newSums);
                        if (this.onFlySummaryProvider != null) {
                            this.onFlySummaryProvider.addSummary(new ClassMethodSummaries(className, newSums));
                        }
                    }
                    curSummaries.merge(newSums);
                    if (this.config.getClassSummaryTimeout() <= 0L || !((double)(System.nanoTime() - nanosBeforeClass) / 1.0E9 > (double)this.config.getClassSummaryTimeout())) continue;
                    logger.info(String.format("Class summaries for %s aborted after %.2f seconds. Still got %d summaries.", className, (double)(System.nanoTime() - nanosBeforeClass) / 1.0E9, curSummaries.getFlowCount()));
                    break;
                }
                logger.info(String.format("Class summaries for %s done in %.2f seconds for %d summaries", className, (double)(System.nanoTime() - nanosBeforeClass) / 1.0E9, curSummaries.getFlowCount()));
            }
            if (handler != null) {
                handler.onClassFinished(curSummaries);
            }
            summaries.merge(curSummaries);
            new SummaryFlowCompactor(curSummaries.getMethodSummaries()).compact();
        }
        this.calculateDependencies(summaries);
        return summaries;
    }

    private boolean checkAndAdd(ClassAnalysisTask analysisTask, SootMethod sm) {
        if (!sm.isConcrete()) {
            return false;
        }
        if (!sm.isPublic() && !sm.isProtected()) {
            return false;
        }
        String sig = sm.getSignature();
        if (!this.config.getSummarizeHashCodeEquals() && (sig.equals("int hashCode()") || sig.equals("boolean equals(java.lang.Object)"))) {
            return false;
        }
        analysisTask.addMethod(sig);
        return true;
    }

    private void checkAndAdd(Set<ClassAnalysisTask> classes, String className) {
        if (this.config.getExcludes() != null) {
            for (String excl : this.config.getExcludes()) {
                String baseName;
                if (excl.equals(className)) {
                    return;
                }
                if (!excl.endsWith(".*") || !className.startsWith(baseName = excl.substring(0, excl.length() - 1))) continue;
                return;
            }
        }
        classes.add(new ClassAnalysisTask(className));
    }

    private Collection<? extends String> getImplementorsOf(SootClass sc) {
        HashSet<String> classes = new HashSet<String>();
        HashSet<SootClass> doneSet = new HashSet<SootClass>();
        ArrayList<SootClass> workList = new ArrayList<SootClass>();
        workList.add(sc);
        while (!workList.isEmpty()) {
            SootClass curClass = (SootClass)workList.remove(0);
            if (!doneSet.add(curClass)) continue;
            if (curClass.isConcrete()) {
                classes.add(curClass.getName());
            }
            if (sc.isInterface()) {
                workList.addAll(Scene.v().getActiveHierarchy().getImplementersOf(sc));
                workList.addAll(Scene.v().getActiveHierarchy().getSubinterfacesOf(sc));
                continue;
            }
            for (SootClass c : Scene.v().getActiveHierarchy().getSubclassesOf(sc)) {
                classes.add(c.getName());
            }
        }
        return classes;
    }

    private void calculateDependencies(ClassSummaries summaries) {
        for (MethodFlow flow : summaries.getAllFlows()) {
            AccessPathFragment sinkAP;
            String className;
            AccessPathFragment sourceAP;
            if (flow.source().hasAccessPath() && !(sourceAP = flow.source().getAccessPath()).isEmpty()) {
                for (String apElement : sourceAP.getFields()) {
                    className = this.getTypeFromFieldDef(apElement);
                    if (summaries.hasSummariesForClass(className)) continue;
                    summaries.addDependency(className);
                }
            }
            if (!flow.sink().hasAccessPath() || (sinkAP = flow.sink().getAccessPath()).isEmpty()) continue;
            for (String apElement : sinkAP.getFields()) {
                className = this.getTypeFromFieldDef(apElement);
                if (summaries.hasSummariesForClass(className)) continue;
                summaries.addDependency(className);
            }
        }
    }

    private String getTypeFromFieldDef(String apElement) {
        apElement = apElement.substring(apElement.indexOf(":") + 1).trim();
        apElement = apElement.substring(0, apElement.indexOf(" "));
        while (apElement.endsWith("[]")) {
            apElement = apElement.substring(0, apElement.length() - 2);
        }
        return apElement;
    }

    public MethodSummaries createMethodSummary(String classpath, String methodSig) {
        return this.createMethodSummary(classpath, methodSig, "", new GapManager());
    }

    private MethodSummaries createMethodSummary(String classpath, String methodSig, String parentClass, GapManager gapManager) {
        return this.createMethodSummary(classpath, methodSig, parentClass, gapManager, null);
    }

    private MethodSummaries createMethodSummary(String classpath, final String methodSig, String parentClass, final GapManager gapManager, final ResultsAvailableHandler resultHandler) {
        this.initializeFallbackWrapper();
        logger.info(String.format("Computing method summary for %s...", methodSig));
        long nanosBeforeMethod = System.nanoTime();
        final SourceSinkFactory sourceSinkFactory = new SourceSinkFactory(this.config.getAccessPathConfiguration().getAccessPathLength());
        SummarySourceSinkManager sourceSinkManager = new SummarySourceSinkManager(methodSig, parentClass, sourceSinkFactory);
        final MethodSummaries summaries = new MethodSummaries();
        final SummaryInfoflow infoflow = this.initInfoflow(summaries, gapManager);
        final SummaryTaintPropagationHandler listener = new SummaryTaintPropagationHandler(methodSig, parentClass, gapManager);
        infoflow.setTaintPropagationHandler(listener);
        infoflow.setPreProcessors(Collections.singleton(new PreAnalysisHandler(){

            public void onBeforeCallgraphConstruction() {
            }

            public void onAfterCallgraphConstruction() {
                listener.addExcludedMethod(Scene.v().getMethod(SummaryGenerator.DUMMY_MAIN_SIG));
            }
        }));
        infoflow.addResultsAvailableHandler(new ResultsAvailableHandler(){

            public void onResultsAvailable(IInfoflowCFG cfg, InfoflowResults results) {
                InfoflowResultPostProcessor processor = infoflow.getManager() != null ? new InfoflowResultPostProcessor(listener.getResult(), infoflow.getManager(), methodSig, sourceSinkFactory, gapManager) : new InfoflowResultPostProcessor(listener.getResult(), infoflow.getConfig(), methodSig, sourceSinkFactory, gapManager);
                processor.postProcess(summaries);
                if (resultHandler != null) {
                    resultHandler.onResultsAvailable(cfg, results);
                }
            }
        });
        try {
            infoflow.computeInfoflow(null, classpath, (IEntryPointCreator)this.createEntryPoint(Collections.singletonList(methodSig), parentClass), sourceSinkManager);
        }
        catch (Exception e) {
            logger.error(String.format("Could not generate summary for method %s", methodSig, e));
            throw e;
        }
        logger.info("Method summary for " + methodSig + " done in " + (double)(System.nanoTime() - nanosBeforeMethod) / 1.0E9 + " seconds");
        return summaries;
    }

    private BaseEntryPointCreator createEntryPoint(Collection<String> entryPoints, String parentClass) {
        SequentialEntryPointCreator dEntryPointCreater = new SequentialEntryPointCreator(entryPoints);
        ArrayList<String> substClasses = new ArrayList<String>(this.substitutedWith);
        if (parentClass != null && !parentClass.isEmpty()) {
            substClasses.add(parentClass);
        }
        dEntryPointCreater.setSubstituteClasses(substClasses);
        dEntryPointCreater.setSubstituteCallParams(true);
        dEntryPointCreater.setIgnoreSystemClassParams(false);
        return dEntryPointCreater;
    }

    protected SummaryInfoflow getInfoflowInstance() {
        SummaryInfoflow infoflow = new SummaryInfoflow();
        infoflow.setPathBuilderFactory((IPathBuilderFactory)new DefaultPathBuilderFactory(this.config.getPathConfiguration()){

            public boolean supportsPathReconstruction() {
                return true;
            }
        });
        return infoflow;
    }

    protected SummaryGenerationTaintWrapper createTaintWrapper(MethodSummaries summaries, GapManager gapManager) {
        return new SummaryGenerationTaintWrapper(summaries, gapManager);
    }

    protected SummaryInfoflow initInfoflow(MethodSummaries summaries, GapManager gapManager) {
        SummaryInfoflow iFlow = this.getInfoflowInstance();
        InfoflowConfiguration.setMergeNeighbors((boolean)true);
        iFlow.setConfig(this.config);
        if (this.nativeCallHandler == null) {
            iFlow.setNativeCallHandler((INativeCallHandler)new SummaryNativeCallHandler());
        } else {
            iFlow.setNativeCallHandler((INativeCallHandler)new SummaryNativeCallHandler(this.nativeCallHandler));
        }
        SummaryGenerationTaintWrapper summaryWrapper = this.createTaintWrapper(summaries, gapManager);
        iFlow.setTaintWrapper((ITaintPropagationWrapper)new TaintWrapperList(new ITaintPropagationWrapper[]{this.fallbackWrapper, summaryWrapper}));
        if (this.sootConfig == null) {
            iFlow.setSootConfig(new DefaultSummaryConfig());
        } else {
            iFlow.setSootConfig(this.sootConfig);
        }
        return iFlow;
    }

    public void setNativeCallHandler(INativeCallHandler nativeCallHandler) {
        this.nativeCallHandler = nativeCallHandler;
    }

    public void setSootConfig(IInfoflowConfig config) {
        this.sootConfig = config;
    }

    public List<String> getSubstitutedWith() {
        return this.substitutedWith;
    }

    public void setSubstitutedWith(List<String> substitutedWith) {
        this.substitutedWith = substitutedWith;
    }

    public SummaryGeneratorConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(SummaryGeneratorConfiguration config) {
        this.config = config;
    }

    private static class SummaryHierarchyGenerator
    implements ResultsAvailableHandler {
        private final ClassMethodSummaries summaries;

        public SummaryHierarchyGenerator(ClassMethodSummaries summaries) {
            this.summaries = summaries;
        }

        public void onResultsAvailable(IInfoflowCFG cfg, InfoflowResults results) {
            SootClass sc = Scene.v().getSootClassUnsafe(this.summaries.getClassName());
            if (sc != null) {
                if (sc.hasSuperclass()) {
                    this.summaries.setSuperClass(sc.getSuperclass().getName());
                }
                for (SootClass intf : sc.getInterfaces()) {
                    this.summaries.addInterface(intf.getName());
                }
            }
        }
    }

    private static class AnalysisTasksComparator
    implements Comparator<ClassAnalysisTask> {
        private AnalysisTasksComparator() {
        }

        @Override
        public int compare(ClassAnalysisTask o1, ClassAnalysisTask o2) {
            SootClass sc1 = Scene.v().getSootClassUnsafe(o1.className);
            SootClass sc2 = Scene.v().getSootClassUnsafe(o2.className);
            if (sc1 != null && sc2 != null) {
                int numDeps1 = this.getDependencyCount(sc1);
                int numDeps2 = this.getDependencyCount(sc2);
                return numDeps1 - numDeps2;
            }
            return 0;
        }

        private int getDependencyCount(SootClass sc) {
            HashSet<SootClass> dependencies = new HashSet<SootClass>();
            for (SootMethod sm : sc.getMethods()) {
                if (!sm.isConcrete()) continue;
                for (Unit u : sm.retrieveActiveBody().getUnits()) {
                    SootMethod callee;
                    SootField fld;
                    Stmt stmt = (Stmt)u;
                    if (stmt.containsFieldRef() && (fld = stmt.getFieldRef().getField()).getDeclaringClass() != sc) {
                        dependencies.add(fld.getDeclaringClass());
                    }
                    if (!stmt.containsInvokeExpr() || (callee = stmt.getInvokeExpr().getMethod()).getDeclaringClass() == sc) continue;
                    dependencies.add(callee.getDeclaringClass());
                }
            }
            return dependencies.size();
        }
    }

    private static class ClassAnalysisTask {
        private final String className;
        private final Set<String> methods = new HashSet<String>();

        public ClassAnalysisTask(String className) {
            this.className = className;
        }

        public void addMethod(String signature) {
            this.methods.add(signature);
        }
    }
}

