/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.generator;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.DefinitionStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.SourceContext;
import soot.jimple.infoflow.methodSummary.data.sourceSink.FlowSource;
import soot.jimple.infoflow.methodSummary.data.summary.GapDefinition;
import soot.jimple.infoflow.methodSummary.data.summary.MethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.SourceSinkType;
import soot.jimple.infoflow.methodSummary.generator.GapManager;
import soot.jimple.infoflow.methodSummary.util.AliasUtils;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;

public class SummaryGenerationTaintWrapper
implements ITaintPropagationWrapper {
    protected InfoflowManager manager;
    protected final MethodSummaries summaries;
    protected final GapManager gapManager;

    public SummaryGenerationTaintWrapper(MethodSummaries summaries, GapManager gapManager) {
        this.summaries = summaries;
        this.gapManager = gapManager;
    }

    public void initialize(InfoflowManager manager) {
        this.manager = manager;
    }

    public Set<Abstraction> getTaintsForMethod(Stmt stmt, Abstraction d1, Abstraction taintedPath) {
        AccessPath ap;
        if (!stmt.containsInvokeExpr()) {
            return Collections.singleton(taintedPath);
        }
        if (!this.gapManager.needsGapConstruction(stmt, taintedPath, this.manager.getICFG())) {
            return Collections.singleton(taintedPath);
        }
        if (!taintedPath.isAbstractionActive()) {
            return Collections.singleton(taintedPath);
        }
        if (((SootMethod)this.manager.getICFG().getMethodOf((Object)stmt)).getDeclaringClass().getName().equals("java.lang.System")) {
            return Collections.singleton(taintedPath);
        }
        GapDefinition gap = this.gapManager.getOrCreateGapForCall(this.summaries, stmt);
        HashSet<Abstraction> res = new HashSet<Abstraction>();
        if (stmt.getInvokeExpr() instanceof InstanceInvokeExpr) {
            ap = this.manager.getAccessPathFactory().createAccessPath(((InstanceInvokeExpr)stmt.getInvokeExpr()).getBase(), true);
            res.add(this.getContinuation(taintedPath, ap, gap, stmt));
        }
        for (Value paramVal : stmt.getInvokeExpr().getArgs()) {
            AccessPath ap2;
            if (!AccessPath.canContainValue((Value)paramVal) || !AliasUtils.canAccessPathHaveAliases(ap2 = this.manager.getAccessPathFactory().createAccessPath(paramVal, true))) continue;
            res.add(this.getContinuation(taintedPath, ap2, gap, stmt));
        }
        if (stmt instanceof DefinitionStmt) {
            ap = this.manager.getAccessPathFactory().createAccessPath(((DefinitionStmt)stmt).getLeftOp(), true);
            res.add(this.getContinuation(taintedPath, ap, gap, stmt));
        }
        return res;
    }

    private Abstraction getContinuation(Abstraction source, AccessPath accessPath, GapDefinition gap, Stmt stmt) {
        Abstraction newOutAbs = source.clone().deriveNewAbstraction(accessPath, stmt);
        newOutAbs.setPredecessor(null);
        newOutAbs.setSourceContext(new SourceContext(null, accessPath, stmt, this.getFlowSource(accessPath, stmt, gap)));
        return newOutAbs;
    }

    private Set<FlowSource> getFlowSource(AccessPath accessPath, Stmt stmt, GapDefinition gap) {
        HashSet<FlowSource> res = new HashSet<FlowSource>();
        if (stmt.getInvokeExpr() instanceof InstanceInvokeExpr && ((InstanceInvokeExpr)stmt.getInvokeExpr()).getBase() == accessPath.getPlainValue()) {
            res.add(new FlowSource(SourceSinkType.Field, accessPath.getBaseType().toString(), gap));
        }
        for (int i = 0; i < stmt.getInvokeExpr().getArgCount(); ++i) {
            if (stmt.getInvokeExpr().getArg(i) != accessPath.getPlainValue()) continue;
            res.add(new FlowSource(SourceSinkType.Parameter, i, accessPath.getBaseType().toString(), gap));
        }
        if (stmt instanceof DefinitionStmt && ((DefinitionStmt)stmt).getLeftOp() == accessPath.getPlainValue()) {
            res.add(new FlowSource(SourceSinkType.Return, accessPath.getBaseType().toString(), gap));
        }
        return res;
    }

    public boolean isExclusive(Stmt stmt, Abstraction taintedPath) {
        return this.gapManager.needsGapConstruction(stmt, taintedPath, this.manager.getICFG());
    }

    public boolean supportsCallee(SootMethod method) {
        return true;
    }

    public boolean supportsCallee(Stmt callSite) {
        Iterator edgeIt = Scene.v().getCallGraph().edgesOutOf((Unit)callSite);
        return !edgeIt.hasNext();
    }

    public int getWrapperHits() {
        return -1;
    }

    public int getWrapperMisses() {
        return -1;
    }

    public Set<Abstraction> getAliasesForMethod(Stmt stmt, Abstraction d1, Abstraction taintedPath) {
        return null;
    }
}

