/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.generator;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import soot.Local;
import soot.SootMethod;
import soot.ValueBox;
import soot.jimple.DefinitionStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.methodSummary.data.summary.GapDefinition;
import soot.jimple.infoflow.methodSummary.data.summary.MethodSummaries;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;

public class GapManager {
    private final Map<Stmt, GapDefinition> gaps = new HashMap<Stmt, GapDefinition>();
    private int lastGapID = 0;

    public synchronized GapDefinition getOrCreateGapForCall(MethodSummaries flows, Stmt gapCall) {
        GapDefinition gd = this.gaps.get(gapCall);
        if (gd == null) {
            gd = flows.getOrCreateGap(this.lastGapID++, gapCall.getInvokeExpr().getMethod().getSignature());
            this.gaps.put(gapCall, gd);
        }
        return gd;
    }

    public GapDefinition getGapForCall(Stmt gapCall) {
        return this.gaps.get(gapCall);
    }

    public synchronized boolean isLocalReferencedInGap(Local local) {
        for (Stmt stmt : this.gaps.keySet()) {
            for (ValueBox vb : stmt.getUseBoxes()) {
                if (vb.getValue() != local) continue;
                return true;
            }
            if (!(stmt instanceof DefinitionStmt) || ((DefinitionStmt)stmt).getLeftOp() != local) continue;
            return true;
        }
        return false;
    }

    public Set<GapDefinition> getGapDefinitionsForLocalUse(Local local) {
        HashSet<GapDefinition> res = null;
        block0: for (Stmt stmt : this.gaps.keySet()) {
            for (ValueBox vb : stmt.getUseBoxes()) {
                if (vb.getValue() != local) continue;
                if (res == null) {
                    res = new HashSet<GapDefinition>();
                }
                res.add(this.gaps.get(stmt));
                continue block0;
            }
        }
        return res;
    }

    public Set<GapDefinition> getGapDefinitionsForLocalDef(Local local) {
        HashSet<GapDefinition> res = null;
        for (Stmt stmt : this.gaps.keySet()) {
            if (!(stmt instanceof DefinitionStmt) || ((DefinitionStmt)stmt).getLeftOp() != local) continue;
            if (res == null) {
                res = new HashSet<GapDefinition>();
            }
            res.add(this.gaps.get(stmt));
        }
        return res;
    }

    public boolean needsGapConstruction(Stmt stmt, Abstraction abs, IInfoflowCFG icfg) {
        SootMethod targetMethod = stmt.getInvokeExpr().getMethod();
        if (!abs.isAbstractionActive()) {
            return false;
        }
        if (targetMethod.isNative()) {
            return false;
        }
        if (targetMethod.isConstructor() || targetMethod.isStaticInitializer()) {
            return false;
        }
        if (abs.getSourceContext() != null && abs.getSourceContext().getStmt() == stmt) {
            return false;
        }
        if (!this.isValueUsedInStmt(stmt, abs)) {
            return false;
        }
        SootMethod sm = (SootMethod)icfg.getMethodOf((Object)stmt);
        Collection callees = icfg.getCalleesOfCallAt((Object)stmt);
        if (!(callees == null || callees.isEmpty() || callees.size() == 1 && callees.contains(sm) && stmt.getInvokeExpr().getMethod().isAbstract())) {
            return false;
        }
        if (sm.getDeclaringClass().getName().equals("java.lang.System")) {
            return false;
        }
        return !targetMethod.getDeclaringClass().getName().startsWith("sun.");
    }

    private boolean isValueUsedInStmt(Stmt stmt, Abstraction abs) {
        if (!stmt.containsInvokeExpr()) {
            return false;
        }
        InvokeExpr iexpr = stmt.getInvokeExpr();
        for (int i = 0; i < iexpr.getArgCount(); ++i) {
            if (abs.getAccessPath().getPlainValue() != iexpr.getArg(i)) continue;
            return true;
        }
        return iexpr instanceof InstanceInvokeExpr && ((InstanceInvokeExpr)iexpr).getBase() == abs.getAccessPath().getPlainValue();
    }
}

