/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.data.summary;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import soot.jimple.infoflow.methodSummary.data.summary.ClassMethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.ImmutableClassSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.MethodFlow;
import soot.jimple.infoflow.methodSummary.data.summary.MethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.SummaryMetaData;

public class ClassSummaries {
    public static final ClassSummaries EMPTY_SUMMARIES = new ImmutableClassSummaries();
    private final Map<String, ClassMethodSummaries> summaries = new HashMap<String, ClassMethodSummaries>();
    private final Set<String> dependencies = new HashSet<String>();
    private SummaryMetaData metaData = null;

    public ClassMethodSummaries getClassSummaries(String className) {
        return this.summaries.get(className);
    }

    public ClassMethodSummaries getOrCreateClassSummaries(String className) {
        return this.summaries.computeIfAbsent(className, n -> new ClassMethodSummaries(className));
    }

    public MethodSummaries getMethodSummaries(String className) {
        ClassMethodSummaries cms = this.summaries.get(className);
        if (cms == null) {
            return null;
        }
        return cms.getMethodSummaries();
    }

    public Collection<ClassMethodSummaries> getAllSummaries() {
        return this.summaries.values();
    }

    public Collection<MethodSummaries> getAllMethodSummaries() {
        return this.summaries.values().stream().map(v -> v.getMethodSummaries()).collect(Collectors.toSet());
    }

    public Set<MethodFlow> getAllFlowsForMethod(String signature) {
        HashSet<MethodFlow> flows = new HashSet<MethodFlow>();
        for (String className : this.summaries.keySet()) {
            Set<MethodFlow> methodFlows;
            ClassMethodSummaries classSummaries = this.summaries.get(className);
            if (classSummaries == null || (methodFlows = classSummaries.getMethodSummaries().getFlowsForMethod(signature)) == null || methodFlows.isEmpty()) continue;
            flows.addAll(methodFlows);
        }
        return flows;
    }

    public MethodSummaries getAllSummariesForMethod(String signature) {
        MethodSummaries summaries = new MethodSummaries();
        for (String className : this.summaries.keySet()) {
            ClassMethodSummaries classSummaries = this.summaries.get(className);
            if (classSummaries == null) continue;
            summaries.merge(classSummaries.getMethodSummaries().filterForMethod(signature));
        }
        return summaries;
    }

    public Set<MethodFlow> getAllFlows() {
        return this.summaries.values().stream().flatMap(cs -> cs.getMethodSummaries().getAllFlows().stream()).collect(Collectors.toSet());
    }

    public ClassSummaries filterForMethod(String signature) {
        return this.filterForMethod(this.summaries.keySet(), signature);
    }

    public ClassSummaries filterForMethod(Set<String> classes, String signature) {
        ClassSummaries newSummaries = new ClassSummaries();
        for (String className : classes) {
            ClassMethodSummaries methodSummaries = this.summaries.get(className);
            if (methodSummaries == null || methodSummaries.isEmpty()) continue;
            newSummaries.merge(methodSummaries.filterForMethod(signature));
        }
        return newSummaries;
    }

    public void merge(String className, MethodSummaries newSums) {
        if (newSums == null || newSums.isEmpty()) {
            return;
        }
        ClassMethodSummaries methodSummaries = this.summaries.get(className);
        if (methodSummaries == null) {
            this.summaries.put(className, new ClassMethodSummaries(className, newSums));
        } else {
            methodSummaries.merge(newSums);
        }
    }

    public void merge(String className, Set<MethodFlow> newSums) {
        if (newSums == null || newSums.isEmpty()) {
            return;
        }
        ClassMethodSummaries methodSummaries = this.summaries.get(className);
        MethodSummaries ms = new MethodSummaries(newSums);
        if (methodSummaries == null) {
            methodSummaries = new ClassMethodSummaries(className, ms);
            this.summaries.put(className, methodSummaries);
        } else {
            methodSummaries.merge(ms);
        }
    }

    public void merge(ClassSummaries summaries) {
        if (summaries == null || summaries.isEmpty()) {
            return;
        }
        for (String className : summaries.getClasses()) {
            this.merge(summaries.getClassSummaries(className));
        }
        if (this.metaData != null) {
            this.metaData.merge(summaries.metaData);
        } else {
            this.metaData = new SummaryMetaData(summaries.metaData);
        }
    }

    public boolean merge(ClassMethodSummaries summaries) {
        if (summaries == null || summaries.isEmpty()) {
            return false;
        }
        ClassMethodSummaries existingSummaries = this.summaries.get(summaries.getClassName());
        if (existingSummaries == null) {
            this.summaries.put(summaries.getClassName(), summaries);
            return true;
        }
        return existingSummaries.merge(summaries);
    }

    public boolean isEmpty() {
        return this.summaries.isEmpty();
    }

    public Set<String> getClasses() {
        return this.summaries.keySet();
    }

    public boolean hasSummariesForClass(String className) {
        return this.summaries.containsKey(className);
    }

    public boolean addDependency(String className) {
        if (this.isPrimitiveType(className) || this.summaries.containsKey(className)) {
            return false;
        }
        return this.dependencies.add(className);
    }

    private boolean isPrimitiveType(String typeName) {
        return typeName.equals("int") || typeName.equals("long") || typeName.equals("float") || typeName.equals("double") || typeName.equals("char") || typeName.equals("byte") || typeName.equals("short") || typeName.equals("boolean");
    }

    public Set<String> getDependencies() {
        return this.dependencies;
    }

    public SummaryMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(SummaryMetaData metaData) {
        this.metaData = metaData;
    }

    public void clear() {
        if (this.dependencies != null) {
            this.dependencies.clear();
        }
        if (this.summaries != null) {
            this.summaries.clear();
        }
    }

    public void validate() {
        for (String className : this.summaries.keySet()) {
            this.summaries.get(className).validate();
        }
    }

    public String toString() {
        if (this.summaries == null || this.summaries.isEmpty()) {
            return "<no class summaries>";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Summaries for ");
        boolean isFirst = true;
        for (String className : this.summaries.keySet()) {
            if (!isFirst) {
                sb.append(", ");
            }
            sb.append(className);
            isFirst = false;
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dependencies == null ? 0 : this.dependencies.hashCode());
        result = 31 * result + (this.metaData == null ? 0 : this.metaData.hashCode());
        result = 31 * result + (this.summaries == null ? 0 : this.summaries.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassSummaries other = (ClassSummaries)obj;
        if (this.dependencies == null ? other.dependencies != null : !this.dependencies.equals(other.dependencies)) {
            return false;
        }
        if (this.metaData == null ? other.metaData != null : !this.metaData.equals(other.metaData)) {
            return false;
        }
        return !(this.summaries == null ? other.summaries != null : !this.summaries.equals(other.summaries));
    }
}

