/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.data.provider;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.infoflow.methodSummary.data.provider.IMethodSummaryProvider;
import soot.jimple.infoflow.methodSummary.data.summary.ClassMethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.ClassSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.MethodClear;
import soot.jimple.infoflow.methodSummary.data.summary.MethodFlow;
import soot.jimple.infoflow.methodSummary.data.summary.MethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.SummaryMetaData;
import soot.jimple.infoflow.methodSummary.xml.MetaDataReader;
import soot.jimple.infoflow.methodSummary.xml.SummaryReader;
import soot.util.MultiMap;

public class XMLSummaryProvider
implements IMethodSummaryProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String FILE_META_DATA = "SummaryMetaData.xml";
    private final SummaryReader summaryReader;
    private MetaDataReader metaDataReader;
    private ClassSummaries summaries = new ClassSummaries();
    private Set<String> supportedClasses = new HashSet<String>();
    protected Set<String> loadableClasses = new HashSet<String>();
    protected Set<File> files;
    protected Set<Path> pathes;
    private FileSystem fileSystem;
    protected Set<String> subsigMethodsWithSummaries = new HashSet<String>();
    private boolean hasLoadingErrors;

    public XMLSummaryProvider(String folderInJar) throws URISyntaxException, IOException {
        this(folderInJar, XMLSummaryProvider.class);
    }

    public XMLSummaryProvider(File source) {
        this(Collections.singletonList(source));
    }

    public XMLSummaryProvider(List<File> files) {
        this.summaryReader = new SummaryReader();
        this.metaDataReader = new MetaDataReader();
        this.files = new HashSet<File>();
        for (File f : files) {
            if (!f.exists()) {
                throw new RuntimeException("Input file does not exist: " + f);
            }
            if (f.isFile()) {
                this.files.add(f);
                continue;
            }
            if (f.isDirectory()) {
                File[] filesInDir = f.listFiles();
                if (filesInDir == null) {
                    throw new RuntimeException("Could not get files in directory " + f);
                }
                this.files.addAll(Arrays.asList(filesInDir));
                continue;
            }
            throw new RuntimeException("Invalid input file: " + f);
        }
        this.init();
    }

    public XMLSummaryProvider(String folderInJar, Class<?> parentClass) throws URISyntaxException, IOException {
        this.summaryReader = new SummaryReader();
        this.metaDataReader = new MetaDataReader();
        File f = new File(folderInJar);
        if (f.exists()) {
            this.load(f);
            return;
        }
        this.loadSummariesFromJAR(folderInJar, parentClass);
        this.init();
    }

    protected void loadSummariesFromJAR(String folderInJar, Class<?> parentClass) throws URISyntaxException, IOException {
        Path path = this.getPathInJar(folderInJar, parentClass);
        this.fileSystem = path.getFileSystem();
        try (Stream<Path> walk = Files.walk(path, 1, new FileVisitOption[0]);){
            this.pathes = new HashSet<Path>();
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                Path classp = (Path)it.next();
                this.pathes.add(classp);
                String name = this.getFileName(classp);
                if (!name.endsWith(".xml") || name.equals(FILE_META_DATA)) continue;
                this.loadableClasses.add(this.fileToClass(name));
            }
        }
    }

    protected Path getPathInJar(String folderInJar, Class<?> parentClass) throws URISyntaxException, IOException {
        Path path;
        URI uri = null;
        String jarRelativePath = folderInJar.startsWith("/") ? folderInJar : "/" + folderInJar;
        URL resourceURL = parentClass.getResource(jarRelativePath);
        if (resourceURL == null) {
            this.logger.warn(String.format("Could not find folder %s in JAR, trying normal folder on disk...", folderInJar));
            String classLocation = parentClass.getProtectionDomain().getCodeSource().getLocation().getPath();
            File classFile = new File(new URI("file:///" + classLocation));
            if (classFile.getCanonicalPath().endsWith("build" + File.separator + "classes")) {
                classFile = classFile.getParentFile().getParentFile();
            }
            if ((classFile = new File(classFile, folderInJar)).exists()) {
                uri = classFile.toURI();
            }
        } else {
            uri = resourceURL.toURI();
        }
        if (uri == null) {
            throw new RuntimeException(String.format("Could not find summaries in folder %s", folderInJar));
        }
        if (uri.getScheme().equals("jar")) {
            try {
                this.fileSystem = FileSystems.getFileSystem(uri);
            }
            catch (FileSystemNotFoundException e) {
                this.fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
            }
            path = this.fileSystem.getPath(folderInJar, new String[0]);
        } else {
            path = Paths.get(uri);
        }
        return path;
    }

    private String getFileName(Path path) {
        return path.getFileName().toString();
    }

    private void load(File source) {
        if (!source.exists()) {
            throw new RuntimeException("Source directory " + source + " does not exist");
        }
        if (source.isFile()) {
            this.files = Collections.singleton(source);
        } else if (source.isDirectory()) {
            File[] filesInDir = source.listFiles();
            if (filesInDir == null) {
                throw new RuntimeException("Could not get files in directory " + source);
            }
            this.files = new HashSet<File>(Arrays.asList(filesInDir));
        } else {
            throw new RuntimeException("Invalid input file: " + source);
        }
        this.init();
    }

    private void init() {
        if (this.files != null) {
            for (File f : this.files) {
                if (!f.isFile() || !f.getName().endsWith(".xml")) continue;
                this.loadableClasses.add(f.getName().replace(".xml", ""));
            }
        }
        this.loadMetaData();
    }

    protected SummaryReader getSummaryReader() {
        return this.summaryReader;
    }

    @Override
    public boolean supportsClass(String clazz) {
        if (this.supportedClasses.contains(clazz)) {
            return true;
        }
        return this.loadableClasses != null && this.loadableClasses.contains(clazz);
    }

    @Override
    public ClassSummaries getMethodFlows(Set<String> classes, String methodSignature) {
        if (this.loadableClasses != null) {
            for (String className : classes) {
                if (!this.loadableClasses.contains(className)) continue;
                this.loadClass(className);
            }
        }
        return this.summaries.filterForMethod(classes, methodSignature);
    }

    @Override
    public ClassMethodSummaries getMethodFlows(String className, String methodSignature) {
        ClassMethodSummaries classSummaries = this.getClassSummaries(className);
        return classSummaries == null ? null : classSummaries.filterForMethod(methodSignature);
    }

    protected ClassMethodSummaries getClassSummaries(String className) {
        if (this.loadableClasses != null && this.loadableClasses.contains(className)) {
            this.loadClass(className);
        }
        ClassMethodSummaries classSummaries = this.summaries.getClassSummaries(className);
        return classSummaries;
    }

    protected void loadClass(String clazz) {
        if (this.supportedClasses.contains(clazz)) {
            return;
        }
        if (this.files != null && !this.files.isEmpty()) {
            for (File f : this.files) {
                if (!this.fileToClass(f).equals(clazz)) continue;
                try {
                    ClassMethodSummaries classSummaries = new ClassMethodSummaries(clazz);
                    this.summaryReader.read(f, classSummaries);
                    this.addMethodSummaries(classSummaries);
                    break;
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(this.getClass()).error(String.format("An error occurred while loading the summary of %s", clazz), (Throwable)e);
                    this.hasLoadingErrors = true;
                }
            }
        }
        if (this.pathes != null && !this.pathes.isEmpty()) {
            for (Path path : this.pathes) {
                if (!this.fileToClass(this.getFileName(path)).equals(clazz)) continue;
                try (InputStream inputStream = Files.newInputStream(path, StandardOpenOption.READ);){
                    ClassMethodSummaries classSummaries = new ClassMethodSummaries(clazz);
                    this.summaryReader.read(new InputStreamReader(inputStream), classSummaries);
                    this.addMethodSummaries(classSummaries);
                    break;
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(this.getClass()).error(String.format("An error occurred while loading the summary of %s", clazz), (Throwable)e);
                    this.hasLoadingErrors = true;
                }
            }
        }
    }

    protected void addMethodSummaries(ClassMethodSummaries newSummaries) {
        this.addSubsigsForMethod(newSummaries.getMethodSummaries());
        this.summaries.merge(newSummaries);
        if (this.loadableClasses != null && !this.loadableClasses.isEmpty()) {
            this.loadableClasses.remove(newSummaries.getClassName());
        }
        this.supportedClasses.add(newSummaries.getClassName());
    }

    protected void addSubsigsForMethod(MethodSummaries read) {
        MultiMap<String, MethodFlow> flows = read.getFlows();
        MultiMap<String, MethodClear> clears = read.getClears();
        if (flows != null) {
            this.subsigMethodsWithSummaries.addAll(flows.keySet());
        }
        if (clears != null) {
            this.subsigMethodsWithSummaries.addAll(clears.keySet());
        }
    }

    private void loadMetaData() {
        SummaryMetaData metadata = null;
        if (this.files != null) {
            for (File f : this.files) {
                if (!f.getName().equals(FILE_META_DATA)) continue;
                try {
                    metadata = this.metaDataReader.read(f);
                    this.summaries.setMetaData(metadata);
                }
                catch (Exception ex) {
                    LoggerFactory.getLogger(this.getClass()).error("An error occurred while loading the meta data data of %s");
                }
            }
        }
        if (this.pathes != null) {
            for (Path path : this.pathes) {
                if (!this.getFileName(path).equals(FILE_META_DATA)) continue;
                try {
                    InputStream inputStream = path.getFileSystem().provider().newInputStream(path, new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        metadata = this.metaDataReader.read(new InputStreamReader(inputStream));
                        this.summaries.setMetaData(metadata);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(this.getClass()).error("An error occurred while loading the meta data data of %s");
                }
            }
        }
        if (metadata != null) {
            metadata.mergeHierarchyData(this.summaries);
        }
    }

    public boolean hasLoadingErrors() {
        return this.hasLoadingErrors;
    }

    private String fileToClass(File f) {
        return this.fileToClass(f.getName());
    }

    private String fileToClass(String s) {
        String ext;
        int idx = s.lastIndexOf(".");
        if (idx >= 0 && (ext = s.substring(idx)).equals(".xml")) {
            s = s.substring(0, idx);
        }
        return s;
    }

    @Override
    public Set<String> getSupportedClasses() {
        return this.supportedClasses;
    }

    @Override
    public Set<String> getLoadableClasses() {
        return this.loadableClasses;
    }

    @Override
    public ClassSummaries getSummaries() {
        return this.summaries;
    }

    @Override
    public ClassMethodSummaries getClassFlows(String className) {
        if (this.loadableClasses != null && this.loadableClasses.contains(className)) {
            this.loadClass(className);
        }
        return this.summaries.getClassSummaries(className);
    }

    @Override
    public boolean mayHaveSummaryForMethod(String subsig) {
        if (this.loadableClasses != null && !this.loadableClasses.isEmpty()) {
            return true;
        }
        return this.subsigMethodsWithSummaries.contains(subsig);
    }

    @Override
    public boolean isMethodExcluded(String className, String subSignature) {
        ClassMethodSummaries summaries = this.getClassSummaries(className);
        return summaries != null && summaries.getMethodSummaries().isExcluded(subSignature);
    }
}

