/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import soot.jimple.infoflow.methodSummary.data.summary.ClassMethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.ClassSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.MethodSummaries;
import soot.jimple.infoflow.methodSummary.generator.IClassSummaryHandler;
import soot.jimple.infoflow.methodSummary.generator.SummaryGenerator;
import soot.jimple.infoflow.methodSummary.generator.SummaryGeneratorFactory;
import soot.jimple.infoflow.methodSummary.xml.SummaryWriter;

class Main {
    private final Options options = new Options();
    private static final String OPTION_FORCE_OVERWRITE = "fo";
    private static final String OPTION_LOAD_FULL_JAR = "lf";
    private static final String OPTION_EXCLUDE = "e";
    private static final String OPTION_REPEAT = "r";
    private static final String OPTION_FLOW_TIMEOUT = "ft";
    private static final String OPTION_CLASS_TIMEOUT = "ct";
    private static final String OPTION_ANALYZE_HASHCODE_EQUALS = "he";
    private static final String OPTION_ANDROID_PLATFORMS = "p";

    public static void main(String[] args) throws FileNotFoundException, XMLStreamException {
        Main main = new Main();
        main.run(args);
    }

    public Main() {
        this.initializeCommandLineOptions();
    }

    private void initializeCommandLineOptions() {
        this.options.addOption("?", "help", false, "Print this help message");
        this.options.addOption(OPTION_FORCE_OVERWRITE, "forceoverwrite", false, "Silently overwrite summary files in output directory");
        this.options.addOption(OPTION_LOAD_FULL_JAR, "loadfulljar", false, "Summarizes all classes from the given JAR file");
        this.options.addOption(OPTION_EXCLUDE, "exclude", true, "Excludes the given class(es)");
        this.options.addOption(OPTION_REPEAT, "repeat", true, "Repeats the summary generation multiple times. Useful for performance measurements.");
        this.options.addOption(OPTION_FLOW_TIMEOUT, "flowtimeout", true, "Aborts the per-method data flow analysis after the given number of seconds");
        this.options.addOption(OPTION_CLASS_TIMEOUT, "classtimeout", true, "Aborts the summary generation for the current class after the given number of seconds");
        this.options.addOption(OPTION_ANALYZE_HASHCODE_EQUALS, "analyzehashcodeequals", false, "Also analyze hashCode() and equals() methods");
        this.options.addOption(OPTION_ANDROID_PLATFORMS, "platformsdir", true, "Path to the platforms directory from the Android SDK");
    }

    public void run(String[] args) throws FileNotFoundException, XMLStreamException {
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine cmd = parser.parse(this.options, args);
            boolean forceOverwrite = cmd.hasOption(OPTION_FORCE_OVERWRITE);
            boolean loadFullJAR = cmd.hasOption(OPTION_LOAD_FULL_JAR);
            String[] extraArgs = cmd.getArgs();
            if (extraArgs.length < 2 || extraArgs.length < 3 && !loadFullJAR) {
                this.printHelpMessage();
                return;
            }
            Set<String> excludes = this.parseExcludes(cmd);
            SummaryGenerator generator = new SummaryGeneratorFactory().initSummaryGenerator();
            File toAnalyze = new File(extraArgs[0]);
            File outputFolder = new File(extraArgs[1]);
            ArrayList<String> classesToAnalyze = new ArrayList<String>();
            if (!loadFullJAR) {
                for (int i = 2; i < extraArgs.length; ++i) {
                    if (extraArgs[i].startsWith("-")) {
                        this.printHelpMessage();
                        return;
                    }
                    classesToAnalyze.add(extraArgs[i]);
                }
                if (classesToAnalyze.isEmpty()) {
                    this.printHelpMessage();
                    return;
                }
            }
            generator.getConfig().setLoadFullJAR(loadFullJAR);
            generator.getConfig().setExcludes(excludes);
            this.configureOptionalSettings(cmd, generator);
            if (!toAnalyze.exists()) {
                System.err.println("File not found: " + toAnalyze);
                System.exit(1);
                return;
            }
            generator.getConfig().addAdditionalSummaryDirectory(outputFolder.getAbsolutePath());
            if (toAnalyze.isDirectory()) {
                File[] files = toAnalyze.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.toLowerCase().endsWith(".jar");
                    }
                });
                for (int c = 0; c < files.length; ++c) {
                    File f = files[c];
                    System.out.println(String.format("Jar %d of %d: %s", c + 1, files.length, f));
                    Main.createSummaries(generator, classesToAnalyze, forceOverwrite, f, outputFolder);
                }
                if (files.length == 0) {
                    System.out.println(String.format("Analyzing directory %s...", toAnalyze.getAbsolutePath()));
                    Main.createSummaries(generator, classesToAnalyze, forceOverwrite, toAnalyze, outputFolder);
                }
            } else {
                Main.createSummaries(generator, classesToAnalyze, forceOverwrite, toAnalyze, outputFolder);
            }
            System.out.println("Done.");
        }
        catch (ParseException e) {
            this.printHelpMessage();
            return;
        }
    }

    protected void configureOptionalSettings(CommandLine cmd, SummaryGenerator generator) {
        boolean analyzeHashCodeEquals;
        long classTimeout;
        long flowTimeout;
        int repeatCount = Integer.parseInt(cmd.getOptionValue(OPTION_REPEAT, "-1"));
        if (repeatCount > 0) {
            generator.getConfig().setRepeatCount(repeatCount);
        }
        if ((flowTimeout = Long.parseLong(cmd.getOptionValue(OPTION_FLOW_TIMEOUT, "-1"))) > 0L) {
            generator.getConfig().setDataFlowTimeout(flowTimeout);
        }
        if ((classTimeout = Long.parseLong(cmd.getOptionValue(OPTION_CLASS_TIMEOUT, "-1"))) > 0L) {
            generator.getConfig().setClassSummaryTimeout(classTimeout);
        }
        if (analyzeHashCodeEquals = cmd.hasOption(OPTION_ANALYZE_HASHCODE_EQUALS)) {
            generator.getConfig().setSummarizeHashCodeEquals(analyzeHashCodeEquals);
        }
        String platformsDir = cmd.getOptionValue(OPTION_ANDROID_PLATFORMS);
        generator.getConfig().setAndroidPlatformDir(platformsDir);
    }

    private Set<String> parseExcludes(CommandLine cmd) {
        String[] excludes = cmd.getOptionValues(OPTION_EXCLUDE);
        if (excludes == null || excludes.length == 0) {
            return Collections.emptySet();
        }
        HashSet<String> excludeSet = new HashSet<String>(excludes.length);
        for (String exclude : excludes) {
            excludeSet.add(exclude);
        }
        return excludeSet;
    }

    private void printHelpMessage() {
        System.out.println("FlowDroid Summary Generator (c) Secure Software Engineering Group");
        System.out.println();
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("soot-infoflow-cmd <JAR File> <Output Directory> <Classes...> [OPTIONS]", this.options);
    }

    private static void createSummaries(SummaryGenerator generator, List<String> classesToAnalyze, final boolean doForceOverwrite, File toAnalyze, final File outputFolder) {
        ClassSummaries summaries = generator.createMethodSummaries(toAnalyze.getPath(), classesToAnalyze, new IClassSummaryHandler(){

            @Override
            public boolean onBeforeAnalyzeClass(String className) {
                if (doForceOverwrite) {
                    return true;
                }
                String summaryFile = className + ".xml";
                return !new File(outputFolder, summaryFile).exists();
            }

            @Override
            public void onMethodFinished(String methodSignature, MethodSummaries summaries) {
                System.out.println("Method " + methodSignature + " done.");
            }

            @Override
            public void onClassFinished(ClassMethodSummaries summaries) {
                String className = summaries.getClassName();
                String summaryFile = className + ".xml";
                Main.write(summaries, summaryFile, outputFolder.getPath());
                System.out.println("Class " + className + " done.");
            }
        });
        if (summaries != null && !summaries.getDependencies().isEmpty()) {
            System.out.println("Dependencies:");
            for (String className : summaries.getDependencies()) {
                System.out.println("\t" + className);
            }
        }
    }

    private static void write(ClassMethodSummaries flows, String fileName, String folder) {
        File f = new File(folder);
        if (!f.exists()) {
            f.mkdir();
        }
        SummaryWriter writer = new SummaryWriter();
        try {
            writer.write(new File(f, fileName), flows);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

