/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.util;

import soot.RefType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.jimple.infoflow.data.AccessPath;

public class SystemClassHandler {
    private static SystemClassHandler instance;
    private boolean excludeSystemComponents = true;

    public static SystemClassHandler v() {
        if (instance == null) {
            instance = new SystemClassHandler();
        }
        return instance;
    }

    public static void setInstance(SystemClassHandler instance) {
        SystemClassHandler.instance = instance;
    }

    public boolean isClassInSystemPackage(SootClass clazz) {
        return clazz != null && this.isClassInSystemPackage(clazz.getName());
    }

    public boolean isClassInSystemPackage(String className) {
        return (className.startsWith("android.") || className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("sun.") || className.startsWith("org.omg.") || className.startsWith("org.w3c.dom.") || className.startsWith("com.google.") || className.startsWith("com.android.")) && this.excludeSystemComponents;
    }

    public boolean isClassInSystemPackage(Type type) {
        if (type instanceof RefType) {
            return this.isClassInSystemPackage(((RefType)type).getSootClass().getName());
        }
        return false;
    }

    public boolean isTaintVisible(AccessPath taintedPath, SootMethod method) {
        if (taintedPath == null) {
            return true;
        }
        if (!taintedPath.isInstanceFieldRef()) {
            return true;
        }
        if (!this.isClassInSystemPackage(method.getDeclaringClass().getName())) {
            return true;
        }
        boolean hasSystemType = taintedPath.getBaseType() != null && this.isClassInSystemPackage(taintedPath.getBaseType());
        for (SootField fld : taintedPath.getFields()) {
            boolean curFieldIsSystem = this.isClassInSystemPackage(fld.getType());
            if (this.isClassInSystemPackage((Type)fld.getDeclaringClass().getType())) {
                curFieldIsSystem = true;
            }
            if (curFieldIsSystem) {
                hasSystemType = true;
                continue;
            }
            if (!hasSystemType) continue;
            return false;
        }
        return true;
    }

    public void setExcludeSystemComponents(boolean excludeSystemComponents) {
        this.excludeSystemComponents = excludeSystemComponents;
    }
}

