/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public class SootMethodRepresentationParser {
    private static final SootMethodRepresentationParser instance = new SootMethodRepresentationParser();
    private Pattern patternSubsigToName = null;
    private Pattern patternMethodSig = null;

    private SootMethodRepresentationParser() {
    }

    public static SootMethodRepresentationParser v() {
        return instance;
    }

    public SootMethodAndClass parseSootMethodString(String parseString) {
        Matcher matcher;
        if (parseString == null || parseString.isEmpty()) {
            return null;
        }
        if (!parseString.startsWith("<") || !parseString.endsWith(">")) {
            throw new IllegalArgumentException("Illegal format of " + parseString + " (should use soot method representation)");
        }
        if (this.patternMethodSig == null) {
            this.patternMethodSig = Pattern.compile("<(?<className>.*?): (?<returnType>.*?) (?<methodName>.*?)\\((?<parameters>.*?)\\)>");
        }
        if ((matcher = this.patternMethodSig.matcher(parseString)).find()) {
            String className = matcher.group("className");
            String returnType = matcher.group("returnType");
            String methodName = matcher.group("methodName");
            String paramList = matcher.group("parameters");
            return new SootMethodAndClass(methodName, className, returnType, paramList);
        }
        return null;
    }

    public HashMap<String, Set<String>> parseClassNames(Collection<String> methods, boolean subSignature) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        Pattern pattern = Pattern.compile("^\\s*<(.*?):\\s*(.*?)>\\s*$");
        for (String parseString : methods) {
            String className = "";
            Matcher matcher = pattern.matcher(parseString);
            if (!matcher.find()) continue;
            className = matcher.group(1);
            String params = "";
            params = subSignature ? matcher.group(2) : parseString;
            if (result.containsKey(className)) {
                result.get(className).add(params);
                continue;
            }
            HashSet<String> methodList = new HashSet<String>();
            methodList.add(params);
            result.put(className, methodList);
        }
        return result;
    }

    public MultiMap<String, String> parseClassNames2(Collection<String> methods, boolean subSignature) {
        HashMultiMap result = new HashMultiMap();
        Pattern pattern = Pattern.compile("^\\s*<(.*?):\\s*(.*?)>\\s*$");
        for (String parseString : methods) {
            String className = "";
            Matcher matcher = pattern.matcher(parseString);
            if (!matcher.find()) continue;
            className = matcher.group(1);
            String params = "";
            params = subSignature ? matcher.group(2) : parseString;
            result.put((Object)className, (Object)params);
        }
        return result;
    }

    public String getMethodNameFromSubSignature(String subSignature) {
        Matcher matcher;
        if (this.patternSubsigToName == null) {
            Pattern pattern;
            this.patternSubsigToName = pattern = Pattern.compile("^\\s*(.+)\\s+(.+)\\((.*?)\\)\\s*$");
        }
        if (!(matcher = this.patternSubsigToName.matcher(subSignature)).find()) {
            Pattern pattern;
            this.patternSubsigToName = pattern = Pattern.compile("^\\s*(.+)\\((.*?)\\)\\s*$");
            return this.getMethodNameFromSubSignature(subSignature);
        }
        String method = matcher.group(matcher.groupCount() - 1);
        return method;
    }

    public String[] getParameterTypesFromSubSignature(String subSignature) {
        Matcher matcher;
        if (this.patternSubsigToName == null) {
            Pattern pattern;
            this.patternSubsigToName = pattern = Pattern.compile("^\\s*(.+)\\s+(.+)\\((.*?)\\)\\s*$");
        }
        if (!(matcher = this.patternSubsigToName.matcher(subSignature)).find()) {
            Pattern pattern;
            this.patternSubsigToName = pattern = Pattern.compile("^\\s*(.+)\\((.*?)\\)\\s*$");
            return this.getParameterTypesFromSubSignature(subSignature);
        }
        String params = matcher.group(matcher.groupCount());
        if (params.equals("")) {
            return null;
        }
        return params.split("\\s*,\\s*");
    }
}

