/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.sourcesSinks.manager;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import heros.solver.IDESolver;
import heros.solver.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.VoidType;
import soot.jimple.AssignStmt;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.callbacks.CallbackDefinition;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.sourcesSinks.definitions.AccessPathTuple;
import soot.jimple.infoflow.sourcesSinks.definitions.FieldSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.MethodSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.StatementSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.manager.IOneSourceAtATimeManager;
import soot.jimple.infoflow.sourcesSinks.manager.ISourceSinkManager;
import soot.jimple.infoflow.sourcesSinks.manager.SinkInfo;
import soot.jimple.infoflow.sourcesSinks.manager.SourceInfo;
import soot.jimple.infoflow.util.SystemClassHandler;
import soot.jimple.infoflow.values.IValueProvider;
import soot.jimple.infoflow.values.SimpleConstantValueProvider;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public abstract class BaseSourceSinkManager
implements ISourceSinkManager,
IOneSourceAtATimeManager {
    private static final String GLOBAL_SIG = "--GLOBAL--";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected MultiMap<String, ISourceSinkDefinition> sourceDefs;
    protected MultiMap<String, ISourceSinkDefinition> sinkDefs;
    protected Map<SootMethod, ISourceSinkDefinition> sourceMethods;
    protected Map<Stmt, ISourceSinkDefinition> sourceStatements;
    protected Map<SootMethod, ISourceSinkDefinition> sinkMethods;
    protected Map<SootMethod, ISourceSinkDefinition> sinkReturnMethods;
    protected Map<SootMethod, CallbackDefinition> callbackMethods;
    protected Map<SootField, ISourceSinkDefinition> sourceFields;
    protected Map<SootField, ISourceSinkDefinition> sinkFields;
    protected Map<Stmt, ISourceSinkDefinition> sinkStatements;
    protected final InfoflowConfiguration.SourceSinkConfiguration sourceSinkConfig;
    protected final Set<SootMethod> excludedMethods = new HashSet<SootMethod>();
    protected boolean oneSourceAtATime = false;
    protected SourceType osaatType = SourceType.MethodCall;
    protected Iterator<SootMethod> osaatIterator = null;
    protected SootMethod currentSource = null;
    protected IValueProvider valueProvider = new SimpleConstantValueProvider();
    protected final LoadingCache<SootClass, Collection<SootClass>> interfacesOf = IDESolver.DEFAULT_CACHE_BUILDER.build((CacheLoader)new CacheLoader<SootClass, Collection<SootClass>>(){

        public Collection<SootClass> load(SootClass sc) throws Exception {
            HashSet<SootClass> set = new HashSet<SootClass>(sc.getInterfaceCount());
            for (SootClass i : sc.getInterfaces()) {
                set.add(i);
                set.addAll((Collection)BaseSourceSinkManager.this.interfacesOf.getUnchecked((Object)i));
            }
            if (sc.hasSuperclass()) {
                set.addAll((Collection)BaseSourceSinkManager.this.interfacesOf.getUnchecked((Object)sc.getSuperclass()));
            }
            return set;
        }
    });

    public BaseSourceSinkManager(Set<? extends ISourceSinkDefinition> sources, Set<? extends ISourceSinkDefinition> sinks, InfoflowConfiguration config) {
        this(sources, sinks, Collections.emptySet(), config);
    }

    public BaseSourceSinkManager(Set<? extends ISourceSinkDefinition> sources, Set<? extends ISourceSinkDefinition> sinks, Set<? extends CallbackDefinition> callbackMethods, InfoflowConfiguration config) {
        this.sourceSinkConfig = config.getSourceSinkConfig();
        this.sourceDefs = new HashMultiMap();
        for (ISourceSinkDefinition iSourceSinkDefinition : sources) {
            this.sourceDefs.put((Object)this.getSignature(iSourceSinkDefinition), (Object)iSourceSinkDefinition);
        }
        this.sinkDefs = new HashMultiMap();
        for (ISourceSinkDefinition iSourceSinkDefinition : sinks) {
            this.sinkDefs.put((Object)this.getSignature(iSourceSinkDefinition), (Object)iSourceSinkDefinition);
        }
        this.callbackMethods = new HashMap<SootMethod, CallbackDefinition>();
        for (CallbackDefinition callbackDefinition : callbackMethods) {
            this.callbackMethods.put(callbackDefinition.getTargetMethod(), callbackDefinition);
        }
        this.logger.info(String.format("Created a SourceSinkManager with %d sources, %d sinks, and %d callback methods.", this.sourceDefs.size(), this.sinkDefs.size(), this.callbackMethods.size()));
    }

    private String getSignature(ISourceSinkDefinition am) {
        if (am instanceof MethodSourceSinkDefinition) {
            MethodSourceSinkDefinition methodSource = (MethodSourceSinkDefinition)am;
            return methodSource.getMethod().getSignature();
        }
        if (am instanceof FieldSourceSinkDefinition) {
            FieldSourceSinkDefinition fieldSource = (FieldSourceSinkDefinition)am;
            return fieldSource.getFieldSignature();
        }
        if (am instanceof StatementSourceSinkDefinition) {
            return GLOBAL_SIG;
        }
        throw new RuntimeException(String.format("Invalid type of source/sink definition: %s", am.getClass().getName()));
    }

    protected ISourceSinkDefinition getSinkDefinition(Stmt sCallSite, InfoflowManager manager, AccessPath ap) {
        ISourceSinkDefinition def = this.sinkStatements.get(sCallSite);
        if (def != null) {
            return def;
        }
        if (sCallSite.containsInvokeExpr()) {
            ISourceSinkDefinition def2;
            ISourceSinkDefinition def3;
            SootMethod callee = sCallSite.getInvokeExpr().getMethod();
            if (!SystemClassHandler.v().isTaintVisible(ap, callee)) {
                return null;
            }
            ISourceSinkDefinition def4 = this.sinkMethods.get(sCallSite.getInvokeExpr().getMethod());
            if (def4 != null) {
                return def4;
            }
            String subSig = callee.getSubSignature();
            for (SootClass i : (Collection)this.interfacesOf.getUnchecked((Object)sCallSite.getInvokeExpr().getMethod().getDeclaringClass())) {
                if (!i.declaresMethod(subSig) || (def3 = this.sinkMethods.get(i.getMethod(subSig))) == null) continue;
                return def3;
            }
            for (SootMethod sm : manager.getICFG().getCalleesOfCallAt(sCallSite)) {
                def3 = this.sinkMethods.get(sm);
                if (def3 == null) continue;
                return def3;
            }
            if (callee.getDeclaringClass().isPhantom() && (def2 = BaseSourceSinkManager.findDefinitionInHierarchy(callee, this.sinkMethods)) != null) {
                return def2;
            }
            return null;
        }
        if (sCallSite instanceof AssignStmt) {
            FieldRef fieldRef;
            ISourceSinkDefinition def5;
            AssignStmt assignStmt = (AssignStmt)sCallSite;
            if (assignStmt.getLeftOp() instanceof FieldRef && (def5 = this.sinkFields.get((fieldRef = (FieldRef)assignStmt.getLeftOp()).getField())) != null) {
                return def5;
            }
        } else if (sCallSite instanceof ReturnStmt) {
            return this.sinkReturnMethods.get(manager.getICFG().getMethodOf(sCallSite));
        }
        return null;
    }

    private static ISourceSinkDefinition findDefinitionInHierarchy(SootMethod callee, Map<SootMethod, ISourceSinkDefinition> map) {
        String subSig = callee.getSubSignature();
        SootClass curClass = callee.getDeclaringClass();
        while (curClass != null) {
            ISourceSinkDefinition def;
            SootMethod curMethod = curClass.getMethodUnsafe(subSig);
            if (curMethod != null && (def = map.get(curMethod)) != null) {
                map.put(callee, def);
                return def;
            }
            if (curClass.hasSuperclass() && curClass.isPhantom()) {
                curClass = curClass.getSuperclass();
                continue;
            }
            curClass = null;
        }
        return null;
    }

    @Override
    public SinkInfo getSinkInfo(Stmt sCallSite, InfoflowManager manager, AccessPath ap) {
        ISourceSinkDefinition def = this.getSinkDefinition(sCallSite, manager, ap);
        return def == null ? null : new SinkInfo(def);
    }

    @Override
    public SourceInfo getSourceInfo(Stmt sCallSite, InfoflowManager manager) {
        if (this.excludedMethods.contains(manager.getICFG().getMethodOf(sCallSite))) {
            return null;
        }
        ISourceSinkDefinition def = this.getSource(sCallSite, manager.getICFG());
        return this.createSourceInfo(sCallSite, manager, def);
    }

    protected SourceInfo createSourceInfo(Stmt sCallSite, InfoflowManager manager, ISourceSinkDefinition def) {
        if (def == null) {
            return null;
        }
        if (!sCallSite.containsInvokeExpr()) {
            if (sCallSite instanceof DefinitionStmt) {
                DefinitionStmt defStmt = (DefinitionStmt)sCallSite;
                return new SourceInfo(def, manager.getAccessPathFactory().createAccessPath(defStmt.getLeftOp(), null, null, null, true, false, true, AccessPath.ArrayTaintType.ContentsAndLength, false));
            }
            return null;
        }
        InvokeExpr iexpr = sCallSite.getInvokeExpr();
        if (sCallSite instanceof DefinitionStmt && iexpr.getMethod().getReturnType() != null) {
            DefinitionStmt defStmt = (DefinitionStmt)sCallSite;
            return new SourceInfo(def, manager.getAccessPathFactory().createAccessPath(defStmt.getLeftOp(), null, null, null, true, false, true, AccessPath.ArrayTaintType.ContentsAndLength, false));
        }
        if (iexpr instanceof InstanceInvokeExpr && iexpr.getMethod().getReturnType() == VoidType.v()) {
            InstanceInvokeExpr iinv = (InstanceInvokeExpr)sCallSite.getInvokeExpr();
            return new SourceInfo(def, manager.getAccessPathFactory().createAccessPath(iinv.getBase(), true));
        }
        return null;
    }

    protected ISourceSinkDefinition getSourceMethod(SootMethod method) {
        if (this.oneSourceAtATime && (this.osaatType != SourceType.MethodCall || this.currentSource != method)) {
            return null;
        }
        return this.sourceMethods.get(method);
    }

    protected ISourceSinkDefinition getSourceDefinition(SootMethod method) {
        if (this.oneSourceAtATime) {
            if (this.osaatType == SourceType.MethodCall && this.currentSource == method) {
                return this.sourceMethods.get(method);
            }
            return null;
        }
        return this.sourceMethods.get(method);
    }

    protected CallbackDefinition getCallbackDefinition(SootMethod method) {
        if (this.oneSourceAtATime) {
            if (this.osaatType == SourceType.Callback && this.currentSource == method) {
                return this.callbackMethods.get(method);
            }
            return null;
        }
        return this.callbackMethods.get(method);
    }

    protected ISourceSinkDefinition getSource(Stmt sCallSite, IInfoflowCFG cfg) {
        assert (cfg != null);
        assert (cfg instanceof BiDiInterproceduralCFG);
        ISourceSinkDefinition def = this.sourceStatements.get(sCallSite);
        if (def != null) {
            return def;
        }
        def = null;
        if ((!this.oneSourceAtATime || this.osaatType == SourceType.MethodCall) && sCallSite.containsInvokeExpr()) {
            SootMethod callee = sCallSite.getInvokeExpr().getMethod();
            def = this.getSourceDefinition(callee);
            if (def != null) {
                return def;
            }
            String subSig = callee.getSubSignature();
            for (SootClass i : (Collection)this.interfacesOf.getUnchecked((Object)callee.getDeclaringClass())) {
                SootMethod m = i.getMethodUnsafe(subSig);
                if (m == null || (def = this.getSourceDefinition(m)) == null) continue;
                return def;
            }
            for (SootMethod sm : cfg.getCalleesOfCallAt(sCallSite)) {
                def = this.getSourceDefinition(sm);
                if (def == null) continue;
                return def;
            }
            if (callee.getDeclaringClass().isPhantom() && (def = BaseSourceSinkManager.findDefinitionInHierarchy(callee, this.sourceMethods)) != null) {
                return def;
            }
        }
        if (!(this.oneSourceAtATime && this.osaatType != SourceType.UISource || (def = this.getUISourceDefinition(sCallSite, cfg)) == null)) {
            return def;
        }
        def = this.checkCallbackParamSource(sCallSite, cfg);
        if (def != null) {
            return def;
        }
        def = this.checkFieldSource(sCallSite, cfg);
        if (def != null) {
            return def;
        }
        return null;
    }

    private ISourceSinkDefinition checkFieldSource(Stmt stmt, IInfoflowCFG cfg) {
        AssignStmt assignStmt;
        if (stmt instanceof AssignStmt && (assignStmt = (AssignStmt)stmt).getRightOp() instanceof FieldRef) {
            FieldRef fieldRef = (FieldRef)assignStmt.getRightOp();
            return this.sourceFields.get(fieldRef.getField());
        }
        return null;
    }

    protected ISourceSinkDefinition checkCallbackParamSource(Stmt sCallSite, IInfoflowCFG cfg) {
        if (this.sourceSinkConfig.getCallbackSourceMode() == InfoflowConfiguration.CallbackSourceMode.NoParametersAsSources) {
            return null;
        }
        if (this.oneSourceAtATime && this.osaatType != SourceType.Callback) {
            return null;
        }
        if (!(sCallSite instanceof IdentityStmt)) {
            return null;
        }
        IdentityStmt is = (IdentityStmt)sCallSite;
        if (!(is.getRightOp() instanceof ParameterRef)) {
            return null;
        }
        ParameterRef paramRef = (ParameterRef)is.getRightOp();
        SootMethod parentMethod = (SootMethod)cfg.getMethodOf(sCallSite);
        if (parentMethod == null) {
            return null;
        }
        if (!this.sourceSinkConfig.getEnableLifecycleSources() && this.isEntryPointMethod(parentMethod)) {
            return null;
        }
        CallbackDefinition def = this.getCallbackDefinition(parentMethod);
        if (def == null) {
            return null;
        }
        if (this.sourceSinkConfig.getCallbackSourceMode() == InfoflowConfiguration.CallbackSourceMode.AllParametersAsSources) {
            return MethodSourceSinkDefinition.createParameterSource(paramRef.getIndex(), MethodSourceSinkDefinition.CallType.Callback);
        }
        ISourceSinkDefinition sourceSinkDef = this.sourceMethods.get(def.getParentMethod());
        if (sourceSinkDef instanceof MethodSourceSinkDefinition) {
            Set<AccessPathTuple> apTuples;
            Set<AccessPathTuple>[] methodParamDefs;
            MethodSourceSinkDefinition methodDef = (MethodSourceSinkDefinition)sourceSinkDef;
            if (this.sourceSinkConfig.getCallbackSourceMode() == InfoflowConfiguration.CallbackSourceMode.SourceListOnly && sourceSinkDef != null && (methodParamDefs = methodDef.getParameters()) != null && methodParamDefs.length > paramRef.getIndex() && (apTuples = methodDef.getParameters()[paramRef.getIndex()]) != null && !apTuples.isEmpty()) {
                for (AccessPathTuple curTuple : apTuples) {
                    if (!curTuple.getSourceSinkType().isSource()) continue;
                    return sourceSinkDef;
                }
            }
        }
        return null;
    }

    protected abstract boolean isEntryPointMethod(SootMethod var1);

    protected ISourceSinkDefinition getUISourceDefinition(Stmt sCallSite, IInfoflowCFG cfg) {
        return null;
    }

    @Override
    public void initialize() {
        StatementSourceSinkDefinition sssd;
        SootField sf;
        ISourceSinkDefinition sourceSinkDef;
        if (this.sourceDefs != null) {
            this.sourceMethods = new HashMap<SootMethod, ISourceSinkDefinition>();
            this.sourceFields = new HashMap<SootField, ISourceSinkDefinition>();
            this.sourceStatements = new HashMap<Stmt, ISourceSinkDefinition>();
            for (Pair entry : this.sourceDefs) {
                sourceSinkDef = (ISourceSinkDefinition)entry.getO2();
                if (sourceSinkDef instanceof MethodSourceSinkDefinition) {
                    SootMethodAndClass method = ((MethodSourceSinkDefinition)sourceSinkDef).getMethod();
                    String returnType = method.getReturnType();
                    if (returnType == null || returnType.isEmpty()) {
                        String subSignatureWithoutReturnType;
                        String className = method.getClassName();
                        SootMethod sootMethod = this.grabMethodWithoutReturn(className, subSignatureWithoutReturnType = ((MethodSourceSinkDefinition)sourceSinkDef).getMethod().getSubSignature());
                        if (sootMethod == null) continue;
                        this.sourceMethods.put(sootMethod, sourceSinkDef);
                        continue;
                    }
                    SootMethod sm = Scene.v().grabMethod((String)entry.getO1());
                    if (sm == null) continue;
                    this.sourceMethods.put(sm, sourceSinkDef);
                    continue;
                }
                if (sourceSinkDef instanceof FieldSourceSinkDefinition) {
                    sf = Scene.v().grabField((String)entry.getO1());
                    if (sf == null) continue;
                    this.sourceFields.put(sf, sourceSinkDef);
                    continue;
                }
                if (!(sourceSinkDef instanceof StatementSourceSinkDefinition)) continue;
                sssd = (StatementSourceSinkDefinition)sourceSinkDef;
                this.sourceStatements.put(sssd.getStmt(), sssd);
            }
            this.sourceDefs = null;
        }
        if (this.sinkDefs != null) {
            this.sinkMethods = new HashMap<SootMethod, ISourceSinkDefinition>();
            this.sinkFields = new HashMap<SootField, ISourceSinkDefinition>();
            this.sinkReturnMethods = new HashMap<SootMethod, ISourceSinkDefinition>();
            this.sinkStatements = new HashMap<Stmt, ISourceSinkDefinition>();
            for (Pair entry : this.sinkDefs) {
                sourceSinkDef = (ISourceSinkDefinition)entry.getO2();
                if (sourceSinkDef instanceof MethodSourceSinkDefinition) {
                    boolean isMethodWithoutReturnType;
                    SootMethodAndClass method;
                    MethodSourceSinkDefinition methodSourceSinkDef = (MethodSourceSinkDefinition)sourceSinkDef;
                    if (methodSourceSinkDef.getCallType() == MethodSourceSinkDefinition.CallType.Return) {
                        method = methodSourceSinkDef.getMethod();
                        SootMethod m = Scene.v().grabMethod(method.getSignature());
                        if (m == null) continue;
                        this.sinkReturnMethods.put(m, methodSourceSinkDef);
                        continue;
                    }
                    method = methodSourceSinkDef.getMethod();
                    String returnType = method.getReturnType();
                    boolean bl = isMethodWithoutReturnType = returnType == null || returnType.isEmpty();
                    if (isMethodWithoutReturnType) {
                        String subSignatureWithoutReturnType;
                        String className = method.getClassName();
                        SootMethod sootMethod = this.grabMethodWithoutReturn(className, subSignatureWithoutReturnType = ((MethodSourceSinkDefinition)sourceSinkDef).getMethod().getSubSignature());
                        if (sootMethod == null) continue;
                        this.sinkMethods.put(sootMethod, sourceSinkDef);
                        continue;
                    }
                    SootMethod sm = Scene.v().grabMethod((String)entry.getO1());
                    if (sm == null) continue;
                    this.sinkMethods.put(sm, (ISourceSinkDefinition)entry.getO2());
                    continue;
                }
                if (sourceSinkDef instanceof FieldSourceSinkDefinition) {
                    sf = Scene.v().grabField((String)entry.getO1());
                    if (sf == null) continue;
                    this.sinkFields.put(sf, sourceSinkDef);
                    continue;
                }
                if (!(sourceSinkDef instanceof StatementSourceSinkDefinition)) continue;
                sssd = (StatementSourceSinkDefinition)sourceSinkDef;
                this.sinkStatements.put(sssd.getStmt(), sssd);
            }
            this.sinkDefs = null;
        }
    }

    private SootMethod grabMethodWithoutReturn(String sootClassName, String subSignature) {
        SootClass sootClass = Scene.v().getSootClassUnsafe(sootClassName);
        if (sootClass == null) {
            return null;
        }
        List sootMethods = null;
        if (sootClass.resolvingLevel() != 0) {
            sootMethods = sootClass.getMethods();
            for (SootMethod s : sootMethods) {
                String[] tempSignature = s.getSubSignature().split(" ");
                if (tempSignature.length != 2 || !tempSignature[1].equals(subSignature)) continue;
                return s;
            }
        }
        return null;
    }

    @Override
    public void setOneSourceAtATimeEnabled(boolean enabled) {
        this.oneSourceAtATime = enabled;
    }

    @Override
    public boolean isOneSourceAtATimeEnabled() {
        return this.oneSourceAtATime;
    }

    @Override
    public void resetCurrentSource() {
        this.osaatIterator = this.sourceMethods.keySet().iterator();
        this.osaatType = SourceType.MethodCall;
    }

    @Override
    public void nextSource() {
        if (this.osaatType == SourceType.MethodCall || this.osaatType == SourceType.Callback) {
            this.currentSource = this.osaatIterator.next();
        }
    }

    @Override
    public boolean hasNextSource() {
        if (this.osaatType == SourceType.MethodCall) {
            if (this.osaatIterator.hasNext()) {
                return true;
            }
            this.osaatType = SourceType.Callback;
            this.osaatIterator = this.callbackMethods.keySet().iterator();
            return this.hasNextSource();
        }
        if (this.osaatType == SourceType.Callback) {
            if (this.osaatIterator.hasNext()) {
                return true;
            }
            this.osaatType = SourceType.UISource;
            return true;
        }
        if (this.osaatType == SourceType.UISource) {
            this.osaatType = SourceType.NoSource;
            return false;
        }
        return false;
    }

    public void excludeMethod(SootMethod toExclude) {
        this.excludedMethods.add(toExclude);
    }

    public static enum SourceType {
        NoSource,
        MethodCall,
        Callback,
        UISource;

    }
}

