/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.sourcesSinks.definitions;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import soot.Local;
import soot.jimple.Stmt;
import soot.jimple.infoflow.sourcesSinks.definitions.AbstractSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.AccessPathTuple;
import soot.jimple.infoflow.sourcesSinks.definitions.IAccessPathBasedSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.SourceSinkType;

public class StatementSourceSinkDefinition
extends AbstractSourceSinkDefinition
implements IAccessPathBasedSourceSinkDefinition {
    private final Stmt stmt;
    private final Local local;
    private Set<AccessPathTuple> accessPaths;

    public StatementSourceSinkDefinition(Stmt stmt, Local local, Set<AccessPathTuple> accessPaths) {
        this.stmt = stmt;
        this.local = local;
        this.accessPaths = accessPaths;
    }

    @Override
    public StatementSourceSinkDefinition getSourceOnlyDefinition() {
        HashSet<AccessPathTuple> newSet = null;
        if (this.accessPaths != null) {
            newSet = new HashSet<AccessPathTuple>(this.accessPaths.size());
            for (AccessPathTuple apt : this.accessPaths) {
                SourceSinkType ssType = apt.getSourceSinkType();
                if (ssType == SourceSinkType.Source) {
                    newSet.add(apt);
                    continue;
                }
                if (ssType != SourceSinkType.Both) continue;
                newSet.add(new AccessPathTuple(apt.getBaseType(), apt.getFields(), apt.getFieldTypes(), SourceSinkType.Source));
            }
        }
        return this.buildNewDefinition(this.stmt, this.local, newSet);
    }

    @Override
    public StatementSourceSinkDefinition getSinkOnlyDefinition() {
        HashSet<AccessPathTuple> newSet = null;
        if (this.accessPaths != null) {
            newSet = new HashSet<AccessPathTuple>(this.accessPaths.size());
            for (AccessPathTuple apt : this.accessPaths) {
                SourceSinkType ssType = apt.getSourceSinkType();
                if (ssType == SourceSinkType.Sink) {
                    newSet.add(apt);
                    continue;
                }
                if (ssType != SourceSinkType.Both) continue;
                newSet.add(new AccessPathTuple(apt.getBaseType(), apt.getFields(), apt.getFieldTypes(), SourceSinkType.Sink));
            }
        }
        return this.buildNewDefinition(this.stmt, this.local, newSet);
    }

    public Stmt getStmt() {
        return this.stmt;
    }

    public Local getLocal() {
        return this.local;
    }

    public Set<AccessPathTuple> getAccessPaths() {
        return this.accessPaths;
    }

    @Override
    public void merge(ISourceSinkDefinition other) {
        if (other instanceof StatementSourceSinkDefinition) {
            StatementSourceSinkDefinition otherStmt = (StatementSourceSinkDefinition)other;
            if (otherStmt.accessPaths != null && !otherStmt.accessPaths.isEmpty()) {
                if (this.accessPaths == null) {
                    this.accessPaths = new HashSet<AccessPathTuple>();
                }
                for (AccessPathTuple apt : otherStmt.accessPaths) {
                    this.accessPaths.add(apt);
                }
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public String toString() {
        return String.format("Local %s at %s", this.local, this.stmt);
    }

    @Override
    public Set<AccessPathTuple> getAllAccessPaths() {
        return this.accessPaths;
    }

    @Override
    public IAccessPathBasedSourceSinkDefinition filter(Collection<AccessPathTuple> toFilter) {
        HashSet<AccessPathTuple> filteredAPs = null;
        if (this.accessPaths != null && !this.accessPaths.isEmpty()) {
            filteredAPs = new HashSet<AccessPathTuple>(this.accessPaths.size());
            for (AccessPathTuple ap : this.accessPaths) {
                if (!toFilter.contains(ap)) continue;
                filteredAPs.add(ap);
            }
        }
        StatementSourceSinkDefinition def = this.buildNewDefinition(this.stmt, this.local, filteredAPs);
        def.setCategory(this.category);
        return def;
    }

    protected StatementSourceSinkDefinition buildNewDefinition(Stmt stmt, Local local, Set<AccessPathTuple> accessPaths) {
        return new StatementSourceSinkDefinition(stmt, local, accessPaths);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accessPaths == null ? 0 : this.accessPaths.hashCode());
        result = 31 * result + (this.local == null ? 0 : this.local.hashCode());
        result = 31 * result + (this.stmt == null ? 0 : this.stmt.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatementSourceSinkDefinition other = (StatementSourceSinkDefinition)obj;
        if (this.accessPaths == null ? other.accessPaths != null : !this.accessPaths.equals(other.accessPaths)) {
            return false;
        }
        if (this.local == null ? other.local != null : !this.local.equals(other.local)) {
            return false;
        }
        return !(this.stmt == null ? other.stmt != null : !this.stmt.equals(other.stmt));
    }
}

