/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.sourcesSinks.definitions;

public enum SourceSinkType {
    Undefined,
    Source,
    Sink,
    Neither,
    Both;


    public static SourceSinkType fromFlags(boolean isSink, boolean isSource) {
        if (isSink && isSource) {
            return Both;
        }
        if (!isSink && !isSource) {
            return Neither;
        }
        if (isSource) {
            return Source;
        }
        if (isSink) {
            return Sink;
        }
        return Undefined;
    }

    public boolean isSource() {
        return this == Source || this == Both;
    }

    public boolean isSink() {
        return this == Sink || this == Both;
    }

    public SourceSinkType removeType(SourceSinkType toRemove) {
        switch (this) {
            case Neither: 
            case Undefined: {
                return this;
            }
            case Source: {
                return toRemove == Source || toRemove == Both ? Neither : this;
            }
            case Sink: {
                return toRemove == Sink || toRemove == Both ? Neither : this;
            }
            case Both: {
                switch (toRemove) {
                    case Neither: 
                    case Undefined: {
                        return this;
                    }
                    case Source: {
                        return Sink;
                    }
                    case Sink: {
                        return Source;
                    }
                    case Both: {
                        return Neither;
                    }
                }
            }
        }
        return this;
    }

    public SourceSinkType addType(SourceSinkType toAdd) {
        switch (this) {
            case Neither: 
            case Undefined: {
                return toAdd;
            }
            case Source: {
                return toAdd == Sink || toAdd == Both ? Both : this;
            }
            case Sink: {
                return toAdd == Source || toAdd == Both ? Both : this;
            }
            case Both: {
                return this;
            }
        }
        return this;
    }
}

