/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.sourcesSinks.definitions;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.sourcesSinks.definitions.AbstractSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.AccessPathTuple;
import soot.jimple.infoflow.sourcesSinks.definitions.IAccessPathBasedSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;

public class MethodSourceSinkDefinition
extends AbstractSourceSinkDefinition
implements IAccessPathBasedSourceSinkDefinition {
    private static MethodSourceSinkDefinition BASE_OBJ_SOURCE;
    private static MethodSourceSinkDefinition BASE_OBJ_SINK;
    private static MethodSourceSinkDefinition[] PARAM_OBJ_SOURCE;
    protected final SootMethodAndClass method;
    protected final CallType callType;
    protected Set<AccessPathTuple> baseObjects;
    protected Set<AccessPathTuple>[] parameters;
    protected Set<AccessPathTuple> returnValues;

    public MethodSourceSinkDefinition(Set<AccessPathTuple> baseObjects, Set<AccessPathTuple>[] parameters, Set<AccessPathTuple> returnValues, CallType callType) {
        this(null, baseObjects, parameters, returnValues, callType);
    }

    public MethodSourceSinkDefinition(SootMethodAndClass am) {
        this(am, null, null, null, CallType.MethodCall);
    }

    public MethodSourceSinkDefinition(SootMethodAndClass am, Set<AccessPathTuple> baseObjects, Set<AccessPathTuple>[] parameters, Set<AccessPathTuple> returnValues, CallType callType) {
        this.method = am;
        this.baseObjects = baseObjects == null || baseObjects.isEmpty() ? null : baseObjects;
        this.parameters = parameters;
        this.returnValues = returnValues == null || returnValues.isEmpty() ? null : returnValues;
        this.callType = callType;
    }

    public SootMethodAndClass getMethod() {
        return this.method;
    }

    public CallType getCallType() {
        return this.callType;
    }

    public Set<AccessPathTuple> getBaseObjects() {
        return this.baseObjects;
    }

    public int getBaseObjectCount() {
        return this.baseObjects == null ? 0 : this.baseObjects.size();
    }

    public Set<AccessPathTuple>[] getParameters() {
        return this.parameters;
    }

    public int getParameterCount() {
        if (this.parameters == null || this.parameters.length == 0) {
            return 0;
        }
        int cnt = 0;
        for (Set<AccessPathTuple> apt : this.parameters) {
            cnt += apt.size();
        }
        return cnt;
    }

    public Set<AccessPathTuple> getReturnValues() {
        return this.returnValues;
    }

    public int getReturnValueCount() {
        return this.returnValues == null ? 0 : this.returnValues.size();
    }

    @Override
    public boolean isEmpty() {
        boolean parametersEmpty = true;
        if (this.parameters != null) {
            for (Set<AccessPathTuple> paramSet : this.parameters) {
                if (paramSet == null || paramSet.isEmpty()) continue;
                parametersEmpty = false;
                break;
            }
        }
        return !(this.baseObjects != null && !this.baseObjects.isEmpty() || !parametersEmpty || this.returnValues != null && !this.returnValues.isEmpty());
    }

    public String toString() {
        return this.method == null ? "<no method>" : this.method.getSignature();
    }

    @Override
    public MethodSourceSinkDefinition getSourceOnlyDefinition() {
        HashSet<AccessPathTuple> baseSources = null;
        if (this.baseObjects != null) {
            baseSources = new HashSet<AccessPathTuple>(this.baseObjects.size());
            for (AccessPathTuple apt : this.baseObjects) {
                if (!apt.getSourceSinkType().isSource()) continue;
                baseSources.add(apt);
            }
        }
        Set[] paramSources = new Set[this.parameters.length];
        for (int i = 0; i < this.parameters.length; ++i) {
            HashSet<AccessPathTuple> thisParam;
            Set<AccessPathTuple> aptSet = this.parameters[i];
            paramSources[i] = thisParam = new HashSet<AccessPathTuple>(aptSet.size());
            Iterator<AccessPathTuple> iterator = aptSet.iterator();
            while (iterator.hasNext()) {
                AccessPathTuple apt = iterator.next();
                if (!apt.getSourceSinkType().isSource()) continue;
                thisParam.add(apt);
            }
        }
        HashSet<AccessPathTuple> returnSources = null;
        if (this.returnValues != null) {
            returnSources = new HashSet<AccessPathTuple>(this.returnValues.size());
            for (AccessPathTuple apt : this.returnValues) {
                if (!apt.getSourceSinkType().isSource()) continue;
                returnSources.add(apt);
            }
        }
        MethodSourceSinkDefinition mssd = this.buildNewDefinition(baseSources, paramSources, returnSources);
        return mssd;
    }

    @Override
    public MethodSourceSinkDefinition getSinkOnlyDefinition() {
        HashSet<AccessPathTuple> baseSinks = null;
        if (this.baseObjects != null) {
            baseSinks = new HashSet<AccessPathTuple>(this.baseObjects.size());
            for (AccessPathTuple apt : this.baseObjects) {
                if (!apt.getSourceSinkType().isSink()) continue;
                baseSinks.add(apt);
            }
        }
        Set[] paramSinks = new Set[this.parameters.length];
        for (int i = 0; i < this.parameters.length; ++i) {
            HashSet<AccessPathTuple> thisParam;
            Set<AccessPathTuple> aptSet = this.parameters[i];
            paramSinks[i] = thisParam = new HashSet<AccessPathTuple>(aptSet.size());
            Iterator<AccessPathTuple> iterator = aptSet.iterator();
            while (iterator.hasNext()) {
                AccessPathTuple apt = iterator.next();
                if (!apt.getSourceSinkType().isSink()) continue;
                thisParam.add(apt);
            }
        }
        HashSet<AccessPathTuple> returnSinks = null;
        if (this.returnValues != null) {
            returnSinks = new HashSet<AccessPathTuple>(this.returnValues.size());
            for (AccessPathTuple apt : this.returnValues) {
                if (!apt.getSourceSinkType().isSink()) continue;
                returnSinks.add(apt);
            }
        }
        MethodSourceSinkDefinition mssd = this.buildNewDefinition(baseSinks, paramSinks, returnSinks);
        return mssd;
    }

    protected MethodSourceSinkDefinition buildNewDefinition(Set<AccessPathTuple> baseAPTs, Set<AccessPathTuple>[] paramAPTs, Set<AccessPathTuple> returnAPTs) {
        MethodSourceSinkDefinition def = this.buildNewDefinition(this.method, baseAPTs, paramAPTs, returnAPTs, this.callType);
        def.setCategory(this.category);
        return def;
    }

    protected MethodSourceSinkDefinition buildNewDefinition(SootMethodAndClass methodAndclass, Set<AccessPathTuple> filteredBaseObjects, Set<AccessPathTuple>[] filteredParameters, Set<AccessPathTuple> filteredReturnValues, CallType callType) {
        return new MethodSourceSinkDefinition(methodAndclass, filteredBaseObjects, filteredParameters, filteredReturnValues, callType);
    }

    @Override
    public void merge(ISourceSinkDefinition other) {
        if (other instanceof MethodSourceSinkDefinition) {
            MethodSourceSinkDefinition otherMethod = (MethodSourceSinkDefinition)other;
            if (otherMethod.baseObjects != null && !otherMethod.baseObjects.isEmpty()) {
                if (this.baseObjects == null) {
                    this.baseObjects = new HashSet<AccessPathTuple>();
                }
                for (AccessPathTuple apt : otherMethod.baseObjects) {
                    this.baseObjects.add(apt);
                }
            }
            if (otherMethod.parameters != null && otherMethod.parameters.length > 0) {
                if (this.parameters == null) {
                    this.parameters = new Set[this.method.getParameters().size()];
                }
                for (int i = 0; i < otherMethod.parameters.length; ++i) {
                    this.parameters[i].addAll(otherMethod.parameters[i]);
                }
            }
            if (otherMethod.returnValues != null && !otherMethod.returnValues.isEmpty()) {
                if (this.returnValues == null) {
                    this.returnValues = new HashSet<AccessPathTuple>();
                }
                for (AccessPathTuple apt : otherMethod.returnValues) {
                    this.returnValues.add(apt);
                }
            }
        }
    }

    public MethodSourceSinkDefinition getBaseObjectSource() {
        if (BASE_OBJ_SOURCE == null) {
            BASE_OBJ_SOURCE = new MethodSourceSinkDefinition(Collections.singleton(AccessPathTuple.getBlankSourceTuple()), null, null, CallType.MethodCall);
        }
        return BASE_OBJ_SOURCE;
    }

    public MethodSourceSinkDefinition getBaseObjectSink() {
        if (BASE_OBJ_SINK == null) {
            BASE_OBJ_SINK = new MethodSourceSinkDefinition(Collections.singleton(AccessPathTuple.getBlankSinkTuple()), null, null, CallType.MethodCall);
        }
        return BASE_OBJ_SINK;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.baseObjects == null ? 0 : this.baseObjects.hashCode());
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + (this.callType == null ? 0 : this.callType.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : Arrays.hashCode(this.parameters));
        result = 31 * result + (this.returnValues == null ? 0 : this.returnValues.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodSourceSinkDefinition other = (MethodSourceSinkDefinition)obj;
        if (this.baseObjects == null ? other.baseObjects != null : !this.baseObjects.equals(other.baseObjects)) {
            return false;
        }
        if (this.method == null ? other.method != null : !this.method.equals(other.method)) {
            return false;
        }
        if (this.callType == null ? other.callType != null : !this.callType.equals((Object)other.callType)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !Arrays.equals(this.parameters, other.parameters)) {
            return false;
        }
        return !(this.returnValues == null ? other.returnValues != null : !this.returnValues.equals(other.returnValues));
    }

    public static MethodSourceSinkDefinition createParameterSource(int index, CallType callType) {
        if (index < 5 && callType == CallType.MethodCall) {
            MethodSourceSinkDefinition def = PARAM_OBJ_SOURCE[index];
            if (def == null) {
                MethodSourceSinkDefinition.PARAM_OBJ_SOURCE[index] = def = new MethodSourceSinkDefinition(null, new Set[]{Collections.singleton(AccessPathTuple.getBlankSourceTuple())}, null, callType);
            }
            return def;
        }
        return new MethodSourceSinkDefinition(null, new Set[]{Collections.singleton(AccessPathTuple.getBlankSourceTuple())}, null, callType);
    }

    public static MethodSourceSinkDefinition createReturnSource(CallType callType) {
        return new MethodSourceSinkDefinition(null, null, Collections.singleton(AccessPathTuple.getBlankSourceTuple()), callType);
    }

    public MethodSourceSinkDefinition simplify() {
        MethodSourceSinkDefinition baseObjSource = this.getBaseObjectSource();
        MethodSourceSinkDefinition baseObjSink = this.getBaseObjectSink();
        if (this.equals(baseObjSource)) {
            return baseObjSource;
        }
        if (this.equals(baseObjSink)) {
            return baseObjSink;
        }
        for (int i = 0; i < PARAM_OBJ_SOURCE.length; ++i) {
            MethodSourceSinkDefinition def = MethodSourceSinkDefinition.createParameterSource(i, this.getCallType());
            if (!this.equals(def)) continue;
            return def;
        }
        return this;
    }

    @Override
    public Set<AccessPathTuple> getAllAccessPaths() {
        HashSet<AccessPathTuple> aps = new HashSet<AccessPathTuple>();
        if (this.baseObjects != null && !this.baseObjects.isEmpty()) {
            aps.addAll(this.baseObjects);
        }
        if (this.returnValues != null && !this.returnValues.isEmpty()) {
            aps.addAll(this.returnValues);
        }
        if (this.parameters != null && this.parameters.length > 0) {
            for (Set<AccessPathTuple> paramAPs : this.parameters) {
                if (paramAPs == null || paramAPs.isEmpty()) continue;
                aps.addAll(paramAPs);
            }
        }
        return aps;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MethodSourceSinkDefinition filter(Collection<AccessPathTuple> accessPaths) {
        void var4_9;
        HashSet<AccessPathTuple> filteredBaseObjects = null;
        if (this.baseObjects != null && !this.baseObjects.isEmpty()) {
            filteredBaseObjects = new HashSet<AccessPathTuple>(this.baseObjects.size());
            for (AccessPathTuple accessPathTuple : this.baseObjects) {
                if (!accessPaths.contains(accessPathTuple)) continue;
                filteredBaseObjects.add(accessPathTuple);
            }
        }
        HashSet<AccessPathTuple> filteredReturnValues = null;
        if (this.returnValues != null && !this.returnValues.isEmpty()) {
            filteredReturnValues = new HashSet<AccessPathTuple>(this.returnValues.size());
            for (AccessPathTuple ap : this.returnValues) {
                if (!accessPaths.contains(ap)) continue;
                filteredReturnValues.add(ap);
            }
        }
        Object var4_7 = null;
        if (this.parameters != null && this.parameters.length > 0) {
            Set[] setArray = new Set[this.parameters.length];
            for (int i = 0; i < this.parameters.length; ++i) {
                if (this.parameters[i] == null || this.parameters[i].isEmpty()) continue;
                setArray[i] = new HashSet();
                for (AccessPathTuple ap : this.parameters[i]) {
                    if (!accessPaths.contains(ap)) continue;
                    setArray[i].add(ap);
                }
            }
        }
        MethodSourceSinkDefinition def = this.buildNewDefinition(this.method, (Set<AccessPathTuple>)filteredBaseObjects, (Set<AccessPathTuple>[])var4_9, (Set<AccessPathTuple>)filteredReturnValues, this.callType);
        def.setCategory(this.category);
        return def;
    }

    static {
        PARAM_OBJ_SOURCE = new MethodSourceSinkDefinition[5];
    }

    public static enum CallType {
        MethodCall,
        Callback,
        Return;

    }
}

