/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.sourcesSinks.definitions;

import java.util.HashSet;
import java.util.Set;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinitionProvider;

public class FilteringSourceSinkDefinitionProvider
implements ISourceSinkDefinitionProvider {
    private final ISourceSinkDefinitionProvider innerProvider;
    private final ISourceSinkFilter filter;

    public FilteringSourceSinkDefinitionProvider(ISourceSinkDefinitionProvider innerProvider, ISourceSinkFilter filter) {
        this.innerProvider = innerProvider;
        this.filter = filter;
    }

    private Set<ISourceSinkDefinition> filter(Set<? extends ISourceSinkDefinition> input) {
        HashSet<ISourceSinkDefinition> filtered = new HashSet<ISourceSinkDefinition>(input.size());
        for (ISourceSinkDefinition iSourceSinkDefinition : input) {
            if (!this.filter.accepts(iSourceSinkDefinition)) continue;
            filtered.add(iSourceSinkDefinition);
        }
        return filtered;
    }

    public Set<ISourceSinkDefinition> getSources() {
        return this.filter(this.innerProvider.getSources());
    }

    public Set<ISourceSinkDefinition> getSinks() {
        return this.filter(this.innerProvider.getSinks());
    }

    public Set<ISourceSinkDefinition> getAllMethods() {
        return this.filter(this.innerProvider.getAllMethods());
    }

    public static interface ISourceSinkFilter {
        public boolean accepts(ISourceSinkDefinition var1);
    }
}

