/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.sourcesSinks.definitions;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import soot.jimple.infoflow.sourcesSinks.definitions.AbstractSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.AccessPathTuple;
import soot.jimple.infoflow.sourcesSinks.definitions.IAccessPathBasedSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;

public class FieldSourceSinkDefinition
extends AbstractSourceSinkDefinition
implements IAccessPathBasedSourceSinkDefinition {
    protected final String fieldSignature;
    protected Set<AccessPathTuple> accessPaths;

    public FieldSourceSinkDefinition(String fieldSignature) {
        this(fieldSignature, null);
    }

    public FieldSourceSinkDefinition(String fieldSignature, Set<AccessPathTuple> accessPaths) {
        this.fieldSignature = fieldSignature;
        this.accessPaths = accessPaths;
    }

    public String getFieldSignature() {
        return this.fieldSignature;
    }

    public Set<AccessPathTuple> getAccessPaths() {
        return this.accessPaths;
    }

    @Override
    public FieldSourceSinkDefinition getSourceOnlyDefinition() {
        HashSet<AccessPathTuple> sources = null;
        if (this.accessPaths != null) {
            sources = new HashSet<AccessPathTuple>(this.accessPaths.size());
            for (AccessPathTuple apt : this.accessPaths) {
                if (!apt.getSourceSinkType().isSource()) continue;
                sources.add(apt);
            }
        }
        return this.buildNewDefinition(sources);
    }

    @Override
    public FieldSourceSinkDefinition getSinkOnlyDefinition() {
        HashSet<AccessPathTuple> sinks = null;
        if (this.accessPaths != null) {
            sinks = new HashSet<AccessPathTuple>(this.accessPaths.size());
            for (AccessPathTuple apt : this.accessPaths) {
                if (!apt.getSourceSinkType().isSink()) continue;
                sinks.add(apt);
            }
        }
        return this.buildNewDefinition(sinks);
    }

    protected FieldSourceSinkDefinition buildNewDefinition(Set<AccessPathTuple> accessPaths) {
        return this.buildNewDefinition(this.fieldSignature, accessPaths);
    }

    protected FieldSourceSinkDefinition buildNewDefinition(String fieldSignature, Set<AccessPathTuple> accessPaths) {
        return new FieldSourceSinkDefinition(fieldSignature, accessPaths);
    }

    @Override
    public void merge(ISourceSinkDefinition other) {
        if (other instanceof FieldSourceSinkDefinition) {
            FieldSourceSinkDefinition otherField = (FieldSourceSinkDefinition)other;
            if (otherField.accessPaths != null && !otherField.accessPaths.isEmpty()) {
                if (this.accessPaths == null) {
                    this.accessPaths = new HashSet<AccessPathTuple>();
                }
                for (AccessPathTuple apt : otherField.accessPaths) {
                    this.accessPaths.add(apt);
                }
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.accessPaths == null || this.accessPaths.isEmpty();
    }

    @Override
    public Set<AccessPathTuple> getAllAccessPaths() {
        return this.accessPaths;
    }

    @Override
    public IAccessPathBasedSourceSinkDefinition filter(Collection<AccessPathTuple> toFilter) {
        HashSet<AccessPathTuple> filteredAPs = null;
        if (this.accessPaths != null && !this.accessPaths.isEmpty()) {
            filteredAPs = new HashSet<AccessPathTuple>(this.accessPaths.size());
            for (AccessPathTuple ap : this.accessPaths) {
                if (!toFilter.contains(ap)) continue;
                filteredAPs.add(ap);
            }
        }
        FieldSourceSinkDefinition def = this.buildNewDefinition(this.fieldSignature, filteredAPs);
        def.setCategory(this.category);
        return def;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accessPaths == null ? 0 : this.accessPaths.hashCode());
        result = 31 * result + (this.fieldSignature == null ? 0 : this.fieldSignature.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldSourceSinkDefinition other = (FieldSourceSinkDefinition)obj;
        if (this.accessPaths == null ? other.accessPaths != null : !this.accessPaths.equals(other.accessPaths)) {
            return false;
        }
        return !(this.fieldSignature == null ? other.fieldSignature != null : !this.fieldSignature.equals(other.fieldSignature));
    }
}

