/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.sourcesSinks.definitions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import soot.PrimType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.Type;
import soot.Value;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.sourcesSinks.definitions.InvalidAccessPathException;
import soot.jimple.infoflow.sourcesSinks.definitions.SourceSinkType;
import soot.jimple.infoflow.util.TypeUtils;

public class AccessPathTuple {
    private final String baseType;
    private final String[] fields;
    private final String[] fieldTypes;
    private final SourceSinkType sinkSource;
    private String description;
    private int hashCode = 0;
    private static AccessPathTuple SOURCE_TUPLE;
    private static AccessPathTuple SINK_TUPLE;

    AccessPathTuple(String[] fields, String[] fieldTypes, SourceSinkType sinkSource) {
        this(null, fields, fieldTypes, sinkSource);
    }

    AccessPathTuple(String baseType, String[] fields, String[] fieldTypes, SourceSinkType sinkSource) {
        this.baseType = baseType;
        this.fields = fields;
        this.fieldTypes = fieldTypes;
        this.sinkSource = sinkSource;
    }

    public static AccessPathTuple create(boolean isSource, boolean isSink) {
        return AccessPathTuple.fromPathElements((String[])null, (String[])null, isSource, isSink);
    }

    public static AccessPathTuple fromPathElements(List<String> fields, List<String> fieldTypes, boolean isSource, boolean isSink) {
        String[] fieldArray = fields == null || fields.isEmpty() ? null : fields.toArray(new String[fields.size()]);
        String[] fieldTypeArray = fieldTypes == null || fieldTypes.isEmpty() ? null : fieldTypes.toArray(new String[fieldTypes.size()]);
        return AccessPathTuple.fromPathElements(fieldArray, fieldTypeArray, isSource, isSink);
    }

    public static AccessPathTuple fromPathElements(List<String> fields, List<String> fieldTypes, SourceSinkType sourceSinkType) {
        return AccessPathTuple.fromPathElements(null, fields, fieldTypes, sourceSinkType);
    }

    public static AccessPathTuple fromPathElements(String field, String fieldType, SourceSinkType sourceSinkType) {
        return AccessPathTuple.fromPathElements(null, field, fieldType, sourceSinkType);
    }

    public static AccessPathTuple fromPathElements(String baseType, String field, String fieldType, SourceSinkType sourceSinkType) {
        return AccessPathTuple.fromPathElements(baseType, Collections.singletonList(field), Collections.singletonList(fieldType), sourceSinkType);
    }

    public static AccessPathTuple fromPathElements(String baseType, List<String> fields, List<String> fieldTypes, SourceSinkType sourceSinkType) {
        String[] fieldArray = fields == null || fields.isEmpty() ? null : fields.toArray(new String[fields.size()]);
        String[] fieldTypeArray = fieldTypes == null || fieldTypes.isEmpty() ? null : fieldTypes.toArray(new String[fieldTypes.size()]);
        return new AccessPathTuple(baseType, fieldArray, fieldTypeArray, sourceSinkType);
    }

    public static AccessPathTuple fromPathElements(String[] fields, String[] fieldTypes, boolean isSource, boolean isSink) {
        return new AccessPathTuple(fields, fieldTypes, SourceSinkType.fromFlags(isSink, isSource));
    }

    public String getBaseType() {
        return this.baseType;
    }

    public String[] getFields() {
        return this.fields;
    }

    public String[] getFieldTypes() {
        return this.fieldTypes;
    }

    public SourceSinkType getSourceSinkType() {
        return this.sinkSource;
    }

    public static AccessPathTuple getBlankSourceTuple() {
        if (SOURCE_TUPLE == null) {
            SOURCE_TUPLE = AccessPathTuple.create(true, false);
        }
        return SOURCE_TUPLE;
    }

    public static AccessPathTuple getBlankSinkTuple() {
        if (SINK_TUPLE == null) {
            SINK_TUPLE = AccessPathTuple.create(false, true);
        }
        return SINK_TUPLE;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.baseType == null ? 0 : this.baseType.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + Arrays.hashCode(this.fieldTypes);
        result = 31 * result + Arrays.hashCode(this.fields);
        this.hashCode = result = 31 * result + (this.sinkSource == null ? 0 : this.sinkSource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessPathTuple other = (AccessPathTuple)obj;
        if (this.baseType == null ? other.baseType != null : !this.baseType.equals(other.baseType)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (!Arrays.equals(this.fieldTypes, other.fieldTypes)) {
            return false;
        }
        if (!Arrays.equals(this.fields, other.fields)) {
            return false;
        }
        return this.sinkSource == other.sinkSource;
    }

    public AccessPathTuple simplify() {
        AccessPathTuple blankSource = AccessPathTuple.getBlankSourceTuple();
        AccessPathTuple blankSink = AccessPathTuple.getBlankSinkTuple();
        if (this.equals(blankSource)) {
            return blankSource;
        }
        if (this.equals(blankSink)) {
            return blankSink;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessPath toAccessPath(Value baseVal, InfoflowManager manager, boolean canHaveImmutableAliases) {
        if (baseVal.getType() instanceof PrimType || this.fields == null || this.fields.length == 0) {
            return manager.getAccessPathFactory().createAccessPath(baseVal, null, null, null, true, false, true, AccessPath.ArrayTaintType.ContentsAndLength, canHaveImmutableAliases);
        }
        RefType baseType = this.baseType == null || this.baseType.isEmpty() ? null : RefType.v((String)this.baseType);
        SootClass baseClass = baseType == null ? ((RefType)baseVal.getType()).getSootClass() : baseType.getSootClass();
        SootField[] fields = new SootField[this.fields.length];
        for (int i = 0; i < fields.length; ++i) {
            Type fieldType;
            RefType lastFieldType;
            String fieldName = this.fields[i];
            Object object = lastFieldType = i == 0 ? baseClass.getType() : TypeUtils.getTypeFromString(this.fieldTypes[i - 1]);
            if (!(lastFieldType instanceof RefType)) {
                throw new InvalidAccessPathException(String.format("Type %s cannot have fields (requested: %s)", lastFieldType.toString(), fieldName));
            }
            SootClass lastFieldClass = lastFieldType.getSootClass();
            SootField fld = lastFieldClass.getFieldUnsafe(fieldName, fieldType = TypeUtils.getTypeFromString(this.fieldTypes[i]));
            if (fld == null) {
                SootClass sootClass = lastFieldClass;
                synchronized (sootClass) {
                    fld = lastFieldClass.getFieldUnsafe(fieldName, fieldType);
                    if (fld == null) {
                        SootField f = Scene.v().makeSootField(fieldName, fieldType, 0);
                        f.setPhantom(true);
                        fld = lastFieldClass.getOrAddField(f);
                    }
                }
            }
            if (fld == null) {
                return null;
            }
            fields[i] = fld;
        }
        return manager.getAccessPathFactory().createAccessPath(baseVal, fields, (Type)baseType, null, true, false, true, AccessPath.ArrayTaintType.ContentsAndLength, canHaveImmutableAliases);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.fields != null && this.fields.length > 0) {
            for (int i = 0; i < this.fields.length; ++i) {
                if (i > 0) {
                    sb.append(".");
                }
                sb.append(this.fields[i]);
            }
        } else {
            sb.append("<empty>");
        }
        if (this.description != null && !this.description.isEmpty()) {
            sb.append(" (");
            sb.append(this.description);
            sb.append(")");
        }
        return sb.toString();
    }
}

