/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.solver.fastSolver;

import com.google.common.cache.CacheBuilder;
import heros.DontSynchronize;
import heros.FlowFunction;
import heros.FlowFunctionCache;
import heros.FlowFunctions;
import heros.IFDSTabulationProblem;
import heros.SynchronizedBy;
import heros.solver.Pair;
import heros.solver.PathEdge;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.jimple.infoflow.collect.MyConcurrentHashMap;
import soot.jimple.infoflow.memory.IMemoryBoundedSolver;
import soot.jimple.infoflow.memory.ISolverTerminationReason;
import soot.jimple.infoflow.solver.PredecessorShorteningMode;
import soot.jimple.infoflow.solver.executors.InterruptableExecutor;
import soot.jimple.infoflow.solver.executors.SetPoolExecutor;
import soot.jimple.infoflow.solver.fastSolver.FastSolverLinkedNode;
import soot.jimple.infoflow.solver.memory.IMemoryManager;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;

public class IFDSSolver<N, D extends FastSolverLinkedNode<D, N>, I extends BiDiInterproceduralCFG<N, SootMethod>>
implements IMemoryBoundedSolver {
    public static CacheBuilder<Object, Object> DEFAULT_CACHE_BUILDER = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors()).initialCapacity(10000).softValues();
    protected static final Logger logger = LoggerFactory.getLogger(IFDSSolver.class);
    public static final boolean DEBUG = logger.isDebugEnabled();
    protected InterruptableExecutor executor;
    @DontSynchronize(value="only used by single thread")
    protected int numThreads;
    @SynchronizedBy(value="thread safe data structure, consistent locking when used")
    protected MyConcurrentHashMap<PathEdge<N, D>, D> jumpFunctions = new MyConcurrentHashMap();
    @SynchronizedBy(value="thread safe data structure, only modified internally")
    protected final I icfg;
    @SynchronizedBy(value="consistent lock on 'incoming'")
    protected final MyConcurrentHashMap<Pair<SootMethod, D>, Map<Pair<N, D>, D>> endSummary = new MyConcurrentHashMap();
    @SynchronizedBy(value="consistent lock on field")
    protected final MyConcurrentHashMap<Pair<SootMethod, D>, MyConcurrentHashMap<N, Map<D, D>>> incoming = new MyConcurrentHashMap();
    @DontSynchronize(value="stateless")
    protected final FlowFunctions<N, D, SootMethod> flowFunctions;
    @DontSynchronize(value="only used by single thread")
    protected final Map<N, Set<D>> initialSeeds;
    @DontSynchronize(value="benign races")
    public long propagationCount;
    @DontSynchronize(value="stateless")
    protected final D zeroValue;
    @DontSynchronize(value="readOnly")
    protected final FlowFunctionCache<N, D, SootMethod> ffCache;
    @DontSynchronize(value="readOnly")
    protected final boolean followReturnsPastSeeds;
    @DontSynchronize(value="readOnly")
    protected PredecessorShorteningMode shorteningMode = PredecessorShorteningMode.NeverShorten;
    @DontSynchronize(value="readOnly")
    private int maxJoinPointAbstractions = -1;
    @DontSynchronize(value="readOnly")
    protected IMemoryManager<D, N> memoryManager = null;
    protected boolean solverId;
    private Set<IMemoryBoundedSolver.IMemoryBoundedSolverStatusNotification> notificationListeners = new HashSet<IMemoryBoundedSolver.IMemoryBoundedSolverStatusNotification>();
    private ISolverTerminationReason killFlag = null;
    private int maxCalleesPerCallSite = 75;
    private int maxAbstractionPathLength = 100;

    public IFDSSolver(IFDSTabulationProblem<N, D, SootMethod, I> tabulationProblem) {
        this(tabulationProblem, DEFAULT_CACHE_BUILDER);
    }

    public IFDSSolver(IFDSTabulationProblem<N, D, SootMethod, I> tabulationProblem, CacheBuilder flowFunctionCacheBuilder) {
        FlowFunctionCache<N, D, SootMethod> flowFunctions;
        if (logger.isDebugEnabled()) {
            flowFunctionCacheBuilder = flowFunctionCacheBuilder.recordStats();
        }
        this.zeroValue = (FastSolverLinkedNode)tabulationProblem.zeroValue();
        this.icfg = (BiDiInterproceduralCFG)tabulationProblem.interproceduralCFG();
        Object object = flowFunctions = tabulationProblem.autoAddZero() ? new FlowFunctionCache<N, D, SootMethod>(tabulationProblem.flowFunctions(), this.zeroValue) : tabulationProblem.flowFunctions();
        if (flowFunctionCacheBuilder != null) {
            this.ffCache = new FlowFunctionCache((FlowFunctions)flowFunctions, flowFunctionCacheBuilder);
            flowFunctions = this.ffCache;
        } else {
            this.ffCache = null;
        }
        this.flowFunctions = flowFunctions;
        this.initialSeeds = tabulationProblem.initialSeeds();
        this.followReturnsPastSeeds = tabulationProblem.followReturnsPastSeeds();
        this.numThreads = Math.max(1, tabulationProblem.numThreads());
        this.executor = this.getExecutor();
    }

    public void setSolverId(boolean solverId) {
        this.solverId = solverId;
    }

    public void solve() {
        this.reset();
        for (IMemoryBoundedSolver.IMemoryBoundedSolverStatusNotification listener : this.notificationListeners) {
            listener.notifySolverStarted(this);
        }
        this.submitInitialSeeds();
        this.awaitCompletionComputeValuesAndShutdown();
        for (IMemoryBoundedSolver.IMemoryBoundedSolverStatusNotification listener : this.notificationListeners) {
            listener.notifySolverTerminated(this);
        }
    }

    protected void submitInitialSeeds() {
        for (Map.Entry<N, Set<D>> seed : this.initialSeeds.entrySet()) {
            N startPoint = seed.getKey();
            for (FastSolverLinkedNode val : seed.getValue()) {
                this.propagate(this.zeroValue, startPoint, val, null, false);
            }
            this.addFunction(new PathEdge(this.zeroValue, startPoint, this.zeroValue));
        }
    }

    protected void awaitCompletionComputeValuesAndShutdown() {
        this.runExecutorAndAwaitCompletion();
        if (logger.isDebugEnabled()) {
            this.printStats();
        }
        this.executor.shutdown();
        while (!this.executor.isTerminated()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void runExecutorAndAwaitCompletion() {
        try {
            this.executor.awaitCompletion();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Throwable exception = this.executor.getException();
        if (exception != null) {
            throw new RuntimeException("There were exceptions during IFDS analysis. Exiting.", exception);
        }
    }

    protected void scheduleEdgeProcessing(PathEdge<N, D> edge) {
        if (this.killFlag != null || this.executor.isTerminating() || this.executor.isTerminated()) {
            return;
        }
        this.executor.execute(new PathEdgeProcessingTask(edge, this.solverId));
        ++this.propagationCount;
    }

    private void processCall(PathEdge<N, D> edge) {
        final FastSolverLinkedNode d1 = (FastSolverLinkedNode)edge.factAtSource();
        final Object n = edge.getTarget();
        final FastSolverLinkedNode d2 = (FastSolverLinkedNode)edge.factAtTarget();
        assert (d2 != null);
        final Collection returnSiteNs = this.icfg.getReturnSitesOfCallAt(n);
        Collection callees = this.icfg.getCalleesOfCallAt(n);
        if (this.maxCalleesPerCallSite < 0 || callees.size() <= this.maxCalleesPerCallSite) {
            callees.stream().filter(m -> m.isConcrete()).forEach(new Consumer<SootMethod>(){

                @Override
                public void accept(SootMethod sCalledProcN) {
                    if (IFDSSolver.this.killFlag != null) {
                        return;
                    }
                    FlowFunction function = IFDSSolver.this.flowFunctions.getCallFlowFunction(n, (Object)sCalledProcN);
                    Set<FastSolverLinkedNode> res = IFDSSolver.this.computeCallFlowFunction(function, d1, d2);
                    if (res != null && !res.isEmpty()) {
                        Collection startPointsOf = IFDSSolver.this.icfg.getStartPointsOf((Object)sCalledProcN);
                        for (FastSolverLinkedNode d3 : res) {
                            if (IFDSSolver.this.memoryManager != null) {
                                d3 = IFDSSolver.this.memoryManager.handleGeneratedMemoryObject(d2, d3);
                            }
                            if (d3 == null) continue;
                            for (Object sP : startPointsOf) {
                                IFDSSolver.this.propagate(d3, sP, d3, n, false);
                            }
                            if (!IFDSSolver.this.addIncoming(sCalledProcN, d3, n, d1, d2)) continue;
                            IFDSSolver.this.applyEndSummaryOnCall(d1, n, d2, returnSiteNs, sCalledProcN, d3);
                        }
                    }
                }
            });
        }
        for (Object returnSiteN : returnSiteNs) {
            FlowFunction callToReturnFlowFunction = this.flowFunctions.getCallToReturnFlowFunction(n, returnSiteN);
            Set<FastSolverLinkedNode> res = this.computeCallToReturnFlowFunction(callToReturnFlowFunction, d1, d2);
            if (res == null || res.isEmpty()) continue;
            for (FastSolverLinkedNode d3 : res) {
                if (this.memoryManager != null) {
                    d3 = this.memoryManager.handleGeneratedMemoryObject(d2, d3);
                }
                if (d3 == null) continue;
                this.propagate(d1, returnSiteN, d3, n, false);
            }
        }
    }

    protected void onEndSummaryApplied(N n, SootMethod sCalledProc, D d3) {
    }

    protected void applyEndSummaryOnCall(D d1, N n, D d2, Collection<N> returnSiteNs, SootMethod sCalledProcN, D d3) {
        Set<Pair<N, D>> endSumm = this.endSummary(sCalledProcN, d3);
        if (endSumm != null && !endSumm.isEmpty()) {
            for (Pair<N, D> entry : endSumm) {
                Object eP = entry.getO1();
                FastSolverLinkedNode d4 = (FastSolverLinkedNode)entry.getO2();
                for (N retSiteN : returnSiteNs) {
                    FlowFunction retFunction = this.flowFunctions.getReturnFlowFunction(n, (Object)sCalledProcN, eP, retSiteN);
                    Set<FastSolverLinkedNode> retFlowRes = this.computeReturnFlowFunction(retFunction, d3, d4, n, Collections.singleton(d1));
                    if (retFlowRes == null || retFlowRes.isEmpty()) continue;
                    for (FastSolverLinkedNode d5 : retFlowRes) {
                        if (this.memoryManager != null) {
                            d5 = this.memoryManager.handleGeneratedMemoryObject(d4, d5);
                        }
                        FastSolverLinkedNode d5p = d5;
                        switch (this.shorteningMode) {
                            case AlwaysShorten: {
                                if (d5p == d2) break;
                                d5p = (FastSolverLinkedNode)d5p.clone();
                                d5p.setPredecessor(d2);
                                break;
                            }
                            case ShortenIfEqual: {
                                if (!d5.equals(d2)) break;
                                d5p = d2;
                            }
                        }
                        this.propagate(d1, retSiteN, d5p, n, false);
                    }
                }
            }
            this.onEndSummaryApplied(n, sCalledProcN, d3);
        }
    }

    protected Set<D> computeCallFlowFunction(FlowFunction<D> callFlowFunction, D d1, D d2) {
        return callFlowFunction.computeTargets(d2);
    }

    protected Set<D> computeCallToReturnFlowFunction(FlowFunction<D> callToReturnFlowFunction, D d1, D d2) {
        return callToReturnFlowFunction.computeTargets(d2);
    }

    protected void processExit(PathEdge<N, D> edge) {
        FastSolverLinkedNode d2;
        FastSolverLinkedNode d1;
        Object n = edge.getTarget();
        SootMethod methodThatNeedsSummary = (SootMethod)this.icfg.getMethodOf(n);
        if (!this.addEndSummary(methodThatNeedsSummary, d1 = (FastSolverLinkedNode)edge.factAtSource(), n, d2 = (FastSolverLinkedNode)edge.factAtTarget())) {
            return;
        }
        Map<N, Map<FastSolverLinkedNode, FastSolverLinkedNode>> inc = this.incoming(d1, methodThatNeedsSummary);
        if (inc != null && !inc.isEmpty()) {
            for (Map.Entry<N, Map<FastSolverLinkedNode, FastSolverLinkedNode>> entry : inc.entrySet()) {
                if (this.killFlag != null) {
                    return;
                }
                Object c = entry.getKey();
                Set<FastSolverLinkedNode> callerSideDs = entry.getValue().keySet();
                for (Object retSiteC : this.icfg.getReturnSitesOfCallAt(c)) {
                    FlowFunction retFunction = this.flowFunctions.getReturnFlowFunction(c, (Object)methodThatNeedsSummary, n, retSiteC);
                    Set<FastSolverLinkedNode> targets = this.computeReturnFlowFunction(retFunction, d1, d2, c, callerSideDs);
                    if (targets == null || targets.isEmpty()) continue;
                    for (Map.Entry<FastSolverLinkedNode, FastSolverLinkedNode> d1d2entry : entry.getValue().entrySet()) {
                        FastSolverLinkedNode d4 = d1d2entry.getKey();
                        FastSolverLinkedNode predVal = d1d2entry.getValue();
                        for (FastSolverLinkedNode d5 : targets) {
                            if (this.memoryManager != null) {
                                d5 = this.memoryManager.handleGeneratedMemoryObject(d2, d5);
                            }
                            if (d5 == null) continue;
                            FastSolverLinkedNode d5p = d5;
                            switch (this.shorteningMode) {
                                case AlwaysShorten: {
                                    if (d5p == predVal) break;
                                    d5p = (FastSolverLinkedNode)d5p.clone();
                                    d5p.setPredecessor(predVal);
                                    break;
                                }
                                case ShortenIfEqual: {
                                    if (!d5.equals(predVal)) break;
                                    d5p = predVal;
                                }
                            }
                            this.propagate(d4, retSiteC, d5p, c, false);
                        }
                    }
                }
            }
        }
        if (this.followReturnsPastSeeds && d1 == this.zeroValue && (inc == null || inc.isEmpty())) {
            Collection callers = this.icfg.getCallersOf((Object)methodThatNeedsSummary);
            for (Object c : callers) {
                for (Object retSiteC : this.icfg.getReturnSitesOfCallAt(c)) {
                    FlowFunction retFunction = this.flowFunctions.getReturnFlowFunction(c, (Object)methodThatNeedsSummary, n, retSiteC);
                    Set<FastSolverLinkedNode> targets = this.computeReturnFlowFunction(retFunction, d1, d2, c, Collections.singleton(this.zeroValue));
                    if (targets == null || targets.isEmpty()) continue;
                    for (FastSolverLinkedNode d5 : targets) {
                        if (this.memoryManager != null) {
                            d5 = this.memoryManager.handleGeneratedMemoryObject(d2, d5);
                        }
                        if (d5 == null) continue;
                        this.propagate(this.zeroValue, retSiteC, d5, c, true);
                    }
                }
            }
            if (callers.isEmpty()) {
                FlowFunction flowFunction = this.flowFunctions.getReturnFlowFunction(null, (Object)methodThatNeedsSummary, n, null);
                flowFunction.computeTargets((Object)d2);
            }
        }
    }

    protected Set<D> computeReturnFlowFunction(FlowFunction<D> retFunction, D d1, D d2, N callSite, Collection<D> callerSideDs) {
        return retFunction.computeTargets(d2);
    }

    private void processNormalFlow(PathEdge<N, D> edge) {
        FastSolverLinkedNode d1 = (FastSolverLinkedNode)edge.factAtSource();
        Object n = edge.getTarget();
        FastSolverLinkedNode d2 = (FastSolverLinkedNode)edge.factAtTarget();
        for (Object m : this.icfg.getSuccsOf(n)) {
            if (this.killFlag != null) {
                return;
            }
            FlowFunction flowFunction = this.flowFunctions.getNormalFlowFunction(n, m);
            Set<FastSolverLinkedNode> res = this.computeNormalFlowFunction(flowFunction, d1, d2);
            if (res == null || res.isEmpty()) continue;
            for (FastSolverLinkedNode d3 : res) {
                if (this.memoryManager != null && d2 != d3) {
                    d3 = this.memoryManager.handleGeneratedMemoryObject(d2, d3);
                }
                if (d3 == null) continue;
                this.propagate(d1, m, d3, null, false);
            }
        }
    }

    protected Set<D> computeNormalFlowFunction(FlowFunction<D> flowFunction, D d1, D d2) {
        return flowFunction.computeTargets(d2);
    }

    protected void propagate(D sourceVal, N target, D targetVal, N relatedCallSite, boolean isUnbalancedReturn) {
        if (this.memoryManager != null) {
            sourceVal = (FastSolverLinkedNode)this.memoryManager.handleMemoryObject(sourceVal);
            if ((targetVal = (FastSolverLinkedNode)this.memoryManager.handleMemoryObject(targetVal)) == null) {
                return;
            }
        }
        if (this.maxAbstractionPathLength >= 0 && targetVal.getPathLength() > this.maxAbstractionPathLength) {
            return;
        }
        PathEdge edge = new PathEdge(sourceVal, target, targetVal);
        Object existingVal = this.addFunction(edge);
        if (existingVal != null) {
            if (existingVal != targetVal) {
                boolean isEssential = this.memoryManager == null ? relatedCallSite != null && this.icfg.isCallStmt(relatedCallSite) : this.memoryManager.isEssentialJoinPoint(targetVal, relatedCallSite);
                if (this.maxJoinPointAbstractions < 0 || existingVal.getNeighborCount() < this.maxJoinPointAbstractions || isEssential) {
                    existingVal.addNeighbor((Object)targetVal);
                }
            }
        } else {
            PathEdge activeEdge;
            FastSolverLinkedNode activeVal = (FastSolverLinkedNode)targetVal.getActiveCopy();
            if (activeVal != targetVal && this.jumpFunctions.containsKey(activeEdge = new PathEdge(sourceVal, target, (Object)activeVal))) {
                return;
            }
            this.scheduleEdgeProcessing(edge);
        }
    }

    public D addFunction(PathEdge<N, D> edge) {
        return (D)((FastSolverLinkedNode)this.jumpFunctions.putIfAbsent(edge, edge.factAtTarget()));
    }

    protected Set<Pair<N, D>> endSummary(SootMethod m, D d3) {
        Map map = (Map)this.endSummary.get(new Pair((Object)m, d3));
        return map == null ? null : map.keySet();
    }

    private boolean addEndSummary(SootMethod m, D d1, N eP, D d2) {
        if (d1 == this.zeroValue) {
            return true;
        }
        Map summaries = this.endSummary.putIfAbsentElseGet(new Pair((Object)m, d1), () -> new MyConcurrentHashMap());
        FastSolverLinkedNode oldD2 = (FastSolverLinkedNode)summaries.putIfAbsent(new Pair(eP, d2), d2);
        if (oldD2 != null) {
            oldD2.addNeighbor(d2);
            return false;
        }
        return true;
    }

    protected Map<N, Map<D, D>> incoming(D d1, SootMethod m) {
        Map map = (Map)this.incoming.get(new Pair((Object)m, d1));
        return map;
    }

    protected boolean addIncoming(SootMethod m, D d3, N n, D d1, D d2) {
        MyConcurrentHashMap summaries = this.incoming.putIfAbsentElseGet(new Pair((Object)m, d3), () -> new MyConcurrentHashMap());
        Map set = summaries.putIfAbsentElseGet(n, () -> new ConcurrentHashMap());
        return set.put(d1, d2) == null;
    }

    protected InterruptableExecutor getExecutor() {
        SetPoolExecutor executor = new SetPoolExecutor(1, this.numThreads, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        executor.setThreadFactory(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thrIFDS = new Thread(r);
                thrIFDS.setDaemon(true);
                thrIFDS.setName("IFDS Solver");
                return thrIFDS;
            }
        });
        return executor;
    }

    protected String getDebugName() {
        return "FAST IFDS SOLVER";
    }

    public void printStats() {
        if (logger.isDebugEnabled()) {
            if (this.ffCache != null) {
                this.ffCache.printStats();
            }
        } else {
            logger.info("No statistics were collected, as DEBUG is disabled.");
        }
    }

    public void setPredecessorShorteningMode(PredecessorShorteningMode mode) {
    }

    public void setMaxJoinPointAbstractions(int maxJoinPointAbstractions) {
        this.maxJoinPointAbstractions = maxJoinPointAbstractions;
    }

    public void setMemoryManager(IMemoryManager<D, N> memoryManager) {
        this.memoryManager = memoryManager;
    }

    public IMemoryManager<D, N> getMemoryManager() {
        return this.memoryManager;
    }

    @Override
    public void forceTerminate(ISolverTerminationReason reason) {
        this.killFlag = reason;
        this.executor.interrupt();
        this.executor.shutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.killFlag != null || this.executor.isFinished();
    }

    @Override
    public boolean isKilled() {
        return this.killFlag != null;
    }

    @Override
    public void reset() {
        this.killFlag = null;
    }

    @Override
    public void addStatusListener(IMemoryBoundedSolver.IMemoryBoundedSolverStatusNotification listener) {
        this.notificationListeners.add(listener);
    }

    @Override
    public ISolverTerminationReason getTerminationReason() {
        return this.killFlag;
    }

    public void setMaxCalleesPerCallSite(int maxCalleesPerCallSite) {
        this.maxCalleesPerCallSite = maxCalleesPerCallSite;
    }

    public void setMaxAbstractionPathLength(int maxAbstractionPathLength) {
        this.maxAbstractionPathLength = maxAbstractionPathLength;
    }

    private class PathEdgeProcessingTask
    implements Runnable {
        private final PathEdge<N, D> edge;
        private final boolean solverId;

        public PathEdgeProcessingTask(PathEdge<N, D> edge, boolean solverId) {
            this.edge = edge;
            this.solverId = solverId;
        }

        @Override
        public void run() {
            if (IFDSSolver.this.icfg.isCallStmt(this.edge.getTarget())) {
                IFDSSolver.this.processCall(this.edge);
            } else {
                if (IFDSSolver.this.icfg.isExitStmt(this.edge.getTarget())) {
                    IFDSSolver.this.processExit(this.edge);
                }
                if (!IFDSSolver.this.icfg.getSuccsOf(this.edge.getTarget()).isEmpty()) {
                    IFDSSolver.this.processNormalFlow(this.edge);
                }
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.edge == null ? 0 : this.edge.hashCode());
            result = 31 * result + (this.solverId ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PathEdgeProcessingTask other = (PathEdgeProcessingTask)obj;
            if (this.edge == null ? other.edge != null : !this.edge.equals(other.edge)) {
                return false;
            }
            return this.solverId == other.solverId;
        }
    }
}

