/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.solver.executors;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import soot.jimple.infoflow.solver.executors.InterruptableExecutor;

public class SetPoolExecutor
extends InterruptableExecutor {
    protected Set<Runnable> waiting = Collections.newSetFromMap(new ConcurrentHashMap());

    public SetPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    @Override
    public void execute(Runnable command) {
        if (this.waiting.add(command)) {
            super.execute(command);
        }
    }

    protected void afterExecute(Runnable r, Throwable t) {
        this.waiting.remove(r);
        super.afterExecute(r, t);
    }

    @Override
    public void interrupt() {
        super.interrupt();
        this.waiting.clear();
    }

    public void shutdown() {
        super.shutdown();
        this.waiting.clear();
    }

    public List<Runnable> shutdownNow() {
        List tasks = super.shutdownNow();
        this.waiting.clear();
        return tasks;
    }
}

