/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.results.xml;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import soot.jimple.infoflow.results.InfoflowPerformanceData;
import soot.jimple.infoflow.results.xml.SerializedAccessPath;
import soot.jimple.infoflow.results.xml.SerializedInfoflowResults;
import soot.jimple.infoflow.results.xml.SerializedPathElement;
import soot.jimple.infoflow.results.xml.SerializedSinkInfo;
import soot.jimple.infoflow.results.xml.SerializedSourceInfo;

public class InfoflowResultsReader {
    /*
     * Loose catch block
     */
    public SerializedInfoflowResults readResults(String fileName) throws XMLStreamException, IOException {
        SerializedInfoflowResults results = new SerializedInfoflowResults();
        InfoflowPerformanceData perfData = null;
        try (XMLStreamReader reader = null;){
            try (FileInputStream in = new FileInputStream(fileName);){
                reader = XMLInputFactory.newInstance().createXMLStreamReader(in);
                String statement = null;
                String method = null;
                String apValue = null;
                String apValueType = null;
                boolean apTaintSubFields = false;
                ArrayList<String> apFields = new ArrayList<String>();
                ArrayList<String> apTypes = new ArrayList<String>();
                SerializedAccessPath ap = null;
                SerializedSinkInfo sink = null;
                SerializedSourceInfo source = null;
                ArrayList<SerializedPathElement> pathElements = new ArrayList<SerializedPathElement>();
                Stack<State> stateStack = new Stack<State>();
                stateStack.push(State.init);
                while (reader.hasNext()) {
                    reader.next();
                    if (!reader.hasName()) continue;
                    if (reader.getLocalName().equals("DataFlowResults") && reader.isStartElement() && stateStack.peek() == State.init) {
                        stateStack.push(State.dataFlowResults);
                        results.setFileFormatVersion(this.int2Str(this.getAttributeByName(reader, "FileFormatVersion")));
                        continue;
                    }
                    if (reader.getLocalName().equals("Results") && reader.isStartElement() && stateStack.peek() == State.dataFlowResults) {
                        stateStack.push(State.results);
                        continue;
                    }
                    if (reader.getLocalName().equals("Result") && reader.isStartElement() && stateStack.peek() == State.results) {
                        stateStack.push(State.result);
                        continue;
                    }
                    if (reader.getLocalName().equals("Sink") && reader.isStartElement() && stateStack.peek() == State.result) {
                        stateStack.push(State.sink);
                        statement = this.getAttributeByName(reader, "Statement");
                        continue;
                    }
                    if (reader.getLocalName().equals("AccessPath") && reader.isStartElement()) {
                        stateStack.push(State.accessPath);
                        apValue = this.getAttributeByName(reader, "Value");
                        apValueType = this.getAttributeByName(reader, "Type");
                        apTaintSubFields = this.getAttributeByName(reader, "TaintSubFields").equals("true");
                        apFields.clear();
                        apTypes.clear();
                        continue;
                    }
                    if (reader.getLocalName().equals("Fields") && reader.isStartElement() && stateStack.peek() == State.accessPath) {
                        stateStack.push(State.fields);
                        continue;
                    }
                    if (reader.getLocalName().equals("Field") && reader.isStartElement() && stateStack.peek() == State.fields) {
                        stateStack.push(State.field);
                        String value = this.getAttributeByName(reader, "Value");
                        String type = this.getAttributeByName(reader, "Type");
                        if (value == null || value.isEmpty() || type == null || type.isEmpty()) continue;
                        apFields.add(value);
                        apTypes.add(value);
                        continue;
                    }
                    if (reader.getLocalName().equals("Sources") && reader.isStartElement() && stateStack.peek() == State.result) {
                        stateStack.push(State.sources);
                        continue;
                    }
                    if (reader.getLocalName().equals("Source") && reader.isStartElement() && stateStack.peek() == State.sources) {
                        stateStack.push(State.source);
                        statement = this.getAttributeByName(reader, "Statement");
                        method = this.getAttributeByName(reader, "Method");
                        continue;
                    }
                    if (reader.getLocalName().equals("TaintPath") && reader.isStartElement() && stateStack.peek() == State.source) {
                        stateStack.push(State.taintPath);
                        pathElements.clear();
                        continue;
                    }
                    if (reader.getLocalName().equals("PathElement") && reader.isStartElement() && stateStack.peek() == State.source) {
                        stateStack.push(State.taintPath);
                        statement = this.getAttributeByName(reader, "Statement");
                        method = this.getAttributeByName(reader, "Method");
                        continue;
                    }
                    if (reader.getLocalName().equals("PerformanceData") && reader.isStartElement() && stateStack.peek() == State.dataFlowResults) {
                        stateStack.push(State.performanceData);
                        continue;
                    }
                    if (reader.getLocalName().equals("PerformanceEntry") && reader.isStartElement() && stateStack.peek() == State.performanceData) {
                        stateStack.push(State.performanceEntry);
                        if (perfData == null) {
                            perfData = results.getOrCreatePerformanceData();
                        }
                        String perfName = this.getAttributeByName(reader, "Name");
                        String perfValue = this.getAttributeByName(reader, "Value");
                        switch (perfName) {
                            case "CallgraphConstructionSeconds": {
                                perfData.setCallgraphConstructionSeconds(Integer.parseInt(perfValue));
                                break;
                            }
                            case "PathReconstructionSeconds": {
                                perfData.setPathReconstructionSeconds(Integer.parseInt(perfValue));
                                break;
                            }
                            case "TaintPropagationSeconds": {
                                perfData.setTaintPropagationSeconds(Integer.parseInt(perfValue));
                                break;
                            }
                            case "TotalRuntimeSeconds": {
                                perfData.setTotalRuntimeSeconds(Integer.parseInt(perfValue));
                                break;
                            }
                            case "MaxMemoryConsumption": {
                                perfData.setMaxMemoryConsumption(Integer.parseInt(perfValue));
                                break;
                            }
                            case "SourceCount": {
                                perfData.setSourceCount(Integer.parseInt(perfValue));
                                break;
                            }
                            case "SinkCount": {
                                perfData.setSinkCount(Integer.parseInt(perfValue));
                            }
                        }
                        continue;
                    }
                    if (!reader.isEndElement()) continue;
                    stateStack.pop();
                    if (reader.getLocalName().equals("AccessPath")) {
                        ap = new SerializedAccessPath(apValue, apValueType, apTaintSubFields, apFields.toArray(new String[apFields.size()]), apTypes.toArray(new String[apTypes.size()]));
                        continue;
                    }
                    if (reader.getLocalName().equals("Sink")) {
                        sink = new SerializedSinkInfo(ap, statement, method);
                        continue;
                    }
                    if (reader.getLocalName().equals("Source")) {
                        source = new SerializedSourceInfo(ap, statement, method, pathElements);
                        continue;
                    }
                    if (reader.getLocalName().equals("Result")) {
                        results.addResult(source, sink);
                        continue;
                    }
                    if (!reader.getLocalName().equals("PathElement")) continue;
                    pathElements.add(new SerializedPathElement(ap, statement, method));
                }
                SerializedInfoflowResults serializedInfoflowResults = results;
                return serializedInfoflowResults;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    private int int2Str(String value) {
        if (value == null || value.isEmpty()) {
            return -1;
        }
        return Integer.valueOf(value);
    }

    private String getAttributeByName(XMLStreamReader reader, String id) {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            if (!reader.getAttributeLocalName(i).equals(id)) continue;
            return reader.getAttributeValue(i);
        }
        return "";
    }

    private static enum State {
        init,
        dataFlowResults,
        results,
        result,
        fields,
        field,
        sources,
        source,
        sink,
        taintPath,
        pathElement,
        accessPath,
        performanceData,
        performanceEntry;

    }
}

