/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems.rules;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import soot.Local;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.IfStmt;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.collect.ConcurrentHashSet;
import soot.jimple.infoflow.collect.MyConcurrentHashMap;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AbstractionAtSink;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.problems.TaintPropagationResults;
import soot.jimple.infoflow.problems.rules.AbstractTaintPropagationRule;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.sourcesSinks.manager.SinkInfo;
import soot.jimple.infoflow.util.ByReferenceBoolean;

public class ImplicitPropagtionRule
extends AbstractTaintPropagationRule {
    private final MyConcurrentHashMap<Unit, Set<Abstraction>> implicitTargets = new MyConcurrentHashMap();

    public ImplicitPropagtionRule(InfoflowManager manager, Abstraction zeroValue, TaintPropagationResults results) {
        super(manager, zeroValue, results);
    }

    @Override
    public Collection<Abstraction> propagateNormalFlow(Abstraction d1, Abstraction source, Stmt stmt, Stmt destStmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        if (source == this.getZeroValue()) {
            return null;
        }
        if (this.leavesConditionalBranch(stmt, source, killAll)) {
            return null;
        }
        if (!source.isAbstractionActive()) {
            return null;
        }
        if (source.getAccessPath().isEmpty()) {
            return null;
        }
        HashSet<Value> values = new HashSet<Value>();
        if (this.getManager().getICFG().isExceptionalEdgeBetween((Unit)stmt, (Unit)destStmt)) {
            for (ValueBox box : stmt.getUseBoxes()) {
                values.add(box.getValue());
            }
        } else {
            Value condition;
            if (stmt instanceof IfStmt) {
                condition = ((IfStmt)stmt).getCondition();
            } else if (stmt instanceof LookupSwitchStmt) {
                condition = ((LookupSwitchStmt)stmt).getKey();
            } else if (stmt instanceof TableSwitchStmt) {
                condition = ((TableSwitchStmt)stmt).getKey();
            } else {
                return null;
            }
            if (condition instanceof Local) {
                values.add(condition);
            } else {
                for (ValueBox box : condition.getUseBoxes()) {
                    values.add(box.getValue());
                }
            }
        }
        HashSet<Abstraction> res = null;
        for (Value val : values) {
            IInfoflowCFG.UnitContainer postdom;
            if (!this.getAliasing().mayAlias(val, (Value)source.getAccessPath().getPlainValue()) || (postdom = this.getManager().getICFG().getPostdominatorOf((Unit)stmt)).getMethod() == null && source.getTopPostdominator() != null && this.getManager().getICFG().getMethodOf(postdom.getUnit()) == source.getTopPostdominator().getMethod()) continue;
            Abstraction newAbs = source.deriveConditionalAbstractionEnter(postdom, stmt);
            if (res == null) {
                res = new HashSet<Abstraction>();
            }
            res.add(newAbs);
            break;
        }
        return res;
    }

    private boolean leavesConditionalBranch(Stmt stmt, Abstraction source, ByReferenceBoolean killAll) {
        if (source.isTopPostdominator((Unit)stmt) && (source = source.dropTopPostdominator()).getAccessPath().isEmpty() && source.getTopPostdominator() == null) {
            if (killAll != null) {
                killAll.value = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public Collection<Abstraction> propagateCallFlow(Abstraction d1, Abstraction source, Stmt stmt, SootMethod dest, ByReferenceBoolean killAll) {
        if (source == this.getZeroValue()) {
            return null;
        }
        if (this.leavesConditionalBranch(stmt, source, killAll)) {
            return null;
        }
        if (this.implicitTargets.containsKey(stmt) && (d1 == null || ((Set)this.implicitTargets.get(stmt)).contains(d1))) {
            if (killAll != null) {
                killAll.value = true;
            }
            return null;
        }
        if (source.getAccessPath().isEmpty()) {
            if (d1 != null) {
                Set callSites = this.implicitTargets.putIfAbsentElseGet((Unit)stmt, new ConcurrentHashSet());
                callSites.add(d1);
            }
            Abstraction abs = source.deriveConditionalAbstractionCall((Unit)stmt);
            return Collections.singleton(abs);
        }
        if (source.getTopPostdominator() != null) {
            if (killAll != null) {
                killAll.value = true;
            }
            return null;
        }
        return null;
    }

    @Override
    public Collection<Abstraction> propagateCallToReturnFlow(Abstraction d1, Abstraction source, Stmt stmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        if (source == this.getZeroValue()) {
            return null;
        }
        if (this.leavesConditionalBranch(stmt, source, killAll)) {
            return null;
        }
        if (source.isAbstractionActive()) {
            if (source.getAccessPath().isEmpty() || source.getTopPostdominator() != null) {
                SinkInfo sinkInfo = this.getManager().getSourceSinkManager().getSinkInfo(stmt, this.getManager(), null);
                if (sinkInfo != null) {
                    this.getResults().addResult(new AbstractionAtSink(sinkInfo.getDefinition(), source, stmt));
                }
            } else {
                SinkInfo sinkInfo;
                SootMethod curMethod = (SootMethod)this.getManager().getICFG().getMethodOf(stmt);
                if (!curMethod.isStatic() && source.getAccessPath().getFirstField() == null && this.getAliasing().mayAlias((Value)curMethod.getActiveBody().getThisLocal(), (Value)source.getAccessPath().getPlainValue()) && (sinkInfo = this.getManager().getSourceSinkManager().getSinkInfo(stmt, this.getManager(), null)) != null) {
                    this.getResults().addResult(new AbstractionAtSink(sinkInfo.getDefinition(), source, stmt));
                }
            }
        }
        if (stmt instanceof DefinitionStmt) {
            boolean implicitTaint;
            boolean bl = implicitTaint = source.getTopPostdominator() != null && source.getTopPostdominator().getUnit() != null;
            if (implicitTaint |= source.getAccessPath().isEmpty()) {
                Value leftVal = ((DefinitionStmt)stmt).getLeftOp();
                if ((d1 == null || d1.getAccessPath().isEmpty()) && !(leftVal instanceof FieldRef)) {
                    return null;
                }
                Abstraction abs = source.deriveNewAbstraction(this.getManager().getAccessPathFactory().createAccessPath(leftVal, true), stmt);
                return Collections.singleton(abs);
            }
        }
        return null;
    }

    @Override
    public Collection<Abstraction> propagateReturnFlow(Collection<Abstraction> callerD1s, Abstraction source, Stmt returnStmt, Stmt retSite, Stmt callSite, ByReferenceBoolean killAll) {
        boolean callerD1sConditional = false;
        for (Abstraction d1 : callerD1s) {
            if (!d1.getAccessPath().isEmpty()) continue;
            callerD1sConditional = true;
            break;
        }
        if (source.getAccessPath().isEmpty()) {
            if (returnStmt instanceof ReturnStmt && ((ReturnStmt)returnStmt).getOp() instanceof Constant && callSite instanceof DefinitionStmt) {
                DefinitionStmt def = (DefinitionStmt)callSite;
                AccessPath ap = this.getManager().getAccessPathFactory().copyWithNewValue(source.getAccessPath(), def.getLeftOp());
                Abstraction abs = source.deriveNewAbstraction(ap, returnStmt);
                HashSet<Abstraction> res = new HashSet<Abstraction>();
                res.add(abs);
                if (this.manager.getAliasing().canHaveAliases((Stmt)def, def.getLeftOp(), abs) && !callerD1sConditional) {
                    for (Abstraction d1 : callerD1s) {
                        this.getAliasing().computeAliases(d1, returnStmt, def.getLeftOp(), res, (SootMethod)this.getManager().getICFG().getMethodOf(callSite), abs);
                    }
                }
                return res;
            }
            killAll.value = true;
            return null;
        }
        if (returnStmt instanceof ReturnStmt && callSite instanceof DefinitionStmt) {
            boolean insideConditional;
            DefinitionStmt defnStmt = (DefinitionStmt)callSite;
            Value leftOp = defnStmt.getLeftOp();
            boolean bl = insideConditional = source.getTopPostdominator() != null || source.getAccessPath().isEmpty();
            if (insideConditional && leftOp instanceof FieldRef) {
                AccessPath ap = this.getManager().getAccessPathFactory().copyWithNewValue(source.getAccessPath(), leftOp);
                Abstraction abs = source.deriveNewAbstraction(ap, returnStmt);
                if (abs.isImplicit() && abs.getAccessPath().isFieldRef() && !callerD1sConditional) {
                    HashSet<Abstraction> res = new HashSet<Abstraction>();
                    res.add(abs);
                    for (Abstraction d1 : callerD1s) {
                        this.getAliasing().computeAliases(d1, callSite, leftOp, res, (SootMethod)this.getManager().getICFG().getMethodOf(callSite), abs);
                    }
                }
                return Collections.singleton(abs);
            }
        }
        return null;
    }
}

