/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems;

import heros.InterproceduralCFG;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.DefinitionStmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.collect.ConcurrentHashSet;
import soot.jimple.infoflow.collect.MyConcurrentHashMap;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.handlers.TaintPropagationHandler;
import soot.jimple.infoflow.nativeCallHandler.INativeCallHandler;
import soot.jimple.infoflow.solver.IInfoflowSolver;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.infoflow.util.SystemClassHandler;
import soot.jimple.toolkits.ide.DefaultJimpleIFDSTabulationProblem;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;

public abstract class AbstractInfoflowProblem
extends DefaultJimpleIFDSTabulationProblem<Abstraction, BiDiInterproceduralCFG<Unit, SootMethod>> {
    protected final InfoflowManager manager;
    protected final Map<Unit, Set<Abstraction>> initialSeeds = new HashMap<Unit, Set<Abstraction>>();
    protected ITaintPropagationWrapper taintWrapper;
    protected INativeCallHandler ncHandler;
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected Abstraction zeroValue = null;
    protected IInfoflowSolver solver = null;
    protected TaintPropagationHandler taintPropagationHandler = null;
    private MyConcurrentHashMap<Unit, Set<Unit>> activationUnitsToCallSites = new MyConcurrentHashMap();

    public AbstractInfoflowProblem(InfoflowManager manager) {
        super((InterproceduralCFG)manager.getICFG());
        this.manager = manager;
    }

    public void setSolver(IInfoflowSolver solver) {
        this.solver = solver;
    }

    public void setZeroValue(Abstraction zeroValue) {
        this.zeroValue = zeroValue;
    }

    public boolean followReturnsPastSeeds() {
        return true;
    }

    public void setTaintWrapper(ITaintPropagationWrapper wrapper) {
        this.taintWrapper = wrapper;
    }

    public void setNativeCallHandler(INativeCallHandler handler) {
        this.ncHandler = handler;
    }

    protected boolean isInitialMethod(SootMethod sm) {
        for (Unit u : this.initialSeeds.keySet()) {
            if (this.interproceduralCFG().getMethodOf(u) != sm) continue;
            return true;
        }
        return false;
    }

    public Map<Unit, Set<Abstraction>> initialSeeds() {
        return this.initialSeeds;
    }

    public boolean autoAddZero() {
        return false;
    }

    protected boolean isCallSiteActivatingTaint(Unit callSite, Unit activationUnit) {
        if (!this.manager.getConfig().getFlowSensitiveAliasing()) {
            return false;
        }
        if (activationUnit == null) {
            return false;
        }
        Set callSites = (Set)this.activationUnitsToCallSites.get(activationUnit);
        return callSites != null && callSites.contains(callSite);
    }

    protected boolean registerActivationCallSite(Unit callSite, SootMethod callee, Abstraction activationAbs) {
        if (!this.manager.getConfig().getFlowSensitiveAliasing()) {
            return false;
        }
        Unit activationUnit = activationAbs.getActivationUnit();
        if (activationUnit == null) {
            return false;
        }
        Set callSites = this.activationUnitsToCallSites.putIfAbsentElseGet(activationUnit, new ConcurrentHashSet());
        if (callSites.contains(callSite)) {
            return false;
        }
        if (!activationAbs.isAbstractionActive() && !callee.getActiveBody().getUnits().contains((Object)activationUnit)) {
            boolean found = false;
            for (Unit au : callSites) {
                if (!callee.getActiveBody().getUnits().contains((Object)au)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        return callSites.add(callSite);
    }

    public void setActivationUnitsToCallSites(AbstractInfoflowProblem other) {
        this.activationUnitsToCallSites = other.activationUnitsToCallSites;
    }

    public IInfoflowCFG interproceduralCFG() {
        return (IInfoflowCFG)super.interproceduralCFG();
    }

    public void addInitialSeeds(Unit unit, Set<Abstraction> seeds) {
        if (this.initialSeeds.containsKey(unit)) {
            this.initialSeeds.get(unit).addAll(seeds);
        } else {
            this.initialSeeds.put(unit, new HashSet<Abstraction>(seeds));
        }
    }

    public boolean hasInitialSeeds() {
        return !this.initialSeeds.isEmpty();
    }

    public Map<Unit, Set<Abstraction>> getInitialSeeds() {
        return this.initialSeeds;
    }

    public void setTaintPropagationHandler(TaintPropagationHandler handler) {
        this.taintPropagationHandler = handler;
    }

    public Abstraction createZeroValue() {
        if (this.zeroValue == null) {
            this.zeroValue = Abstraction.getZeroAbstraction(this.manager.getConfig().getFlowSensitiveAliasing());
        }
        return this.zeroValue;
    }

    protected Abstraction getZeroValue() {
        return this.zeroValue;
    }

    protected boolean isExceptionHandler(Unit u) {
        if (u instanceof DefinitionStmt) {
            DefinitionStmt defStmt = (DefinitionStmt)u;
            return defStmt.getRightOp() instanceof CaughtExceptionRef;
        }
        return false;
    }

    protected Set<Abstraction> notifyOutFlowHandlers(Unit stmt, Abstraction d1, Abstraction incoming, Set<Abstraction> outgoing, TaintPropagationHandler.FlowFunctionType functionType) {
        if (this.taintPropagationHandler != null && outgoing != null && !outgoing.isEmpty()) {
            outgoing = this.taintPropagationHandler.notifyFlowOut(stmt, d1, incoming, outgoing, this.manager, functionType);
        }
        return outgoing;
    }

    public boolean computeValues() {
        return false;
    }

    public InfoflowManager getManager() {
        return this.manager;
    }

    protected boolean isExcluded(SootMethod sm) {
        SootClass declClass;
        if (sm.hasTag("fd_essential_method")) {
            return false;
        }
        if (this.manager.getConfig().getExcludeSootLibraryClasses() && (declClass = sm.getDeclaringClass()) != null && declClass.isLibraryClass()) {
            return true;
        }
        return this.manager.getConfig().getIgnoreFlowsInSystemPackages() && (declClass = sm.getDeclaringClass()) != null && SystemClassHandler.v().isClassInSystemPackage(declClass.getName());
    }
}

