/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.memory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.infoflow.memory.IMemoryBoundedSolver;
import soot.jimple.infoflow.memory.ISolversTerminatedCallback;
import soot.jimple.infoflow.memory.reasons.TimeoutReason;
import soot.jimple.infoflow.results.InfoflowResults;

public class FlowDroidTimeoutWatcher
implements IMemoryBoundedSolver.IMemoryBoundedSolverStatusNotification {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final long timeout;
    private final InfoflowResults results;
    private final Map<IMemoryBoundedSolver, SolverState> solvers = new ConcurrentHashMap<IMemoryBoundedSolver, SolverState>();
    private boolean stopped = false;
    private ISolversTerminatedCallback terminationCallback = null;

    public FlowDroidTimeoutWatcher(long timeout) {
        this.timeout = timeout;
        this.results = null;
    }

    public FlowDroidTimeoutWatcher(long timeout, InfoflowResults res) {
        this.timeout = timeout;
        this.results = res;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void addSolver(IMemoryBoundedSolver solver) {
        this.solvers.put(solver, SolverState.IDLE);
        solver.addStatusListener(this);
    }

    public void start() {
        final long startTime = System.currentTimeMillis();
        this.logger.info("FlowDroid timeout watcher started");
        this.stopped = false;
        new Thread(new Runnable(){

            @Override
            public void run() {
                boolean allTerminated = this.isTerminated();
                long timeElapsed = 0L;
                while (!FlowDroidTimeoutWatcher.this.stopped && (timeElapsed = System.currentTimeMillis() - startTime) < 1000L * FlowDroidTimeoutWatcher.this.timeout && !(allTerminated = this.isTerminated())) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!FlowDroidTimeoutWatcher.this.stopped & !allTerminated) {
                    FlowDroidTimeoutWatcher.this.logger.warn("Timeout reached, stopping the solvers...");
                    if (FlowDroidTimeoutWatcher.this.results != null) {
                        FlowDroidTimeoutWatcher.this.results.addException("Timeout reached");
                    }
                    TimeoutReason reason = new TimeoutReason(timeElapsed / 1000L, FlowDroidTimeoutWatcher.this.timeout);
                    for (IMemoryBoundedSolver solver : FlowDroidTimeoutWatcher.this.solvers.keySet()) {
                        solver.forceTerminate(reason);
                    }
                    if (FlowDroidTimeoutWatcher.this.terminationCallback != null) {
                        FlowDroidTimeoutWatcher.this.terminationCallback.onSolversTerminated();
                    }
                }
                FlowDroidTimeoutWatcher.this.logger.info("FlowDroid timeout watcher terminated");
            }

            private boolean isTerminated() {
                boolean allTerminated = true;
                for (IMemoryBoundedSolver solver : FlowDroidTimeoutWatcher.this.solvers.keySet()) {
                    if (FlowDroidTimeoutWatcher.this.solvers.get(solver) == SolverState.DONE && solver.isTerminated()) continue;
                    allTerminated = false;
                    break;
                }
                return allTerminated;
            }
        }, "FlowDroid Timeout Watcher").start();
    }

    public void stop() {
        this.stopped = true;
    }

    public void reset() {
        this.stopped = false;
        for (IMemoryBoundedSolver solver : this.solvers.keySet()) {
            this.solvers.put(solver, SolverState.IDLE);
        }
    }

    @Override
    public void notifySolverStarted(IMemoryBoundedSolver solver) {
        this.solvers.put(solver, SolverState.RUNNING);
    }

    @Override
    public void notifySolverTerminated(IMemoryBoundedSolver solver) {
        this.solvers.put(solver, SolverState.DONE);
    }

    public void setTerminationCallback(ISolversTerminatedCallback terminationCallback) {
        this.terminationCallback = terminationCallback;
    }

    private static enum SolverState {
        IDLE,
        RUNNING,
        DONE;

    }
}

