/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.entryPointCreators;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import soot.Local;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.Jimple;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.entryPointCreators.BaseEntryPointCreator;
import soot.jimple.infoflow.util.SootMethodRepresentationParser;

public class SequentialEntryPointCreator
extends BaseEntryPointCreator {
    private final Collection<String> methodsToCall;

    public SequentialEntryPointCreator(Collection<String> methodsToCall) {
        this.methodsToCall = methodsToCall;
    }

    @Override
    public Collection<String> getRequiredClasses() {
        return SootMethodRepresentationParser.v().parseClassNames(this.methodsToCall, false).keySet();
    }

    @Override
    protected SootMethod createDummyMainInternal() {
        HashMap<String, Set<String>> classMap = SootMethodRepresentationParser.v().parseClassNames(this.methodsToCall, false);
        for (String className : classMap.keySet()) {
            SootClass createdClass = Scene.v().forceResolve(className, 3);
            createdClass.setApplicationClass();
            Local localVal = this.generateClassConstructor(createdClass);
            if (localVal == null) {
                this.logger.warn("Cannot generate constructor for class: {}", (Object)createdClass);
                continue;
            }
            for (String method : (Set)classMap.get(className)) {
                SootMethodAndClass methodAndClass = SootMethodRepresentationParser.v().parseSootMethodString(method);
                SootMethod methodToInvoke = this.findMethod(Scene.v().getSootClass(methodAndClass.getClassName()), methodAndClass.getSubSignature());
                if (methodToInvoke == null) {
                    this.logger.warn("Method %s not found, skipping", (Object)methodAndClass);
                    continue;
                }
                if (!methodToInvoke.isConcrete() || methodToInvoke.isConstructor()) continue;
                methodToInvoke.retrieveActiveBody();
                this.buildMethodCall(methodToInvoke, localVal);
            }
        }
        this.body.getUnits().add((Unit)Jimple.v().newReturnVoidStmt());
        return this.mainMethod;
    }

    @Override
    public Collection<SootMethod> getAdditionalMethods() {
        return null;
    }

    @Override
    public Collection<SootField> getAdditionalFields() {
        return null;
    }
}

