/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data.pathBuilders;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AbstractionAtSink;
import soot.jimple.infoflow.data.pathBuilders.ConcurrentAbstractionPathBuilder;
import soot.jimple.infoflow.solver.executors.InterruptableExecutor;

public class ContextInsensitiveSourceFinder
extends ConcurrentAbstractionPathBuilder {
    private int lastTaskId = 0;
    private int numTasks = 0;

    public ContextInsensitiveSourceFinder(InfoflowManager manager, InterruptableExecutor executor) {
        this(manager, executor, -1);
    }

    public ContextInsensitiveSourceFinder(InfoflowManager manager, InterruptableExecutor executor, int numTasks) {
        super(manager, executor);
        this.numTasks = numTasks;
    }

    @Override
    protected boolean triggerComputationForNeighbors() {
        return false;
    }

    @Override
    protected Runnable getTaintPathTask(AbstractionAtSink abs) {
        return new SourceFindingTask(this.lastTaskId++, abs, abs.getAbstraction());
    }

    @Override
    public void runIncrementalPathCompuation() {
    }

    @Override
    public void computeTaintPaths(Set<AbstractionAtSink> res) {
        this.numTasks = this.numTasks < 0 ? res.size() : (this.numTasks += res.size());
        super.computeTaintPaths(res);
    }

    private class SourceFindingTask
    implements Runnable {
        private final int taskId;
        private final AbstractionAtSink flagAbs;
        private final List<Abstraction> abstractionQueue = new LinkedList<Abstraction>();

        public SourceFindingTask(int taskId, AbstractionAtSink flagAbs, Abstraction abstraction) {
            this.taskId = taskId;
            this.flagAbs = flagAbs;
            this.abstractionQueue.add(abstraction);
            abstraction.registerPathFlag(taskId, ContextInsensitiveSourceFinder.this.numTasks);
        }

        @Override
        public void run() {
            while (!this.abstractionQueue.isEmpty()) {
                if (ContextInsensitiveSourceFinder.this.isKilled()) {
                    this.abstractionQueue.clear();
                    return;
                }
                Abstraction abstraction = this.abstractionQueue.remove(0);
                if (abstraction.getSourceContext() != null) {
                    ContextInsensitiveSourceFinder.this.results.addResult(this.flagAbs.getSinkDefinition(), this.flagAbs.getAbstraction().getAccessPath(), this.flagAbs.getSinkStmt(), abstraction.getSourceContext().getDefinition(), abstraction.getSourceContext().getAccessPath(), abstraction.getSourceContext().getStmt(), abstraction.getSourceContext().getUserData(), null);
                    assert (abstraction.getPredecessor() == null);
                } else if (abstraction.getPredecessor().registerPathFlag(this.taskId, ContextInsensitiveSourceFinder.this.numTasks)) {
                    this.abstractionQueue.add(abstraction.getPredecessor());
                }
                if (abstraction.getNeighbors() == null) continue;
                for (Abstraction nb : abstraction.getNeighbors()) {
                    if (!nb.registerPathFlag(this.taskId, ContextInsensitiveSourceFinder.this.numTasks)) continue;
                    this.abstractionQueue.add(nb);
                }
            }
        }
    }
}

