/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data;

import java.util.ArrayList;
import java.util.List;
import soot.SootMethod;
import soot.Type;

public class SootMethodAndClass {
    private final String methodName;
    private final String className;
    private final String returnType;
    private final List<String> parameters;
    private String subSignature = null;
    private String signature = null;
    private int hashCode = 0;

    public SootMethodAndClass(String methodName, String className, String returnType, List<String> parameters) {
        this.methodName = methodName;
        this.className = className;
        this.returnType = returnType;
        this.parameters = parameters;
    }

    public SootMethodAndClass(String methodName, String className, String returnType, String parameters) {
        this.methodName = methodName;
        this.className = className;
        this.returnType = returnType;
        this.parameters = new ArrayList<String>();
        if (parameters != null && !parameters.isEmpty()) {
            String[] params;
            for (String s : params = parameters.split(",")) {
                this.parameters.add(s);
            }
        }
    }

    public SootMethodAndClass(SootMethod sm) {
        this.methodName = sm.getName();
        this.className = sm.getDeclaringClass().getName();
        this.returnType = sm.getReturnType().toString();
        this.parameters = new ArrayList<String>();
        for (Type p : sm.getParameterTypes()) {
            this.parameters.add(p.toString());
        }
    }

    public SootMethodAndClass(SootMethodAndClass methodAndClass) {
        this.methodName = methodAndClass.methodName;
        this.className = methodAndClass.className;
        this.returnType = methodAndClass.returnType;
        this.parameters = new ArrayList<String>(methodAndClass.parameters);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public String getSubSignature() {
        if (this.subSignature != null) {
            return this.subSignature;
        }
        StringBuilder sb = new StringBuilder(10 + this.returnType.length() + this.methodName.length() + this.parameters.size() * 30);
        if (!this.returnType.isEmpty()) {
            sb.append(this.returnType);
            sb.append(" ");
        }
        sb.append(this.methodName);
        sb.append("(");
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.parameters.get(i).trim());
        }
        sb.append(")");
        this.subSignature = sb.toString();
        return this.subSignature;
    }

    public String getSignature() {
        if (this.signature != null) {
            return this.signature;
        }
        StringBuilder sb = new StringBuilder(10 + this.className.length() + this.returnType.length() + this.methodName.length() + this.parameters.size() * 30);
        sb.append("<");
        sb.append(this.className);
        sb.append(": ");
        if (!this.returnType.isEmpty()) {
            sb.append(this.returnType);
            sb.append(" ");
        }
        sb.append(this.methodName);
        sb.append("(");
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.parameters.get(i).trim());
        }
        sb.append(")>");
        this.signature = sb.toString();
        return this.signature;
    }

    public boolean equals(Object another) {
        if (super.equals(another)) {
            return true;
        }
        if (!(another instanceof SootMethodAndClass)) {
            return false;
        }
        SootMethodAndClass otherMethod = (SootMethodAndClass)another;
        if (!this.methodName.equals(otherMethod.methodName)) {
            return false;
        }
        if (!this.parameters.equals(otherMethod.parameters)) {
            return false;
        }
        return this.className.equals(otherMethod.className);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.methodName.hashCode() + this.className.hashCode() * 5;
        }
        return this.hashCode + this.parameters.hashCode() * 7;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(this.className);
        sb.append(": ");
        sb.append(this.returnType);
        sb.append(" ");
        sb.append(this.methodName);
        sb.append("(");
        boolean isFirst = true;
        for (String param : this.parameters) {
            if (!isFirst) {
                sb.append(",");
            }
            sb.append(param);
            isFirst = false;
        }
        sb.append(")>");
        return sb.toString();
    }
}

