/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.Local;
import soot.PrimType;
import soot.RefLikeType;
import soot.RefType;
import soot.SootField;
import soot.Type;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.StaticFieldRef;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.collect.ConcurrentHashSet;
import soot.jimple.infoflow.collect.MyConcurrentHashMap;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.util.TypeUtils;

public class AccessPathFactory {
    protected static final Logger logger = LoggerFactory.getLogger(AccessPathFactory.class);
    private final InfoflowConfiguration config;
    private MyConcurrentHashMap<Type, Set<BasePair>> baseRegister = new MyConcurrentHashMap();

    public AccessPathFactory(InfoflowConfiguration config) {
        this.config = config;
    }

    public AccessPath createAccessPath(Value val, boolean taintSubFields) {
        return this.createAccessPath(val, null, null, null, taintSubFields, false, true, AccessPath.ArrayTaintType.ContentsAndLength);
    }

    public AccessPath createAccessPath(Value val, Type valType, boolean taintSubFields, AccessPath.ArrayTaintType arrayTaintType) {
        return this.createAccessPath(val, null, valType, null, taintSubFields, false, true, arrayTaintType);
    }

    public AccessPath createAccessPath(Value val, SootField[] appendingFields, boolean taintSubFields) {
        return this.createAccessPath(val, appendingFields, null, null, taintSubFields, false, true, AccessPath.ArrayTaintType.ContentsAndLength);
    }

    public AccessPath createAccessPath(Value val, SootField[] appendingFields, Type valType, Type[] appendingFieldTypes, boolean taintSubFields, boolean cutFirstField, boolean reduceBases, AccessPath.ArrayTaintType arrayTaintType) {
        return this.createAccessPath(val, appendingFields, valType, appendingFieldTypes, taintSubFields, cutFirstField, reduceBases, arrayTaintType, false);
    }

    public AccessPath createAccessPath(Value val, SootField[] appendingFields, Type valType, Type[] appendingFieldTypes, boolean taintSubFields, boolean cutFirstField, boolean reduceBases, AccessPath.ArrayTaintType arrayTaintType, boolean canHaveImmutableAliases) {
        boolean cutOffApproximation;
        ArrayType at;
        Type[] newTypes;
        Type[] fieldTypes;
        SootField[] fields;
        Type baseType;
        Local value;
        FieldRef ref;
        if (val != null && !AccessPath.canContainValue(val)) {
            logger.error(String.format("Access paths cannot be rooted in values of type %s", val.getClass().getName()));
            return null;
        }
        if (val == null && (appendingFields == null || appendingFields.length == 0)) {
            return null;
        }
        InfoflowConfiguration.AccessPathConfiguration accessPathConfig = this.config.getAccessPathConfiguration();
        if (!this.config.getEnableTypeChecking()) {
            valType = null;
            appendingFieldTypes = null;
        }
        if (appendingFields != null && appendingFieldTypes == null) {
            appendingFieldTypes = new Type[appendingFields.length];
            for (int i = 0; i < appendingFields.length; ++i) {
                appendingFieldTypes[i] = appendingFields[i].getType();
            }
        }
        if (val instanceof FieldRef) {
            ref = (FieldRef)val;
            if (val instanceof InstanceFieldRef) {
                InstanceFieldRef iref = (InstanceFieldRef)val;
                value = (Local)iref.getBase();
                baseType = value.getType();
            } else {
                value = null;
                baseType = null;
            }
            fields = new SootField[(appendingFields == null ? 0 : appendingFields.length) + 1];
            fields[0] = ref.getField();
            if (appendingFields != null) {
                System.arraycopy(appendingFields, 0, fields, 1, appendingFields.length);
            }
            fieldTypes = new Type[(appendingFieldTypes == null ? 0 : appendingFieldTypes.length) + 1];
            Type type = fieldTypes[0] = valType != null ? valType : fields[0].getType();
            if (appendingFieldTypes != null) {
                System.arraycopy(appendingFieldTypes, 0, fieldTypes, 1, appendingFieldTypes.length);
            }
        } else if (val instanceof ArrayRef) {
            ref = (ArrayRef)val;
            value = (Local)ref.getBase();
            baseType = valType == null ? value.getType() : valType;
            fields = appendingFields == null ? null : Arrays.copyOf(appendingFields, appendingFields.length);
            fieldTypes = appendingFieldTypes == null ? null : Arrays.copyOf(appendingFieldTypes, appendingFieldTypes.length);
        } else {
            value = (Local)val;
            baseType = valType == null ? (value == null ? null : value.getType()) : valType;
            fields = appendingFields == null ? null : Arrays.copyOf(appendingFields, appendingFields.length);
            Type[] typeArray = fieldTypes = appendingFieldTypes == null ? null : Arrays.copyOf(appendingFieldTypes, appendingFieldTypes.length);
        }
        if (accessPathConfig.getAccessPathLength() == 0) {
            fields = null;
            fieldTypes = null;
        }
        if (cutFirstField && fields != null && fields.length > 0) {
            SootField[] newFields = new SootField[fields.length - 1];
            Type[] newTypes2 = new Type[newFields.length];
            System.arraycopy(fields, 1, newFields, 0, newFields.length);
            System.arraycopy(fieldTypes, 1, newTypes2, 0, newTypes2.length);
            fields = newFields.length > 0 ? newFields : null;
            Object object = fieldTypes = newTypes2.length > 0 ? newTypes2 : null;
        }
        if (this.config.getAccessPathConfiguration().getUseSameFieldReduction() && fields != null && fields.length > 1) {
            for (int bucketStart = fields.length - 2; bucketStart >= 0; --bucketStart) {
                int repeatPos = -1;
                for (int i = bucketStart + 1; i < fields.length; ++i) {
                    if (fields[i] != fields[bucketStart]) continue;
                    repeatPos = i;
                    break;
                }
                int repeatLen = repeatPos - bucketStart;
                if (repeatPos < 0) continue;
                boolean matches = true;
                for (int i = 0; i < repeatPos - bucketStart; ++i) {
                    matches &= repeatPos + i < fields.length && fields[bucketStart + i] == fields[repeatPos + i];
                }
                if (!matches) continue;
                SootField[] newFields = new SootField[fields.length - repeatLen];
                newTypes = new Type[fields.length - repeatLen];
                System.arraycopy(fields, 0, newFields, 0, bucketStart + 1);
                System.arraycopy(fields, repeatPos + 1, newFields, bucketStart + 1, fields.length - repeatPos - 1);
                fields = newFields;
                System.arraycopy(fieldTypes, 0, newTypes, 0, bucketStart + 1);
                System.arraycopy(fieldTypes, repeatPos + 1, newTypes, bucketStart + 1, fieldTypes.length - repeatPos - 1);
                fieldTypes = newTypes;
                break;
            }
        }
        if (this.config.getEnableTypeChecking()) {
            if (value != null && value.getType() != baseType) {
                if ((baseType = TypeUtils.getMorePreciseType(baseType, value.getType())) == null) {
                    return null;
                }
                if (fields != null && fields.length > 0 && !(baseType instanceof ArrayType)) {
                    baseType = TypeUtils.getMorePreciseType(baseType, (Type)fields[0].getDeclaringClass().getType());
                }
                if (baseType == null) {
                    return null;
                }
            }
            if (fields != null && fieldTypes != null) {
                for (int i = 0; i < fields.length; ++i) {
                    fieldTypes[i] = TypeUtils.getMorePreciseType(fieldTypes[i], fields[i].getType());
                    if (fieldTypes[i] == null) {
                        return null;
                    }
                    if (fields.length > i + 1 && !(fieldTypes[i] instanceof ArrayType)) {
                        fieldTypes[i] = TypeUtils.getMorePreciseType(fieldTypes[i], (Type)fields[i + 1].getDeclaringClass().getType());
                    }
                    if (fieldTypes[i] != null) continue;
                    return null;
                }
            }
        }
        if (value != null && value.getType() instanceof ArrayType && !((at = (ArrayType)value.getType()).getArrayElementType() instanceof RefLikeType) && fields != null && fields.length > 0) {
            return null;
        }
        if (accessPathConfig.getUseThisChainReduction() && reduceBases && fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().startsWith("this$")) continue;
                String outerClassName = ((RefType)fields[i].getType()).getClassName();
                int startIdx = -1;
                if (value != null && value.getType() instanceof RefType && ((RefType)value.getType()).getClassName().equals(outerClassName)) {
                    startIdx = 0;
                } else {
                    for (int j = 0; j < i; ++j) {
                        if (!(fields[j].getType() instanceof RefType) || !((RefType)fields[j].getType()).getClassName().equals(outerClassName)) continue;
                        startIdx = j;
                        break;
                    }
                }
                if (startIdx < 0) continue;
                SootField[] newFields = new SootField[fields.length - (i - startIdx) - 1];
                Type[] newFieldTypes = new Type[fieldTypes.length - (i - startIdx) - 1];
                System.arraycopy(fields, 0, newFields, 0, startIdx);
                System.arraycopy(fieldTypes, 0, newFieldTypes, 0, startIdx);
                System.arraycopy(fields, i + 1, newFields, startIdx, fields.length - i - 1);
                System.arraycopy(fieldTypes, i + 1, newFieldTypes, startIdx, fieldTypes.length - i - 1);
                fields = newFields;
                fieldTypes = newFieldTypes;
                break;
            }
        }
        boolean recursiveCutOff = false;
        if (accessPathConfig.getUseRecursiveAccessPaths() && reduceBases && fields != null) {
            int ei;
            int n = ei = val instanceof StaticFieldRef ? 1 : 0;
            while (ei < fields.length) {
                Type eiType = ei == 0 ? baseType : fieldTypes[ei - 1];
                int ej = ei;
                while (ej < fields.length) {
                    if (fieldTypes[ej] == eiType || fields[ej].getType() == eiType) {
                        SootField[] newFields = new SootField[fields.length - (ej - ei) - 1];
                        newTypes = new Type[newFields.length];
                        System.arraycopy(fields, 0, newFields, 0, ei);
                        System.arraycopy(fieldTypes, 0, newTypes, 0, ei);
                        if (fields.length > ej) {
                            System.arraycopy(fields, ej + 1, newFields, ei, fields.length - ej - 1);
                            System.arraycopy(fieldTypes, ej + 1, newTypes, ei, fieldTypes.length - ej - 1);
                        }
                        SootField[] base = new SootField[ej - ei + 1];
                        Type[] baseTypes = new Type[ej - ei + 1];
                        System.arraycopy(fields, ei, base, 0, base.length);
                        System.arraycopy(fieldTypes, ei, baseTypes, 0, base.length);
                        this.registerBase(eiType, base, baseTypes);
                        fields = newFields;
                        fieldTypes = newTypes;
                        recursiveCutOff = true;
                        continue;
                    }
                    ++ej;
                }
                ++ei;
            }
        }
        if (fields != null) {
            int maxAccessPathLength = accessPathConfig.getAccessPathLength();
            if (maxAccessPathLength >= 0) {
                int fieldNum = Math.min(maxAccessPathLength, fields.length);
                if (fields.length > fieldNum) {
                    taintSubFields = true;
                    cutOffApproximation = true;
                } else {
                    cutOffApproximation = recursiveCutOff;
                }
                if (fieldNum == 0) {
                    fields = null;
                    fieldTypes = null;
                } else {
                    SootField[] newFields = new SootField[fieldNum];
                    Type[] newFieldTypes = new Type[fieldNum];
                    System.arraycopy(fields, 0, newFields, 0, fieldNum);
                    System.arraycopy(fieldTypes, 0, newFieldTypes, 0, fieldNum);
                    fields = newFields;
                    fieldTypes = newFieldTypes;
                }
            } else {
                cutOffApproximation = recursiveCutOff;
            }
        } else {
            cutOffApproximation = false;
            fields = null;
            fieldTypes = null;
        }
        assert (value == null || baseType instanceof ArrayType || TypeUtils.isObjectLikeType(baseType) || !(value.getType() instanceof ArrayType));
        assert (value == null || !(baseType instanceof ArrayType) || value.getType() instanceof ArrayType || TypeUtils.isObjectLikeType(value.getType())) : "Type mismatch. Type was " + baseType + ", value was: " + (value == null ? null : value.getType());
        if (fields == null && fieldTypes != null || fields != null && fieldTypes == null) {
            throw new RuntimeException("When there are fields, there must be field types and vice versa");
        }
        if (fields != null && fields.length != fieldTypes.length) {
            throw new RuntimeException("Field and field type arrays must be of equal length");
        }
        if (baseType instanceof PrimType && fields != null) {
            logger.warn("Primitive types cannot have fields");
            return null;
        }
        if (fields != null) {
            for (int i = 0; i < fields.length - 2; ++i) {
                if (!(fields[i].getType() instanceof PrimType)) continue;
                logger.warn("Primitive types cannot have fields");
                return null;
            }
        }
        return new AccessPath(value, fields, baseType, fieldTypes, taintSubFields, cutOffApproximation, arrayTaintType, canHaveImmutableAliases);
    }

    private void registerBase(Type eiType, SootField[] base, Type[] baseTypes) {
        assert (base.length == baseTypes.length);
        for (int i = 0; i < base.length; ++i) {
            if (baseTypes[i] != eiType) continue;
            SootField[] newBase = new SootField[i + 1];
            Type[] newTypes = new Type[i + 1];
            System.arraycopy(base, 0, newBase, 0, i + 1);
            System.arraycopy(baseTypes, 0, newTypes, 0, i + 1);
            base = newBase;
            baseTypes = newTypes;
            break;
        }
        Set bases = this.baseRegister.putIfAbsentElseGet(eiType, new ConcurrentHashSet());
        bases.add(new BasePair(base, baseTypes));
    }

    public Collection<BasePair> getBaseForType(Type tp) {
        return (Collection)this.baseRegister.get(tp);
    }

    public AccessPath copyWithNewValue(AccessPath original, Value val) {
        return this.copyWithNewValue(original, val, original.getBaseType(), false);
    }

    public AccessPath copyWithNewValue(AccessPath original, Value val, Type newType, boolean cutFirstField) {
        return this.copyWithNewValue(original, val, newType, cutFirstField, true);
    }

    public AccessPath copyWithNewValue(AccessPath original, Value val, Type newType, boolean cutFirstField, boolean reduceBases) {
        return this.copyWithNewValue(original, val, newType, cutFirstField, reduceBases, original.getArrayTaintType());
    }

    public AccessPath copyWithNewValue(AccessPath original, Value val, Type newType, boolean cutFirstField, boolean reduceBases, AccessPath.ArrayTaintType arrayTaintType) {
        if (original.getPlainValue() != null && original.getPlainValue().equals(val) && original.getBaseType().equals(newType) && original.getArrayTaintType() == arrayTaintType) {
            return original;
        }
        AccessPath newAP = this.createAccessPath(val, original.getFields(), newType, original.getFieldTypes(), original.getTaintSubFields(), cutFirstField, reduceBases, arrayTaintType, original.getCanHaveImmutableAliases());
        if (newAP != null && newAP.equals(original)) {
            return original;
        }
        return newAP;
    }

    public AccessPath merge(AccessPath ap1, AccessPath ap2) {
        return this.appendFields(ap1, ap2.getFields(), ap2.getFieldTypes(), ap2.getTaintSubFields());
    }

    public AccessPath appendFields(AccessPath original, SootField[] apFields, Type[] apFieldTypes, boolean taintSubFields) {
        int offset = original.getFields() == null ? 0 : original.getFields().length;
        SootField[] fields = new SootField[offset + (apFields == null ? 0 : apFields.length)];
        Type[] fieldTypes = new Type[offset + (apFields == null ? 0 : apFields.length)];
        if (original.getFields() != null) {
            System.arraycopy(original.getFields(), 0, fields, 0, original.getFields().length);
            System.arraycopy(original.getFieldTypes(), 0, fieldTypes, 0, original.getFieldTypes().length);
        }
        if (apFields != null && apFields.length > 0) {
            System.arraycopy(apFields, 0, fields, offset, apFields.length);
            System.arraycopy(apFieldTypes, 0, fieldTypes, offset, apFieldTypes.length);
        }
        return this.createAccessPath((Value)original.getPlainValue(), fields, original.getBaseType(), fieldTypes, taintSubFields, false, true, original.getArrayTaintType());
    }

    public static class BasePair {
        private final SootField[] fields;
        private final Type[] types;
        private int hashCode = 0;

        private BasePair(SootField[] fields, Type[] types) {
            this.fields = fields;
            this.types = types;
            if (fields == null || fields.length == 0) {
                throw new RuntimeException("A base must contain at least one field");
            }
        }

        public SootField[] getFields() {
            return this.fields;
        }

        public Type[] getTypes() {
            return this.types;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int prime = 31;
                int result = 1;
                result = 31 * result + Arrays.hashCode(this.fields);
                this.hashCode = result = 31 * result + Arrays.hashCode(this.types);
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BasePair other = (BasePair)obj;
            if (!Arrays.equals(this.fields, other.fields)) {
                return false;
            }
            return Arrays.equals(this.types, other.types);
        }

        public String toString() {
            return Arrays.toString(this.fields);
        }
    }
}

