/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.collect;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;

public class ConcurrentCountingMap<T>
implements ConcurrentMap<T, Integer> {
    private final ConcurrentMap<T, AtomicInteger> map;
    private final ReentrantLock lock = new ReentrantLock();
    private LockingMode lockingMode = LockingMode.NoLocking;
    private AtomicInteger changeCounter = new AtomicInteger();

    public ConcurrentCountingMap() {
        this.map = new ConcurrentHashMap<T, AtomicInteger>();
    }

    public ConcurrentCountingMap(int size) {
        this.map = new ConcurrentHashMap<T, AtomicInteger>(size);
    }

    public ConcurrentCountingMap(Map<T, AtomicInteger> map) {
        this.map = new ConcurrentHashMap<T, AtomicInteger>(map);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Integer) {
            AtomicInteger i = new AtomicInteger((Integer)value);
            return this.map.containsValue(i);
        }
        return false;
    }

    @Override
    public Integer get(Object key) {
        AtomicInteger i = (AtomicInteger)this.map.get(key);
        return i == null ? 0 : i.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer put(T key, Integer value) {
        try {
            switch (this.lockingMode) {
                case Fast: {
                    if (!this.lock.isLocked()) break;
                    this.lock.lock();
                    break;
                }
                case Safe: {
                    this.lock.lock();
                }
            }
            AtomicInteger old = this.map.put(key, value == null ? null : new AtomicInteger(value));
            this.changeCounter.incrementAndGet();
            Integer n = old == null ? 0 : old.get();
            return n;
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer remove(Object key) {
        try {
            switch (this.lockingMode) {
                case Fast: {
                    if (!this.lock.isLocked()) break;
                    this.lock.lock();
                    break;
                }
                case Safe: {
                    this.lock.lock();
                }
            }
            AtomicInteger old = (AtomicInteger)this.map.remove(key);
            this.changeCounter.incrementAndGet();
            Integer n = old == null ? 0 : old.get();
            return n;
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends T, ? extends Integer> m) {
        try {
            switch (this.lockingMode) {
                case Fast: {
                    if (!this.lock.isLocked()) break;
                    this.lock.lock();
                    break;
                }
                case Safe: {
                    this.lock.lock();
                }
            }
            Iterator<T> iterator = m.keySet().iterator();
            while (iterator.hasNext()) {
                T t;
                Integer i = m.get(t = iterator.next());
                this.map.put(t, i == null ? null : new AtomicInteger(i));
                this.changeCounter.incrementAndGet();
            }
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void clear() {
        try {
            switch (this.lockingMode) {
                case Fast: {
                    if (!this.lock.isLocked()) break;
                    this.lock.lock();
                    break;
                }
                case Safe: {
                    this.lock.lock();
                }
            }
            this.map.clear();
            this.changeCounter.incrementAndGet();
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    @Override
    public Set<T> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Integer> values() {
        return this.map.values().stream().map(i -> i == null ? 0 : i.get()).collect(Collectors.toSet());
    }

    @Override
    public Set<Map.Entry<T, Integer>> entrySet() {
        return this.map.entrySet().stream().map(e -> new Entry((Map.Entry)e)).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer putIfAbsent(T key, Integer value) {
        try {
            switch (this.lockingMode) {
                case Fast: {
                    if (!this.lock.isLocked()) break;
                    this.lock.lock();
                    break;
                }
                case Safe: {
                    this.lock.lock();
                }
            }
            AtomicInteger i = this.map.computeIfAbsent(key, k -> new AtomicInteger(value));
            if (i == null) {
                this.changeCounter.incrementAndGet();
                Integer n = 0;
                return n;
            }
            Integer n = i.get();
            return n;
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        try {
            switch (this.lockingMode) {
                case Fast: {
                    if (!this.lock.isLocked()) break;
                    this.lock.lock();
                    break;
                }
                case Safe: {
                    this.lock.lock();
                }
            }
            if (value instanceof Integer) {
                boolean res = this.map.remove(key, new AtomicInteger((Integer)value));
                this.changeCounter.incrementAndGet();
                boolean bl = res;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(T key, Integer oldValue, Integer newValue) {
        try {
            switch (this.lockingMode) {
                case Fast: {
                    if (!this.lock.isLocked()) break;
                    this.lock.lock();
                    break;
                }
                case Safe: {
                    this.lock.lock();
                }
            }
            if (oldValue == null || newValue == null) {
                boolean bl = false;
                return bl;
            }
            boolean res = this.map.replace(key, new AtomicInteger(oldValue), new AtomicInteger(newValue));
            this.changeCounter.incrementAndGet();
            boolean bl = res;
            return bl;
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer replace(T key, Integer value) {
        try {
            switch (this.lockingMode) {
                case Fast: {
                    if (!this.lock.isLocked()) break;
                    this.lock.lock();
                    break;
                }
                case Safe: {
                    this.lock.lock();
                }
            }
            if (value == null) {
                Integer n = null;
                return n;
            }
            AtomicInteger i = this.map.replace(key, new AtomicInteger(value));
            this.changeCounter.incrementAndGet();
            Integer n = i == null ? 0 : i.get();
            return n;
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int increment(T key) {
        try {
            switch (this.lockingMode) {
                case Fast: {
                    if (!this.lock.isLocked()) break;
                    this.lock.lock();
                    break;
                }
                case Safe: {
                    this.lock.lock();
                }
            }
            AtomicInteger i = this.map.computeIfAbsent(key, k -> new AtomicInteger(0));
            this.changeCounter.incrementAndGet();
            int n = i.incrementAndGet();
            return n;
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decrement(T key) {
        try {
            switch (this.lockingMode) {
                case Fast: {
                    if (!this.lock.isLocked()) break;
                    this.lock.lock();
                    break;
                }
                case Safe: {
                    this.lock.lock();
                }
            }
            AtomicInteger i = (AtomicInteger)this.map.get(key);
            if (i == null) {
                int n = 0;
                return n;
            }
            int res = i.decrementAndGet();
            this.changeCounter.incrementAndGet();
            int n = res;
            return n;
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    public Set<T> getByValue(int value) {
        HashSet set = new HashSet();
        for (Map.Entry e : this.map.entrySet()) {
            AtomicInteger atomicInt = (AtomicInteger)e.getValue();
            if (atomicInt == null || atomicInt.get() != value) continue;
            set.add(e.getKey());
        }
        return set;
    }

    public void setLockingMode(LockingMode lockingMode) {
        this.lockingMode = lockingMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentCountingMap<T> snapshot() {
        try {
            this.lock.lock();
            ConcurrentCountingMap snapshot = new ConcurrentCountingMap();
            for (Object key : this.map.keySet()) {
                snapshot.put(key, ((AtomicInteger)this.map.get(key)).get());
            }
            ConcurrentCountingMap concurrentCountingMap = snapshot;
            return concurrentCountingMap;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentCountingMap<T> snapshot(Collection<T> subset) {
        try {
            this.lock.lock();
            ConcurrentCountingMap<T> snapshot = new ConcurrentCountingMap<T>(subset.size());
            for (T key : subset) {
                AtomicInteger atomic = (AtomicInteger)this.map.get(key);
                if (atomic == null) continue;
                snapshot.put(key, atomic.get());
            }
            ConcurrentCountingMap<T> concurrentCountingMap = snapshot;
            return concurrentCountingMap;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getChangeCounter() {
        return this.changeCounter.get();
    }

    public class Entry
    implements Map.Entry<T, Integer> {
        private final Map.Entry<T, AtomicInteger> parentEntry;

        private Entry(Map.Entry<T, AtomicInteger> parentEntry) {
            this.parentEntry = parentEntry;
        }

        @Override
        public T getKey() {
            return this.parentEntry.getKey();
        }

        @Override
        public Integer getValue() {
            AtomicInteger i = this.parentEntry.getValue();
            return i == null ? 0 : i.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer setValue(Integer value) {
            try {
                switch (ConcurrentCountingMap.this.lockingMode) {
                    case Fast: {
                        if (!ConcurrentCountingMap.this.lock.isLocked()) break;
                        ConcurrentCountingMap.this.lock.lock();
                        break;
                    }
                    case Safe: {
                        ConcurrentCountingMap.this.lock.lock();
                    }
                }
                AtomicInteger i = this.parentEntry.setValue(new AtomicInteger(value));
                Integer n = i == null ? 0 : i.get();
                return n;
            }
            finally {
                if (ConcurrentCountingMap.this.lock.isHeldByCurrentThread()) {
                    ConcurrentCountingMap.this.lock.unlock();
                }
            }
        }
    }

    public static enum LockingMode {
        NoLocking,
        Fast,
        Safe;

    }
}

