/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.codeOptimization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import soot.MethodOrMethodContext;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.codeOptimization.ICodeOptimizer;
import soot.jimple.infoflow.codeOptimization.InterproceduralConstantValuePropagator;
import soot.jimple.infoflow.sourcesSinks.manager.ISourceSinkManager;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.infoflow.util.SystemClassHandler;
import soot.jimple.toolkits.scalar.ConditionalBranchFolder;
import soot.jimple.toolkits.scalar.ConstantPropagatorAndFolder;
import soot.jimple.toolkits.scalar.DeadAssignmentEliminator;
import soot.jimple.toolkits.scalar.UnreachableCodeEliminator;
import soot.util.queue.QueueReader;

public class DeadCodeEliminator
implements ICodeOptimizer {
    private InfoflowConfiguration config;

    @Override
    public void initialize(InfoflowConfiguration config) {
        this.config = config;
    }

    @Override
    public void run(InfoflowManager manager, Collection<SootMethod> entryPoints, ISourceSinkManager sourcesSinks, ITaintPropagationWrapper taintWrapper) {
        QueueReader rdr = Scene.v().getReachableMethods().listener();
        while (rdr.hasNext()) {
            MethodOrMethodContext sm = (MethodOrMethodContext)rdr.next();
            SootMethod method = sm.method();
            if (method == null || !method.hasActiveBody() || entryPoints.contains(method)) continue;
            List<Unit> callSites = DeadCodeEliminator.getCallsInMethod(method);
            ConstantPropagatorAndFolder.v().transform(method.getActiveBody());
            DeadAssignmentEliminator.v().transform(method.getActiveBody());
            DeadCodeEliminator.removeDeadCallgraphEdges(method, callSites);
        }
        InterproceduralConstantValuePropagator ipcvp = new InterproceduralConstantValuePropagator(manager, entryPoints, sourcesSinks, taintWrapper);
        ipcvp.setRemoveSideEffectFreeMethods(this.config.getCodeEliminationMode() == InfoflowConfiguration.CodeEliminationMode.RemoveSideEffectFreeCode && this.config.getImplicitFlowMode() != InfoflowConfiguration.ImplicitFlowMode.AllImplicitFlows);
        ipcvp.setExcludeSystemClasses(this.config.getIgnoreFlowsInSystemPackages());
        ipcvp.transform();
        QueueReader rdr2 = Scene.v().getReachableMethods().listener();
        while (rdr2.hasNext()) {
            MethodOrMethodContext sm = (MethodOrMethodContext)rdr2.next();
            SootMethod method = sm.method();
            if (method == null || !method.hasActiveBody() || this.config.getIgnoreFlowsInSystemPackages() && SystemClassHandler.v().isClassInSystemPackage(sm.method().getDeclaringClass().getName())) continue;
            ConditionalBranchFolder.v().transform(method.getActiveBody());
            List<Unit> callSites = DeadCodeEliminator.getCallsInMethod(method);
            UnreachableCodeEliminator.v().transform(method.getActiveBody());
            DeadCodeEliminator.removeDeadCallgraphEdges(method, callSites);
        }
    }

    static void removeDeadCallgraphEdges(SootMethod method, List<Unit> oldCallSites) {
        List<Unit> newCallSites = DeadCodeEliminator.getCallsInMethod(method);
        if (oldCallSites != null) {
            for (Unit u : oldCallSites) {
                if (newCallSites != null && newCallSites.contains(u)) continue;
                Scene.v().getCallGraph().removeAllEdgesOutOf(u);
            }
        }
    }

    static List<Unit> getCallsInMethod(SootMethod method) {
        ArrayList<Unit> callSites = null;
        for (Unit u : method.getActiveBody().getUnits()) {
            if (!((Stmt)u).containsInvokeExpr()) continue;
            if (callSites == null) {
                callSites = new ArrayList<Unit>();
            }
            callSites.add(u);
        }
        return callSites;
    }
}

