/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.cfg;

import java.util.Collections;
import soot.Body;
import soot.IntType;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.VoidType;
import soot.javaToJimple.LocalGenerator;
import soot.jimple.Constant;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NullConstant;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.infoflow.cfg.FlowDroidEssentialMethodTag;
import soot.tagkit.Tag;

public class LibraryClassPatcher {
    private final Constant stubConst = StringConstant.v((String)"Stub!");

    public void patchLibraries() {
        this.patchHandlerImplementation();
        this.patchThreadImplementation();
        this.patchActivityImplementation();
        this.patchTimerImplementation();
        this.patchActivityGetFragmentManager();
        this.patchMessageObtainImplementation();
    }

    private void patchMessageObtainImplementation() {
        SootMethod smObtain4;
        SootMethod smObtain3;
        SootMethod smObtain2;
        SootClass sc = Scene.v().getSootClassUnsafe("android.os.Message");
        if (sc == null || sc.resolvingLevel() < 2) {
            return;
        }
        sc.setLibraryClass();
        SootMethod smMessageConstructor = Scene.v().grabMethod("<android.os.Message: void <init>()>");
        if (smMessageConstructor == null) {
            return;
        }
        SootField tmp = sc.getFieldUnsafe("int what");
        if (tmp == null) {
            tmp = Scene.v().makeSootField("what", (Type)IntType.v());
            sc.addField(tmp);
        }
        final SootField fldWhat = tmp;
        tmp = sc.getFieldUnsafe("int arg1");
        if (tmp == null) {
            tmp = Scene.v().makeSootField("arg1", (Type)IntType.v());
            sc.addField(tmp);
        }
        final SootField fldArg1 = tmp;
        tmp = sc.getFieldUnsafe("int arg2");
        if (tmp == null) {
            tmp = Scene.v().makeSootField("arg2", (Type)IntType.v());
            sc.addField(tmp);
        }
        final SootField fldArg2 = tmp;
        tmp = sc.getFieldUnsafe("java.lang.Object obj");
        if (tmp == null) {
            tmp = Scene.v().makeSootField("obj", (Type)Scene.v().getObjectType());
            sc.addField(tmp);
        }
        final SootField fldObj = tmp;
        SootMethod smObtain1 = sc.getMethodUnsafe("android.os.Message obtain(android.os.Handler,int)");
        if (smObtain1 != null && (!smObtain1.hasActiveBody() || this.isStubImplementation(smObtain1.getActiveBody()))) {
            this.generateMessageObtainMethod(smObtain1, new IMessageObtainCodeInjector(){

                @Override
                public void injectCode(Body body, Local messageLocal) {
                    body.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)messageLocal, fldWhat.makeRef()), (Value)body.getParameterLocal(1)));
                }
            });
        }
        if ((smObtain2 = sc.getMethodUnsafe("android.os.Message obtain(android.os.Handler,int,int,int,java.lang.Object)")) != null && (!smObtain2.hasActiveBody() || this.isStubImplementation(smObtain2.getActiveBody()))) {
            this.generateMessageObtainMethod(smObtain2, new IMessageObtainCodeInjector(){

                @Override
                public void injectCode(Body body, Local messageLocal) {
                    body.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)messageLocal, fldWhat.makeRef()), (Value)body.getParameterLocal(1)));
                    body.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)messageLocal, fldArg1.makeRef()), (Value)body.getParameterLocal(2)));
                    body.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)messageLocal, fldArg2.makeRef()), (Value)body.getParameterLocal(3)));
                    body.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)messageLocal, fldObj.makeRef()), (Value)body.getParameterLocal(4)));
                }
            });
        }
        if ((smObtain3 = sc.getMethodUnsafe("android.os.Message obtain(android.os.Handler,int,int,int)")) != null && (!smObtain3.hasActiveBody() || this.isStubImplementation(smObtain3.getActiveBody()))) {
            this.generateMessageObtainMethod(smObtain3, new IMessageObtainCodeInjector(){

                @Override
                public void injectCode(Body body, Local messageLocal) {
                    body.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)messageLocal, fldWhat.makeRef()), (Value)body.getParameterLocal(1)));
                    body.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)messageLocal, fldArg1.makeRef()), (Value)body.getParameterLocal(2)));
                    body.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)messageLocal, fldArg2.makeRef()), (Value)body.getParameterLocal(3)));
                }
            });
        }
        if ((smObtain4 = sc.getMethodUnsafe("android.os.Message obtain(android.os.Handler,int,java.lang.Object)")) != null && (!smObtain4.hasActiveBody() || this.isStubImplementation(smObtain4.getActiveBody()))) {
            this.generateMessageObtainMethod(smObtain4, new IMessageObtainCodeInjector(){

                @Override
                public void injectCode(Body body, Local messageLocal) {
                    body.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)messageLocal, fldWhat.makeRef()), (Value)body.getParameterLocal(1)));
                    body.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)messageLocal, fldObj.makeRef()), (Value)body.getParameterLocal(2)));
                }
            });
        }
    }

    private void generateMessageObtainMethod(SootMethod sm, IMessageObtainCodeInjector injector) {
        RefType tpMessage = RefType.v((String)"android.os.Message");
        sm.getDeclaringClass().setLibraryClass();
        sm.setPhantom(false);
        sm.addTag((Tag)new FlowDroidEssentialMethodTag());
        JimpleBody body = Jimple.v().newBody(sm);
        sm.setActiveBody((Body)body);
        body.insertIdentityStmts();
        SootMethod smMessageConstructor = Scene.v().grabMethod("<android.os.Message: void <init>()>");
        LocalGenerator lg = new LocalGenerator((Body)body);
        Local messageLocal = lg.generateLocal((Type)tpMessage);
        body.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)messageLocal, (Value)Jimple.v().newNewExpr(tpMessage)));
        body.getUnits().add((Unit)Jimple.v().newInvokeStmt((Value)Jimple.v().newSpecialInvokeExpr(messageLocal, smMessageConstructor.makeRef())));
        if (injector != null) {
            injector.injectCode((Body)body, messageLocal);
        }
        body.getUnits().add((Unit)Jimple.v().newReturnStmt((Value)messageLocal));
    }

    private boolean isStubImplementation(Body body) {
        for (Unit u : body.getUnits()) {
            InvokeExpr iexpr;
            SootMethod targetMethod;
            Stmt stmt = (Stmt)u;
            if (!stmt.containsInvokeExpr() || !(targetMethod = (iexpr = stmt.getInvokeExpr()).getMethod()).isConstructor() || !targetMethod.getDeclaringClass().getName().equals("java.lang.RuntimeException") || iexpr.getArgCount() <= 0 || !iexpr.getArg(0).equals(this.stubConst)) continue;
            return true;
        }
        return false;
    }

    private void patchActivityImplementation() {
        SootClass scApplicationHolder = LibraryClassPatcher.createOrGetApplicationHolder();
        SootClass sc = Scene.v().getSootClassUnsafe("android.app.Activity");
        if (sc == null || sc.resolvingLevel() < 2 || scApplicationHolder == null) {
            return;
        }
        sc.setLibraryClass();
        SootMethod smRun = sc.getMethodUnsafe("android.app.Application getApplication()");
        if (smRun == null || smRun.hasActiveBody() && !this.isStubImplementation(smRun.getActiveBody())) {
            return;
        }
        smRun.setPhantom(false);
        smRun.addTag((Tag)new FlowDroidEssentialMethodTag());
        JimpleBody b = Jimple.v().newBody(smRun);
        smRun.setActiveBody((Body)b);
        Local thisLocal = Jimple.v().newLocal("this", (Type)sc.getType());
        b.getLocals().add((Object)thisLocal);
        b.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)thisLocal, (Value)Jimple.v().newThisRef(sc.getType())));
        SootFieldRef appStaticFieldRef = scApplicationHolder.getFieldByName("application").makeRef();
        Local targetLocal = Jimple.v().newLocal("retApplication", appStaticFieldRef.type());
        b.getLocals().add((Object)targetLocal);
        b.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)targetLocal, (Value)Jimple.v().newStaticFieldRef(appStaticFieldRef)));
        ReturnStmt retStmt = Jimple.v().newReturnStmt((Value)targetLocal);
        b.getUnits().add((Unit)retStmt);
        b.validate();
    }

    public static SootClass createOrGetApplicationHolder() {
        SootClass scApplicationHolder;
        SootClass scApplication = Scene.v().getSootClassUnsafe("android.app.Application");
        if (scApplication == null || scApplication.resolvingLevel() < 2) {
            return null;
        }
        String applicationHolderClassName = "il.ac.tau.MyApplicationHolder";
        if (!Scene.v().containsClass(applicationHolderClassName)) {
            scApplicationHolder = Scene.v().makeSootClass(applicationHolderClassName, 1);
            scApplicationHolder.setSuperclass(Scene.v().getSootClass("java.lang.Object"));
            Scene.v().addClass(scApplicationHolder);
            scApplicationHolder.addField(Scene.v().makeSootField("application", (Type)scApplication.getType(), 9));
            scApplicationHolder.validate();
        } else {
            scApplicationHolder = Scene.v().getSootClassUnsafe(applicationHolderClassName);
        }
        return scApplicationHolder;
    }

    private void patchThreadImplementation() {
        SootClass sc = Scene.v().getSootClassUnsafe("java.lang.Thread");
        if (sc == null || sc.resolvingLevel() < 2) {
            return;
        }
        sc.setLibraryClass();
        SootMethod smRun = sc.getMethodUnsafe("void run()");
        if (smRun == null || smRun.hasActiveBody() && !this.isStubImplementation(smRun.getActiveBody())) {
            return;
        }
        smRun.addTag((Tag)new FlowDroidEssentialMethodTag());
        SootMethod smCons = sc.getMethodUnsafe("void <init>(java.lang.Runnable)");
        if (smCons == null || smCons.hasActiveBody() && !this.isStubImplementation(smCons.getActiveBody())) {
            return;
        }
        smCons.addTag((Tag)new FlowDroidEssentialMethodTag());
        SootClass runnable = Scene.v().getSootClassUnsafe("java.lang.Runnable");
        if (runnable == null || runnable.resolvingLevel() < 2) {
            return;
        }
        int fieldIdx = 0;
        SootField fldTarget = null;
        while ((fldTarget = sc.getFieldByNameUnsafe("target" + fieldIdx)) != null) {
            ++fieldIdx;
        }
        fldTarget = Scene.v().makeSootField("target" + fieldIdx, (Type)runnable.getType());
        sc.addField(fldTarget);
        this.patchThreadConstructor(smCons, runnable, fldTarget);
        this.patchThreadRunMethod(smRun, runnable, fldTarget);
    }

    private void patchThreadRunMethod(SootMethod smRun, SootClass runnable, SootField fldTarget) {
        SootClass sc = smRun.getDeclaringClass();
        sc.setLibraryClass();
        smRun.setPhantom(false);
        JimpleBody b = Jimple.v().newBody(smRun);
        smRun.setActiveBody((Body)b);
        Local thisLocal = Jimple.v().newLocal("this", (Type)sc.getType());
        b.getLocals().add((Object)thisLocal);
        b.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)thisLocal, (Value)Jimple.v().newThisRef(sc.getType())));
        Local targetLocal = Jimple.v().newLocal("target", (Type)runnable.getType());
        b.getLocals().add((Object)targetLocal);
        b.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)targetLocal, (Value)Jimple.v().newInstanceFieldRef((Value)thisLocal, fldTarget.makeRef())));
        ReturnVoidStmt retStmt = Jimple.v().newReturnVoidStmt();
        b.getUnits().add((Unit)Jimple.v().newIfStmt((Value)Jimple.v().newEqExpr((Value)targetLocal, (Value)NullConstant.v()), (Unit)retStmt));
        b.getUnits().add((Unit)Jimple.v().newInvokeStmt((Value)Jimple.v().newInterfaceInvokeExpr(targetLocal, runnable.getMethod("void run()").makeRef())));
        b.getUnits().add((Unit)retStmt);
    }

    private void patchThreadConstructor(SootMethod smCons, SootClass runnable, SootField fldTarget) {
        SootClass sc = smCons.getDeclaringClass();
        sc.setLibraryClass();
        smCons.setPhantom(false);
        JimpleBody b = Jimple.v().newBody(smCons);
        smCons.setActiveBody((Body)b);
        Local thisLocal = Jimple.v().newLocal("this", (Type)sc.getType());
        b.getLocals().add((Object)thisLocal);
        b.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)thisLocal, (Value)Jimple.v().newThisRef(sc.getType())));
        Local param0Local = Jimple.v().newLocal("p0", (Type)runnable.getType());
        b.getLocals().add((Object)param0Local);
        b.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)param0Local, (Value)Jimple.v().newParameterRef((Type)runnable.getType(), 0)));
        b.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)thisLocal, fldTarget.makeRef()), (Value)param0Local));
        b.getUnits().add((Unit)Jimple.v().newReturnVoidStmt());
    }

    private void patchHandlerImplementation() {
        SootClass sc = Scene.v().getSootClassUnsafe("android.os.Handler");
        if (sc == null || sc.resolvingLevel() < 2) {
            return;
        }
        sc.setLibraryClass();
        SootClass runnable = Scene.v().getSootClassUnsafe("java.lang.Runnable");
        if (runnable == null || runnable.resolvingLevel() < 2) {
            return;
        }
        SootMethod smPost = sc.getMethodUnsafe("boolean post(java.lang.Runnable)");
        SootMethod smPostAtFrontOfQueue = sc.getMethodUnsafe("boolean postAtFrontOfQueue(java.lang.Runnable)");
        SootMethod smPostAtTimeWithToken = sc.getMethodUnsafe("boolean postAtTime(java.lang.Runnable,java.lang.Object,long)");
        SootMethod smPostAtTime = sc.getMethodUnsafe("boolean postAtTime(java.lang.Runnable,long)");
        SootMethod smPostDelayed = sc.getMethodUnsafe("boolean postDelayed(java.lang.Runnable,long)");
        SootMethod smDispatchMessage = sc.getMethodUnsafe("void dispatchMessage(android.os.Message)");
        if (smPost != null && (!smPost.hasActiveBody() || this.isStubImplementation(smPost.getActiveBody()))) {
            this.patchHandlerPostBody(smPost, runnable);
            smPost.addTag((Tag)new FlowDroidEssentialMethodTag());
        }
        if (smPostAtFrontOfQueue != null && (!smPostAtFrontOfQueue.hasActiveBody() || this.isStubImplementation(smPostAtFrontOfQueue.getActiveBody()))) {
            this.patchHandlerPostBody(smPostAtFrontOfQueue, runnable);
            smPostAtFrontOfQueue.addTag((Tag)new FlowDroidEssentialMethodTag());
        }
        if (smPostAtTime != null && (!smPostAtTime.hasActiveBody() || this.isStubImplementation(smPostAtTime.getActiveBody()))) {
            this.patchHandlerPostBody(smPostAtTime, runnable);
            smPostAtTime.addTag((Tag)new FlowDroidEssentialMethodTag());
        }
        if (smPostAtTimeWithToken != null && (!smPostAtTimeWithToken.hasActiveBody() || this.isStubImplementation(smPostAtTimeWithToken.getActiveBody()))) {
            this.patchHandlerPostBody(smPostAtTimeWithToken, runnable);
            smPostAtTimeWithToken.addTag((Tag)new FlowDroidEssentialMethodTag());
        }
        if (smPostDelayed != null && (!smPostDelayed.hasActiveBody() || this.isStubImplementation(smPostDelayed.getActiveBody()))) {
            this.patchHandlerPostBody(smPostDelayed, runnable);
            smPostDelayed.addTag((Tag)new FlowDroidEssentialMethodTag());
        }
        if (smDispatchMessage != null && (!smDispatchMessage.hasActiveBody() || this.isStubImplementation(smDispatchMessage.getActiveBody()))) {
            this.patchHandlerDispatchBody(smDispatchMessage);
            smDispatchMessage.addTag((Tag)new FlowDroidEssentialMethodTag());
        }
    }

    private Body patchHandlerDispatchBody(SootMethod method) {
        SootClass sc = method.getDeclaringClass();
        sc.setLibraryClass();
        method.setPhantom(false);
        JimpleBody b = Jimple.v().newBody(method);
        method.setActiveBody((Body)b);
        Local thisLocal = Jimple.v().newLocal("this", (Type)sc.getType());
        b.getLocals().add((Object)thisLocal);
        b.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)thisLocal, (Value)Jimple.v().newThisRef(sc.getType())));
        Local firstParam = null;
        for (int i = 0; i < method.getParameterCount(); ++i) {
            Local paramLocal = Jimple.v().newLocal("param" + i, method.getParameterType(i));
            b.getLocals().add((Object)paramLocal);
            b.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)paramLocal, (Value)Jimple.v().newParameterRef(method.getParameterType(i), i)));
            if (i != 0) continue;
            firstParam = paramLocal;
        }
        b.getUnits().add((Unit)Jimple.v().newInvokeStmt((Value)Jimple.v().newVirtualInvokeExpr(thisLocal, Scene.v().makeMethodRef(sc, "handleMessage", Collections.singletonList(method.getParameterType(0)), (Type)VoidType.v(), false), firstParam)));
        ReturnVoidStmt retStmt = Jimple.v().newReturnVoidStmt();
        b.getUnits().add((Unit)retStmt);
        b.validate();
        return b;
    }

    private Body patchHandlerPostBody(SootMethod method, SootClass runnable) {
        SootClass sc = method.getDeclaringClass();
        sc.setLibraryClass();
        method.setPhantom(false);
        JimpleBody b = Jimple.v().newBody(method);
        method.setActiveBody((Body)b);
        Local thisLocal = Jimple.v().newLocal("this", (Type)sc.getType());
        b.getLocals().add((Object)thisLocal);
        b.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)thisLocal, (Value)Jimple.v().newThisRef(sc.getType())));
        Local firstParam = null;
        for (int i = 0; i < method.getParameterCount(); ++i) {
            Local paramLocal = Jimple.v().newLocal("param" + i, method.getParameterType(i));
            b.getLocals().add((Object)paramLocal);
            b.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)paramLocal, (Value)Jimple.v().newParameterRef(method.getParameterType(i), i)));
            if (i != 0) continue;
            firstParam = paramLocal;
        }
        b.getUnits().add((Unit)Jimple.v().newInvokeStmt((Value)Jimple.v().newInterfaceInvokeExpr(firstParam, Scene.v().makeMethodRef(runnable, "run", Collections.emptyList(), (Type)VoidType.v(), false))));
        ReturnStmt retStmt = Jimple.v().newReturnStmt((Value)IntConstant.v((int)1));
        b.getUnits().add((Unit)retStmt);
        return b;
    }

    private void patchTimerImplementation() {
        SootMethod smSchedule6;
        SootMethod smSchedule5;
        SootMethod smSchedule4;
        SootMethod smSchedule3;
        SootMethod smSchedule2;
        SootClass sc = Scene.v().getSootClassUnsafe("java.util.Timer");
        if (sc == null || sc.resolvingLevel() < 2) {
            return;
        }
        sc.setLibraryClass();
        SootMethod smSchedule1 = sc.getMethodUnsafe("void schedule(java.util.TimerTask,long)");
        if (smSchedule1 != null && !smSchedule1.hasActiveBody()) {
            this.patchTimerScheduleMethod(smSchedule1);
            smSchedule1.addTag((Tag)new FlowDroidEssentialMethodTag());
        }
        if ((smSchedule2 = sc.getMethodUnsafe("void schedule(java.util.TimerTask,java.util.Date)")) != null && !smSchedule2.hasActiveBody()) {
            this.patchTimerScheduleMethod(smSchedule2);
            smSchedule2.addTag((Tag)new FlowDroidEssentialMethodTag());
        }
        if ((smSchedule3 = sc.getMethodUnsafe("void schedule(java.util.TimerTask,java.util.Date,long)")) != null && !smSchedule3.hasActiveBody()) {
            this.patchTimerScheduleMethod(smSchedule3);
            smSchedule3.addTag((Tag)new FlowDroidEssentialMethodTag());
        }
        if ((smSchedule4 = sc.getMethodUnsafe("void schedule(java.util.TimerTask,long,long)")) != null && !smSchedule4.hasActiveBody()) {
            this.patchTimerScheduleMethod(smSchedule4);
            smSchedule4.addTag((Tag)new FlowDroidEssentialMethodTag());
        }
        if ((smSchedule5 = sc.getMethodUnsafe("void scheduleAtFixedRate(java.util.TimerTask,java.util.Date,long)")) != null && !smSchedule5.hasActiveBody()) {
            this.patchTimerScheduleMethod(smSchedule5);
            smSchedule5.addTag((Tag)new FlowDroidEssentialMethodTag());
        }
        if ((smSchedule6 = sc.getMethodUnsafe("void scheduleAtFixedRate(java.util.TimerTask,long,long)")) != null && !smSchedule6.hasActiveBody()) {
            this.patchTimerScheduleMethod(smSchedule6);
            smSchedule6.addTag((Tag)new FlowDroidEssentialMethodTag());
        }
    }

    private void patchTimerScheduleMethod(SootMethod method) {
        SootClass sc = method.getDeclaringClass();
        sc.setLibraryClass();
        method.setPhantom(false);
        JimpleBody b = Jimple.v().newBody(method);
        method.setActiveBody((Body)b);
        Local thisLocal = Jimple.v().newLocal("this", (Type)sc.getType());
        b.getLocals().add((Object)thisLocal);
        b.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)thisLocal, (Value)Jimple.v().newThisRef(sc.getType())));
        Local firstParam = null;
        for (int i = 0; i < method.getParameterCount(); ++i) {
            Local paramLocal = Jimple.v().newLocal("param" + i, method.getParameterType(i));
            b.getLocals().add((Object)paramLocal);
            b.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)paramLocal, (Value)Jimple.v().newParameterRef(method.getParameterType(i), i)));
            if (i != 0) continue;
            firstParam = paramLocal;
        }
        SootMethod runMethod = Scene.v().grabMethod("<java.util.TimerTask: void run()>");
        if (runMethod != null) {
            InvokeStmt invokeStmt = Jimple.v().newInvokeStmt((Value)Jimple.v().newVirtualInvokeExpr(firstParam, runMethod.makeRef()));
            b.getUnits().add((Unit)invokeStmt);
        }
        b.getUnits().add((Unit)Jimple.v().newReturnVoidStmt());
    }

    private void patchActivityGetFragmentManager() {
        SootClass sc = Scene.v().getSootClassUnsafe("android.app.Activity");
        if (sc == null || sc.resolvingLevel() < 2) {
            return;
        }
        sc.setLibraryClass();
        SootMethod smGetFM = sc.getMethodUnsafe("android.app.FragmentManager getFragmentManager()");
        if (smGetFM == null || smGetFM.hasActiveBody()) {
            return;
        }
        JimpleBody b = Jimple.v().newBody(smGetFM);
        smGetFM.setActiveBody((Body)b);
        Local thisLocal = Jimple.v().newLocal("this", (Type)sc.getType());
        b.getLocals().add((Object)thisLocal);
        b.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)thisLocal, (Value)Jimple.v().newThisRef(sc.getType())));
        SootClass scFragmentTransaction = Scene.v().forceResolve("android.app.FragmentManager", 2);
        Local retLocal = Jimple.v().newLocal("retFragMan", (Type)Scene.v().getSootClassUnsafe("android.app.FragmentManager").getType());
        b.getLocals().add((Object)retLocal);
        b.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)retLocal, (Value)Jimple.v().newNewExpr(scFragmentTransaction.getType())));
        b.getUnits().add((Unit)Jimple.v().newReturnStmt((Value)retLocal));
    }

    private static interface IMessageObtainCodeInjector {
        public void injectCode(Body var1, Local var2);
    }
}

