/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.aliasing;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import heros.solver.IDESolver;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.Local;
import soot.PrimType;
import soot.RefLikeType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.IAliasingStrategy;
import soot.jimple.infoflow.aliasing.ImplicitFlowAliasStrategy;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.AccessPathFactory;
import soot.jimple.infoflow.util.TypeUtils;
import soot.jimple.toolkits.pointer.LocalMustAliasAnalysis;
import soot.jimple.toolkits.pointer.StrongLocalMustAliasAnalysis;
import soot.toolkits.graph.UnitGraph;

public class Aliasing {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IAliasingStrategy aliasingStrategy;
    private final IAliasingStrategy implicitFlowAliasingStrategy;
    private final InfoflowManager manager;
    private final Set<SootMethod> excludedFromMustAliasAnalysis = new HashSet<SootMethod>();
    protected final LoadingCache<SootMethod, LocalMustAliasAnalysis> strongAliasAnalysis = IDESolver.DEFAULT_CACHE_BUILDER.build((CacheLoader)new CacheLoader<SootMethod, LocalMustAliasAnalysis>(){

        public LocalMustAliasAnalysis load(SootMethod method) throws Exception {
            return new StrongLocalMustAliasAnalysis((UnitGraph)Aliasing.this.manager.getICFG().getOrCreateUnitGraph(method));
        }
    });

    public Aliasing(IAliasingStrategy aliasingStrategy, InfoflowManager manager) {
        this.aliasingStrategy = aliasingStrategy;
        this.implicitFlowAliasingStrategy = new ImplicitFlowAliasStrategy(manager);
        this.manager = manager;
    }

    public void computeAliases(Abstraction d1, Stmt src, Value targetValue, Set<Abstraction> taintSet, SootMethod method, Abstraction newAbs) {
        if (!Aliasing.canHaveAliases(newAbs.getAccessPath()) && !this.isStringConstructorCall(src)) {
            return;
        }
        if (!d1.getAccessPath().isEmpty()) {
            this.aliasingStrategy.computeAliasTaints(d1, src, targetValue, taintSet, method, newAbs);
        } else if (targetValue instanceof InstanceFieldRef) {
            this.implicitFlowAliasingStrategy.computeAliasTaints(d1, src, targetValue, taintSet, method, newAbs);
        }
    }

    private AccessPath getReferencedAPBase(AccessPath taintedAP, SootField[] referencedFields) {
        Collection<AccessPathFactory.BasePair> bases = taintedAP.isStaticFieldRef() ? this.manager.getAccessPathFactory().getBaseForType(taintedAP.getFirstFieldType()) : this.manager.getAccessPathFactory().getBaseForType(taintedAP.getBaseType());
        for (int fieldIdx = 0; fieldIdx < referencedFields.length; ++fieldIdx) {
            if (fieldIdx >= taintedAP.getFieldCount()) {
                if (taintedAP.getTaintSubFields()) {
                    return taintedAP;
                }
                return null;
            }
            if (taintedAP.getFields()[fieldIdx] == referencedFields[fieldIdx]) continue;
            if (!(bases == null || taintedAP.isStaticFieldRef() && fieldIdx == 0)) {
                for (AccessPathFactory.BasePair base : bases) {
                    if (base.getFields()[0] != referencedFields[fieldIdx]) continue;
                    SootField[] cutFields = new SootField[taintedAP.getFieldCount() + base.getFields().length];
                    Type[] cutFieldTypes = new Type[cutFields.length];
                    System.arraycopy(taintedAP.getFields(), 0, cutFields, 0, fieldIdx);
                    System.arraycopy(base.getFields(), 0, cutFields, fieldIdx, base.getFields().length);
                    System.arraycopy(taintedAP.getFields(), fieldIdx, cutFields, fieldIdx + base.getFields().length, taintedAP.getFieldCount() - fieldIdx);
                    System.arraycopy(taintedAP.getFieldTypes(), 0, cutFieldTypes, 0, fieldIdx);
                    System.arraycopy(base.getTypes(), 0, cutFieldTypes, fieldIdx, base.getTypes().length);
                    System.arraycopy(taintedAP.getFieldTypes(), fieldIdx, cutFieldTypes, fieldIdx + base.getTypes().length, taintedAP.getFieldCount() - fieldIdx);
                    return this.manager.getAccessPathFactory().createAccessPath((Value)taintedAP.getPlainValue(), cutFields, taintedAP.getBaseType(), cutFieldTypes, taintedAP.getTaintSubFields(), false, false, taintedAP.getArrayTaintType());
                }
            }
            return null;
        }
        return taintedAP;
    }

    public boolean mayAlias(Value val1, Value val2) {
        if (!AccessPath.canContainValue(val1) || !AccessPath.canContainValue(val2)) {
            return false;
        }
        if (val1 instanceof Constant || val2 instanceof Constant) {
            return false;
        }
        if (val1 == val2) {
            return true;
        }
        if (this.aliasingStrategy.isInteractive()) {
            return this.aliasingStrategy.mayAlias(this.manager.getAccessPathFactory().createAccessPath(val1, false), this.manager.getAccessPathFactory().createAccessPath(val2, false));
        }
        return false;
    }

    public AccessPath mayAlias(AccessPath ap, Value val) {
        SootField[] sootFieldArray;
        if (!AccessPath.canContainValue(val)) {
            return null;
        }
        if (val instanceof Constant) {
            return null;
        }
        if (this.aliasingStrategy.isInteractive()) {
            if (!this.aliasingStrategy.mayAlias(ap, this.manager.getAccessPathFactory().createAccessPath(val, true))) {
                return null;
            }
        } else {
            if (val instanceof Local && ap.getPlainValue() != val) {
                return null;
            }
            if (val instanceof ArrayRef && ap.getPlainValue() != ((ArrayRef)val).getBase()) {
                return null;
            }
            if (val instanceof InstanceFieldRef) {
                if (!ap.isLocal() && !ap.isInstanceFieldRef()) {
                    return null;
                }
                if (((InstanceFieldRef)val).getBase() != ap.getPlainValue()) {
                    return null;
                }
            }
        }
        if (val instanceof StaticFieldRef && !ap.isStaticFieldRef()) {
            return null;
        }
        if (val instanceof FieldRef) {
            SootField[] sootFieldArray2 = new SootField[1];
            sootFieldArray = sootFieldArray2;
            sootFieldArray2[0] = ((FieldRef)val).getField();
        } else {
            sootFieldArray = new SootField[]{};
        }
        SootField[] fields = sootFieldArray;
        return this.getReferencedAPBase(ap, fields);
    }

    public boolean mustAlias(SootField field1, SootField field2) {
        return field1 == field2;
    }

    public boolean mustAlias(Local val1, Local val2, Stmt position) {
        if (val1 == val2) {
            return true;
        }
        if (!(val1.getType() instanceof RefLikeType) || !(val2.getType() instanceof RefLikeType)) {
            return false;
        }
        SootMethod method = (SootMethod)this.manager.getICFG().getMethodOf(position);
        if (this.excludedFromMustAliasAnalysis.contains(method)) {
            return false;
        }
        if (this.manager.isAnalysisAborted()) {
            return false;
        }
        try {
            LocalMustAliasAnalysis lmaa = (LocalMustAliasAnalysis)this.strongAliasAnalysis.getUnchecked((Object)method);
            return lmaa.mustAlias(val1, position, val2, position);
        }
        catch (Exception ex) {
            this.logger.error("Error in local must alias analysis", (Throwable)ex);
            return false;
        }
    }

    public boolean canHaveAliases(Stmt stmt, Value val, Abstraction source) {
        if (stmt instanceof DefinitionStmt) {
            DefinitionStmt defStmt = (DefinitionStmt)stmt;
            if (defStmt.getLeftOp() instanceof Local && defStmt.getLeftOp() == source.getAccessPath().getPlainValue()) {
                return false;
            }
            if (val instanceof ArrayRef) {
                return true;
            }
            if (val instanceof FieldRef) {
                return true;
            }
        }
        if (val.getType() instanceof PrimType) {
            return false;
        }
        if (val instanceof Constant) {
            return false;
        }
        if (TypeUtils.isStringType(val.getType()) && !this.isStringConstructorCall(stmt) && !source.getAccessPath().getCanHaveImmutableAliases()) {
            return false;
        }
        return val instanceof FieldRef || val instanceof Local && ((Local)val).getType() instanceof ArrayType;
    }

    public boolean isStringConstructorCall(Stmt iStmt) {
        SootClass scString = Scene.v().getSootClassUnsafe("java.lang.String");
        Collection callees = this.manager.getICFG().getCalleesOfCallAt(iStmt);
        if (callees != null && !callees.isEmpty()) {
            for (SootMethod callee : callees) {
                if (callee.getDeclaringClass() != scString || !callee.isConstructor()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canHaveAliases(AccessPath ap) {
        if (TypeUtils.isStringType(ap.getBaseType()) && !ap.getCanHaveImmutableAliases()) {
            return false;
        }
        return !(ap.isStaticFieldRef() ? ap.getFirstFieldType() instanceof PrimType : ap.getBaseType() instanceof PrimType);
    }

    public static boolean baseMatches(Value baseValue, Abstraction source) {
        if (baseValue instanceof Local) {
            if (baseValue.equals(source.getAccessPath().getPlainValue())) {
                return true;
            }
        } else if (baseValue instanceof InstanceFieldRef) {
            InstanceFieldRef ifr = (InstanceFieldRef)baseValue;
            if (ifr.getBase().equals(source.getAccessPath().getPlainValue()) && source.getAccessPath().firstFieldMatches(ifr.getField())) {
                return true;
            }
        } else if (baseValue instanceof StaticFieldRef) {
            StaticFieldRef sfr = (StaticFieldRef)baseValue;
            if (source.getAccessPath().firstFieldMatches(sfr.getField())) {
                return true;
            }
        }
        return false;
    }

    public static boolean baseMatchesStrict(Value baseValue, Abstraction source) {
        if (!Aliasing.baseMatches(baseValue, source)) {
            return false;
        }
        if (baseValue instanceof Local) {
            return source.getAccessPath().isLocal();
        }
        if (baseValue instanceof InstanceFieldRef || baseValue instanceof StaticFieldRef) {
            return source.getAccessPath().getFieldCount() == 1;
        }
        throw new RuntimeException("Unexpected left side");
    }

    public void excludeMethodFromMustAlias(SootMethod method) {
        this.excludedFromMustAliasAnalysis.add(method);
    }

    public IAliasingStrategy getAliasingStrategy() {
        return this.aliasingStrategy;
    }
}

