/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoflowConfiguration {
    protected static final Logger logger = LoggerFactory.getLogger(InfoflowConfiguration.class);
    private final SourceSinkConfiguration sourceSinkConfig = new SourceSinkConfiguration();
    private static boolean pathAgnosticResults = true;
    private static boolean oneResultPerAccessPath = false;
    private static boolean mergeNeighbors = false;
    private int stopAfterFirstKFlows = 0;
    private ImplicitFlowMode implicitFlowMode = ImplicitFlowMode.NoImplicitFlows;
    private boolean enableExceptions = true;
    private boolean enableArrays = true;
    private boolean enableArraySizeTainting = true;
    private boolean flowSensitiveAliasing = true;
    private boolean enableTypeChecking = true;
    private boolean ignoreFlowsInSystemPackages = false;
    private boolean excludeSootLibraryClasses = false;
    private int maxThreadNum = -1;
    private boolean writeOutputFiles = false;
    private boolean logSourcesAndSinks = false;
    private boolean enableReflection = false;
    private boolean enableLineNumbers = false;
    private boolean enableOriginalNames = false;
    private boolean inspectSources = false;
    private boolean inspectSinks = false;
    private PathConfiguration pathConfiguration = new PathConfiguration();
    private OutputConfiguration outputConfiguration = new OutputConfiguration();
    private SolverConfiguration solverConfiguration = new SolverConfiguration();
    private AccessPathConfiguration accessPathConfiguration = new AccessPathConfiguration();
    private CallgraphAlgorithm callgraphAlgorithm = CallgraphAlgorithm.AutomaticSelection;
    private AliasingAlgorithm aliasingAlgorithm = AliasingAlgorithm.FlowSensitive;
    private CodeEliminationMode codeEliminationMode = CodeEliminationMode.PropagateConstants;
    private StaticFieldTrackingMode staticFieldTrackingMode = StaticFieldTrackingMode.ContextFlowSensitive;
    private boolean taintAnalysisEnabled = true;
    private boolean incrementalResultReporting = false;
    private long dataFlowTimeout = 0L;
    private double memoryThreshold = 0.9;
    private boolean oneSourceAtATime = false;

    public void merge(InfoflowConfiguration config) {
        this.stopAfterFirstKFlows = config.stopAfterFirstKFlows;
        this.implicitFlowMode = config.implicitFlowMode;
        this.enableExceptions = config.enableExceptions;
        this.enableArrays = config.enableArrays;
        this.enableArraySizeTainting = config.enableArraySizeTainting;
        this.flowSensitiveAliasing = config.flowSensitiveAliasing;
        this.enableTypeChecking = config.enableTypeChecking;
        this.ignoreFlowsInSystemPackages = config.ignoreFlowsInSystemPackages;
        this.excludeSootLibraryClasses = config.excludeSootLibraryClasses;
        this.maxThreadNum = config.maxThreadNum;
        this.writeOutputFiles = config.writeOutputFiles;
        this.logSourcesAndSinks = config.logSourcesAndSinks;
        this.enableReflection = config.enableReflection;
        this.enableLineNumbers = config.enableLineNumbers;
        this.enableOriginalNames = config.enableOriginalNames;
        this.pathConfiguration.merge(config.pathConfiguration);
        this.outputConfiguration.merge(config.outputConfiguration);
        this.solverConfiguration.merge(config.solverConfiguration);
        this.accessPathConfiguration.merge(config.accessPathConfiguration);
        this.callgraphAlgorithm = config.callgraphAlgorithm;
        this.aliasingAlgorithm = config.aliasingAlgorithm;
        this.codeEliminationMode = config.codeEliminationMode;
        this.staticFieldTrackingMode = config.staticFieldTrackingMode;
        this.inspectSources = config.inspectSources;
        this.inspectSinks = config.inspectSinks;
        this.taintAnalysisEnabled = config.writeOutputFiles;
        this.incrementalResultReporting = config.incrementalResultReporting;
        this.dataFlowTimeout = config.dataFlowTimeout;
        this.memoryThreshold = config.memoryThreshold;
        this.oneSourceAtATime = config.oneSourceAtATime;
    }

    public static void setPathAgnosticResults(boolean pathAgnosticResults) {
        InfoflowConfiguration.pathAgnosticResults = pathAgnosticResults;
    }

    public static boolean getPathAgnosticResults() {
        return pathAgnosticResults;
    }

    public static boolean getOneResultPerAccessPath() {
        return oneResultPerAccessPath;
    }

    public static void setOneResultPerAccessPath(boolean oneResultPerAP) {
        oneResultPerAccessPath = oneResultPerAP;
    }

    public static boolean getMergeNeighbors() {
        return mergeNeighbors;
    }

    public static void setMergeNeighbors(boolean value) {
        mergeNeighbors = value;
    }

    public void setStopAfterFirstKFlows(int stopAfterFirstKFlows) {
        this.stopAfterFirstKFlows = stopAfterFirstKFlows;
    }

    public int getStopAfterFirstKFlows() {
        return this.stopAfterFirstKFlows;
    }

    public void setStopAfterFirstFlow(boolean stopAfterFirstFlow) {
        this.stopAfterFirstKFlows = stopAfterFirstFlow ? 1 : 0;
    }

    public boolean getStopAfterFirstFlow() {
        return this.stopAfterFirstKFlows == 1;
    }

    public void setInspectSources(boolean inspect) {
        this.inspectSources = inspect;
    }

    public boolean getInspectSources() {
        return this.inspectSources;
    }

    public void setInspectSinks(boolean inspect) {
        this.inspectSinks = inspect;
    }

    public boolean getInspectSinks() {
        return this.inspectSinks;
    }

    public void setImplicitFlowMode(ImplicitFlowMode implicitFlowMode) {
        this.implicitFlowMode = implicitFlowMode;
    }

    public ImplicitFlowMode getImplicitFlowMode() {
        return this.implicitFlowMode;
    }

    public void setStaticFieldTrackingMode(StaticFieldTrackingMode staticFieldTrackingMode) {
        this.staticFieldTrackingMode = staticFieldTrackingMode;
    }

    public StaticFieldTrackingMode getStaticFieldTrackingMode() {
        return this.staticFieldTrackingMode;
    }

    public void setFlowSensitiveAliasing(boolean flowSensitiveAliasing) {
        this.flowSensitiveAliasing = flowSensitiveAliasing;
    }

    public boolean getFlowSensitiveAliasing() {
        return this.flowSensitiveAliasing;
    }

    public void setEnableExceptionTracking(boolean enableExceptions) {
        this.enableExceptions = enableExceptions;
    }

    public boolean getEnableExceptionTracking() {
        return this.enableExceptions;
    }

    public void setEnableArrayTracking(boolean enableArrays) {
        this.enableArrays = enableArrays;
    }

    public boolean getEnableArrayTracking() {
        return this.enableArrays;
    }

    public void setEnableArraySizeTainting(boolean arrayLengthTainting) {
        this.enableArraySizeTainting = arrayLengthTainting;
    }

    public boolean getEnableArraySizeTainting() {
        return this.enableArraySizeTainting;
    }

    public void setCallgraphAlgorithm(CallgraphAlgorithm algorithm) {
        this.callgraphAlgorithm = algorithm;
    }

    public CallgraphAlgorithm getCallgraphAlgorithm() {
        return this.callgraphAlgorithm;
    }

    public void setAliasingAlgorithm(AliasingAlgorithm algorithm) {
        this.aliasingAlgorithm = algorithm;
    }

    public AliasingAlgorithm getAliasingAlgorithm() {
        return this.aliasingAlgorithm;
    }

    public void setEnableTypeChecking(boolean enableTypeChecking) {
        this.enableTypeChecking = enableTypeChecking;
    }

    public boolean getEnableTypeChecking() {
        return this.enableTypeChecking;
    }

    public void setIgnoreFlowsInSystemPackages(boolean ignoreFlowsInSystemPackages) {
        this.ignoreFlowsInSystemPackages = ignoreFlowsInSystemPackages;
    }

    public boolean getIgnoreFlowsInSystemPackages() {
        return this.ignoreFlowsInSystemPackages;
    }

    public void setExcludeSootLibraryClasses(boolean excludeSootLibraryClasses) {
        this.excludeSootLibraryClasses = excludeSootLibraryClasses;
    }

    public boolean getExcludeSootLibraryClasses() {
        return this.excludeSootLibraryClasses;
    }

    public void setMaxThreadNum(int threadNum) {
        this.maxThreadNum = threadNum;
    }

    public int getMaxThreadNum() {
        return this.maxThreadNum;
    }

    public boolean getWriteOutputFiles() {
        return this.writeOutputFiles;
    }

    public void setWriteOutputFiles(boolean writeOutputFiles) {
        this.writeOutputFiles = writeOutputFiles;
    }

    public void setCodeEliminationMode(CodeEliminationMode mode) {
        this.codeEliminationMode = mode;
    }

    public CodeEliminationMode getCodeEliminationMode() {
        return this.codeEliminationMode;
    }

    public boolean getLogSourcesAndSinks() {
        return this.logSourcesAndSinks;
    }

    public void setLogSourcesAndSinks(boolean logSourcesAndSinks) {
        this.logSourcesAndSinks = logSourcesAndSinks;
    }

    public boolean getEnableReflection() {
        return this.enableReflection;
    }

    public void setEnableReflection(boolean enableReflections) {
        this.enableReflection = enableReflections;
    }

    public boolean getEnableLineNumbers() {
        return this.enableLineNumbers;
    }

    public void setEnableLineNumbers(boolean enableLineNumbers) {
        this.enableLineNumbers = enableLineNumbers;
    }

    public boolean getEnableOriginalNames() {
        return this.enableOriginalNames;
    }

    public void setEnableOriginalNames(boolean enableOriginalNames) {
        this.enableOriginalNames = enableOriginalNames;
    }

    public boolean isTaintAnalysisEnabled() {
        return this.taintAnalysisEnabled;
    }

    public void setTaintAnalysisEnabled(boolean taintAnalysisEnabled) {
        this.taintAnalysisEnabled = taintAnalysisEnabled;
    }

    public boolean getIncrementalResultReporting() {
        return this.incrementalResultReporting;
    }

    public void setIncrementalResultReporting(boolean incrementalReporting) {
        this.incrementalResultReporting = incrementalReporting;
    }

    public long getDataFlowTimeout() {
        return this.dataFlowTimeout;
    }

    public void setDataFlowTimeout(long timeout) {
        this.dataFlowTimeout = timeout;
    }

    public double getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public void setMemoryThreshold(double memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
    }

    public boolean getOneSourceAtATime() {
        return this.oneSourceAtATime;
    }

    public void setOneSourceAtATime(boolean oneSourceAtATime) {
        this.oneSourceAtATime = oneSourceAtATime;
    }

    public PathConfiguration getPathConfiguration() {
        return this.pathConfiguration;
    }

    public OutputConfiguration getOutputConfiguration() {
        return this.outputConfiguration;
    }

    public SolverConfiguration getSolverConfiguration() {
        return this.solverConfiguration;
    }

    public AccessPathConfiguration getAccessPathConfiguration() {
        return this.accessPathConfiguration;
    }

    public void printSummary() {
        if (this.staticFieldTrackingMode == StaticFieldTrackingMode.None) {
            logger.warn("Static field tracking is disabled, results may be incomplete");
        }
        if (!this.flowSensitiveAliasing) {
            logger.warn("Using flow-insensitive alias tracking, results may be imprecise");
        }
        switch (this.implicitFlowMode) {
            case AllImplicitFlows: {
                logger.info("Implicit flow tracking is enabled");
                break;
            }
            case ArrayAccesses: {
                logger.info("Tracking of implicit array accesses is enabled");
                break;
            }
            case NoImplicitFlows: {
                logger.info("Implicit flow tracking is NOT enabled");
            }
        }
        if (this.enableExceptions) {
            logger.info("Exceptional flow tracking is enabled");
        } else {
            logger.info("Exceptional flow tracking is NOT enabled");
        }
        logger.info("Running with a maximum access path length of {}", (Object)this.accessPathConfiguration.getAccessPathLength());
        if (pathAgnosticResults) {
            logger.info("Using path-agnostic result collection");
        } else {
            logger.info("Using path-sensitive result collection");
        }
        if (this.accessPathConfiguration.useRecursiveAccessPaths) {
            logger.info("Recursive access path shortening is enabled");
        } else {
            logger.info("Recursive access path shortening is NOT enabled");
        }
        logger.info("Taint analysis enabled: " + this.taintAnalysisEnabled);
        if (this.oneSourceAtATime) {
            logger.info("Running with one source at a time");
        }
        logger.info("Using alias algorithm " + (Object)((Object)this.aliasingAlgorithm));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accessPathConfiguration == null ? 0 : this.accessPathConfiguration.hashCode());
        result = 31 * result + (this.aliasingAlgorithm == null ? 0 : this.aliasingAlgorithm.hashCode());
        result = 31 * result + (this.callgraphAlgorithm == null ? 0 : this.callgraphAlgorithm.hashCode());
        result = 31 * result + (this.codeEliminationMode == null ? 0 : this.codeEliminationMode.hashCode());
        result = 31 * result + (int)(this.dataFlowTimeout ^ this.dataFlowTimeout >>> 32);
        result = 31 * result + (this.enableArraySizeTainting ? 1231 : 1237);
        result = 31 * result + (this.enableArrays ? 1231 : 1237);
        result = 31 * result + (this.enableExceptions ? 1231 : 1237);
        result = 31 * result + (this.enableReflection ? 1231 : 1237);
        result = 31 * result + (this.enableLineNumbers ? 1231 : 1237);
        result = 31 * result + (this.enableOriginalNames ? 1231 : 1237);
        result = 31 * result + (this.enableTypeChecking ? 1231 : 1237);
        result = 31 * result + (this.excludeSootLibraryClasses ? 1231 : 1237);
        result = 31 * result + (this.flowSensitiveAliasing ? 1231 : 1237);
        result = 31 * result + (this.ignoreFlowsInSystemPackages ? 1231 : 1237);
        result = 31 * result + (this.implicitFlowMode == null ? 0 : this.implicitFlowMode.hashCode());
        result = 31 * result + (this.incrementalResultReporting ? 1231 : 1237);
        result = 31 * result + (this.inspectSinks ? 1231 : 1237);
        result = 31 * result + (this.inspectSources ? 1231 : 1237);
        result = 31 * result + (this.logSourcesAndSinks ? 1231 : 1237);
        result = 31 * result + this.maxThreadNum;
        long temp = Double.doubleToLongBits(this.memoryThreshold);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.oneSourceAtATime ? 1231 : 1237);
        result = 31 * result + (this.outputConfiguration == null ? 0 : this.outputConfiguration.hashCode());
        result = 31 * result + (this.pathConfiguration == null ? 0 : this.pathConfiguration.hashCode());
        result = 31 * result + (this.solverConfiguration == null ? 0 : this.solverConfiguration.hashCode());
        result = 31 * result + (this.staticFieldTrackingMode == null ? 0 : this.staticFieldTrackingMode.hashCode());
        result = 31 * result + this.stopAfterFirstKFlows;
        result = 31 * result + (this.taintAnalysisEnabled ? 1231 : 1237);
        result = 31 * result + (this.writeOutputFiles ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InfoflowConfiguration other = (InfoflowConfiguration)obj;
        if (this.accessPathConfiguration == null ? other.accessPathConfiguration != null : !this.accessPathConfiguration.equals(other.accessPathConfiguration)) {
            return false;
        }
        if (this.aliasingAlgorithm != other.aliasingAlgorithm) {
            return false;
        }
        if (this.callgraphAlgorithm != other.callgraphAlgorithm) {
            return false;
        }
        if (this.codeEliminationMode != other.codeEliminationMode) {
            return false;
        }
        if (this.dataFlowTimeout != other.dataFlowTimeout) {
            return false;
        }
        if (this.enableArraySizeTainting != other.enableArraySizeTainting) {
            return false;
        }
        if (this.enableArrays != other.enableArrays) {
            return false;
        }
        if (this.enableExceptions != other.enableExceptions) {
            return false;
        }
        if (this.enableReflection != other.enableReflection) {
            return false;
        }
        if (this.enableLineNumbers != other.enableLineNumbers) {
            return false;
        }
        if (this.enableOriginalNames != other.enableOriginalNames) {
            return false;
        }
        if (this.enableTypeChecking != other.enableTypeChecking) {
            return false;
        }
        if (this.excludeSootLibraryClasses != other.excludeSootLibraryClasses) {
            return false;
        }
        if (this.flowSensitiveAliasing != other.flowSensitiveAliasing) {
            return false;
        }
        if (this.ignoreFlowsInSystemPackages != other.ignoreFlowsInSystemPackages) {
            return false;
        }
        if (this.implicitFlowMode != other.implicitFlowMode) {
            return false;
        }
        if (this.incrementalResultReporting != other.incrementalResultReporting) {
            return false;
        }
        if (this.inspectSinks != other.inspectSinks) {
            return false;
        }
        if (this.inspectSources != other.inspectSources) {
            return false;
        }
        if (this.logSourcesAndSinks != other.logSourcesAndSinks) {
            return false;
        }
        if (this.maxThreadNum != other.maxThreadNum) {
            return false;
        }
        if (Double.doubleToLongBits(this.memoryThreshold) != Double.doubleToLongBits(other.memoryThreshold)) {
            return false;
        }
        if (this.oneSourceAtATime != other.oneSourceAtATime) {
            return false;
        }
        if (this.outputConfiguration == null ? other.outputConfiguration != null : !this.outputConfiguration.equals(other.outputConfiguration)) {
            return false;
        }
        if (this.pathConfiguration == null ? other.pathConfiguration != null : !this.pathConfiguration.equals(other.pathConfiguration)) {
            return false;
        }
        if (this.solverConfiguration == null ? other.solverConfiguration != null : !this.solverConfiguration.equals(other.solverConfiguration)) {
            return false;
        }
        if (this.staticFieldTrackingMode != other.staticFieldTrackingMode) {
            return false;
        }
        if (this.stopAfterFirstKFlows != other.stopAfterFirstKFlows) {
            return false;
        }
        if (this.taintAnalysisEnabled != other.taintAnalysisEnabled) {
            return false;
        }
        return this.writeOutputFiles == other.writeOutputFiles;
    }

    public SourceSinkConfiguration getSourceSinkConfig() {
        return this.sourceSinkConfig;
    }

    public static class AccessPathConfiguration {
        private int accessPathLength = 5;
        private boolean useRecursiveAccessPaths = true;
        private boolean useThisChainReduction = true;
        private boolean useSameFieldReduction = true;

        public void merge(AccessPathConfiguration config) {
            this.accessPathLength = config.accessPathLength;
            this.useRecursiveAccessPaths = config.useRecursiveAccessPaths;
            this.useThisChainReduction = config.useThisChainReduction;
            this.useSameFieldReduction = config.useSameFieldReduction;
        }

        public int getAccessPathLength() {
            return this.accessPathLength;
        }

        public void setAccessPathLength(int accessPathLength) {
            this.accessPathLength = accessPathLength;
        }

        public boolean getUseRecursiveAccessPaths() {
            return this.useRecursiveAccessPaths;
        }

        public void setUseRecursiveAccessPaths(boolean useRecursiveAccessPaths) {
            this.useRecursiveAccessPaths = useRecursiveAccessPaths;
        }

        public boolean getUseThisChainReduction() {
            return this.useThisChainReduction;
        }

        public void setUseThisChainReduction(boolean useThisChainReduction) {
            this.useThisChainReduction = useThisChainReduction;
        }

        public boolean getUseSameFieldReduction() {
            return this.useSameFieldReduction;
        }

        public void setUseSameFieldReduction(boolean useSameFieldReduction) {
            this.useSameFieldReduction = useSameFieldReduction;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.accessPathLength;
            result = 31 * result + (this.useRecursiveAccessPaths ? 1231 : 1237);
            result = 31 * result + (this.useSameFieldReduction ? 1231 : 1237);
            result = 31 * result + (this.useThisChainReduction ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AccessPathConfiguration other = (AccessPathConfiguration)obj;
            if (this.accessPathLength != other.accessPathLength) {
                return false;
            }
            if (this.useRecursiveAccessPaths != other.useRecursiveAccessPaths) {
                return false;
            }
            if (this.useSameFieldReduction != other.useSameFieldReduction) {
                return false;
            }
            return this.useThisChainReduction == other.useThisChainReduction;
        }
    }

    public static class SolverConfiguration {
        private DataFlowSolver dataFlowSolver = DataFlowSolver.ContextFlowSensitive;
        private int maxJoinPointAbstractions = 10;
        private int maxCalleesPerCallSite = 75;
        private int maxAbstractionPathLength = 100;

        public void merge(SolverConfiguration solverConfig) {
            this.dataFlowSolver = solverConfig.dataFlowSolver;
            this.maxJoinPointAbstractions = solverConfig.maxJoinPointAbstractions;
            this.maxCalleesPerCallSite = solverConfig.maxCalleesPerCallSite;
            this.maxAbstractionPathLength = solverConfig.maxAbstractionPathLength;
        }

        public DataFlowSolver getDataFlowSolver() {
            return this.dataFlowSolver;
        }

        public void setDataFlowSolver(DataFlowSolver solver) {
            this.dataFlowSolver = solver;
        }

        public int getMaxJoinPointAbstractions() {
            return this.maxJoinPointAbstractions;
        }

        public void setMaxJoinPointAbstractions(int maxJoinPointAbstractions) {
            this.maxJoinPointAbstractions = maxJoinPointAbstractions;
        }

        public int getMaxCalleesPerCallSite() {
            return this.maxCalleesPerCallSite;
        }

        public void setMaxCalleesPerCallSite(int maxCalleesPerCallSite) {
            this.maxCalleesPerCallSite = maxCalleesPerCallSite;
        }

        public void setSingleJoinPointAbstraction(boolean singleJointAbstraction) {
            this.maxJoinPointAbstractions = singleJointAbstraction ? 1 : 10;
        }

        public int getMaxAbstractionPathLength() {
            return this.maxAbstractionPathLength;
        }

        public void setMaxAbstractionPathLength(int maxAbstractionPathLength) {
            this.maxAbstractionPathLength = maxAbstractionPathLength;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dataFlowSolver == null ? 0 : this.dataFlowSolver.hashCode());
            result = 31 * result + this.maxCalleesPerCallSite;
            result = 31 * result + this.maxJoinPointAbstractions;
            result = 31 * result + this.maxAbstractionPathLength;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SolverConfiguration other = (SolverConfiguration)obj;
            if (this.dataFlowSolver != other.dataFlowSolver) {
                return false;
            }
            if (this.maxCalleesPerCallSite != other.maxCalleesPerCallSite) {
                return false;
            }
            if (this.maxJoinPointAbstractions != other.maxJoinPointAbstractions) {
                return false;
            }
            return this.maxAbstractionPathLength == other.maxAbstractionPathLength;
        }
    }

    public static class OutputConfiguration {
        private boolean noPassedValues = false;
        private boolean noCallGraphFraction = false;
        private int maxCallersInOutputFile = 5;
        private long resultSerializationTimeout = 0L;

        public void merge(OutputConfiguration outputConfig) {
            this.noPassedValues = outputConfig.noPassedValues;
            this.noCallGraphFraction = outputConfig.noCallGraphFraction;
            this.maxCallersInOutputFile = outputConfig.maxCallersInOutputFile;
            this.resultSerializationTimeout = outputConfig.resultSerializationTimeout;
        }

        public boolean getNoPassedValues() {
            return this.noPassedValues;
        }

        public void setNoCallGraphFraction(boolean noCallGraphFraction) {
            this.noCallGraphFraction = noCallGraphFraction;
        }

        public boolean getNoCallGraphFraction() {
            return this.noCallGraphFraction;
        }

        public void setMaxCallersInOutputFile(int maxCallers) {
            this.maxCallersInOutputFile = maxCallers;
        }

        public int getMaxCallersInOutputFile() {
            return this.maxCallersInOutputFile;
        }

        public void setResultSerializationTimeout(long timeout) {
            this.resultSerializationTimeout = timeout;
        }

        public long getResultSerializationTimeout() {
            return this.resultSerializationTimeout;
        }

        public void setNoPassedValues(boolean noPassedValues) {
            this.noPassedValues = noPassedValues;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.maxCallersInOutputFile;
            result = 31 * result + (this.noCallGraphFraction ? 1231 : 1237);
            result = 31 * result + (this.noPassedValues ? 1231 : 1237);
            result = 31 * result + (int)(this.resultSerializationTimeout ^ this.resultSerializationTimeout >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OutputConfiguration other = (OutputConfiguration)obj;
            if (this.maxCallersInOutputFile != other.maxCallersInOutputFile) {
                return false;
            }
            if (this.noCallGraphFraction != other.noCallGraphFraction) {
                return false;
            }
            if (this.noPassedValues != other.noPassedValues) {
                return false;
            }
            return this.resultSerializationTimeout == other.resultSerializationTimeout;
        }
    }

    public static class PathConfiguration {
        private boolean sequentialPathProcessing = false;
        private PathReconstructionMode pathReconstructionMode = PathReconstructionMode.NoPaths;
        private PathBuildingAlgorithm pathBuildingAlgorithm = PathBuildingAlgorithm.ContextSensitive;
        private int maxCallStackSize = 30;
        private int maxPathLength = 75;
        private int maxPathsPerAbstraction = 15;
        private long pathReconstructionTimeout = 0L;
        private int pathReconstructionBatchSize = 5;

        public void merge(PathConfiguration pathConfig) {
            this.sequentialPathProcessing = pathConfig.sequentialPathProcessing;
            this.pathReconstructionMode = pathConfig.pathReconstructionMode;
            this.pathBuildingAlgorithm = pathConfig.pathBuildingAlgorithm;
            this.maxCallStackSize = pathConfig.maxCallStackSize;
            this.maxPathLength = pathConfig.maxPathLength;
            this.maxPathsPerAbstraction = pathConfig.maxPathsPerAbstraction;
            this.pathReconstructionTimeout = pathConfig.pathReconstructionTimeout;
            this.pathReconstructionBatchSize = pathConfig.pathReconstructionBatchSize;
        }

        public boolean getSequentialPathProcessing() {
            return this.sequentialPathProcessing;
        }

        public void setSequentialPathProcessing(boolean sequentialPathProcessing) {
            this.sequentialPathProcessing = sequentialPathProcessing;
        }

        public PathReconstructionMode getPathReconstructionMode() {
            return this.pathReconstructionMode;
        }

        public void setPathReconstructionMode(PathReconstructionMode pathReconstructionMode) {
            this.pathReconstructionMode = pathReconstructionMode;
        }

        public PathBuildingAlgorithm getPathBuildingAlgorithm() {
            return this.pathBuildingAlgorithm;
        }

        public void setPathBuildingAlgorithm(PathBuildingAlgorithm pathBuildingAlgorithm) {
            this.pathBuildingAlgorithm = pathBuildingAlgorithm;
        }

        public void setMaxCallStackSize(int maxCallStackSize) {
            this.maxCallStackSize = maxCallStackSize;
        }

        public int getMaxCallStackSize() {
            return this.maxCallStackSize;
        }

        public int getMaxPathLength() {
            return this.maxPathLength;
        }

        public void setMaxPathLength(int maxPathLength) {
            this.maxPathLength = maxPathLength;
        }

        public int getMaxPathsPerAbstraction() {
            return this.maxPathsPerAbstraction;
        }

        public void setMaxPathsPerAbstraction(int maxPathsPerAbstraction) {
            this.maxPathsPerAbstraction = maxPathsPerAbstraction;
        }

        public long getPathReconstructionTimeout() {
            return this.pathReconstructionTimeout;
        }

        public void setPathReconstructionTimeout(long timeout) {
            this.pathReconstructionTimeout = timeout;
        }

        public int getPathReconstructionBatchSize() {
            return this.pathReconstructionBatchSize;
        }

        public void setPathReconstructionBatchSize(int pathReconstructionBatchSize) {
            this.pathReconstructionBatchSize = pathReconstructionBatchSize;
        }

        public boolean mustKeepStatements() {
            return this.pathReconstructionMode.reconstructPaths() || this.pathBuildingAlgorithm == PathBuildingAlgorithm.ContextSensitive;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.maxCallStackSize;
            result = 31 * result + this.maxPathLength;
            result = 31 * result + this.maxPathsPerAbstraction;
            result = 31 * result + (this.pathBuildingAlgorithm == null ? 0 : this.pathBuildingAlgorithm.hashCode());
            result = 31 * result + this.pathReconstructionBatchSize;
            result = 31 * result + (this.pathReconstructionMode == null ? 0 : this.pathReconstructionMode.hashCode());
            result = 31 * result + (int)(this.pathReconstructionTimeout ^ this.pathReconstructionTimeout >>> 32);
            result = 31 * result + (this.sequentialPathProcessing ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PathConfiguration other = (PathConfiguration)obj;
            if (this.maxCallStackSize != other.maxCallStackSize) {
                return false;
            }
            if (this.maxPathLength != other.maxPathLength) {
                return false;
            }
            if (this.maxPathsPerAbstraction != other.maxPathsPerAbstraction) {
                return false;
            }
            if (this.pathBuildingAlgorithm != other.pathBuildingAlgorithm) {
                return false;
            }
            if (this.pathReconstructionBatchSize != other.pathReconstructionBatchSize) {
                return false;
            }
            if (this.pathReconstructionMode != other.pathReconstructionMode) {
                return false;
            }
            if (this.pathReconstructionTimeout != other.pathReconstructionTimeout) {
                return false;
            }
            return this.sequentialPathProcessing == other.sequentialPathProcessing;
        }
    }

    public static class SourceSinkConfiguration {
        private CallbackSourceMode callbackSourceMode = CallbackSourceMode.SourceListOnly;
        private boolean enableLifecycleSources = false;
        private LayoutMatchingMode layoutMatchingMode = LayoutMatchingMode.MatchSensitiveOnly;
        private SourceSinkFilterMode sourceFilterMode = SourceSinkFilterMode.UseAllButExcluded;
        private SourceSinkFilterMode sinkFilterMode = SourceSinkFilterMode.UseAllButExcluded;

        public void merge(SourceSinkConfiguration ssConfig) {
            this.callbackSourceMode = ssConfig.callbackSourceMode;
            this.enableLifecycleSources = ssConfig.enableLifecycleSources;
            this.layoutMatchingMode = ssConfig.layoutMatchingMode;
            this.sourceFilterMode = ssConfig.sourceFilterMode;
            this.sinkFilterMode = ssConfig.sinkFilterMode;
        }

        public void setSourceFilterMode(SourceSinkFilterMode sourceFilterMode) {
            this.sourceFilterMode = sourceFilterMode;
        }

        public SourceSinkFilterMode getSinkFilterMode() {
            return this.sinkFilterMode;
        }

        public void setSinkFilterMode(SourceSinkFilterMode sinkFilterMode) {
            this.sinkFilterMode = sinkFilterMode;
        }

        public void setCallbackSourceMode(CallbackSourceMode callbackSourceMode) {
            this.callbackSourceMode = callbackSourceMode;
        }

        public CallbackSourceMode getCallbackSourceMode() {
            return this.callbackSourceMode;
        }

        public void setEnableLifecycleSources(boolean enableLifecycleSources) {
            this.enableLifecycleSources = enableLifecycleSources;
        }

        public boolean getEnableLifecycleSources() {
            return this.enableLifecycleSources;
        }

        public void setLayoutMatchingMode(LayoutMatchingMode mode) {
            this.layoutMatchingMode = mode;
        }

        public LayoutMatchingMode getLayoutMatchingMode() {
            return this.layoutMatchingMode;
        }

        public SourceSinkFilterMode getSourceFilterMode() {
            return this.sourceFilterMode;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.callbackSourceMode == null ? 0 : this.callbackSourceMode.hashCode());
            result = 31 * result + (this.enableLifecycleSources ? 1231 : 1237);
            result = 31 * result + (this.layoutMatchingMode == null ? 0 : this.layoutMatchingMode.hashCode());
            result = 31 * result + (this.sinkFilterMode == null ? 0 : this.sinkFilterMode.hashCode());
            result = 31 * result + (this.sourceFilterMode == null ? 0 : this.sourceFilterMode.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SourceSinkConfiguration other = (SourceSinkConfiguration)obj;
            if (this.callbackSourceMode != other.callbackSourceMode) {
                return false;
            }
            if (this.enableLifecycleSources != other.enableLifecycleSources) {
                return false;
            }
            if (this.layoutMatchingMode != other.layoutMatchingMode) {
                return false;
            }
            if (this.sinkFilterMode != other.sinkFilterMode) {
                return false;
            }
            return this.sourceFilterMode == other.sourceFilterMode;
        }
    }

    public static enum LayoutMatchingMode {
        NoMatch,
        MatchAll,
        MatchSensitiveOnly;

    }

    public static enum CallbackSourceMode {
        NoParametersAsSources,
        AllParametersAsSources,
        SourceListOnly;

    }

    public static enum CategoryMode {
        Include,
        Exclude;

    }

    public static enum SourceSinkFilterMode {
        UseAllButExcluded,
        UseOnlyIncluded;

    }

    public static enum StaticFieldTrackingMode {
        ContextFlowSensitive,
        ContextFlowInsensitive,
        None;

    }

    public static enum PathBuildingAlgorithm {
        Recursive,
        ContextSensitive,
        ContextInsensitive,
        ContextInsensitiveSourceFinder,
        None;

    }

    public static enum PathReconstructionMode {
        NoPaths,
        Fast,
        Precise;


        public boolean reconstructPaths() {
            return this != NoPaths;
        }
    }

    public static enum ImplicitFlowMode {
        NoImplicitFlows,
        ArrayAccesses,
        AllImplicitFlows;


        public boolean trackArrayAccesses() {
            return this == AllImplicitFlows || this == ArrayAccesses;
        }

        public boolean trackControlFlowDependencies() {
            return this == AllImplicitFlows;
        }
    }

    public static enum DataFlowSolver {
        ContextFlowSensitive,
        FlowInsensitive,
        GarbageCollecting;

    }

    public static enum CodeEliminationMode {
        NoCodeElimination,
        PropagateConstants,
        RemoveSideEffectFreeCode;

    }

    public static enum AliasingAlgorithm {
        FlowSensitive,
        PtsBased,
        None,
        Lazy;

    }

    public static enum CallgraphAlgorithm {
        AutomaticSelection,
        CHA,
        VTA,
        RTA,
        SPARK,
        GEOM,
        OnDemand;

    }
}

