/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.G;
import soot.MethodOrMethodContext;
import soot.PackManager;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.jimple.Stmt;
import soot.jimple.infoflow.AbstractInfoflow;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.aliasing.FlowSensitiveAliasStrategy;
import soot.jimple.infoflow.aliasing.IAliasingStrategy;
import soot.jimple.infoflow.aliasing.LazyAliasingStrategy;
import soot.jimple.infoflow.aliasing.NullAliasStrategy;
import soot.jimple.infoflow.aliasing.PtsBasedAliasStrategy;
import soot.jimple.infoflow.cfg.BiDirICFGFactory;
import soot.jimple.infoflow.codeOptimization.DeadCodeEliminator;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AbstractionAtSink;
import soot.jimple.infoflow.data.AccessPathFactory;
import soot.jimple.infoflow.data.FlowDroidMemoryManager;
import soot.jimple.infoflow.data.pathBuilders.BatchPathBuilder;
import soot.jimple.infoflow.data.pathBuilders.DefaultPathBuilderFactory;
import soot.jimple.infoflow.data.pathBuilders.IAbstractionPathBuilder;
import soot.jimple.infoflow.entryPointCreators.IEntryPointCreator;
import soot.jimple.infoflow.globalTaints.GlobalTaintManager;
import soot.jimple.infoflow.handlers.PostAnalysisHandler;
import soot.jimple.infoflow.handlers.ResultsAvailableHandler;
import soot.jimple.infoflow.handlers.ResultsAvailableHandler2;
import soot.jimple.infoflow.handlers.TaintPropagationHandler;
import soot.jimple.infoflow.memory.FlowDroidMemoryWatcher;
import soot.jimple.infoflow.memory.FlowDroidTimeoutWatcher;
import soot.jimple.infoflow.memory.IMemoryBoundedSolver;
import soot.jimple.infoflow.memory.ISolverTerminationReason;
import soot.jimple.infoflow.memory.reasons.AbortRequestedReason;
import soot.jimple.infoflow.memory.reasons.OutOfMemoryReason;
import soot.jimple.infoflow.memory.reasons.TimeoutReason;
import soot.jimple.infoflow.problems.AbstractInfoflowProblem;
import soot.jimple.infoflow.problems.BackwardsInfoflowProblem;
import soot.jimple.infoflow.problems.InfoflowProblem;
import soot.jimple.infoflow.problems.TaintPropagationResults;
import soot.jimple.infoflow.problems.rules.DefaultPropagationRuleManagerFactory;
import soot.jimple.infoflow.problems.rules.IPropagationRuleManagerFactory;
import soot.jimple.infoflow.results.InfoflowPerformanceData;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.results.ResultSinkInfo;
import soot.jimple.infoflow.results.ResultSourceInfo;
import soot.jimple.infoflow.solver.IInfoflowSolver;
import soot.jimple.infoflow.solver.PredecessorShorteningMode;
import soot.jimple.infoflow.solver.SolverPeerGroup;
import soot.jimple.infoflow.solver.cfg.BackwardsInfoflowCFG;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.solver.executors.InterruptableExecutor;
import soot.jimple.infoflow.solver.fastSolver.InfoflowSolver;
import soot.jimple.infoflow.solver.gcSolver.GCSolverPeerGroup;
import soot.jimple.infoflow.solver.memory.DefaultMemoryManagerFactory;
import soot.jimple.infoflow.solver.memory.IMemoryManager;
import soot.jimple.infoflow.solver.memory.IMemoryManagerFactory;
import soot.jimple.infoflow.sourcesSinks.manager.IOneSourceAtATimeManager;
import soot.jimple.infoflow.sourcesSinks.manager.ISourceSinkManager;
import soot.jimple.infoflow.threading.DefaultExecutorFactory;
import soot.jimple.infoflow.threading.IExecutorFactory;
import soot.jimple.infoflow.util.SootMethodRepresentationParser;
import soot.jimple.infoflow.util.SystemClassHandler;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.options.Options;
import soot.util.queue.QueueReader;

public class Infoflow
extends AbstractInfoflow {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected InfoflowResults results = null;
    protected InfoflowManager manager;
    protected Set<ResultsAvailableHandler> onResultsAvailable = new HashSet<ResultsAvailableHandler>();
    protected TaintPropagationHandler taintPropagationHandler = null;
    protected TaintPropagationHandler backwardsPropagationHandler = null;
    protected IMemoryManagerFactory memoryManagerFactory = new DefaultMemoryManagerFactory();
    protected IExecutorFactory executorFactory = new DefaultExecutorFactory();
    protected IPropagationRuleManagerFactory ruleManagerFactory = new DefaultPropagationRuleManagerFactory();
    protected FlowDroidMemoryWatcher memoryWatcher = null;
    protected Set<Stmt> collectedSources = null;
    protected Set<Stmt> collectedSinks = null;
    protected SootMethod dummyMainMethod = null;
    protected Collection<SootMethod> additionalEntryPointMethods = null;
    private boolean throwExceptions;
    protected SolverPeerGroup solverPeerGroup;

    public Infoflow() {
    }

    public Infoflow(String androidPath, boolean forceAndroidJar) {
        super(null, androidPath, forceAndroidJar);
    }

    public Infoflow(String androidPath, boolean forceAndroidJar, BiDirICFGFactory icfgFactory) {
        super(icfgFactory, androidPath, forceAndroidJar);
    }

    @Override
    public void computeInfoflow(String appPath, String libPath, IEntryPointCreator entryPointCreator, ISourceSinkManager sourcesSinks) {
        if (sourcesSinks == null) {
            this.logger.error("Sources are empty!");
            return;
        }
        this.initializeSoot(appPath, libPath, entryPointCreator.getRequiredClasses());
        this.dummyMainMethod = entryPointCreator.createDummyMain();
        this.additionalEntryPointMethods = entryPointCreator.getAdditionalMethods();
        Scene.v().setEntryPoints(Collections.singletonList(this.dummyMainMethod));
        this.runAnalysis(sourcesSinks, null);
    }

    @Override
    public void computeInfoflow(String appPath, String libPath, String entryPoint, ISourceSinkManager sourcesSinks) {
        if (sourcesSinks == null) {
            this.logger.error("Sources are empty!");
            return;
        }
        this.initializeSoot(appPath, libPath, SootMethodRepresentationParser.v().parseClassNames(Collections.singletonList(entryPoint), false).keySet(), entryPoint);
        if (!Scene.v().containsMethod(entryPoint)) {
            this.logger.error("Entry point not found: " + entryPoint);
            return;
        }
        SootMethod ep = Scene.v().getMethod(entryPoint);
        if (!ep.isConcrete()) {
            this.logger.debug("Skipping non-concrete method " + ep);
            return;
        }
        ep.retrieveActiveBody();
        this.dummyMainMethod = null;
        Scene.v().setEntryPoints(Collections.singletonList(ep));
        Options.v().set_main_class(ep.getDeclaringClass().getName());
        Set<String> seeds = Collections.emptySet();
        if (entryPoint != null && !entryPoint.isEmpty()) {
            seeds = Collections.singleton(entryPoint);
        }
        this.ipcManager.updateJimpleForICC();
        this.runAnalysis(sourcesSinks, seeds);
    }

    private void releaseCallgraph() {
        Scene.v().releaseCallGraph();
        Scene.v().releasePointsToAnalysis();
        Scene.v().releaseReachableMethods();
        G.v().resetSpark();
    }

    protected void runAnalysis(ISourceSinkManager sourcesSinks) {
        this.runAnalysis(sourcesSinks, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAnalysis(ISourceSinkManager sourcesSinks, Set<String> additionalSeeds) {
        block93: {
            InfoflowPerformanceData performanceData = this.createPerformanceDataClass();
            try {
                boolean hasMoreSources;
                IOneSourceAtATimeManager oneSourceAtATime;
                this.results = new InfoflowResults();
                this.results.setPerformanceData(performanceData);
                this.checkAndFixConfiguration();
                this.config.printSummary();
                if (this.memoryWatcher != null) {
                    this.memoryWatcher.clearSolvers();
                    this.memoryWatcher = null;
                }
                this.memoryWatcher = new FlowDroidMemoryWatcher(this.results, this.config.getMemoryThreshold());
                Abstraction.initialize(this.config);
                long beforeCallgraph = System.nanoTime();
                this.constructCallgraph();
                performanceData.setCallgraphConstructionSeconds((int)Math.round((double)(System.nanoTime() - beforeCallgraph) / 1.0E9));
                this.logger.info(String.format("Callgraph construction took %d seconds", performanceData.getCallgraphConstructionSeconds()));
                if (sourcesSinks != null) {
                    sourcesSinks.initialize();
                }
                if (this.config.getCodeEliminationMode() != InfoflowConfiguration.CodeEliminationMode.NoCodeElimination) {
                    long currentMillis = System.nanoTime();
                    this.eliminateDeadCode(sourcesSinks);
                    this.logger.info("Dead code elimination took " + (double)(System.nanoTime() - currentMillis) / 1.0E9 + " seconds");
                }
                if (this.config.getEnableReflection()) {
                    this.releaseCallgraph();
                    this.constructCallgraph();
                }
                if (this.config.getCallgraphAlgorithm() != InfoflowConfiguration.CallgraphAlgorithm.OnDemand) {
                    this.logger.info("Callgraph has {} edges", (Object)Scene.v().getCallGraph().size());
                }
                if (!this.config.isTaintAnalysisEnabled()) {
                    return;
                }
                if (this.pathBuilderFactory == null) {
                    this.pathBuilderFactory = new DefaultPathBuilderFactory(this.config.getPathConfiguration());
                }
                this.logger.info("Starting Taint Analysis");
                IInfoflowCFG iCfg = this.icfgFactory.buildBiDirICFG(this.config.getCallgraphAlgorithm(), this.config.getEnableExceptionTracking());
                IOneSourceAtATimeManager iOneSourceAtATimeManager = oneSourceAtATime = this.config.getOneSourceAtATime() && sourcesSinks != null && sourcesSinks instanceof IOneSourceAtATimeManager ? (IOneSourceAtATimeManager)((Object)sourcesSinks) : null;
                if (oneSourceAtATime != null) {
                    oneSourceAtATime.resetCurrentSource();
                }
                boolean bl = hasMoreSources = oneSourceAtATime == null || oneSourceAtATime.hasNextSource();
                while (hasMoreSources) {
                    IInfoflowSolver solver;
                    long beforePathReconstruction;
                    FlowDroidTimeoutWatcher pathTimeoutWatcher;
                    FlowDroidTimeoutWatcher timeoutWatcher;
                    IInfoflowSolver forwardSolver;
                    InfoflowProblem forwardProblem;
                    IAliasingStrategy aliasingStrategy;
                    block92: {
                        int sinkCount;
                        InterruptableExecutor resultExecutor;
                        Aliasing aliasing;
                        IInfoflowSolver backwardSolver;
                        InterruptableExecutor interruptableExecutor;
                        int numThreads;
                        block90: {
                            IInfoflowSolver solver2;
                            block91: {
                                block88: {
                                    IInfoflowSolver solver22;
                                    block89: {
                                        if (oneSourceAtATime != null) {
                                            oneSourceAtATime.nextSource();
                                        }
                                        numThreads = Runtime.getRuntime().availableProcessors();
                                        interruptableExecutor = this.executorFactory.createExecutor(numThreads, true, this.config);
                                        interruptableExecutor.setThreadFactory(new ThreadFactory(){

                                            @Override
                                            public Thread newThread(Runnable r) {
                                                Thread thrIFDS = new Thread(r);
                                                thrIFDS.setDaemon(true);
                                                thrIFDS.setName("FlowDroid");
                                                return thrIFDS;
                                            }
                                        });
                                        IMemoryManager<Abstraction, Unit> memoryManager = this.createMemoryManager();
                                        HashSet<IInfoflowSolver> solvers = new HashSet<IInfoflowSolver>();
                                        GlobalTaintManager globalTaintManager = new GlobalTaintManager(solvers);
                                        this.manager = this.initializeInfoflowManager(sourcesSinks, iCfg, globalTaintManager);
                                        this.solverPeerGroup = new GCSolverPeerGroup();
                                        Abstraction zeroValue = null;
                                        aliasingStrategy = this.createAliasAnalysis(sourcesSinks, iCfg, interruptableExecutor, memoryManager);
                                        backwardSolver = aliasingStrategy.getSolver();
                                        if (backwardSolver != null) {
                                            zeroValue = backwardSolver.getTabulationProblem().createZeroValue();
                                            solvers.add(backwardSolver);
                                        }
                                        aliasing = this.createAliasController(aliasingStrategy);
                                        if (this.dummyMainMethod != null) {
                                            aliasing.excludeMethodFromMustAlias(this.dummyMainMethod);
                                        }
                                        this.manager.setAliasing(aliasing);
                                        forwardProblem = new InfoflowProblem(this.manager, zeroValue, this.ruleManagerFactory);
                                        forwardSolver = this.createForwardSolver(interruptableExecutor, forwardProblem);
                                        this.manager.setForwardSolver(forwardSolver);
                                        if (aliasingStrategy.getSolver() != null) {
                                            aliasingStrategy.getSolver().getTabulationProblem().getManager().setForwardSolver(forwardSolver);
                                        }
                                        solvers.add(forwardSolver);
                                        this.memoryWatcher.addSolver((IMemoryBoundedSolver)((Object)forwardSolver));
                                        forwardSolver.setMemoryManager(memoryManager);
                                        forwardProblem.setTaintPropagationHandler(this.taintPropagationHandler);
                                        forwardProblem.setTaintWrapper(this.taintWrapper);
                                        if (this.nativeCallHandler != null) {
                                            forwardProblem.setNativeCallHandler(this.nativeCallHandler);
                                        }
                                        if (aliasingStrategy.getSolver() != null) {
                                            aliasingStrategy.getSolver().getTabulationProblem().setActivationUnitsToCallSites(forwardProblem);
                                        }
                                        timeoutWatcher = null;
                                        pathTimeoutWatcher = null;
                                        if (this.config.getDataFlowTimeout() > 0L) {
                                            timeoutWatcher = new FlowDroidTimeoutWatcher(this.config.getDataFlowTimeout(), this.results);
                                            timeoutWatcher.addSolver((IMemoryBoundedSolver)((Object)forwardSolver));
                                            if (aliasingStrategy.getSolver() != null) {
                                                timeoutWatcher.addSolver((IMemoryBoundedSolver)((Object)aliasingStrategy.getSolver()));
                                            }
                                            timeoutWatcher.start();
                                        }
                                        resultExecutor = null;
                                        beforePathReconstruction = 0L;
                                        if (this.config.getFlowSensitiveAliasing() && !aliasingStrategy.isFlowSensitive()) {
                                            this.logger.warn("Trying to use a flow-sensitive aliasing with an aliasing strategy that does not support this feature");
                                        }
                                        if (this.config.getFlowSensitiveAliasing() && this.config.getSolverConfiguration().getMaxJoinPointAbstractions() > 0) {
                                            this.logger.warn("Running with limited join point abstractions can break context-sensitive path builders");
                                        }
                                        sinkCount = 0;
                                        this.logger.info("Looking for sources and sinks...");
                                        for (SootMethod sm : this.getMethodsForSeeds(iCfg)) {
                                            sinkCount += this.scanMethodForSourcesSinks(sourcesSinks, forwardProblem, sm);
                                        }
                                        if (additionalSeeds != null) {
                                            for (String meth : additionalSeeds) {
                                                SootMethod m = Scene.v().getMethod(meth);
                                                if (!m.hasActiveBody()) {
                                                    this.logger.warn("Seed method {} has no active body", (Object)m);
                                                    continue;
                                                }
                                                forwardProblem.addInitialSeeds(m.getActiveBody().getUnits().getFirst(), Collections.singleton(forwardProblem.zeroValue()));
                                            }
                                        }
                                        if (forwardProblem.hasInitialSeeds()) break block88;
                                        this.logger.error("No sources found, aborting analysis");
                                        if (resultExecutor == null) break block89;
                                        resultExecutor.shutdown();
                                    }
                                    if (timeoutWatcher != null) {
                                        timeoutWatcher.stop();
                                    }
                                    if (pathTimeoutWatcher != null) {
                                        pathTimeoutWatcher.stop();
                                    }
                                    if (aliasingStrategy != null && (solver22 = aliasingStrategy.getSolver()) != null) {
                                        solver22.terminate();
                                    }
                                    hasMoreSources = oneSourceAtATime != null && oneSourceAtATime.hasNextSource();
                                    this.memoryWatcher.close();
                                    forwardProblem = null;
                                    forwardSolver = null;
                                    if (this.manager != null) {
                                        this.manager.cleanup();
                                    }
                                    this.manager = null;
                                    continue;
                                }
                                if (sinkCount != 0) break block90;
                                this.logger.error("No sinks found, aborting analysis");
                                if (resultExecutor == null) break block91;
                                resultExecutor.shutdown();
                            }
                            if (timeoutWatcher != null) {
                                timeoutWatcher.stop();
                            }
                            if (pathTimeoutWatcher != null) {
                                pathTimeoutWatcher.stop();
                            }
                            if (aliasingStrategy != null && (solver2 = aliasingStrategy.getSolver()) != null) {
                                solver2.terminate();
                            }
                            hasMoreSources = oneSourceAtATime != null && oneSourceAtATime.hasNextSource();
                            this.memoryWatcher.close();
                            forwardProblem = null;
                            forwardSolver = null;
                            if (this.manager != null) {
                                this.manager.cleanup();
                            }
                            this.manager = null;
                            continue;
                        }
                        try {
                            this.logger.info("Source lookup done, found {} sources and {} sinks.", (Object)forwardProblem.getInitialSeeds().size(), (Object)sinkCount);
                            performanceData.setSourceCount(forwardProblem.getInitialSeeds().size());
                            performanceData.setSinkCount(sinkCount);
                            if (this.taintWrapper != null) {
                                this.taintWrapper.initialize(this.manager);
                            }
                            if (this.nativeCallHandler != null) {
                                this.nativeCallHandler.initialize(this.manager);
                            }
                            TaintPropagationResults propagationResults = forwardProblem.getResults();
                            resultExecutor = this.executorFactory.createExecutor(numThreads, false, this.config);
                            resultExecutor.setThreadFactory(new ThreadFactory(){

                                @Override
                                public Thread newThread(Runnable r) {
                                    Thread thrPath = new Thread(r);
                                    thrPath.setDaemon(true);
                                    thrPath.setName("FlowDroid Path Reconstruction");
                                    return thrPath;
                                }
                            });
                            BatchPathBuilder builder = new BatchPathBuilder(this.manager, this.pathBuilderFactory.createPathBuilder(this.manager, resultExecutor));
                            if (this.config.getIncrementalResultReporting()) {
                                this.initializeIncrementalResultReporting(propagationResults, builder);
                            }
                            if (performanceData.getTaintPropagationSeconds() < 0) {
                                performanceData.setTaintPropagationSeconds(0);
                            }
                            long beforeTaintPropagation = System.nanoTime();
                            this.onBeforeTaintPropagation(forwardSolver, backwardSolver);
                            forwardSolver.solve();
                            int terminateTries = 0;
                            while (!(terminateTries >= 10 || interruptableExecutor.getActiveCount() == 0 && interruptableExecutor.isTerminated())) {
                                ++terminateTries;
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException e) {
                                    this.logger.error("Could not wait for executor termination", (Throwable)e);
                                }
                            }
                            if (interruptableExecutor.getActiveCount() != 0 || !interruptableExecutor.isTerminated()) {
                                this.logger.error("Executor did not terminate gracefully");
                            }
                            if (interruptableExecutor.getException() != null) {
                                throw new RuntimeException("An exception has occurred in an executor", interruptableExecutor.getException());
                            }
                            performanceData.updateMaxMemoryConsumption(this.getUsedMemory());
                            int taintPropagationSeconds = (int)Math.round((double)(System.nanoTime() - beforeTaintPropagation) / 1.0E9);
                            performanceData.addTaintPropagationSeconds(taintPropagationSeconds);
                            if (this.taintWrapper != null) {
                                this.logger.info("Taint wrapper hits: " + this.taintWrapper.getWrapperHits());
                                this.logger.info("Taint wrapper misses: " + this.taintWrapper.getWrapperMisses());
                            }
                            this.onTaintPropagationCompleted(forwardSolver, backwardSolver);
                            Set<AbstractionAtSink> res = propagationResults.getResults();
                            propagationResults = null;
                            this.removeEntailedAbstractions(res);
                            if (this.nativeCallHandler != null) {
                                this.nativeCallHandler.shutdown();
                            }
                            this.logger.info("IFDS problem with {} forward and {} backward edges solved in {} seconds, processing {} results...", new Object[]{forwardSolver.getPropagationCount(), aliasingStrategy.getSolver() == null ? 0L : aliasingStrategy.getSolver().getPropagationCount(), taintPropagationSeconds, res == null ? 0 : res.size()});
                            ISolverTerminationReason reason = ((IMemoryBoundedSolver)((Object)forwardSolver)).getTerminationReason();
                            if (reason != null) {
                                if (reason instanceof OutOfMemoryReason) {
                                    this.results.setTerminationState(this.results.getTerminationState() | 2);
                                } else if (reason instanceof TimeoutReason) {
                                    this.results.setTerminationState(this.results.getTerminationState() | 1);
                                }
                            }
                            performanceData.updateMaxMemoryConsumption(this.getUsedMemory());
                            this.logger.info(String.format("Current memory consumption: %d MB", this.getUsedMemory()));
                            if (timeoutWatcher != null) {
                                timeoutWatcher.stop();
                            }
                            this.memoryWatcher.removeSolver((IMemoryBoundedSolver)((Object)forwardSolver));
                            forwardSolver.cleanup();
                            forwardSolver = null;
                            forwardProblem = null;
                            this.solverPeerGroup = null;
                            aliasing = null;
                            if (aliasingStrategy.getSolver() != null) {
                                aliasingStrategy.getSolver().terminate();
                                this.memoryWatcher.removeSolver((IMemoryBoundedSolver)((Object)aliasingStrategy.getSolver()));
                            }
                            aliasingStrategy.cleanup();
                            aliasingStrategy = null;
                            if (this.config.getIncrementalResultReporting()) {
                                res = null;
                            }
                            iCfg.purge();
                            if (this.manager != null) {
                                this.manager.cleanup();
                            }
                            this.manager = null;
                            Runtime.getRuntime().gc();
                            performanceData.updateMaxMemoryConsumption(this.getUsedMemory());
                            this.logger.info(String.format("Memory consumption after cleanup: %d MB", this.getUsedMemory()));
                            if (this.config.getPathConfiguration().getPathReconstructionTimeout() > 0L) {
                                pathTimeoutWatcher = new FlowDroidTimeoutWatcher(this.config.getPathConfiguration().getPathReconstructionTimeout(), this.results);
                                pathTimeoutWatcher.addSolver(builder);
                                pathTimeoutWatcher.start();
                            }
                            beforePathReconstruction = System.nanoTime();
                            if (this.config.getIncrementalResultReporting()) {
                                builder.runIncrementalPathCompuation();
                                try {
                                    resultExecutor.awaitCompletion();
                                }
                                catch (InterruptedException e) {
                                    this.logger.error("Could not wait for executor termination", (Throwable)e);
                                }
                            } else {
                                this.memoryWatcher.addSolver(builder);
                                builder.computeTaintPaths(res);
                                res = null;
                                reason = builder.getTerminationReason();
                                if (reason != null) {
                                    if (reason instanceof OutOfMemoryReason) {
                                        this.results.setTerminationState(this.results.getTerminationState() | 8);
                                    } else if (reason instanceof TimeoutReason) {
                                        this.results.setTerminationState(this.results.getTerminationState() | 4);
                                    }
                                }
                                try {
                                    long pathTimeout = this.config.getPathConfiguration().getPathReconstructionTimeout();
                                    if (pathTimeout > 0L) {
                                        resultExecutor.awaitCompletion(pathTimeout + 20L, TimeUnit.SECONDS);
                                    } else {
                                        resultExecutor.awaitCompletion();
                                    }
                                }
                                catch (InterruptedException e) {
                                    this.logger.error("Could not wait for executor termination", (Throwable)e);
                                }
                                this.results.addAll(builder.getResults());
                            }
                            resultExecutor.shutdown();
                            if (builder.isKilled()) {
                                this.logger.warn("Path reconstruction aborted. The reported results may be incomplete. You might want to try again with sequential path processing enabled.");
                            }
                            if (resultExecutor == null) break block92;
                        }
                        catch (Throwable throwable) {
                            IInfoflowSolver solver3;
                            if (resultExecutor != null) {
                                resultExecutor.shutdown();
                            }
                            if (timeoutWatcher != null) {
                                timeoutWatcher.stop();
                            }
                            if (pathTimeoutWatcher != null) {
                                pathTimeoutWatcher.stop();
                            }
                            if (aliasingStrategy != null && (solver3 = aliasingStrategy.getSolver()) != null) {
                                solver3.terminate();
                            }
                            hasMoreSources = oneSourceAtATime != null && oneSourceAtATime.hasNextSource();
                            this.memoryWatcher.close();
                            forwardProblem = null;
                            forwardSolver = null;
                            if (this.manager != null) {
                                this.manager.cleanup();
                            }
                            this.manager = null;
                            throw throwable;
                        }
                        resultExecutor.shutdown();
                    }
                    if (timeoutWatcher != null) {
                        timeoutWatcher.stop();
                    }
                    if (pathTimeoutWatcher != null) {
                        pathTimeoutWatcher.stop();
                    }
                    if (aliasingStrategy != null && (solver = aliasingStrategy.getSolver()) != null) {
                        solver.terminate();
                    }
                    hasMoreSources = oneSourceAtATime != null && oneSourceAtATime.hasNextSource();
                    this.memoryWatcher.close();
                    forwardProblem = null;
                    forwardSolver = null;
                    if (this.manager != null) {
                        this.manager.cleanup();
                    }
                    this.manager = null;
                    Runtime.getRuntime().gc();
                    performanceData.updateMaxMemoryConsumption(this.getUsedMemory());
                    performanceData.setPathReconstructionSeconds((int)Math.round((double)(System.nanoTime() - beforePathReconstruction) / 1.0E9));
                    this.logger.info(String.format("Memory consumption after path building: %d MB", this.getUsedMemory()));
                    this.logger.info(String.format("Path reconstruction took %d seconds", performanceData.getPathReconstructionSeconds()));
                }
                for (PostAnalysisHandler postAnalysisHandler : this.postProcessors) {
                    this.results = postAnalysisHandler.onResultsAvailable(this.results, iCfg);
                }
                if (this.results == null || this.results.isEmpty()) {
                    this.logger.warn("No results found.");
                } else if (this.logger.isInfoEnabled()) {
                    for (ResultSinkInfo resultSinkInfo : this.results.getResults().keySet()) {
                        this.logger.info("The sink {} in method {} was called with values from the following sources:", (Object)resultSinkInfo, (Object)((SootMethod)iCfg.getMethodOf(resultSinkInfo.getStmt())).getSignature());
                        for (ResultSourceInfo source : this.results.getResults().get((Object)resultSinkInfo)) {
                            this.logger.info("- {} in method {}", (Object)source, (Object)((SootMethod)iCfg.getMethodOf(source.getStmt())).getSignature());
                            if (source.getPath() == null) continue;
                            this.logger.info("\ton Path: ");
                            for (Stmt p : source.getPath()) {
                                this.logger.info("\t -> " + iCfg.getMethodOf(p));
                                this.logger.info("\t\t -> " + p);
                            }
                        }
                    }
                }
                performanceData.setTotalRuntimeSeconds((int)Math.round((double)(System.nanoTime() - beforeCallgraph) / 1.0E9));
                performanceData.updateMaxMemoryConsumption(this.getUsedMemory());
                this.logger.info(String.format("Data flow solver took %d seconds. Maximum memory consumption: %d MB", performanceData.getTotalRuntimeSeconds(), performanceData.getMaxMemoryConsumption()));
                for (ResultsAvailableHandler resultsAvailableHandler : this.onResultsAvailable) {
                    resultsAvailableHandler.onResultsAvailable(iCfg, this.results);
                }
                if (this.config.getWriteOutputFiles()) {
                    PackManager.v().writeOutput();
                }
            }
            catch (Exception ex) {
                StringWriter stacktrace = new StringWriter();
                PrintWriter pw = new PrintWriter(stacktrace);
                ex.printStackTrace(pw);
                this.results.addException(ex.getClass().getName() + ": " + ex.getMessage() + "\n" + stacktrace.toString());
                this.logger.error("Exception during data flow analysis", (Throwable)ex);
                if (!this.throwExceptions) break block93;
                throw ex;
            }
        }
    }

    protected InfoflowPerformanceData createPerformanceDataClass() {
        return new InfoflowPerformanceData();
    }

    protected Aliasing createAliasController(IAliasingStrategy aliasingStrategy) {
        return new Aliasing(aliasingStrategy, this.manager);
    }

    protected void onBeforeTaintPropagation(IInfoflowSolver forwardSolver, IInfoflowSolver backwardSolver) {
    }

    protected void onTaintPropagationCompleted(IInfoflowSolver forwardSolver, IInfoflowSolver backwardSolver) {
    }

    protected InfoflowManager initializeInfoflowManager(ISourceSinkManager sourcesSinks, IInfoflowCFG iCfg, GlobalTaintManager globalTaintManager) {
        return new InfoflowManager(this.config, null, iCfg, sourcesSinks, this.taintWrapper, this.hierarchy, new AccessPathFactory(this.config), globalTaintManager);
    }

    private void initializeIncrementalResultReporting(TaintPropagationResults propagationResults, final IAbstractionPathBuilder builder) {
        this.memoryWatcher.addSolver(builder);
        this.results = new InfoflowResults();
        propagationResults.addResultAvailableHandler(new TaintPropagationResults.OnTaintPropagationResultAdded(){

            @Override
            public boolean onResultAvailable(AbstractionAtSink abs) {
                builder.addResultAvailableHandler(new IAbstractionPathBuilder.OnPathBuilderResultAvailable(){

                    @Override
                    public void onResultAvailable(ResultSourceInfo source, ResultSinkInfo sink) {
                        for (ResultsAvailableHandler handler : Infoflow.this.onResultsAvailable) {
                            if (!(handler instanceof ResultsAvailableHandler2)) continue;
                            ResultsAvailableHandler2 handler2 = (ResultsAvailableHandler2)handler;
                            handler2.onSingleResultAvailable(source, sink);
                        }
                        Infoflow.this.results.addResult(sink, source);
                    }
                });
                builder.computeTaintPaths(Collections.singleton(abs));
                return true;
            }
        });
    }

    private void checkAndFixConfiguration() {
        InfoflowConfiguration.AccessPathConfiguration accessPathConfig = this.config.getAccessPathConfiguration();
        if (this.config.getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && accessPathConfig.getAccessPathLength() == 0) {
            throw new RuntimeException("Static field tracking must be disabled if the access path length is zero");
        }
        if (this.config.getSolverConfiguration().getDataFlowSolver() == InfoflowConfiguration.DataFlowSolver.FlowInsensitive) {
            this.config.setFlowSensitiveAliasing(false);
            this.config.setEnableTypeChecking(false);
            this.logger.warn("Disabled flow-sensitive aliasing because we are running with a flow-insensitive data flow solver");
        }
    }

    private void removeEntailedAbstractions(Set<AbstractionAtSink> res) {
        Iterator<AbstractionAtSink> absAtSinkIt = res.iterator();
        block0: while (absAtSinkIt.hasNext()) {
            AbstractionAtSink curAbs = absAtSinkIt.next();
            for (AbstractionAtSink checkAbs : res) {
                if (checkAbs == curAbs || checkAbs.getSinkStmt() != curAbs.getSinkStmt() || checkAbs.getAbstraction().isImplicit() != curAbs.getAbstraction().isImplicit() || checkAbs.getAbstraction().getSourceContext() != curAbs.getAbstraction().getSourceContext() || !checkAbs.getAbstraction().getAccessPath().entails(curAbs.getAbstraction().getAccessPath())) continue;
                absAtSinkIt.remove();
                continue block0;
            }
        }
    }

    private IAliasingStrategy createAliasAnalysis(ISourceSinkManager sourcesSinks, IInfoflowCFG iCfg, InterruptableExecutor executor, IMemoryManager<Abstraction, Unit> memoryManager) {
        IAliasingStrategy aliasingStrategy;
        IInfoflowSolver backSolver = null;
        BackwardsInfoflowProblem backProblem = null;
        InfoflowManager backwardsManager = null;
        switch (this.getConfig().getAliasingAlgorithm()) {
            case FlowSensitive: {
                backwardsManager = new InfoflowManager(this.config, null, new BackwardsInfoflowCFG(iCfg), sourcesSinks, this.taintWrapper, this.hierarchy, this.manager.getAccessPathFactory(), this.manager.getGlobalTaintManager());
                backProblem = new BackwardsInfoflowProblem(backwardsManager);
                InfoflowConfiguration.SolverConfiguration solverConfig = this.config.getSolverConfiguration();
                backSolver = this.createDataFlowSolver(executor, backProblem, solverConfig);
                backSolver.setMemoryManager(memoryManager);
                backSolver.setPredecessorShorteningMode(this.pathConfigToShorteningMode(this.manager.getConfig().getPathConfiguration()));
                backSolver.setMaxJoinPointAbstractions(solverConfig.getMaxJoinPointAbstractions());
                backSolver.setMaxCalleesPerCallSite(solverConfig.getMaxCalleesPerCallSite());
                backSolver.setMaxAbstractionPathLength(solverConfig.getMaxAbstractionPathLength());
                backSolver.setSolverId(false);
                backProblem.setTaintPropagationHandler(this.backwardsPropagationHandler);
                backProblem.setTaintWrapper(this.taintWrapper);
                if (this.nativeCallHandler != null) {
                    backProblem.setNativeCallHandler(this.nativeCallHandler);
                }
                this.memoryWatcher.addSolver((IMemoryBoundedSolver)((Object)backSolver));
                aliasingStrategy = new FlowSensitiveAliasStrategy(this.manager, backSolver);
                break;
            }
            case PtsBased: {
                backProblem = null;
                backSolver = null;
                aliasingStrategy = new PtsBasedAliasStrategy(this.manager);
                break;
            }
            case None: {
                backProblem = null;
                backSolver = null;
                aliasingStrategy = new NullAliasStrategy();
                break;
            }
            case Lazy: {
                backProblem = null;
                backSolver = null;
                aliasingStrategy = new LazyAliasingStrategy(this.manager);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported aliasing algorithm");
            }
        }
        return aliasingStrategy;
    }

    private PredecessorShorteningMode pathConfigToShorteningMode(InfoflowConfiguration.PathConfiguration pathConfiguration) {
        if (this.pathBuilderFactory.supportsPathReconstruction()) {
            switch (pathConfiguration.getPathReconstructionMode()) {
                case Fast: {
                    return PredecessorShorteningMode.ShortenIfEqual;
                }
                case NoPaths: {
                    return PredecessorShorteningMode.AlwaysShorten;
                }
                case Precise: {
                    return PredecessorShorteningMode.NeverShorten;
                }
            }
            throw new RuntimeException("Unknown path reconstruction mode");
        }
        return PredecessorShorteningMode.AlwaysShorten;
    }

    private IMemoryManager<Abstraction, Unit> createMemoryManager() {
        if (this.memoryManagerFactory == null) {
            return null;
        }
        FlowDroidMemoryManager.PathDataErasureMode erasureMode = this.config.getPathConfiguration().mustKeepStatements() ? FlowDroidMemoryManager.PathDataErasureMode.EraseNothing : (this.pathBuilderFactory.supportsPathReconstruction() ? FlowDroidMemoryManager.PathDataErasureMode.EraseNothing : (this.pathBuilderFactory.isContextSensitive() ? FlowDroidMemoryManager.PathDataErasureMode.KeepOnlyContextData : FlowDroidMemoryManager.PathDataErasureMode.EraseAll));
        IMemoryManager<Abstraction, Unit> memoryManager = this.memoryManagerFactory.getMemoryManager(false, erasureMode);
        return memoryManager;
    }

    private IInfoflowSolver createForwardSolver(InterruptableExecutor executor, InfoflowProblem forwardProblem) {
        InfoflowConfiguration.SolverConfiguration solverConfig = this.config.getSolverConfiguration();
        IInfoflowSolver forwardSolver = this.createDataFlowSolver(executor, forwardProblem, solverConfig);
        forwardSolver.setSolverId(true);
        forwardSolver.setPredecessorShorteningMode(this.pathConfigToShorteningMode(this.manager.getConfig().getPathConfiguration()));
        forwardSolver.setMaxJoinPointAbstractions(solverConfig.getMaxJoinPointAbstractions());
        forwardSolver.setMaxCalleesPerCallSite(solverConfig.getMaxCalleesPerCallSite());
        forwardSolver.setMaxAbstractionPathLength(solverConfig.getMaxAbstractionPathLength());
        return forwardSolver;
    }

    protected IInfoflowSolver createDataFlowSolver(InterruptableExecutor executor, AbstractInfoflowProblem problem, InfoflowConfiguration.SolverConfiguration solverConfig) {
        switch (solverConfig.getDataFlowSolver()) {
            case ContextFlowSensitive: {
                this.logger.info("Using context- and flow-sensitive solver");
                return new InfoflowSolver(problem, executor);
            }
            case FlowInsensitive: {
                this.logger.info("Using context-sensitive, but flow-insensitive solver");
                return new soot.jimple.infoflow.solver.fastSolver.flowInsensitive.InfoflowSolver(problem, executor);
            }
            case GarbageCollecting: {
                this.logger.info("Using garbage-collecting solver");
                soot.jimple.infoflow.solver.gcSolver.InfoflowSolver solver = new soot.jimple.infoflow.solver.gcSolver.InfoflowSolver(problem, executor);
                this.solverPeerGroup.addSolver(solver);
                solver.setPeerGroup(this.solverPeerGroup);
                return solver;
            }
        }
        throw new RuntimeException("Unsupported data flow solver");
    }

    private int getUsedMemory() {
        Runtime runtime = Runtime.getRuntime();
        return (int)Math.round((double)(runtime.totalMemory() - runtime.freeMemory()) / 1000000.0);
    }

    protected void eliminateDeadCode(ISourceSinkManager sourcesSinks) {
        InfoflowManager dceManager = new InfoflowManager(this.config, null, this.icfgFactory.buildBiDirICFG(this.config.getCallgraphAlgorithm(), this.config.getEnableExceptionTracking()), null, null, null, new AccessPathFactory(this.config), null);
        HashSet<SootMethod> excludedMethods = new HashSet<SootMethod>();
        if (this.additionalEntryPointMethods != null) {
            excludedMethods.addAll(this.additionalEntryPointMethods);
        }
        excludedMethods.addAll(Scene.v().getEntryPoints());
        DeadCodeEliminator dce = new DeadCodeEliminator();
        dce.initialize(this.config);
        dce.run(dceManager, excludedMethods, sourcesSinks, this.taintWrapper);
    }

    protected Collection<SootMethod> getMethodsForSeeds(IInfoflowCFG icfg) {
        LinkedList<SootMethod> seeds = new LinkedList<SootMethod>();
        if (Scene.v().hasCallGraph()) {
            ReachableMethods reachableMethods = Scene.v().getReachableMethods();
            reachableMethods.update();
            QueueReader iter = reachableMethods.listener();
            while (iter.hasNext()) {
                SootMethod sm = ((MethodOrMethodContext)iter.next()).method();
                if (!this.isValidSeedMethod(sm)) continue;
                seeds.add(sm);
            }
        } else {
            long beforeSeedMethods = System.nanoTime();
            HashSet<SootMethod> doneSet = new HashSet<SootMethod>();
            for (SootMethod sm : Scene.v().getEntryPoints()) {
                this.getMethodsForSeedsIncremental(sm, doneSet, seeds, icfg);
            }
            this.logger.info("Collecting seed methods took {} seconds", (Object)((double)(System.nanoTime() - beforeSeedMethods) / 1.0E9));
        }
        return seeds;
    }

    private void getMethodsForSeedsIncremental(SootMethod sm, Set<SootMethod> doneSet, List<SootMethod> seeds, IInfoflowCFG icfg) {
        assert (Scene.v().hasFastHierarchy());
        if (!(sm.isConcrete() && sm.getDeclaringClass().isApplicationClass() && doneSet.add(sm))) {
            return;
        }
        seeds.add(sm);
        for (Unit u : sm.retrieveActiveBody().getUnits()) {
            Stmt stmt = (Stmt)u;
            if (!stmt.containsInvokeExpr()) continue;
            for (SootMethod callee : icfg.getCalleesOfCallAt(stmt)) {
                if (!this.isValidSeedMethod(callee)) continue;
                this.getMethodsForSeedsIncremental(callee, doneSet, seeds, icfg);
            }
        }
    }

    protected boolean isValidSeedMethod(SootMethod sm) {
        if (sm == this.dummyMainMethod) {
            return false;
        }
        if (this.dummyMainMethod != null && sm.getDeclaringClass() == this.dummyMainMethod.getDeclaringClass()) {
            return false;
        }
        String className = sm.getDeclaringClass().getName();
        if (this.config.getIgnoreFlowsInSystemPackages() && SystemClassHandler.v().isClassInSystemPackage(className) && !this.isUserCodeClass(className)) {
            return false;
        }
        return !this.config.getExcludeSootLibraryClasses() || !sm.getDeclaringClass().isLibraryClass();
    }

    protected boolean isUserCodeClass(String className) {
        return false;
    }

    private int scanMethodForSourcesSinks(ISourceSinkManager sourcesSinks, InfoflowProblem forwardProblem, SootMethod m) {
        if (this.getConfig().getLogSourcesAndSinks() && this.collectedSources == null) {
            this.collectedSources = new HashSet<Stmt>();
            this.collectedSinks = new HashSet<Stmt>();
        }
        int sinkCount = 0;
        if (m.hasActiveBody()) {
            if (!this.isValidSeedMethod(m)) {
                return sinkCount;
            }
            UnitPatchingChain units = m.getActiveBody().getUnits();
            for (Unit u : units) {
                Stmt s = (Stmt)u;
                if (sourcesSinks.getSourceInfo(s, this.manager) != null) {
                    forwardProblem.addInitialSeeds(u, Collections.singleton(forwardProblem.zeroValue()));
                    if (this.getConfig().getLogSourcesAndSinks()) {
                        this.collectedSources.add(s);
                    }
                    this.logger.debug("Source found: {} in {}", (Object)u, (Object)m.getSignature());
                }
                if (sourcesSinks.getSinkInfo(s, this.manager, null) == null) continue;
                ++sinkCount;
                if (this.getConfig().getLogSourcesAndSinks()) {
                    this.collectedSinks.add(s);
                }
                this.logger.debug("Sink found: {} in {}", (Object)u, (Object)m.getSignature());
            }
        }
        return sinkCount;
    }

    @Override
    public InfoflowResults getResults() {
        return this.results;
    }

    @Override
    public boolean isResultAvailable() {
        return this.results != null;
    }

    @Override
    public void addResultsAvailableHandler(ResultsAvailableHandler handler) {
        this.onResultsAvailable.add(handler);
    }

    @Override
    public void setTaintPropagationHandler(TaintPropagationHandler handler) {
        this.taintPropagationHandler = handler;
    }

    @Override
    public void setBackwardsPropagationHandler(TaintPropagationHandler handler) {
        this.backwardsPropagationHandler = handler;
    }

    @Override
    public void removeResultsAvailableHandler(ResultsAvailableHandler handler) {
        this.onResultsAvailable.remove(handler);
    }

    @Override
    public Set<Stmt> getCollectedSources() {
        return this.collectedSources;
    }

    @Override
    public Set<Stmt> getCollectedSinks() {
        return this.collectedSinks;
    }

    @Override
    public void setMemoryManagerFactory(IMemoryManagerFactory factory) {
        this.memoryManagerFactory = factory;
    }

    @Override
    public void setExecutorFactory(IExecutorFactory executorFactory) {
        this.executorFactory = executorFactory;
    }

    @Override
    public void setPropagationRuleManagerFactory(IPropagationRuleManagerFactory ruleManagerFactory) {
        this.ruleManagerFactory = ruleManagerFactory;
    }

    @Override
    public void abortAnalysis() {
        AbortRequestedReason reason = new AbortRequestedReason();
        if (this.manager != null && this.manager.getForwardSolver() instanceof IMemoryBoundedSolver) {
            IMemoryBoundedSolver boundedSolver = (IMemoryBoundedSolver)((Object)this.manager.getForwardSolver());
            boundedSolver.forceTerminate(reason);
        }
        if (this.memoryWatcher != null) {
            this.memoryWatcher.forceTerminate(reason);
        }
    }

    public void setThrowExceptions(boolean b) {
        this.throwExceptions = b;
    }
}

