/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.FastHierarchy;
import soot.G;
import soot.PackManager;
import soot.Scene;
import soot.SootClass;
import soot.jimple.infoflow.IInfoflow;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.cfg.BiDirICFGFactory;
import soot.jimple.infoflow.cfg.DefaultBiDiICFGFactory;
import soot.jimple.infoflow.cfg.LibraryClassPatcher;
import soot.jimple.infoflow.config.IInfoflowConfig;
import soot.jimple.infoflow.data.pathBuilders.IPathBuilderFactory;
import soot.jimple.infoflow.entryPointCreators.DefaultEntryPointCreator;
import soot.jimple.infoflow.entryPointCreators.IEntryPointCreator;
import soot.jimple.infoflow.handlers.PostAnalysisHandler;
import soot.jimple.infoflow.handlers.PreAnalysisHandler;
import soot.jimple.infoflow.ipc.DefaultIPCManager;
import soot.jimple.infoflow.ipc.IIPCManager;
import soot.jimple.infoflow.nativeCallHandler.DefaultNativeCallHandler;
import soot.jimple.infoflow.nativeCallHandler.INativeCallHandler;
import soot.jimple.infoflow.sourcesSinks.manager.DefaultSourceSinkManager;
import soot.jimple.infoflow.sourcesSinks.manager.ISourceSinkManager;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.options.Options;

public abstract class AbstractInfoflow
implements IInfoflow {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected IPathBuilderFactory pathBuilderFactory;
    protected InfoflowConfiguration config = new InfoflowConfiguration();
    protected ITaintPropagationWrapper taintWrapper;
    protected INativeCallHandler nativeCallHandler = new DefaultNativeCallHandler();
    protected IIPCManager ipcManager = new DefaultIPCManager(new ArrayList<String>());
    protected final BiDirICFGFactory icfgFactory;
    protected Collection<? extends PreAnalysisHandler> preProcessors = Collections.emptyList();
    protected Collection<? extends PostAnalysisHandler> postProcessors = Collections.emptyList();
    protected final String androidPath;
    protected final boolean forceAndroidJar;
    protected IInfoflowConfig sootConfig;
    protected FastHierarchy hierarchy;

    public AbstractInfoflow() {
        this(null, "", false);
    }

    public AbstractInfoflow(BiDirICFGFactory icfgFactory, String androidPath, boolean forceAndroidJar) {
        if (icfgFactory == null) {
            DefaultBiDiICFGFactory factory = new DefaultBiDiICFGFactory();
            factory.setIsAndroid(androidPath != null && !androidPath.isEmpty());
            this.icfgFactory = factory;
        } else {
            this.icfgFactory = icfgFactory;
        }
        this.androidPath = androidPath;
        this.forceAndroidJar = forceAndroidJar;
    }

    @Override
    public InfoflowConfiguration getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(InfoflowConfiguration config) {
        this.config = config;
    }

    @Override
    public void setTaintWrapper(ITaintPropagationWrapper wrapper) {
        this.taintWrapper = wrapper;
    }

    @Override
    public void setNativeCallHandler(INativeCallHandler handler) {
        this.nativeCallHandler = handler;
    }

    @Override
    public ITaintPropagationWrapper getTaintWrapper() {
        return this.taintWrapper;
    }

    @Override
    public void setPreProcessors(Collection<? extends PreAnalysisHandler> preprocessors) {
        this.preProcessors = preprocessors;
    }

    @Override
    public void setPostProcessors(Collection<? extends PostAnalysisHandler> postprocessors) {
        this.postProcessors = postprocessors;
    }

    @Override
    public void computeInfoflow(String appPath, String libPath, IEntryPointCreator entryPointCreator, List<String> sources, List<String> sinks) {
        this.computeInfoflow(appPath, libPath, entryPointCreator, (ISourceSinkManager)new DefaultSourceSinkManager(sources, sinks));
    }

    @Override
    public void computeInfoflow(String appPath, String libPath, Collection<String> entryPoints, Collection<String> sources, Collection<String> sinks) {
        this.computeInfoflow(appPath, libPath, new DefaultEntryPointCreator(entryPoints), (ISourceSinkManager)new DefaultSourceSinkManager(sources, sinks));
    }

    @Override
    public void computeInfoflow(String libPath, String appPath, String entryPoint, Collection<String> sources, Collection<String> sinks) {
        this.computeInfoflow(appPath, libPath, entryPoint, (ISourceSinkManager)new DefaultSourceSinkManager(sources, sinks));
    }

    private String appendClasspath(String appPath, String libPath) {
        String s;
        String string = s = appPath != null && !appPath.isEmpty() ? appPath : "";
        if (libPath != null && !libPath.isEmpty()) {
            if (!s.isEmpty()) {
                s = s + File.pathSeparator;
            }
            s = s + libPath;
        }
        return s;
    }

    protected void initializeSoot(String appPath, String libPath, Collection<String> classes) {
        this.initializeSoot(appPath, libPath, classes, "");
    }

    protected void initializeSoot(String appPath, String libPath, Collection<String> classes, String extraSeed) {
        this.logger.info("Resetting Soot...");
        G.reset();
        Options.v().set_no_bodies_for_excluded(true);
        Options.v().set_allow_phantom_refs(true);
        if (this.config.getWriteOutputFiles()) {
            Options.v().set_output_format(1);
        } else {
            Options.v().set_output_format(12);
        }
        if (this.config.getCallgraphAlgorithm() == InfoflowConfiguration.CallgraphAlgorithm.OnDemand) {
            Options.v().set_soot_classpath(libPath);
            if (appPath != null) {
                LinkedList<String> processDirs = new LinkedList<String>();
                for (String ap : appPath.split(File.pathSeparator)) {
                    processDirs.add(ap);
                }
                Options.v().set_process_dir(processDirs);
            }
        } else {
            Options.v().set_soot_classpath(this.appendClasspath(appPath, libPath));
        }
        switch (this.config.getCallgraphAlgorithm()) {
            case AutomaticSelection: {
                if (extraSeed == null || extraSeed.isEmpty()) {
                    this.setSparkOptions();
                    break;
                }
                this.setChaOptions();
                break;
            }
            case CHA: {
                this.setChaOptions();
                break;
            }
            case RTA: {
                Options.v().setPhaseOption("cg.spark", "on");
                Options.v().setPhaseOption("cg.spark", "rta:true");
                Options.v().setPhaseOption("cg.spark", "on-fly-cg:false");
                Options.v().setPhaseOption("cg.spark", "string-constants:true");
                break;
            }
            case VTA: {
                Options.v().setPhaseOption("cg.spark", "on");
                Options.v().setPhaseOption("cg.spark", "vta:true");
                Options.v().setPhaseOption("cg.spark", "string-constants:true");
                break;
            }
            case SPARK: {
                this.setSparkOptions();
                break;
            }
            case GEOM: {
                this.setSparkOptions();
                AbstractInfoflow.setGeomPtaSpecificOptions();
                break;
            }
            case OnDemand: {
                break;
            }
            default: {
                throw new RuntimeException("Invalid callgraph algorithm");
            }
        }
        if (this.config.getCallgraphAlgorithm() != InfoflowConfiguration.CallgraphAlgorithm.OnDemand) {
            Options.v().set_whole_program(true);
            Options.v().setPhaseOption("cg", "trim-clinit:false");
            if (this.config.getEnableReflection()) {
                Options.v().setPhaseOption("cg", "types-for-invoke:true");
            }
        }
        Options.v().setPhaseOption("jb.ulp", "off");
        this.setSourcePrec();
        if (this.sootConfig != null) {
            this.sootConfig.setSootOptions(Options.v(), this.config);
        }
        for (String className : classes) {
            Scene.v().addBasicClass(className, 3);
        }
        Scene.v().loadNecessaryClasses();
        this.logger.info("Basic class loading done.");
        boolean hasClasses = false;
        for (String className : classes) {
            SootClass c = Scene.v().forceResolve(className, 3);
            if (c == null) continue;
            c.setApplicationClass();
            if (c.isPhantomClass() || c.isPhantom()) continue;
            hasClasses = true;
        }
        if (!hasClasses) {
            this.logger.error("Only phantom classes loaded, skipping analysis...");
            return;
        }
    }

    protected void setSourcePrec() {
        if (!this.androidPath.isEmpty()) {
            Options.v().set_src_prec(6);
            if (this.forceAndroidJar) {
                Options.v().set_force_android_jar(this.androidPath);
            } else {
                Options.v().set_android_jars(this.androidPath);
            }
        } else {
            Options.v().set_src_prec(4);
        }
    }

    private void setChaOptions() {
        Options.v().setPhaseOption("cg.cha", "on");
    }

    private void setSparkOptions() {
        Options.v().setPhaseOption("cg.spark", "on");
        Options.v().setPhaseOption("cg.spark", "string-constants:true");
    }

    public static void setGeomPtaSpecificOptions() {
        Options.v().setPhaseOption("cg.spark", "geom-pta:true");
        Options.v().setPhaseOption("cg.spark", "geom-encoding:Geom");
        Options.v().setPhaseOption("cg.spark", "geom-worklist:PQ");
    }

    @Override
    public void setSootConfig(IInfoflowConfig config) {
        this.sootConfig = config;
    }

    @Override
    public void setIPCManager(IIPCManager ipcManager) {
        this.ipcManager = ipcManager;
    }

    @Override
    public void setPathBuilderFactory(IPathBuilderFactory factory) {
        this.pathBuilderFactory = factory;
    }

    protected void constructCallgraph() {
        if (this.ipcManager != null) {
            this.ipcManager.updateJimpleForICC();
        }
        for (PreAnalysisHandler preAnalysisHandler : this.preProcessors) {
            preAnalysisHandler.onBeforeCallgraphConstruction();
        }
        LibraryClassPatcher patcher = this.getLibraryClassPatcher();
        patcher.patchLibraries();
        for (SootClass sootClass : Scene.v().getClasses()) {
            if (sootClass.resolvingLevel() != 0) continue;
            sootClass.setResolvingLevel(3);
            sootClass.setPhantomClass();
        }
        if (this.config.getCallgraphAlgorithm() != InfoflowConfiguration.CallgraphAlgorithm.OnDemand && !Scene.v().hasCallGraph()) {
            PackManager.v().getPack("wjpp").apply();
            PackManager.v().getPack("cg").apply();
        }
        this.hierarchy = Scene.v().getOrMakeFastHierarchy();
        for (PreAnalysisHandler preAnalysisHandler : this.preProcessors) {
            preAnalysisHandler.onAfterCallgraphConstruction();
        }
    }

    protected LibraryClassPatcher getLibraryClassPatcher() {
        return new LibraryClassPatcher();
    }
}

