/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.cmd;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.android.InfoflowAndroidConfiguration;
import soot.jimple.infoflow.android.SetupApplication;
import soot.jimple.infoflow.android.config.XMLConfigurationParser;
import soot.jimple.infoflow.cmd.AbortAnalysisException;
import soot.jimple.infoflow.methodSummary.data.provider.IMethodSummaryProvider;
import soot.jimple.infoflow.methodSummary.data.provider.LazySummaryProvider;
import soot.jimple.infoflow.methodSummary.taintWrappers.ReportMissingSummaryWrapper;
import soot.jimple.infoflow.methodSummary.taintWrappers.SummaryTaintWrapper;
import soot.jimple.infoflow.methodSummary.taintWrappers.TaintWrapperFactory;
import soot.jimple.infoflow.taintWrappers.EasyTaintWrapper;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.infoflow.taintWrappers.TaintWrapperSet;
import soot.util.HashMultiMap;

public class MainClass {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Options options = new Options();
    protected SetupApplication analyzer = null;
    protected ReportMissingSummaryWrapper reportMissingSummaryWrapper;
    protected Set<String> filesToSkip = new HashSet<String>();
    private static final String OPTION_CONFIG_FILE = "c";
    private static final String OPTION_APK_FILE = "a";
    private static final String OPTION_PLATFORMS_DIR = "p";
    private static final String OPTION_SOURCES_SINKS_FILE = "s";
    private static final String OPTION_OUTPUT_FILE = "o";
    private static final String OPTION_ADDITIONAL_CLASSPATH = "ac";
    private static final String OPTION_SKIP_APK_FILE = "si";
    private static final String OPTION_WRITE_JIMPLE_FILES = "wj";
    private static final String OPTION_TIMEOUT = "dt";
    private static final String OPTION_CALLBACK_TIMEOUT = "ct";
    private static final String OPTION_RESULT_TIMEOUT = "rt";
    private static final String OPTION_NO_STATIC_FLOWS = "ns";
    private static final String OPTION_NO_CALLBACK_ANALYSIS = "nc";
    private static final String OPTION_NO_EXCEPTIONAL_FLOWS = "ne";
    private static final String OPTION_NO_TYPE_CHECKING = "nt";
    private static final String OPTION_REFLECTION = "r";
    private static final String OPTION_MISSING_SUMMARIES_FILE = "ms";
    private static final String OPTION_OUTPUT_LINENUMBERS = "ol";
    private static final String OPTION_ORIGINAL_NAMES = "on";
    private static final String OPTION_TAINT_WRAPPER = "tw";
    private static final String OPTION_TAINT_WRAPPER_FILE = "t";
    private static final String OPTION_ACCESS_PATH_LENGTH = "al";
    private static final String OPTION_NO_THIS_CHAIN_REDUCTION = "nr";
    private static final String OPTION_FLOW_INSENSITIVE_ALIASING = "af";
    private static final String OPTION_COMPUTE_PATHS = "cp";
    private static final String OPTION_ONE_SOURCE = "os";
    private static final String OPTION_ONE_COMPONENT = "ot";
    private static final String OPTION_SEQUENTIAL_PATHS = "sp";
    private static final String OPTION_LOG_SOURCES_SINKS = "ls";
    private static final String OPTION_MERGE_DEX_FILES = "d";
    private static final String OPTION_SINGLE_JOIN_POINT = "sa";
    private static final String OPTION_MAX_CALLBACKS_COMPONENT = "mc";
    private static final String OPTION_MAX_CALLBACKS_DEPTH = "md";
    private static final String OPTION_PATH_SPECIFIC_RESULTS = "ps";
    private static final String OPTION_ICC_MODEL = "im";
    private static final String OPTION_ICC_NO_PURIFY = "np";
    private static final String OPTION_CALLGRAPH_ALGO = "cg";
    private static final String OPTION_LAYOUT_MODE = "l";
    private static final String OPTION_PATH_RECONSTRUCTION_ALGO = "pa";
    private static final String OPTION_CALLBACK_ANALYZER = "ca";
    private static final String OPTION_DATA_FLOW_SOLVER = "ds";
    private static final String OPTION_ALIAS_ALGO = "aa";
    private static final String OPTION_CODE_ELIMINATION_MODE = "ce";
    private static final String OPTION_CALLBACK_SOURCE_MODE = "cs";
    private static final String OPTION_PATH_RECONSTRUCTION_MODE = "pr";
    private static final String OPTION_IMPLICIT_FLOW_MODE = "i";
    private static final String OPTION_STATIC_FLOW_TRACKING_MODE = "sf";
    private static final String OPTION_ANALYZE_FRAMEWORKS = "ff";

    protected MainClass() {
        this.initializeCommandLineOptions();
    }

    private void initializeCommandLineOptions() {
        this.options.addOption("?", "help", false, "Print this help message");
        this.options.addOption(OPTION_CONFIG_FILE, "configfile", true, "Use the given configuration file");
        this.options.addOption(OPTION_APK_FILE, "apkfile", true, "APK file to analyze");
        this.options.addOption(OPTION_PLATFORMS_DIR, "platformsdir", true, "Path to the platforms directory from the Android SDK");
        this.options.addOption(OPTION_SOURCES_SINKS_FILE, "sourcessinksfile", true, "Definition file for sources and sinks");
        this.options.addOption(OPTION_OUTPUT_FILE, "outputfile", true, "Output XML file for the discovered data flows");
        this.options.addOption(OPTION_ADDITIONAL_CLASSPATH, "additionalclasspath", true, "Additional JAR file that shal be put on the classpath");
        this.options.addOption(OPTION_SKIP_APK_FILE, "skipapkfile", true, "APK file to skip when processing a directory of input files");
        this.options.addOption(OPTION_WRITE_JIMPLE_FILES, "writejimplefiles", true, "Write out the Jimple files");
        this.options.addOption(OPTION_TIMEOUT, "timeout", true, "Timeout for the main data flow analysis");
        this.options.addOption(OPTION_CALLBACK_TIMEOUT, "callbacktimeout", true, "Timeout for the callback collection phase");
        this.options.addOption(OPTION_RESULT_TIMEOUT, "resulttimeout", true, "Timeout for the result collection phase");
        this.options.addOption(OPTION_NO_STATIC_FLOWS, "nostatic", false, "Do not track static data flows");
        this.options.addOption(OPTION_NO_CALLBACK_ANALYSIS, "nocallbacks", false, "Do not analyze Android callbacks");
        this.options.addOption(OPTION_NO_EXCEPTIONAL_FLOWS, "noexceptions", false, "Do not track taints across exceptional control flow edges");
        this.options.addOption(OPTION_NO_TYPE_CHECKING, "notypechecking", false, "Disable type checking during taint propagation");
        this.options.addOption(OPTION_REFLECTION, "enablereflection", false, "Enable support for reflective method calls");
        this.options.addOption(OPTION_MISSING_SUMMARIES_FILE, "missingsummariesoutputfile", true, "Outputs a file with information about which summaries are missing");
        this.options.addOption(OPTION_OUTPUT_LINENUMBERS, "outputlinenumbers", false, "Enable the output of bytecode line numbers associated with sources and sinks in XML results");
        this.options.addOption(OPTION_ORIGINAL_NAMES, "originalnames", false, "Enable the usage of original variablenames if available");
        this.options.addOption(OPTION_TAINT_WRAPPER, "taintwrapper", true, "Use the specified taint wrapper algorithm (NONE, EASY, STUBDROID, MULTI)");
        this.options.addOption(OPTION_TAINT_WRAPPER_FILE, "taintwrapperfile", true, "Definition file for the taint wrapper");
        this.options.addOption(OPTION_ACCESS_PATH_LENGTH, "aplength", true, "Maximum access path length");
        this.options.addOption(OPTION_NO_THIS_CHAIN_REDUCTION, "nothischainreduction", false, "Disable reduction of inner class chains");
        this.options.addOption(OPTION_FLOW_INSENSITIVE_ALIASING, "aliasflowins", false, "Use a flow-insensitive alias analysis");
        this.options.addOption(OPTION_COMPUTE_PATHS, "paths", false, "Compute the taint propagation paths and not just source-to-sink connections. This is a shorthand notation for -pr fast.");
        this.options.addOption(OPTION_LOG_SOURCES_SINKS, "logsourcesandsinks", false, "Write the discovered sources and sinks to the log output");
        this.options.addOption("mt", "maxthreadnum", true, "Limit the maximum number of threads to the given value");
        this.options.addOption(OPTION_ONE_COMPONENT, "onecomponentatatime", false, "Analyze one Android component at a time");
        this.options.addOption(OPTION_ONE_SOURCE, "onesourceatatime", false, "Analyze one source at a time");
        this.options.addOption(OPTION_SEQUENTIAL_PATHS, "sequentialpathprocessing", false, "Process the result paths sequentially instead of in parallel");
        this.options.addOption(OPTION_SINGLE_JOIN_POINT, "singlejoinpointabstraction", false, "Only use a single abstraction at join points, i.e., do not support multiple sources for one value");
        this.options.addOption(OPTION_MAX_CALLBACKS_COMPONENT, "maxcallbackspercomponent", true, "Eliminate Android components that have more than the given number of callbacks");
        this.options.addOption(OPTION_MAX_CALLBACKS_DEPTH, "maxcallbacksdepth", true, "Only analyze callback chains up to the given depth");
        this.options.addOption(OPTION_MERGE_DEX_FILES, "mergedexfiles", false, "Merge all dex files in the given APK file into one analysis target");
        this.options.addOption(OPTION_PATH_SPECIFIC_RESULTS, "pathspecificresults", false, "Report different results for same source/sink pairs if they differ in their propagation paths");
        this.options.addOption(OPTION_ICC_MODEL, "iccmodel", true, "File containing the inter-component data flow model (ICC model)");
        this.options.addOption(OPTION_ICC_NO_PURIFY, "noiccresultspurify", false, "Do not purify the ICC results, i.e., do not remove simple flows that also have a corresponding ICC flow");
        this.options.addOption(OPTION_CALLGRAPH_ALGO, "cgalgo", true, "Callgraph algorithm to use (AUTO, CHA, VTA, RTA, SPARK, GEOM)");
        this.options.addOption(OPTION_LAYOUT_MODE, "layoutmode", true, "Mode for considerung layout controls as sources (NONE, PWD, ALL)");
        this.options.addOption(OPTION_PATH_RECONSTRUCTION_ALGO, "pathalgo", true, "Use the specified algorithm for computing result paths (CONTEXTSENSITIVE, CONTEXTINSENSITIVE, SOURCESONLY)");
        this.options.addOption(OPTION_CALLBACK_ANALYZER, "callbackanalyzer", true, "Use the specified callback analyzer (DEFAULT, FAST)");
        this.options.addOption(OPTION_DATA_FLOW_SOLVER, "dataflowsolver", true, "Use the specified data flow solver (CONTEXTFLOWSENSITIVE, FLOWINSENSITIVE)");
        this.options.addOption(OPTION_ALIAS_ALGO, "aliasalgo", true, "Use the specified aliasing algorithm (NONE, FLOWSENSITIVE, PTSBASED, LAZY)");
        this.options.addOption(OPTION_CODE_ELIMINATION_MODE, "codeelimination", true, "Use the specified code elimination algorithm (NONE, PROPAGATECONSTS, REMOVECODE)");
        this.options.addOption(OPTION_CALLBACK_SOURCE_MODE, "callbacksourcemode", true, "Use the specified mode for defining which callbacks introduce which sources (NONE, ALL, SOURCELIST)");
        this.options.addOption(OPTION_PATH_RECONSTRUCTION_MODE, "pathreconstructionmode", true, "Use the specified mode for reconstructing taint propagation paths (NONE, FAST, PRECISE).");
        this.options.addOption(OPTION_IMPLICIT_FLOW_MODE, "implicit", true, "Use the specified mode when processing implicit data flows (NONE, ARRAYONLY, ALL)");
        this.options.addOption(OPTION_STATIC_FLOW_TRACKING_MODE, "staticmode", true, "Use the specified mode when tracking static data flows (CONTEXTFLOWSENSITIVE, CONTEXTFLOWINSENSITIVE, NONE)");
        this.options.addOption(OPTION_ANALYZE_FRAMEWORKS, "analyzeframeworks", false, "Analyze the full frameworks together with the app without any optimizations");
    }

    public static void main(String[] args) throws Exception {
        MainClass main = new MainClass();
        main.run(args);
    }

    protected void run(String[] args) throws Exception {
        HelpFormatter formatter = new HelpFormatter();
        if (args.length == 0) {
            formatter.printHelp("soot-infoflow-cmd [OPTIONS]", this.options);
            return;
        }
        DefaultParser parser = new DefaultParser();
        try {
            InfoflowAndroidConfiguration config;
            CommandLine cmd = parser.parse(this.options, args);
            if (cmd.hasOption("?") || cmd.hasOption("help")) {
                formatter.printHelp("soot-infoflow-cmd [OPTIONS]", this.options);
                return;
            }
            String configFile = cmd.getOptionValue(OPTION_CONFIG_FILE);
            InfoflowAndroidConfiguration infoflowAndroidConfiguration = config = configFile == null || configFile.isEmpty() ? new InfoflowAndroidConfiguration() : this.loadConfigurationFile(configFile);
            if (config == null) {
                return;
            }
            this.parseCommandLineOptions(cmd, config);
            File targetFile = new File(config.getAnalysisFileConfig().getTargetAPKFile());
            if (!targetFile.exists()) {
                System.err.println(String.format("Target APK file %s does not exist", targetFile.getCanonicalPath()));
                return;
            }
            List<File> apksToAnalyze = targetFile.isDirectory() ? Arrays.asList(targetFile.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".apk");
                }
            })) : Collections.singletonList(targetFile);
            String outputFileStr = config.getAnalysisFileConfig().getOutputFile();
            File outputFile = null;
            if (outputFileStr != null && !outputFileStr.isEmpty()) {
                outputFile = new File(outputFileStr);
                if (outputFile.exists()) {
                    if (apksToAnalyze.size() > 1 && outputFile.isFile()) {
                        System.err.println("The output file must be a directory when analyzing multiple APKs");
                        return;
                    }
                } else if (apksToAnalyze.size() > 1) {
                    outputFile.mkdirs();
                }
            }
            ITaintPropagationWrapper taintWrapper = this.initializeTaintWrapper(cmd);
            int curAppIdx = 1;
            for (File apkFile : apksToAnalyze) {
                if (this.filesToSkip.contains(apkFile.getName())) {
                    this.logger.info(String.format("Skipping app %s (%d of %d)...", apkFile.getCanonicalPath(), curAppIdx++, apksToAnalyze.size()));
                    continue;
                }
                this.logger.info(String.format("Analyzing app %s (%d of %d)...", apkFile.getCanonicalPath(), curAppIdx++, apksToAnalyze.size()));
                config.getAnalysisFileConfig().setTargetAPKFile(apkFile.getCanonicalPath());
                if (outputFile != null && (apksToAnalyze.size() > 1 || outputFile.exists() && outputFile.isDirectory())) {
                    String outputFileName = apkFile.getName().replace(".apk", ".xml");
                    File curOutputFile = new File(outputFile, outputFileName);
                    config.getAnalysisFileConfig().setOutputFile(curOutputFile.getCanonicalPath());
                    if (curOutputFile.exists()) continue;
                }
                this.analyzer = this.createFlowDroidInstance(config);
                this.analyzer.setTaintWrapper(taintWrapper);
                this.analyzer.runInfoflow();
                if (this.reportMissingSummaryWrapper == null) continue;
                String file = cmd.getOptionValue(OPTION_MISSING_SUMMARIES_FILE);
                this.reportMissingSummaryWrapper.writeResults(new File(file));
            }
        }
        catch (AbortAnalysisException cmd) {
        }
        catch (ParseException e) {
            formatter.printHelp("soot-infoflow-cmd [OPTIONS]", this.options);
            return;
        }
        catch (Exception e) {
            System.err.println(String.format("The data flow analysis has failed. Error message: %s", e.getMessage()));
            e.printStackTrace();
        }
    }

    protected SetupApplication createFlowDroidInstance(InfoflowAndroidConfiguration config) {
        return new SetupApplication(config);
    }

    private ITaintPropagationWrapper initializeTaintWrapper(CommandLine cmd) throws Exception {
        if (cmd.hasOption(OPTION_ANALYZE_FRAMEWORKS)) {
            return null;
        }
        String[] definitionFiles = cmd.getOptionValues(OPTION_TAINT_WRAPPER_FILE);
        String taintWrapper = cmd.getOptionValue(OPTION_TAINT_WRAPPER);
        if (taintWrapper == null || taintWrapper.isEmpty()) {
            taintWrapper = definitionFiles != null && definitionFiles.length > 0 ? "multi" : "default";
        }
        SummaryTaintWrapper result = null;
        switch (taintWrapper.toLowerCase()) {
            case "default": {
                result = this.createSummaryTaintWrapper(cmd, new LazySummaryProvider("summariesManual"));
                break;
            }
            case "defaultfallback": {
                SummaryTaintWrapper summaryWrapper = this.createSummaryTaintWrapper(cmd, new LazySummaryProvider("summariesManual"));
                summaryWrapper.setFallbackTaintWrapper((ITaintPropagationWrapper)EasyTaintWrapper.getDefault());
                result = summaryWrapper;
                break;
            }
            case "none": {
                break;
            }
            case "easy": {
                String defFile = null;
                if (definitionFiles == null || definitionFiles.length == 0) {
                    File defaultFile = EasyTaintWrapper.locateDefaultDefinitionFile();
                    if (defaultFile == null) {
                        try {
                            return new EasyTaintWrapper(defFile);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.err.println("No definition file for the easy taint wrapper specified and could not find the default file");
                            throw new AbortAnalysisException();
                        }
                    }
                    defFile = defaultFile.getCanonicalPath();
                } else {
                    if (definitionFiles == null || definitionFiles.length != 1) {
                        System.err.println("Must specify exactly one definition file for the easy taint wrapper");
                        throw new AbortAnalysisException();
                    }
                    defFile = definitionFiles[0];
                }
                result = new EasyTaintWrapper(defFile);
                break;
            }
            case "stubdroid": {
                if (definitionFiles == null || definitionFiles.length == 0) {
                    System.err.println("Must specify at least one definition file for StubDroid");
                    throw new AbortAnalysisException();
                }
                result = TaintWrapperFactory.createTaintWrapper(Arrays.asList(definitionFiles));
                break;
            }
            case "multi": {
                Set easyDefinitions;
                if (definitionFiles == null || definitionFiles.length == 0) {
                    System.err.println("Must explicitly specify the definition files for the multi mode");
                    throw new AbortAnalysisException();
                }
                HashMultiMap extensionToFile = new HashMultiMap(definitionFiles.length);
                for (String str : definitionFiles) {
                    File f = new File(str);
                    if (f.isFile()) {
                        String fileName = f.getName();
                        extensionToFile.put((Object)fileName.substring(fileName.lastIndexOf(".")), (Object)f.getCanonicalPath());
                        continue;
                    }
                    if (!f.isDirectory()) continue;
                    extensionToFile.put((Object)".xml", (Object)f.getCanonicalPath());
                }
                TaintWrapperSet wrapperSet = new TaintWrapperSet();
                SummaryTaintWrapper stubDroidWrapper = null;
                if (extensionToFile.containsKey((Object)".xml")) {
                    stubDroidWrapper = TaintWrapperFactory.createTaintWrapper((Collection)extensionToFile.get((Object)".xml"));
                    wrapperSet.addWrapper((ITaintPropagationWrapper)stubDroidWrapper);
                }
                if (!(easyDefinitions = extensionToFile.get((Object)".txt")).isEmpty()) {
                    if (easyDefinitions.size() > 1) {
                        System.err.println("Must specify exactly one definition file for the easy taint wrapper");
                        throw new AbortAnalysisException();
                    }
                    EasyTaintWrapper easyWrapper = new EasyTaintWrapper((String)easyDefinitions.iterator().next());
                    if (stubDroidWrapper == null) {
                        wrapperSet.addWrapper((ITaintPropagationWrapper)easyWrapper);
                    } else {
                        stubDroidWrapper.setFallbackTaintWrapper((ITaintPropagationWrapper)easyWrapper);
                    }
                }
                result = wrapperSet;
                break;
            }
            default: {
                System.err.println("Invalid taint propagation wrapper specified, ignoring.");
                throw new AbortAnalysisException();
            }
        }
        return result;
    }

    private SummaryTaintWrapper createSummaryTaintWrapper(CommandLine cmd, LazySummaryProvider lazySummaryProvider) {
        if (cmd.hasOption(OPTION_MISSING_SUMMARIES_FILE)) {
            this.reportMissingSummaryWrapper = new ReportMissingSummaryWrapper((IMethodSummaryProvider)lazySummaryProvider);
            return this.reportMissingSummaryWrapper;
        }
        return new SummaryTaintWrapper((IMethodSummaryProvider)lazySummaryProvider);
    }

    private static InfoflowConfiguration.CallgraphAlgorithm parseCallgraphAlgorithm(String algo) {
        if (algo.equalsIgnoreCase("AUTO")) {
            return InfoflowConfiguration.CallgraphAlgorithm.AutomaticSelection;
        }
        if (algo.equalsIgnoreCase("CHA")) {
            return InfoflowConfiguration.CallgraphAlgorithm.CHA;
        }
        if (algo.equalsIgnoreCase("VTA")) {
            return InfoflowConfiguration.CallgraphAlgorithm.VTA;
        }
        if (algo.equalsIgnoreCase("RTA")) {
            return InfoflowConfiguration.CallgraphAlgorithm.RTA;
        }
        if (algo.equalsIgnoreCase("SPARK")) {
            return InfoflowConfiguration.CallgraphAlgorithm.SPARK;
        }
        if (algo.equalsIgnoreCase("GEOM")) {
            return InfoflowConfiguration.CallgraphAlgorithm.GEOM;
        }
        System.err.println(String.format("Invalid callgraph algorithm: %s", algo));
        throw new AbortAnalysisException();
    }

    private static InfoflowConfiguration.LayoutMatchingMode parseLayoutMatchingMode(String layoutMode) {
        if (layoutMode.equalsIgnoreCase("NONE")) {
            return InfoflowConfiguration.LayoutMatchingMode.NoMatch;
        }
        if (layoutMode.equalsIgnoreCase("PWD")) {
            return InfoflowConfiguration.LayoutMatchingMode.MatchSensitiveOnly;
        }
        if (layoutMode.equalsIgnoreCase("ALL")) {
            return InfoflowConfiguration.LayoutMatchingMode.MatchAll;
        }
        System.err.println(String.format("Invalid layout matching mode: %s", layoutMode));
        throw new AbortAnalysisException();
    }

    private static InfoflowConfiguration.PathBuildingAlgorithm parsePathReconstructionAlgo(String pathAlgo) {
        if (pathAlgo.equalsIgnoreCase("CONTEXTSENSITIVE")) {
            return InfoflowConfiguration.PathBuildingAlgorithm.ContextSensitive;
        }
        if (pathAlgo.equalsIgnoreCase("CONTEXTINSENSITIVE")) {
            return InfoflowConfiguration.PathBuildingAlgorithm.ContextInsensitive;
        }
        if (pathAlgo.equalsIgnoreCase("SOURCESONLY")) {
            return InfoflowConfiguration.PathBuildingAlgorithm.ContextInsensitiveSourceFinder;
        }
        if (pathAlgo.equalsIgnoreCase("RECURSIVE")) {
            return InfoflowConfiguration.PathBuildingAlgorithm.Recursive;
        }
        System.err.println(String.format("Invalid path reconstruction algorithm: %s", pathAlgo));
        throw new AbortAnalysisException();
    }

    private static InfoflowAndroidConfiguration.CallbackAnalyzer parseCallbackAnalyzer(String callbackAnalyzer) {
        if (callbackAnalyzer.equalsIgnoreCase("DEFAULT")) {
            return InfoflowAndroidConfiguration.CallbackAnalyzer.Default;
        }
        if (callbackAnalyzer.equalsIgnoreCase("FAST")) {
            return InfoflowAndroidConfiguration.CallbackAnalyzer.Fast;
        }
        System.err.println(String.format("Invalid callback analysis algorithm: %s", callbackAnalyzer));
        throw new AbortAnalysisException();
    }

    private static InfoflowConfiguration.DataFlowSolver parseDataFlowSolver(String solver) {
        if (solver.equalsIgnoreCase("CONTEXTFLOWSENSITIVE")) {
            return InfoflowConfiguration.DataFlowSolver.ContextFlowSensitive;
        }
        if (solver.equalsIgnoreCase("FLOWINSENSITIVE")) {
            return InfoflowConfiguration.DataFlowSolver.FlowInsensitive;
        }
        if (solver.equalsIgnoreCase("GC")) {
            return InfoflowConfiguration.DataFlowSolver.GarbageCollecting;
        }
        System.err.println(String.format("Invalid data flow solver: %s", solver));
        throw new AbortAnalysisException();
    }

    private static InfoflowConfiguration.AliasingAlgorithm parseAliasAlgorithm(String aliasAlgo) {
        if (aliasAlgo.equalsIgnoreCase("NONE")) {
            return InfoflowConfiguration.AliasingAlgorithm.None;
        }
        if (aliasAlgo.equalsIgnoreCase("FLOWSENSITIVE")) {
            return InfoflowConfiguration.AliasingAlgorithm.FlowSensitive;
        }
        if (aliasAlgo.equalsIgnoreCase("PTSBASED")) {
            return InfoflowConfiguration.AliasingAlgorithm.PtsBased;
        }
        if (aliasAlgo.equalsIgnoreCase("LAZY")) {
            return InfoflowConfiguration.AliasingAlgorithm.Lazy;
        }
        System.err.println(String.format("Invalid aliasing algorithm: %s", aliasAlgo));
        throw new AbortAnalysisException();
    }

    private static InfoflowConfiguration.CodeEliminationMode parseCodeEliminationMode(String eliminationMode) {
        if (eliminationMode.equalsIgnoreCase("NONE")) {
            return InfoflowConfiguration.CodeEliminationMode.NoCodeElimination;
        }
        if (eliminationMode.equalsIgnoreCase("PROPAGATECONSTS")) {
            return InfoflowConfiguration.CodeEliminationMode.PropagateConstants;
        }
        if (eliminationMode.equalsIgnoreCase("REMOVECODE")) {
            return InfoflowConfiguration.CodeEliminationMode.RemoveSideEffectFreeCode;
        }
        System.err.println(String.format("Invalid code elimination mode: %s", eliminationMode));
        throw new AbortAnalysisException();
    }

    private static InfoflowConfiguration.CallbackSourceMode parseCallbackSourceMode(String callbackMode) {
        if (callbackMode.equalsIgnoreCase("NONE")) {
            return InfoflowConfiguration.CallbackSourceMode.NoParametersAsSources;
        }
        if (callbackMode.equalsIgnoreCase("ALL")) {
            return InfoflowConfiguration.CallbackSourceMode.AllParametersAsSources;
        }
        if (callbackMode.equalsIgnoreCase("SOURCELIST")) {
            return InfoflowConfiguration.CallbackSourceMode.SourceListOnly;
        }
        System.err.println(String.format("Invalid callback source mode: %s", callbackMode));
        throw new AbortAnalysisException();
    }

    private static InfoflowConfiguration.PathReconstructionMode parsePathReconstructionMode(String pathReconstructionMode) {
        if (pathReconstructionMode.equalsIgnoreCase("NONE")) {
            return InfoflowConfiguration.PathReconstructionMode.NoPaths;
        }
        if (pathReconstructionMode.equalsIgnoreCase("FAST")) {
            return InfoflowConfiguration.PathReconstructionMode.Fast;
        }
        if (pathReconstructionMode.equalsIgnoreCase("PRECISE")) {
            return InfoflowConfiguration.PathReconstructionMode.Precise;
        }
        System.err.println(String.format("Invalid path reconstruction mode: %s", pathReconstructionMode));
        throw new AbortAnalysisException();
    }

    private static InfoflowConfiguration.ImplicitFlowMode parseImplicitFlowMode(String implicitFlowMode) {
        if (implicitFlowMode.equalsIgnoreCase("NONE")) {
            return InfoflowConfiguration.ImplicitFlowMode.NoImplicitFlows;
        }
        if (implicitFlowMode.equalsIgnoreCase("ARRAYONLY")) {
            return InfoflowConfiguration.ImplicitFlowMode.ArrayAccesses;
        }
        if (implicitFlowMode.equalsIgnoreCase("ALL")) {
            return InfoflowConfiguration.ImplicitFlowMode.AllImplicitFlows;
        }
        System.err.println(String.format("Invalid implicit flow mode: %s", implicitFlowMode));
        throw new AbortAnalysisException();
    }

    private static InfoflowConfiguration.StaticFieldTrackingMode parseStaticFlowMode(String staticFlowMode) {
        if (staticFlowMode.equalsIgnoreCase("NONE")) {
            return InfoflowConfiguration.StaticFieldTrackingMode.None;
        }
        if (staticFlowMode.equalsIgnoreCase("CONTEXTFLOWSENSITIVE")) {
            return InfoflowConfiguration.StaticFieldTrackingMode.ContextFlowSensitive;
        }
        if (staticFlowMode.equalsIgnoreCase("CONTEXTFLOWINSENSITIVE")) {
            return InfoflowConfiguration.StaticFieldTrackingMode.ContextFlowInsensitive;
        }
        System.err.println(String.format("Invalid static flow tracking mode: %s", staticFlowMode));
        throw new AbortAnalysisException();
    }

    private void parseCommandLineOptions(CommandLine cmd, InfoflowAndroidConfiguration config) {
        String[] toSkip;
        String staticFlowMode;
        String implicitMode;
        String pathMode;
        String callbackMode;
        String eliminationMode;
        String aliasAlgo;
        String solver;
        String callbackAnalyzer;
        String pathAlgo;
        String layoutMode;
        String cgalgo;
        String iccModel;
        Integer maxDepth;
        Integer maxCallbacks;
        Integer aplength;
        Integer timeout;
        String additionalClasspath;
        String outputFile;
        String sourcesSinks;
        String platformsDir;
        String apkFile = cmd.getOptionValue(OPTION_APK_FILE);
        if (apkFile != null && !apkFile.isEmpty()) {
            config.getAnalysisFileConfig().setTargetAPKFile(apkFile);
        }
        if ((platformsDir = cmd.getOptionValue(OPTION_PLATFORMS_DIR)) != null && !platformsDir.isEmpty()) {
            config.getAnalysisFileConfig().setAndroidPlatformDir(platformsDir);
        }
        if ((sourcesSinks = cmd.getOptionValue(OPTION_SOURCES_SINKS_FILE)) != null && !sourcesSinks.isEmpty()) {
            config.getAnalysisFileConfig().setSourceSinkFile(sourcesSinks);
        }
        if ((outputFile = cmd.getOptionValue(OPTION_OUTPUT_FILE)) != null && !outputFile.isEmpty()) {
            config.getAnalysisFileConfig().setOutputFile(outputFile);
        }
        if ((additionalClasspath = cmd.getOptionValue(OPTION_ADDITIONAL_CLASSPATH)) != null && !additionalClasspath.isEmpty()) {
            config.getAnalysisFileConfig().setAdditionalClasspath(additionalClasspath);
        }
        if (cmd.hasOption(OPTION_WRITE_JIMPLE_FILES)) {
            config.setWriteOutputFiles(true);
        }
        if ((timeout = this.getIntOption(cmd, OPTION_TIMEOUT)) != null) {
            config.setDataFlowTimeout((long)timeout.intValue());
        }
        if ((timeout = this.getIntOption(cmd, OPTION_CALLBACK_TIMEOUT)) != null) {
            config.getCallbackConfig().setCallbackAnalysisTimeout(timeout.intValue());
        }
        if ((timeout = this.getIntOption(cmd, OPTION_RESULT_TIMEOUT)) != null) {
            config.getPathConfiguration().setPathReconstructionTimeout((long)timeout.intValue());
        }
        if (cmd.hasOption(OPTION_NO_STATIC_FLOWS)) {
            config.setStaticFieldTrackingMode(InfoflowConfiguration.StaticFieldTrackingMode.None);
        }
        if (cmd.hasOption(OPTION_NO_CALLBACK_ANALYSIS)) {
            config.getCallbackConfig().setEnableCallbacks(false);
        }
        if (cmd.hasOption(OPTION_NO_EXCEPTIONAL_FLOWS)) {
            config.setEnableExceptionTracking(false);
        }
        if (cmd.hasOption(OPTION_NO_TYPE_CHECKING)) {
            config.setEnableTypeChecking(false);
        }
        if (cmd.hasOption(OPTION_REFLECTION)) {
            config.setEnableReflection(true);
        }
        if (cmd.hasOption(OPTION_OUTPUT_LINENUMBERS)) {
            config.setEnableLineNumbers(true);
        }
        if (cmd.hasOption(OPTION_ORIGINAL_NAMES)) {
            config.setEnableOriginalNames(true);
        }
        if ((aplength = this.getIntOption(cmd, OPTION_ACCESS_PATH_LENGTH)) != null) {
            config.getAccessPathConfiguration().setAccessPathLength(aplength.intValue());
        }
        if (cmd.hasOption(OPTION_NO_THIS_CHAIN_REDUCTION)) {
            config.getAccessPathConfiguration().setUseThisChainReduction(false);
        }
        if (cmd.hasOption(OPTION_FLOW_INSENSITIVE_ALIASING)) {
            config.setFlowSensitiveAliasing(false);
        }
        if (cmd.hasOption(OPTION_COMPUTE_PATHS)) {
            config.getPathConfiguration().setPathReconstructionMode(InfoflowConfiguration.PathReconstructionMode.Fast);
        }
        if (cmd.hasOption(OPTION_ONE_SOURCE)) {
            config.setOneSourceAtATime(true);
        }
        if (cmd.hasOption(OPTION_ONE_COMPONENT)) {
            config.setOneComponentAtATime(true);
        }
        if (cmd.hasOption(OPTION_SEQUENTIAL_PATHS)) {
            config.getPathConfiguration().setSequentialPathProcessing(true);
        }
        if (cmd.hasOption(OPTION_LOG_SOURCES_SINKS)) {
            config.setLogSourcesAndSinks(true);
        }
        if (cmd.hasOption(OPTION_MERGE_DEX_FILES)) {
            config.setMergeDexFiles(true);
        }
        if (cmd.hasOption(OPTION_PATH_SPECIFIC_RESULTS)) {
            InfoflowConfiguration.setPathAgnosticResults((boolean)false);
        }
        if (cmd.hasOption(OPTION_SINGLE_JOIN_POINT)) {
            config.getSolverConfiguration().setSingleJoinPointAbstraction(true);
        }
        if ((maxCallbacks = this.getIntOption(cmd, OPTION_MAX_CALLBACKS_COMPONENT)) != null) {
            config.getCallbackConfig().setMaxCallbacksPerComponent(maxCallbacks.intValue());
        }
        if ((maxDepth = this.getIntOption(cmd, OPTION_MAX_CALLBACKS_DEPTH)) != null) {
            config.getCallbackConfig().setMaxAnalysisCallbackDepth(maxDepth.intValue());
        }
        if (cmd.hasOption(OPTION_ICC_NO_PURIFY)) {
            config.getIccConfig().setIccResultsPurify(false);
        }
        if ((iccModel = cmd.getOptionValue(OPTION_ICC_MODEL)) != null && !iccModel.isEmpty()) {
            config.getIccConfig().setIccModel(iccModel);
        }
        if ((cgalgo = cmd.getOptionValue(OPTION_CALLGRAPH_ALGO)) != null && !cgalgo.isEmpty()) {
            config.setCallgraphAlgorithm(MainClass.parseCallgraphAlgorithm(cgalgo));
        }
        if ((layoutMode = cmd.getOptionValue(OPTION_LAYOUT_MODE)) != null && !layoutMode.isEmpty()) {
            config.getSourceSinkConfig().setLayoutMatchingMode(MainClass.parseLayoutMatchingMode(layoutMode));
        }
        if ((pathAlgo = cmd.getOptionValue(OPTION_PATH_RECONSTRUCTION_ALGO)) != null && !pathAlgo.isEmpty()) {
            config.getPathConfiguration().setPathBuildingAlgorithm(MainClass.parsePathReconstructionAlgo(pathAlgo));
        }
        if ((callbackAnalyzer = cmd.getOptionValue(OPTION_CALLBACK_ANALYZER)) != null && !callbackAnalyzer.isEmpty()) {
            config.getCallbackConfig().setCallbackAnalyzer(MainClass.parseCallbackAnalyzer(callbackAnalyzer));
        }
        if ((solver = cmd.getOptionValue(OPTION_DATA_FLOW_SOLVER)) != null && !solver.isEmpty()) {
            config.getSolverConfiguration().setDataFlowSolver(MainClass.parseDataFlowSolver(solver));
        }
        if ((aliasAlgo = cmd.getOptionValue(OPTION_ALIAS_ALGO)) != null && !aliasAlgo.isEmpty()) {
            config.setAliasingAlgorithm(MainClass.parseAliasAlgorithm(aliasAlgo));
        }
        if ((eliminationMode = cmd.getOptionValue(OPTION_CODE_ELIMINATION_MODE)) != null && !eliminationMode.isEmpty()) {
            config.setCodeEliminationMode(MainClass.parseCodeEliminationMode(eliminationMode));
        }
        if ((callbackMode = cmd.getOptionValue(OPTION_CALLBACK_SOURCE_MODE)) != null && !callbackMode.isEmpty()) {
            config.getSourceSinkConfig().setCallbackSourceMode(MainClass.parseCallbackSourceMode(callbackMode));
        }
        if ((pathMode = cmd.getOptionValue(OPTION_PATH_RECONSTRUCTION_MODE)) != null && !pathMode.isEmpty()) {
            config.getPathConfiguration().setPathReconstructionMode(MainClass.parsePathReconstructionMode(pathMode));
        }
        if ((implicitMode = cmd.getOptionValue(OPTION_IMPLICIT_FLOW_MODE)) != null && !implicitMode.isEmpty()) {
            config.setImplicitFlowMode(MainClass.parseImplicitFlowMode(implicitMode));
        }
        if ((staticFlowMode = cmd.getOptionValue(OPTION_STATIC_FLOW_TRACKING_MODE)) != null && !staticFlowMode.isEmpty()) {
            config.setStaticFieldTrackingMode(MainClass.parseStaticFlowMode(staticFlowMode));
        }
        if ((toSkip = cmd.getOptionValues(OPTION_SKIP_APK_FILE)) != null && toSkip.length > 0) {
            for (String skipAPK : toSkip) {
                this.filesToSkip.add(skipAPK);
            }
        }
        if (cmd.hasOption(OPTION_ANALYZE_FRAMEWORKS)) {
            config.setExcludeSootLibraryClasses(false);
            config.setIgnoreFlowsInSystemPackages(false);
        }
    }

    private Integer getIntOption(CommandLine cmd, String option) {
        String str = cmd.getOptionValue(option);
        if (str == null || str.isEmpty()) {
            return null;
        }
        return Integer.parseInt(str);
    }

    private InfoflowAndroidConfiguration loadConfigurationFile(String configFile) {
        try {
            InfoflowAndroidConfiguration config = new InfoflowAndroidConfiguration();
            XMLConfigurationParser.fromFile((String)configFile).parse(config);
            return config;
        }
        catch (IOException e) {
            System.err.println("Could not parse configuration file: " + e.getMessage());
            return null;
        }
    }
}

