---
layout: documentation
title: Glossary
categories:
 - documentation
---
* **Component**: individual, pluggable and reusable piece of software. In this case a NoFlo-compatible CommonJS Module. See [Components documentation](../components)
* **Component Library**: an NPM module providing a set of components for a particular domain (for example, *noflo-filesystem* for file operations components). See [Publishing modules](../publishing)
* **Connection**: connection between an outport of a Process, and inport of another Process (also known as Edge in non-live graphs)
* **Graph**: the control logic of a FBP application, can be either in programmatical or file format. See [Graphs documentation](../graphs)
* **Initial Information Packet** (IIP): predefined data packet sent to a defined inport of a Process
* **Information Packet** (IP): Packets of information with either a type of `data`, `openBracket`, or `closeBracket`
* **Inport**: inbound port of a component
* **Network**: collection of processes connected by sockets. A running version of a graph
* **Outport**: outbound port of a component
* **Process**: an instance of a component that is running as part of a graph (also known as Node in non-live graphs)
* **Runtime**: an environment capable of running flow-based programs. For example NoFlo or JavaFBP
* **Stream**: a sequence of information packets surrounded by bracket IPs. A single non-bracketed information packet can also be considered a stream
* **Subgraph**: a graph that is being used as a component in another graph

See also the [Flow-Based Programming Glossary](http://www.jpaulmorrison.com/fbp/gloss.htm).
