# Node.js Release WorkGroup Meeting 2021-02-25

## Links

* **Recording**:  https://www.youtube.com/watch?v=Jzm5RmGkgBk
* **GitHub Issue**: https://github.com/nodejs/Release/issues/648
* **Minutes Google Doc**: https://docs.google.com/document/d/1b8xjkbMXPoh-ylHxsdNHqIcEIHVXW2LqEOOioYyssr8

## Present

* Beth Griggs (@BethGriggs)
* Danielle Adams (@danielleadams)
* Michael Zasso (@targos)
* Richard Lau (@richardlau)
* Ruy Adorno (@ruyadorno)
* Tierney Cyren (@bnb)

## Agenda

## Announcements

* Security releases went out on all active release lines.
  * https://nodejs.org/en/blog/vulnerability/february-2021-security-releases/

### nodejs/Release

* doc: add offboarding releasers guidance [#644](https://github.com/nodejs/Release/pull/644)
  * Need to gather a few more reviews.
* Release plan - v15.x Current [#621](https://github.com/nodejs/Release/issues/621)
  * Volunteers for all releases up until April.
* Release plan - v14.x Active LTS [#567](https://github.com/nodejs/Release/issues/567)
  * SemVer minor release planned, ideally in the March/April timeframe.
  * (Action) Land open backport PRs on `v14.x-staging`.
* Release plan - v12.x Maintenance [#494](https://github.com/nodejs/Release/issues/494)
  * (Action) Agreed we should do a SemVer minor to get the open backports PRs out, but after Node.js 14 minor.
* Release plan - v10.x Maintenance [#504](https://github.com/nodejs/Release/issues/504)
  * No pressing patches requiring release at this time.
* Proposal: New Release Model [#37504](https://github.com/nodejs/node/discussions/37504)
  * Release Working Group owns the release policy definition.
  * Concern that it would cause more complicated parsing of versions compared to SemVer.
  * Backporting to LTS could be improved by either reducing the Active LTS timeframe or making it more of an ‘opt-in’.
    * Prefer to tweak the current system rather than radically change it.
    * ‘opt-in’ would save a large portion of the effort in preparing a release.
  * Impact on consumers.
     * (Action) Can we look to the OpenJS Surveys for feedback?
     * Surveys/Twitter polls/etc. would still not be representative of all the Node.js consumers.
  * There is a demand for features being backported to LTS, from both consumers and contributors.
     * Hard to quantify this demand.
   * Node.js 16 is only a month and a half away, it’s too late to change for Node.js 16.
      * Per our documented process, test/release candidate builds for Node.js 16 would be starting imminently.
      * We cannot change course for Node.js 16 based on the proposal, as we do not know when (if at all) any of the proposed changes would be agreed.
      * There would not have been adequate time to socialise the change for Node.js 16.
      * Keeping the existing model for Node.js 16 relieves the pressure and enables more time to discuss, refine, and socialise the proposal.
  * Build and Infrastructure changes.
    * Non-zero cost to the Node.js Build Working Group.
    * The proposal includes automation, but we need persons to write and maintain that automation.
  * We would need a plan on how the two versioning schemes could coexist.
  * Proposal should be raised at the Node.js Package Maintenance Working Group too.
  * Node.js is an impactful project - by aggressively pushing changes, are we encouraging the ecosystem to evolve in the same way?
  * Moving to a release model without emphasis on the SemVer maybe even more complicated to explain.
* Node.js 16 preparations are starting.
  * (Beth) Offered pairing for preparation of the major release.
    * (Action) Set up a Doodle to find a good time.

## Q&A, Other

* Would it be worth gathering feedback from releasers on the pain-points of preparing a release?
